/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.ds.query.mysql.filter;

import com.alibaba.fastjson.JSON;
import com.jxdinfo.hussar.datasource.config.DataSourceConfig;
import com.jxdinfo.hussar.datasource.config.querysql.QuerySqlModel;
import com.jxdinfo.hussar.datasource.dao.DsDataSourceBaseMapper;
import com.jxdinfo.hussar.datasource.enm.DataSourceExceptionEnum;
import com.jxdinfo.hussar.datasource.exception.DataSourceException;
import com.jxdinfo.hussar.datasource.filter.SqlExecuteHandler;
import com.jxdinfo.hussar.datasource.model.DsTableField;
import com.jxdinfo.hussar.datasource.model.DsTableIndex;
import com.jxdinfo.hussar.datasource.model.DsTableInfo;
import com.jxdinfo.hussar.datasource.util.SqlPublicMethodUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="ds.query.mysql")
public class MySqlFilter
implements SqlExecuteHandler {
    private static final Logger logger = LoggerFactory.getLogger(MySqlFilter.class);
    private static final String HOST_REG = "(localhost|((2[0-4]\\d|25[0-5]|[01]?\\d\\d?)\\.){3}(2[0-4]\\d|25[0-5]|[01]?\\d\\d?)|([0-9a-z-]{1,}\\.)?[0-9a-z-]{2,}\\.([0-9a-z-]{2,}\\.)?[a-z]{2,})";
    private static final String PORT_REG = "(:\\d+)";
    private static final String DB_NAME_REG = "(:|\\/)[a-zA-Z0-9-_\\\\.]+";
    private static final String URL_REG = "(localhost|((2[0-4]\\d|25[0-5]|[01]?\\d\\d?)\\.){3}(2[0-4]\\d|25[0-5]|[01]?\\d\\d?)|([0-9a-z-]{1,}\\.)?[0-9a-z-]{2,}\\.([0-9a-z-]{2,}\\.)?[a-z]{2,})(:\\d+)?(:|\\/)[a-zA-Z0-9-_\\\\.]+";
    private static final Pattern DB_NAME_PATTERN = Pattern.compile("(:|\\/)[a-zA-Z0-9-_\\\\.]+");
    private static final Pattern URL_PATTERN = Pattern.compile("(localhost|((2[0-4]\\d|25[0-5]|[01]?\\d\\d?)\\.){3}(2[0-4]\\d|25[0-5]|[01]?\\d\\d?)|([0-9a-z-]{1,}\\.)?[0-9a-z-]{2,}\\.([0-9a-z-]{2,}\\.)?[a-z]{2,})(:\\d+)?(:|\\/)[a-zA-Z0-9-_\\\\.]+");
    @Resource
    private DsDataSourceBaseMapper dsDataSourceBaseMapper;

    public List<DsTableInfo> selectBatch(DataSourceConfig dataSourceConfig, String type) throws DataSourceException {
        ArrayList<DsTableInfo> dsTableInfoList = new ArrayList<DsTableInfo>();
        ArrayList fieldInfo = new ArrayList();
        ArrayList<DsTableIndex> indexInfo = new ArrayList<DsTableIndex>();
        QuerySqlModel querySqlModel = SqlPublicMethodUtil.getQuerySqlObject((DataSourceConfig)dataSourceConfig);
        String tableSql = null;
        String fieldSql = null;
        String indexSql = null;
        String tableSqlWithTask = null;
        if (querySqlModel != null) {
            String dbName = this.getDataBaseName(dataSourceConfig.getUrl());
            tableSql = querySqlModel.getTableSqlTemplate().replace("${dbName}", dbName);
            fieldSql = querySqlModel.getFieldSqlTemplate().replace("${dbName}", dbName);
            indexSql = querySqlModel.getIndexSqlTemplate().replace("${dbName}", dbName);
            tableSqlWithTask = querySqlModel.getTableSqlWithTaskTemplate().replace("${dbName}", dbName);
        }
        if (HussarUtils.isNotEmpty((Object)type) && tableSql != null) {
            switch (type) {
                case "VIEW": {
                    tableSql = tableSql.replace("${tableType}", "VIEW").replace("${tableType1}", "VIEW");
                    break;
                }
                case "BASE TABLE": {
                    tableSql = tableSql.replace("${tableType}", "BASE TABLE").replace("${tableType1}", "BASE TABLE");
                    break;
                }
                case "ALL": {
                    tableSql = tableSql.replace("${tableType}", "VIEW").replace("${tableType1}", "BASE TABLE");
                    break;
                }
                case "BASE TABLE TASK": {
                    if (tableSqlWithTask == null) break;
                    tableSql = tableSqlWithTask.replace("${tableType}", "BASE TABLE").replace("${tableType1}", "BASE TABLE");
                }
            }
        }
        if (HussarUtils.isEmpty((Object)querySqlModel)) {
            throw new DataSourceException(DataSourceExceptionEnum.NOT_SUPPORT_DATA_BASE, dataSourceConfig.getUrl());
        }
        List tableList = this.dsDataSourceBaseMapper.selectList(tableSql);
        if (tableList.size() <= 0) {
            return dsTableInfoList;
        }
        List<Map<String, Object>> indexList = null;
        MySqlFilter.dealTableResultMap(dsTableInfoList, tableList);
        this.dealIndexResultMap(indexInfo, indexList);
        return dsTableInfoList;
    }

    public Optional<DsTableInfo> selectOne(DataSourceConfig dataSourceConfig, String type, String tableName) throws DataSourceException {
        QuerySqlModel querySqlModel = SqlPublicMethodUtil.getQuerySqlObject((DataSourceConfig)dataSourceConfig);
        if (null == querySqlModel) {
            return Optional.empty();
        }
        dataSourceConfig.setUsername(dataSourceConfig.getUsername().toUpperCase());
        String dbName = this.getDataBaseName(dataSourceConfig.getUrl());
        String tableSql = querySqlModel.getSingleTableTemplate().replace("${dbName}", dbName).replace("${tableName}", tableName);
        String fieldSql = querySqlModel.getSingleFiledTemplate().replace("${dbName}", dbName).replace("${tableName}", tableName);
        String indexSql = querySqlModel.getSingleIndexSqlTemplate().replace("${dbName}", dbName).replace("${tableName}", tableName);
        if (HussarUtils.isNotEmpty((Object)type)) {
            switch (type) {
                case "VIEW": {
                    tableSql = tableSql.replace("${tableType}", "VIEW");
                    break;
                }
                case "BASE TABLE": {
                    tableSql = tableSql.replace("${tableType}", "BASE TABLE");
                    break;
                }
                case "ALL": {
                    tableSql = tableSql.replace("${tableType}", "VIEW").replace("${tableType1}", "BASE TABLE");
                    break;
                }
                default: {
                    throw new IllegalArgumentException("failed to match table type");
                }
            }
        }
        List tableList = this.dsDataSourceBaseMapper.execute(tableSql);
        List fieldList = this.dsDataSourceBaseMapper.execute(fieldSql);
        List<Map<String, Object>> indexList = null;
        if (HussarUtils.isEmpty((Object)tableList)) {
            return Optional.empty();
        }
        ArrayList<DsTableInfo> dsTableInfoList = new ArrayList<DsTableInfo>();
        ArrayList<DsTableField> fieldInfo = new ArrayList<DsTableField>();
        ArrayList<DsTableIndex> indexInfo = new ArrayList<DsTableIndex>();
        MySqlFilter.dealTableResultMap(dsTableInfoList, tableList);
        this.dealFieldResultMap(fieldInfo, fieldList);
        this.dealIndexResultMap(indexInfo, indexList);
        return Optional.ofNullable(SqlPublicMethodUtil.combined((DsTableInfo)((DsTableInfo)dsTableInfoList.get(0)), fieldInfo, indexInfo));
    }

    public List<DsTableInfo> selectTableBatch(DataSourceConfig dataSourceConfig, String type) throws DataSourceException {
        ArrayList<DsTableInfo> dsTableInfoList = new ArrayList<DsTableInfo>();
        QuerySqlModel querySqlModel = SqlPublicMethodUtil.getQuerySqlObject((DataSourceConfig)dataSourceConfig);
        String tableSql = null;
        if (querySqlModel != null) {
            String dbName = this.getDataBaseName(dataSourceConfig.getUrl());
            tableSql = querySqlModel.getTableSqlTemplate().replace("${dbName}", dbName);
        }
        if (HussarUtils.isNotEmpty((Object)type) && tableSql != null) {
            switch (type) {
                case "VIEW": {
                    tableSql = tableSql.replace("${tableType}", "VIEW").replace("${tableType1}", "VIEW");
                    break;
                }
                case "BASE TABLE": {
                    tableSql = tableSql.replace("${tableType}", "BASE TABLE").replace("${tableType1}", "BASE TABLE");
                    break;
                }
                case "ALL": {
                    tableSql = tableSql.replace("${tableType}", "VIEW").replace("${tableType1}", "BASE TABLE");
                }
            }
        }
        if (HussarUtils.isEmpty((Object)querySqlModel)) {
            throw new DataSourceException(DataSourceExceptionEnum.NOT_SUPPORT_DATA_BASE, dataSourceConfig.getUrl());
        }
        List tableList = this.dsDataSourceBaseMapper.selectList(tableSql);
        if (tableList.size() <= 0) {
            return dsTableInfoList;
        }
        MySqlFilter.dealTableResultMap(dsTableInfoList, tableList);
        return dsTableInfoList;
    }

    public List<DsTableInfo> selectTableInfoBatch(DataSourceConfig dataSourceConfig, String type, List<String> tableNames) {
        List tableList;
        ArrayList<DsTableInfo> dsTableInfoList = new ArrayList<DsTableInfo>();
        ArrayList<DsTableField> fieldInfo = new ArrayList<DsTableField>();
        QuerySqlModel querySqlModel = SqlPublicMethodUtil.getQuerySqlObject((DataSourceConfig)dataSourceConfig);
        if (null == querySqlModel) {
            return dsTableInfoList;
        }
        dataSourceConfig.setUsername(dataSourceConfig.getUsername().toUpperCase());
        StringBuilder inTableName = new StringBuilder();
        if (HussarUtils.isEmpty(tableNames)) {
            return dsTableInfoList;
        }
        inTableName.append("'").append(tableNames.get(0)).append("'");
        for (int i = 1; i < tableNames.size(); ++i) {
            inTableName.append(",'").append(tableNames.get(i)).append("'");
        }
        String dbName = this.getDataBaseName(dataSourceConfig.getUrl());
        String tableSql = querySqlModel.getTableBatchSqlTemplate().replace("${dbName}", dbName).replace("${tableName}", inTableName);
        String fieldSql = querySqlModel.getFieldBatchSqlTemplate().replace("${dbName}", dbName).replace("${tableName}", inTableName);
        if (HussarUtils.isNotEmpty((Object)type)) {
            switch (type) {
                case "VIEW": {
                    tableSql = tableSql.replace("${tableType}", "VIEW");
                    break;
                }
                case "BASE TABLE": {
                    tableSql = tableSql.replace("${tableType}", "BASE TABLE");
                    break;
                }
                case "ALL": {
                    tableSql = tableSql.replace("${tableType}", "VIEW").replace("${tableType1}", "BASE TABLE");
                    break;
                }
                default: {
                    throw new IllegalArgumentException("failed to match table type");
                }
            }
        }
        if (HussarUtils.isEmpty((Object)(tableList = this.dsDataSourceBaseMapper.execute(tableSql)))) {
            return dsTableInfoList;
        }
        List fieldList = this.dsDataSourceBaseMapper.execute(fieldSql);
        MySqlFilter.dealTableResultMap(dsTableInfoList, tableList);
        this.dealFieldResultMap(fieldInfo, fieldList);
        return SqlPublicMethodUtil.combinedBatch(dsTableInfoList, fieldInfo, null);
    }

    public List<DsTableInfo> getTableInfoWithoutFiled(DataSourceConfig dataSourceConfig, String type) throws DataSourceException {
        ArrayList<DsTableInfo> dsTableInfoList = new ArrayList<DsTableInfo>();
        ArrayList fieldInfo = new ArrayList();
        ArrayList indexInfo = new ArrayList();
        logger.info("\u6279\u91cf\u67e5\u8be2{}\u4fe1\u606f\uff1a\u6570\u636e\u6e90\u4fe1\u606f\uff1a{}", (Object)type, (Object)JSON.toJSONString((Object)dataSourceConfig));
        QuerySqlModel querySqlModel = SqlPublicMethodUtil.getQuerySqlObject((DataSourceConfig)dataSourceConfig);
        String tableSql = null;
        Object fieldSql = null;
        Object indexSql = null;
        String dbName = this.getDataBaseName(dataSourceConfig.getUrl());
        String tableSqlWithTask = null;
        if (querySqlModel != null) {
            tableSql = querySqlModel.getTableSqlTemplate().replace("${dbName}", dbName);
        }
        if (querySqlModel != null) {
            tableSqlWithTask = querySqlModel.getTableSqlWithTaskTemplate().replace("${dbName}", dbName);
        }
        if (HussarUtils.isNotEmpty((Object)type)) {
            switch (type) {
                case "VIEW": {
                    tableSql = tableSql.replace("${tableType}", "VIEW").replace("${tableType1}", "VIEW");
                    break;
                }
                case "BASE TABLE": {
                    tableSql = tableSql.replace("${tableType}", "BASE TABLE").replace("${tableType1}", "BASE TABLE");
                    break;
                }
                case "ALL": {
                    tableSql = tableSql.replace("${tableType}", "VIEW").replace("${tableType1}", "BASE TABLE");
                    break;
                }
                case "BASE TABLE TASK": {
                    tableSql = tableSqlWithTask.replace("${tableType}", "BASE TABLE").replace("${tableType1}", "BASE TABLE");
                    break;
                }
                default: {
                    throw new IllegalArgumentException("failed to match table type");
                }
            }
        }
        List tableList = this.dsDataSourceBaseMapper.selectList(tableSql);
        Object indexList = null;
        MySqlFilter.dealTableResultMap(dsTableInfoList, tableList);
        return dsTableInfoList;
    }

    public List<DsTableInfo> selectTableInfoWithFieldInfoBatch(DataSourceConfig dataSourceConfig, String type) throws DataSourceException {
        ArrayList<DsTableInfo> dsTableInfoList = new ArrayList<DsTableInfo>();
        ArrayList<DsTableField> fieldInfo = new ArrayList<DsTableField>();
        ArrayList<DsTableIndex> indexInfo = new ArrayList<DsTableIndex>();
        QuerySqlModel querySqlModel = SqlPublicMethodUtil.getQuerySqlObject((DataSourceConfig)dataSourceConfig);
        String tableSql = null;
        String fieldSql = null;
        String indexSql = null;
        String tableSqlWithTask = null;
        if (querySqlModel != null) {
            String dbName = this.getDataBaseName(dataSourceConfig.getUrl());
            tableSql = querySqlModel.getTableSqlTemplate().replace("${dbName}", dbName);
            fieldSql = querySqlModel.getFieldSqlTemplate().replace("${dbName}", dbName);
            indexSql = querySqlModel.getIndexSqlTemplate().replace("${dbName}", dbName);
            tableSqlWithTask = querySqlModel.getTableSqlWithTaskTemplate().replace("${dbName}", dbName);
        }
        if (HussarUtils.isNotEmpty((Object)type) && tableSql != null) {
            switch (type) {
                case "VIEW": {
                    tableSql = tableSql.replace("${tableType}", "VIEW").replace("${tableType1}", "VIEW");
                    break;
                }
                case "BASE TABLE": {
                    tableSql = tableSql.replace("${tableType}", "BASE TABLE").replace("${tableType1}", "BASE TABLE");
                    break;
                }
                case "ALL": {
                    tableSql = tableSql.replace("${tableType}", "VIEW").replace("${tableType1}", "BASE TABLE");
                    break;
                }
                case "BASE TABLE TASK": {
                    if (tableSqlWithTask == null) break;
                    tableSql = tableSqlWithTask.replace("${tableType}", "BASE TABLE").replace("${tableType1}", "BASE TABLE");
                }
            }
        }
        if (HussarUtils.isEmpty((Object)querySqlModel)) {
            throw new DataSourceException(DataSourceExceptionEnum.NOT_SUPPORT_DATA_BASE, dataSourceConfig.getUrl());
        }
        List tableList = this.dsDataSourceBaseMapper.selectList(tableSql);
        if (tableList.isEmpty()) {
            return dsTableInfoList;
        }
        List fieldList = this.dsDataSourceBaseMapper.selectList(fieldSql);
        List indexList = this.dsDataSourceBaseMapper.selectList(indexSql);
        MySqlFilter.dealTableResultMap(dsTableInfoList, tableList);
        this.dealFieldResultMap(fieldInfo, fieldList);
        this.dealIndexResultMap(indexInfo, indexList);
        return SqlPublicMethodUtil.combinedBatch(dsTableInfoList, fieldInfo, indexInfo);
    }

    public static void dealTableResultMap(List<DsTableInfo> dsTableInfoList, List<Map<String, Object>> tableResultSet) {
        tableResultSet.forEach(stringObjectMap -> {
            DsTableInfo dsTableInfo = new DsTableInfo();
            dsTableInfo.setName((String)stringObjectMap.get("name"));
            dsTableInfo.setComment((String)stringObjectMap.get("comment"));
            String type = (String)stringObjectMap.get("type");
            dsTableInfo.setType(type);
            dsTableInfo.setView(!"BASE TABLE".equalsIgnoreCase(type));
            dsTableInfoList.add(dsTableInfo);
        });
    }

    private void dealFieldResultMap(List<DsTableField> fieldInfo, List<Map<String, Object>> fieldList) {
        Map map = (Map)JSON.parseObject((String)this.getOperationDesc(), Map.class);
        fieldList.forEach(stringObjectMap -> {
            DsTableField dsTableField = new DsTableField();
            dsTableField.setTableName(Optional.ofNullable((String)stringObjectMap.get("tablename")).orElse(""));
            dsTableField.setName(Optional.ofNullable((String)stringObjectMap.get("name")).orElse(""));
            dsTableField.setComment(Optional.ofNullable((String)stringObjectMap.get("comment")).orElse(""));
            dsTableField.setType(Optional.ofNullable((String)stringObjectMap.get("type2")).orElse(""));
            dsTableField.setPrimarys(Optional.ofNullable((String)stringObjectMap.get("primarys")).orElse(""));
            try {
                Number dataLength;
                Object objectLength = stringObjectMap.get(this.getColumnLengthKeyByType(dsTableField.getType(), map));
                int dataLengthValue = 0;
                if (objectLength instanceof BigInteger) {
                    dataLength = (BigInteger)objectLength;
                    dataLengthValue = ((BigInteger)dataLength).intValue();
                } else if (objectLength instanceof Long) {
                    dataLength = (Long)objectLength;
                    dataLengthValue = ((Long)dataLength).intValue();
                }
                dsTableField.setDataLength(dataLengthValue);
                BigInteger dataDot = Optional.ofNullable((BigInteger)stringObjectMap.get("dataDot")).orElse(BigInteger.valueOf(0L));
                dsTableField.setDataDot(Integer.parseInt(dataDot.toString()));
            }
            catch (Exception e) {
                logger.error("inputParams:{} and errorMessage:{}", new Object[]{dsTableField.toString(), e.getMessage(), e});
            }
            dsTableField.setDataDefaultValue(Optional.ofNullable((String)stringObjectMap.get("dataDefaultValue")).orElse(""));
            dsTableField.setDataIsEmpty(!"YES".equalsIgnoreCase(Optional.ofNullable((String)stringObjectMap.get("dataIsEmpty")).orElse("")));
            fieldInfo.add(dsTableField);
        });
    }

    private void dealIndexResultMap(List<DsTableIndex> indexInfo, List<Map<String, Object>> indexList) {
        if (HussarUtils.isEmpty(indexList)) {
            return;
        }
        for (int i = 0; i < indexList.size(); ++i) {
            if (Integer.valueOf(indexList.get(i).get("isPrimaryIndex").toString()) == 1) continue;
            DsTableIndex dsTableIndex = new DsTableIndex();
            dsTableIndex.setIndexName((String)indexList.get(i).get("indexName"));
            dsTableIndex.setIndexType((String)indexList.get(i).get("indexType"));
            dsTableIndex.setTableName((String)indexList.get(i).get("tableName"));
            dsTableIndex.setTableSchema((String)indexList.get(i).get("tableSchema"));
            dsTableIndex.setColumnName((String)indexList.get(i).get("columnName"));
            dsTableIndex.setIsNonUnique(Integer.parseInt(indexList.get(i).get("isNonUnique").toString()));
            indexInfo.add(dsTableIndex);
        }
    }

    private String getColumnLengthKeyByType(String type, Map<String, List<String>> map) {
        if (HussarUtils.isNotEmpty((Object)type)) {
            String columnName = "dataLength";
            String fieldType = "";
            for (Map.Entry<String, List<String>> stringListEntry : map.entrySet()) {
                List<String> value = stringListEntry.getValue();
                if (!HussarUtils.isNotEmpty(value) || !value.contains(type.toUpperCase())) continue;
                fieldType = stringListEntry.getKey();
                break;
            }
            switch (fieldType) {
                case "CharacterType": {
                    columnName = "dataLength";
                    break;
                }
                case "NumericType": {
                    columnName = "intLength";
                    break;
                }
                case "DateTimeType": {
                    columnName = "dateLength";
                    break;
                }
                case "LargeCharacterType": {
                    if ("TEXT".equals(type.toUpperCase())) {
                        columnName = null;
                        break;
                    }
                    columnName = "dataLength";
                    break;
                }
                case "DateType": {
                    columnName = null;
                    break;
                }
            }
            return columnName;
        }
        return "dataLength";
    }

    private String getOperationDesc() {
        InputStream inputStream = this.getClass().getResourceAsStream("/mysqlFieldMappingTablecolumn.json");
        assert (inputStream != null);
        try {
            return IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private String getDataBaseName(String url) {
        if (url.indexOf(63) > -1) {
            url = url.substring(0, url.indexOf(63));
        }
        String dbName = "";
        Matcher urlMatcher = URL_PATTERN.matcher(url);
        if (urlMatcher.find()) {
            String urlName = urlMatcher.group(0);
            Matcher dbNameMatcher = DB_NAME_PATTERN.matcher(urlName);
            ArrayList<String> dbNameList = new ArrayList<String>();
            while (dbNameMatcher.find()) {
                dbNameList.add(dbNameMatcher.group());
            }
            if (HussarUtils.isNotEmpty(dbNameList)) {
                dbName = ((String)dbNameList.get(dbNameList.size() - 1)).substring(1);
            }
        }
        return dbName;
    }

    public List<DsTableField> getTableFieldByTableName(DataSourceConfig dataSourceConfig, String tableName) {
        QuerySqlModel querySqlModel = SqlPublicMethodUtil.getQuerySqlObject((DataSourceConfig)dataSourceConfig);
        String fieldSql = null;
        if (querySqlModel != null) {
            String dbName = this.getDataBaseName(dataSourceConfig.getUrl());
            fieldSql = querySqlModel.getSingleFiledTemplate().replace("${dbName}", dbName).replace("${tableName}", tableName);
        }
        List fieldList = this.dsDataSourceBaseMapper.selectList(fieldSql);
        ArrayList<DsTableField> dsTableFieldList = new ArrayList<DsTableField>();
        this.dealFieldResultMap(dsTableFieldList, fieldList);
        return dsTableFieldList;
    }
}

