/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.ds.query.kingbase.filter;

import com.jxdinfo.hussar.datasource.config.DataSourceConfig;
import com.jxdinfo.hussar.datasource.config.querysql.QuerySqlModel;
import com.jxdinfo.hussar.datasource.dao.DsDataSourceBaseMapper;
import com.jxdinfo.hussar.datasource.enm.DataSourceExceptionEnum;
import com.jxdinfo.hussar.datasource.exception.DataSourceException;
import com.jxdinfo.hussar.datasource.filter.SqlExecuteHandler;
import com.jxdinfo.hussar.datasource.model.DsTableField;
import com.jxdinfo.hussar.datasource.model.DsTableIndex;
import com.jxdinfo.hussar.datasource.model.DsTableInfo;
import com.jxdinfo.hussar.datasource.util.SqlPublicMethodUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="ds.query.kingbase")
public class KingBaseFilter
implements SqlExecuteHandler {
    private static final Logger logger = LoggerFactory.getLogger(KingBaseFilter.class);
    private static final String DEFAULT_SCHEMA = "public";
    @Resource
    private DsDataSourceBaseMapper dsDataSourceBaseMapper;

    public List<DsTableInfo> selectBatch(DataSourceConfig dataSourceConfig, String type) {
        ArrayList<DsTableInfo> dsTableInfoList = new ArrayList<DsTableInfo>();
        ArrayList fieldInfo = new ArrayList();
        ArrayList<DsTableIndex> indexInfo = new ArrayList<DsTableIndex>();
        QuerySqlModel querySqlModel = SqlPublicMethodUtil.getQuerySqlObject((DataSourceConfig)dataSourceConfig);
        String tableSql = null;
        String fieldSql = null;
        String indexSql = null;
        String tableSqlWithTask = null;
        dataSourceConfig.setUsername(dataSourceConfig.getUsername());
        dataSourceConfig.setSchemaname(dataSourceConfig.getSchemaname());
        String dbName = DEFAULT_SCHEMA;
        if (HussarUtils.isNotEmpty((Object)dataSourceConfig.getSchemaname())) {
            dbName = dataSourceConfig.getSchemaname();
        }
        if (querySqlModel != null) {
            tableSql = querySqlModel.getTableSqlTemplate().replace("${dbName}", dbName);
            fieldSql = querySqlModel.getFieldSqlTemplate().replace("${dbName}", dbName);
            indexSql = querySqlModel.getIndexSqlTemplate().replace("${dbName}", dbName);
            tableSqlWithTask = querySqlModel.getTableSqlWithTaskTemplate();
        }
        if (HussarUtils.isNotEmpty((Object)type) && tableSql != null) {
            switch (type) {
                case "VIEW": {
                    tableSql = tableSql.replace("${tableType}", "VIEW").replace("${tableType1}", "VIEW");
                    break;
                }
                case "BASE TABLE": {
                    tableSql = tableSql.replace("${tableType}", "BASE TABLE").replace("${tableType1}", "BASE TABLE");
                    break;
                }
                case "ALL": {
                    tableSql = tableSql.replace("${tableType}", "VIEW").replace("${tableType1}", "BASE TABLE");
                    break;
                }
                case "BASE TABLE TASK": {
                    if (tableSqlWithTask == null) break;
                    tableSql = tableSqlWithTask.replace("${tableType}", "BASE TABLE").replace("${tableType1}", "BASE TABLE");
                }
            }
        }
        List tableList = this.dsDataSourceBaseMapper.selectList(tableSql);
        List<Map<String, Object>> indexList = null;
        this.dealTableResultMap(dsTableInfoList, tableList);
        this.dealIndexResultMap(indexInfo, indexList);
        return dsTableInfoList;
    }

    public Optional<DsTableInfo> selectOne(DataSourceConfig dataSourceConfig, String type, String tableName) {
        QuerySqlModel querySqlModel = SqlPublicMethodUtil.getQuerySqlObject((DataSourceConfig)dataSourceConfig);
        if (null == querySqlModel) {
            return Optional.empty();
        }
        String tableSql = null;
        String fieldSql = null;
        String indexSql = null;
        dataSourceConfig.setUsername(dataSourceConfig.getUsername());
        dataSourceConfig.setSchemaname(dataSourceConfig.getSchemaname());
        String dbName = DEFAULT_SCHEMA;
        if (HussarUtils.isNotEmpty((Object)dataSourceConfig.getSchemaname())) {
            dbName = dataSourceConfig.getSchemaname();
        }
        tableSql = querySqlModel.getSingleTableTemplate().replace("${dbName}", dbName).replace("${tableName}", tableName);
        fieldSql = querySqlModel.getSingleFiledTemplate().replace("${dbName}", dbName).replace("${tableName}", tableName);
        indexSql = querySqlModel.getSingleIndexSqlTemplate().replace("${dbName}", dbName).replace("${tableName}", tableName);
        if (HussarUtils.isNotEmpty((Object)type)) {
            switch (type) {
                case "VIEW": {
                    tableSql = tableSql.replace("${tableType}", "VIEW").replace("${tableType1}", "VIEW");
                    break;
                }
                case "BASE TABLE": {
                    tableSql = tableSql.replace("${tableType}", "BASE TABLE").replace("${tableType1}", "BASE TABLE");
                    break;
                }
                case "ALL": {
                    tableSql = tableSql.replace("${tableType}", "VIEW").replace("${tableType1}", "BASE TABLE");
                    break;
                }
                default: {
                    throw new IllegalArgumentException("failed to match table type");
                }
            }
        }
        List tableList = this.dsDataSourceBaseMapper.execute(tableSql);
        List fieldList = this.dsDataSourceBaseMapper.execute(fieldSql);
        List<Map<String, Object>> indexList = null;
        if (HussarUtils.isEmpty((Object)tableList)) {
            return Optional.empty();
        }
        ArrayList<DsTableInfo> dsTableInfoList = new ArrayList<DsTableInfo>();
        ArrayList<DsTableField> fieldInfo = new ArrayList<DsTableField>();
        ArrayList<DsTableIndex> indexInfo = new ArrayList<DsTableIndex>();
        this.dealTableResultMap(dsTableInfoList, tableList);
        this.dealFieldResultMap(fieldInfo, fieldList);
        this.dealIndexResultMap(indexInfo, indexList);
        return Optional.ofNullable(SqlPublicMethodUtil.combined((DsTableInfo)((DsTableInfo)dsTableInfoList.get(0)), fieldInfo, indexInfo));
    }

    public List<DsTableInfo> selectTableBatch(DataSourceConfig dataSourceConfig, String type) throws DataSourceException {
        ArrayList<DsTableInfo> dsTableInfoList = new ArrayList<DsTableInfo>();
        QuerySqlModel querySqlModel = SqlPublicMethodUtil.getQuerySqlObject((DataSourceConfig)dataSourceConfig);
        String tableSql = null;
        if (querySqlModel != null) {
            tableSql = querySqlModel.getTableSqlTemplate();
        }
        String dbName = DEFAULT_SCHEMA;
        if (HussarUtils.isNotEmpty((Object)dataSourceConfig.getSchemaname())) {
            dbName = dataSourceConfig.getSchemaname();
        }
        if (tableSql != null) {
            tableSql = tableSql.replace("${dbName}", dbName);
        }
        if (HussarUtils.isNotEmpty((Object)type) && tableSql != null) {
            switch (type) {
                case "VIEW": {
                    tableSql = tableSql.replace("${tableType}", "VIEW").replace("${tableType1}", "VIEW");
                    break;
                }
                case "BASE TABLE": {
                    tableSql = tableSql.replace("${tableType}", "BASE TABLE").replace("${tableType1}", "BASE TABLE");
                    break;
                }
                case "ALL": {
                    tableSql = tableSql.replace("${tableType}", "VIEW").replace("${tableType1}", "BASE TABLE");
                }
            }
        }
        if (HussarUtils.isEmpty((Object)querySqlModel)) {
            throw new DataSourceException(DataSourceExceptionEnum.NOT_SUPPORT_DATA_BASE, dataSourceConfig.getUrl());
        }
        List tableList = this.dsDataSourceBaseMapper.selectList(tableSql);
        if (tableList.size() <= 0) {
            return dsTableInfoList;
        }
        this.dealTableResultMap(dsTableInfoList, tableList);
        return dsTableInfoList;
    }

    public List<DsTableInfo> selectTableInfoBatch(DataSourceConfig dataSourceConfig, String type, List<String> tableNames) {
        List tableList;
        ArrayList<DsTableInfo> dsTableInfoList = new ArrayList<DsTableInfo>();
        ArrayList<DsTableField> fieldInfo = new ArrayList<DsTableField>();
        QuerySqlModel querySqlModel = SqlPublicMethodUtil.getQuerySqlObject((DataSourceConfig)dataSourceConfig);
        if (null == querySqlModel) {
            return dsTableInfoList;
        }
        dataSourceConfig.setUsername(dataSourceConfig.getUsername().toUpperCase());
        StringBuilder inTableName = new StringBuilder();
        if (HussarUtils.isEmpty(tableNames)) {
            return dsTableInfoList;
        }
        inTableName.append("'").append(tableNames.get(0)).append("'");
        for (int i = 1; i < tableNames.size(); ++i) {
            inTableName.append(",'").append(tableNames.get(i)).append("'");
        }
        String tableSql = querySqlModel.getTableBatchSqlTemplate().replace("${dbName}", dataSourceConfig.getDbName()).replace("${tableName}", inTableName);
        String fieldSql = querySqlModel.getFieldBatchSqlTemplate().replace("${dbName}", dataSourceConfig.getDbName()).replace("${tableName}", inTableName);
        if (HussarUtils.isNotEmpty((Object)type)) {
            switch (type) {
                case "VIEW": {
                    tableSql = tableSql.replace("${tableType}", "VIEW");
                    break;
                }
                case "BASE TABLE": {
                    tableSql = tableSql.replace("${tableType}", "BASE TABLE");
                    break;
                }
                case "ALL": {
                    tableSql = tableSql.replace("${tableType}", "VIEW").replace("${tableType1}", "BASE TABLE");
                    break;
                }
                default: {
                    throw new IllegalArgumentException("failed to match table type");
                }
            }
        }
        if (HussarUtils.isEmpty((Object)(tableList = this.dsDataSourceBaseMapper.execute(tableSql)))) {
            return dsTableInfoList;
        }
        List fieldList = this.dsDataSourceBaseMapper.execute(fieldSql);
        this.dealTableResultMap(dsTableInfoList, tableList);
        this.dealFieldResultMap(fieldInfo, fieldList);
        return SqlPublicMethodUtil.combinedBatch(dsTableInfoList, fieldInfo, null);
    }

    public List<DsTableInfo> getTableInfoWithoutFiled(DataSourceConfig dataSourceConfig, String type) {
        ArrayList<DsTableInfo> dsTableInfoList = new ArrayList<DsTableInfo>();
        ArrayList fieldInfo = new ArrayList();
        ArrayList<DsTableIndex> indexInfo = new ArrayList<DsTableIndex>();
        QuerySqlModel querySqlModel = SqlPublicMethodUtil.getQuerySqlObject((DataSourceConfig)dataSourceConfig);
        String tableSql = null;
        String fieldSql = null;
        String indexSql = null;
        String tableSqlWithTask = null;
        dataSourceConfig.setUsername(dataSourceConfig.getUsername());
        dataSourceConfig.setSchemaname(dataSourceConfig.getSchemaname());
        String dbName = DEFAULT_SCHEMA;
        if (HussarUtils.isNotEmpty((Object)dataSourceConfig.getSchemaname())) {
            dbName = dataSourceConfig.getSchemaname();
        }
        if (querySqlModel != null) {
            tableSql = querySqlModel.getTableSqlTemplate().replace("${dbName}", dbName);
            fieldSql = querySqlModel.getFieldSqlTemplate().replace("${dbName}", dbName);
            indexSql = querySqlModel.getIndexSqlTemplate().replace("${dbName}", dbName);
            tableSqlWithTask = querySqlModel.getTableSqlWithTaskTemplate();
        }
        if (HussarUtils.isNotEmpty((Object)type) && tableSql != null) {
            switch (type) {
                case "VIEW": {
                    tableSql = tableSql.replace("${tableType}", "VIEW").replace("${tableType1}", "VIEW");
                    break;
                }
                case "BASE TABLE": {
                    tableSql = tableSql.replace("${tableType}", "BASE TABLE").replace("${tableType1}", "BASE TABLE");
                    break;
                }
                case "ALL": {
                    tableSql = tableSql.replace("${tableType}", "VIEW").replace("${tableType1}", "BASE TABLE");
                    break;
                }
                case "BASE TABLE TASK": {
                    if (tableSqlWithTask == null) break;
                    tableSql = tableSqlWithTask.replace("${tableType}", "BASE TABLE").replace("${tableType1}", "BASE TABLE");
                }
            }
        }
        List tableList = this.dsDataSourceBaseMapper.selectList(tableSql);
        List<Map<String, Object>> indexList = null;
        this.dealTableResultMap(dsTableInfoList, tableList);
        this.dealIndexResultMap(indexInfo, indexList);
        return dsTableInfoList;
    }

    public List<DsTableInfo> selectTableInfoWithFieldInfoBatch(DataSourceConfig dataSourceConfig, String type) throws DataSourceException {
        ArrayList<DsTableInfo> dsTableInfoList = new ArrayList<DsTableInfo>();
        ArrayList<DsTableField> fieldInfo = new ArrayList<DsTableField>();
        ArrayList<DsTableIndex> indexInfo = new ArrayList<DsTableIndex>();
        QuerySqlModel querySqlModel = SqlPublicMethodUtil.getQuerySqlObject((DataSourceConfig)dataSourceConfig);
        String tableSql = null;
        String fieldSql = null;
        String indexSql = null;
        String tableSqlWithTask = null;
        dataSourceConfig.setUsername(dataSourceConfig.getUsername());
        dataSourceConfig.setSchemaname(dataSourceConfig.getSchemaname());
        String dbName = DEFAULT_SCHEMA;
        if (HussarUtils.isNotEmpty((Object)dataSourceConfig.getSchemaname())) {
            dbName = dataSourceConfig.getSchemaname();
        }
        if (querySqlModel != null) {
            tableSql = querySqlModel.getTableSqlTemplate().replace("${dbName}", dbName);
            fieldSql = querySqlModel.getFieldSqlTemplate().replace("${dbName}", dbName);
            indexSql = querySqlModel.getIndexSqlTemplate().replace("${dbName}", dbName);
            tableSqlWithTask = querySqlModel.getTableSqlWithTaskTemplate();
        }
        if (HussarUtils.isNotEmpty((Object)type) && tableSql != null) {
            switch (type) {
                case "VIEW": {
                    tableSql = tableSql.replace("${tableType}", "VIEW").replace("${tableType1}", "VIEW");
                    break;
                }
                case "BASE TABLE": {
                    tableSql = tableSql.replace("${tableType}", "BASE TABLE").replace("${tableType1}", "BASE TABLE");
                    break;
                }
                case "ALL": {
                    tableSql = tableSql.replace("${tableType}", "VIEW").replace("${tableType1}", "BASE TABLE");
                    break;
                }
                case "BASE TABLE TASK": {
                    if (tableSqlWithTask == null) break;
                    tableSql = tableSqlWithTask.replace("${tableType}", "BASE TABLE").replace("${tableType1}", "BASE TABLE");
                }
            }
        }
        List tableList = this.dsDataSourceBaseMapper.selectList(tableSql);
        List fieldList = this.dsDataSourceBaseMapper.selectList(fieldSql);
        List indexList = this.dsDataSourceBaseMapper.selectList(indexSql);
        this.dealTableResultMap(dsTableInfoList, tableList);
        this.dealFieldResultMap(fieldInfo, fieldList);
        this.dealIndexResultMap(indexInfo, indexList);
        return SqlPublicMethodUtil.combinedBatch(dsTableInfoList, fieldInfo, indexInfo);
    }

    private void dealFieldResultMap(List<DsTableField> fieldInfo, List<Map<String, Object>> fieldList) {
        for (Map<String, Object> stringObjectMap : fieldList) {
            DsTableField dsTableField = new DsTableField();
            dsTableField.setTableName((String)stringObjectMap.get("table_name"));
            dsTableField.setName((String)stringObjectMap.get("column_name"));
            dsTableField.setComment((String)stringObjectMap.get("des"));
            String type = String.valueOf(stringObjectMap.get("data_type"));
            String columnType = String.valueOf(stringObjectMap.get("column_type"));
            String precision = String.valueOf(stringObjectMap.get("datetime_precision"));
            switch (type) {
                case "boolean": {
                    type = "BOOLEAN";
                    break;
                }
                case "bpchar": {
                    type = "CHAR";
                    break;
                }
                case "varchar": {
                    type = "VARCHAR";
                    break;
                }
                case "text": {
                    type = "TEXT";
                    break;
                }
                case "numeric": {
                    type = "NUMERIC";
                    break;
                }
                case "real": 
                case "float4": {
                    type = "FLOAT4";
                    break;
                }
                case "double precision": {
                    type = "FLOAT8";
                    break;
                }
                case "date": {
                    type = "DATE";
                    break;
                }
                case "time without time zone": {
                    type = "TIME";
                    break;
                }
                case "timestamp without time zone": {
                    if ("0".equals(precision)) {
                        type = "DATE";
                        break;
                    }
                    type = "TIMESTAMP";
                    break;
                }
                case "USER-DEFINED": {
                    if ("timestamp".equals(columnType)) {
                        type = "TIMESTAMP";
                        break;
                    }
                    if ("time".equals(columnType)) {
                        type = "TIME";
                        break;
                    }
                    if (!"date".equals(columnType)) break;
                    type = "DATE";
                }
            }
            dsTableField.setType(type);
            Object dataLength = Optional.ofNullable(stringObjectMap.get("collength")).orElse("0");
            switch (type) {
                case "BOOLEAN": {
                    dataLength = 1;
                    break;
                }
                case "TEXT": {
                    dataLength = 0;
                    break;
                }
                case "FLOAT4": {
                    dataLength = 8;
                    break;
                }
                case "FLOAT8": {
                    dataLength = 17;
                    break;
                }
                case "DATE": {
                    dataLength = 8;
                    break;
                }
                case "TIME": {
                    dataLength = 8;
                    break;
                }
                case "TIMESTAMP": {
                    dataLength = 8;
                    break;
                }
                case "VARCHAR": 
                case "CHAR": {
                    Pattern pattern;
                    Matcher matcher;
                    if (!HussarUtils.isNotEmpty((Object)columnType) || !(matcher = (pattern = Pattern.compile("\\((\\d+)")).matcher(columnType)).find()) break;
                    dataLength = matcher.group(1);
                    break;
                }
            }
            dsTableField.setDataLength(Integer.parseInt(String.valueOf(dataLength)));
            dsTableField.setDataDefaultValue((String)stringObjectMap.get("defaultvalue"));
            dsTableField.setDataIsEmpty((Integer)stringObjectMap.get("isempty") == 0);
            dsTableField.setPrimarys((Integer)stringObjectMap.get("pk_id") == 0 ? null : "PRI");
            Optional.ofNullable(stringObjectMap.get("numeric_scale")).ifPresent(dataDto -> dsTableField.setDataDot(Integer.parseInt(String.valueOf(dataDto))));
            fieldInfo.add(dsTableField);
        }
    }

    private void dealIndexResultMap(List<DsTableIndex> indexInfo, List<Map<String, Object>> indexList) {
        if (HussarUtils.isEmpty(indexList)) {
            return;
        }
        for (int i = 0; i < indexList.size(); ++i) {
            if (Integer.valueOf(indexList.get(i).get("isprimarykey").toString()) == 1) continue;
            DsTableIndex dsTableIndex = new DsTableIndex();
            dsTableIndex.setIndexName((String)indexList.get(i).get("indexname"));
            dsTableIndex.setIndexType((String)indexList.get(i).get("indextype"));
            dsTableIndex.setTableName((String)indexList.get(i).get("tablename"));
            dsTableIndex.setTableSchema((String)indexList.get(i).get("tableschema"));
            dsTableIndex.setColumnName((String)indexList.get(i).get("columnname"));
            dsTableIndex.setIsNonUnique(Integer.parseInt(indexList.get(i).get("isnonunique").toString()));
            indexInfo.add(dsTableIndex);
        }
    }

    private void dealTableResultMap(List<DsTableInfo> dsTableInfoList, List<Map<String, Object>> tableResultSet) {
        tableResultSet.forEach(stringObjectMap -> {
            DsTableInfo dsTableInfo = new DsTableInfo();
            dsTableInfo.setName((String)stringObjectMap.get("name"));
            dsTableInfo.setComment((String)stringObjectMap.get("comment"));
            String type = (String)stringObjectMap.get("type");
            dsTableInfo.setType(type);
            dsTableInfo.setView(!"BASE TABLE".equalsIgnoreCase(type));
            dsTableInfoList.add(dsTableInfo);
        });
    }

    public List<DsTableField> getTableFieldByTableName(DataSourceConfig dataSourceConfig, String tableName) {
        QuerySqlModel querySqlModel = SqlPublicMethodUtil.getQuerySqlObject((DataSourceConfig)dataSourceConfig);
        String fieldSql = null;
        dataSourceConfig.setUsername(dataSourceConfig.getUsername());
        dataSourceConfig.setSchemaname(dataSourceConfig.getSchemaname());
        String dbName = DEFAULT_SCHEMA;
        if (HussarUtils.isNotEmpty((Object)dataSourceConfig.getSchemaname())) {
            dbName = dataSourceConfig.getSchemaname();
        }
        if (querySqlModel != null) {
            fieldSql = querySqlModel.getSingleFiledTemplate().replace("${dbName}", dbName).replace("${tableName}", tableName);
        }
        List fieldList = this.dsDataSourceBaseMapper.selectList(fieldSql);
        ArrayList<DsTableField> dsTableFieldList = new ArrayList<DsTableField>();
        this.dealFieldResultMap(dsTableFieldList, fieldList);
        return dsTableFieldList;
    }
}

