/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.ds.query.hg.filter;

import com.jxdinfo.hussar.datasource.config.DataSourceConfig;
import com.jxdinfo.hussar.datasource.config.querysql.QuerySqlModel;
import com.jxdinfo.hussar.datasource.dao.DsDataSourceBaseMapper;
import com.jxdinfo.hussar.datasource.enm.DataSourceExceptionEnum;
import com.jxdinfo.hussar.datasource.exception.DataSourceException;
import com.jxdinfo.hussar.datasource.filter.SqlExecuteHandler;
import com.jxdinfo.hussar.datasource.model.DsTableField;
import com.jxdinfo.hussar.datasource.model.DsTableIndex;
import com.jxdinfo.hussar.datasource.model.DsTableInfo;
import com.jxdinfo.hussar.datasource.util.SqlPublicMethodUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="ds.query.highgo")
public class HgFilter
implements SqlExecuteHandler {
    private static final Logger logger = LoggerFactory.getLogger(HgFilter.class);
    @Resource
    private DsDataSourceBaseMapper dsDataSourceBaseMapper;

    public List<DsTableInfo> selectBatch(DataSourceConfig dataSourceConfig, String type) {
        ArrayList<DsTableInfo> dsTableInfoList = new ArrayList<DsTableInfo>();
        ArrayList fieldInfo = new ArrayList();
        ArrayList<DsTableIndex> indexInfo = new ArrayList<DsTableIndex>();
        QuerySqlModel querySqlModel = SqlPublicMethodUtil.getQuerySqlObject((DataSourceConfig)dataSourceConfig);
        String tableSql = null;
        String fieldSql = null;
        String indexSql = null;
        String tableSqlWithTask = null;
        dataSourceConfig.setUsername(dataSourceConfig.getUsername());
        dataSourceConfig.setSchemaname(dataSourceConfig.getSchemaname());
        if (querySqlModel != null) {
            tableSql = dataSourceConfig.getUsername().equals(dataSourceConfig.getSchemaname()) || "".equals(dataSourceConfig.getSchemaname()) || dataSourceConfig.getSchemaname() == null ? querySqlModel.getTableSqlTemplate().replace("${dbName}", dataSourceConfig.getUsername()) : querySqlModel.getTableSqlTemplate().replace("${dbName}", dataSourceConfig.getSchemaname());
        }
        if (querySqlModel != null) {
            tableSqlWithTask = dataSourceConfig.getUsername().equals(dataSourceConfig.getSchemaname()) || "".equals(dataSourceConfig.getSchemaname()) || dataSourceConfig.getSchemaname() == null ? querySqlModel.getTableSqlWithTaskTemplate().replace("${dbName}", dataSourceConfig.getUsername()) : querySqlModel.getTableSqlWithTaskTemplate().replace("${dbName}", dataSourceConfig.getSchemaname());
        }
        if (querySqlModel != null) {
            fieldSql = dataSourceConfig.getUsername().equals(dataSourceConfig.getSchemaname()) || "".equals(dataSourceConfig.getSchemaname()) || dataSourceConfig.getSchemaname() == null ? querySqlModel.getFieldSqlTemplate().replace("${dbName}", dataSourceConfig.getUsername()) : querySqlModel.getFieldSqlTemplate().replace("${dbName}", dataSourceConfig.getSchemaname());
        }
        if (querySqlModel != null) {
            indexSql = dataSourceConfig.getUsername().equals(dataSourceConfig.getSchemaname()) || "".equals(dataSourceConfig.getSchemaname()) || dataSourceConfig.getSchemaname() == null ? querySqlModel.getIndexSqlTemplate().replace("${dbName}", dataSourceConfig.getUsername()) : querySqlModel.getIndexSqlTemplate().replace("${dbName}", dataSourceConfig.getSchemaname());
        }
        if (HussarUtils.isNotEmpty((Object)type) && tableSql != null) {
            switch (type) {
                case "VIEW": {
                    tableSql = tableSql.replace("${tableType}", "VIEW").replace("${tableType1}", "VIEW");
                    break;
                }
                case "BASE TABLE": {
                    tableSql = tableSql.replace("${tableType}", "BASE TABLE").replace("${tableType1}", "BASE TABLE");
                    break;
                }
                case "ALL": {
                    tableSql = tableSql.replace("${tableType}", "VIEW").replace("${tableType1}", "BASE TABLE");
                    break;
                }
                case "BASE TABLE TASK": {
                    if (tableSqlWithTask == null) break;
                    tableSql = tableSqlWithTask.replace("${tableType}", "BASE TABLE").replace("${tableType1}", "BASE TABLE");
                }
            }
        }
        List tableList = this.dsDataSourceBaseMapper.selectList(tableSql);
        List<Map<String, Object>> indexList = null;
        this.dealTableResultMap(dsTableInfoList, tableList);
        this.dealIndexResultMap(indexInfo, indexList);
        return dsTableInfoList;
    }

    public Optional<DsTableInfo> selectOne(DataSourceConfig dataSourceConfig, String type, String tableName) {
        QuerySqlModel querySqlModel = SqlPublicMethodUtil.getQuerySqlObject((DataSourceConfig)dataSourceConfig);
        if (null == querySqlModel) {
            return Optional.empty();
        }
        String tableSql = null;
        String fieldSql = null;
        String indexSql = null;
        dataSourceConfig.setUsername(dataSourceConfig.getUsername());
        dataSourceConfig.setSchemaname(dataSourceConfig.getSchemaname());
        if (dataSourceConfig.getUsername().equals(dataSourceConfig.getSchemaname()) || "".equals(dataSourceConfig.getSchemaname()) || dataSourceConfig.getSchemaname() == null) {
            tableSql = querySqlModel.getSingleTableTemplate().replace("${dbName}", dataSourceConfig.getUsername()).replace("${tableName}", tableName);
            fieldSql = querySqlModel.getSingleFiledTemplate().replace("${dbName}", dataSourceConfig.getUsername()).replace("${tableName}", tableName);
            indexSql = querySqlModel.getSingleIndexSqlTemplate().replace("${dbName}", dataSourceConfig.getUsername()).replace("${tableName}", tableName);
        } else {
            tableSql = querySqlModel.getSingleTableTemplate().replace("${dbName}", dataSourceConfig.getSchemaname()).replace("${tableName}", tableName);
            fieldSql = querySqlModel.getSingleFiledTemplate().replace("${dbName}", dataSourceConfig.getSchemaname()).replace("${tableName}", tableName);
            indexSql = querySqlModel.getSingleIndexSqlTemplate().replace("${dbName}", dataSourceConfig.getSchemaname()).replace("${tableName}", tableName);
        }
        if (HussarUtils.isNotEmpty((Object)type)) {
            switch (type) {
                case "VIEW": {
                    tableSql = tableSql.replace("${tableType}", "VIEW");
                    break;
                }
                case "BASE TABLE": {
                    tableSql = tableSql.replace("${tableType}", "BASE TABLE");
                    break;
                }
                case "ALL": {
                    tableSql = tableSql.replace("${tableType}", "VIEW").replace("${tableType1}", "BASE TABLE");
                    break;
                }
                default: {
                    throw new IllegalArgumentException("failed to match table type");
                }
            }
        }
        List tableList = this.dsDataSourceBaseMapper.execute(tableSql);
        List fieldList = this.dsDataSourceBaseMapper.execute(fieldSql);
        List<Map<String, Object>> indexList = null;
        if (HussarUtils.isEmpty((Object)tableList)) {
            return Optional.empty();
        }
        ArrayList<DsTableInfo> dsTableInfoList = new ArrayList<DsTableInfo>();
        ArrayList<DsTableField> fieldInfo = new ArrayList<DsTableField>();
        ArrayList<DsTableIndex> indexInfo = new ArrayList<DsTableIndex>();
        this.dealTableResultMap(dsTableInfoList, tableList);
        this.dealFieldResultMap(fieldInfo, fieldList);
        this.dealIndexResultMap(indexInfo, indexList);
        return Optional.ofNullable(SqlPublicMethodUtil.combined((DsTableInfo)((DsTableInfo)dsTableInfoList.get(0)), fieldInfo, indexInfo));
    }

    public List<DsTableInfo> selectTableBatch(DataSourceConfig dataSourceConfig, String type) throws DataSourceException {
        ArrayList<DsTableInfo> dsTableInfoList = new ArrayList<DsTableInfo>();
        QuerySqlModel querySqlModel = SqlPublicMethodUtil.getQuerySqlObject((DataSourceConfig)dataSourceConfig);
        String tableSql = null;
        if (querySqlModel != null) {
            tableSql = querySqlModel.getTableSqlTemplate();
        }
        if (querySqlModel != null) {
            tableSql = dataSourceConfig.getUsername().equals(dataSourceConfig.getSchemaname()) || "".equals(dataSourceConfig.getSchemaname()) || dataSourceConfig.getSchemaname() == null ? querySqlModel.getTableSqlTemplate().replace("${dbName}", dataSourceConfig.getUsername()) : querySqlModel.getTableSqlTemplate().replace("${dbName}", dataSourceConfig.getSchemaname());
        }
        if (HussarUtils.isNotEmpty((Object)type) && tableSql != null) {
            switch (type) {
                case "VIEW": {
                    tableSql = tableSql.replace("${tableType}", "VIEW").replace("${tableType1}", "VIEW");
                    break;
                }
                case "BASE TABLE": {
                    tableSql = tableSql.replace("${tableType}", "BASE TABLE").replace("${tableType1}", "BASE TABLE");
                    break;
                }
                case "ALL": {
                    tableSql = tableSql.replace("${tableType}", "VIEW").replace("${tableType1}", "BASE TABLE");
                }
            }
        }
        if (HussarUtils.isEmpty((Object)querySqlModel)) {
            throw new DataSourceException(DataSourceExceptionEnum.NOT_SUPPORT_DATA_BASE, dataSourceConfig.getUrl());
        }
        List tableList = this.dsDataSourceBaseMapper.selectList(tableSql);
        if (tableList.size() <= 0) {
            return dsTableInfoList;
        }
        this.dealTableResultMap(dsTableInfoList, tableList);
        return dsTableInfoList;
    }

    public List<DsTableInfo> selectTableInfoBatch(DataSourceConfig dataSourceConfig, String type, List<String> tableNames) {
        List tableList;
        ArrayList<DsTableInfo> dsTableInfoList = new ArrayList<DsTableInfo>();
        ArrayList<DsTableField> fieldInfo = new ArrayList<DsTableField>();
        QuerySqlModel querySqlModel = SqlPublicMethodUtil.getQuerySqlObject((DataSourceConfig)dataSourceConfig);
        if (null == querySqlModel) {
            return dsTableInfoList;
        }
        dataSourceConfig.setUsername(dataSourceConfig.getUsername());
        StringBuilder inTableName = new StringBuilder();
        if (HussarUtils.isEmpty(tableNames)) {
            return dsTableInfoList;
        }
        inTableName.append("'").append(tableNames.get(0)).append("'");
        for (int i = 1; i < tableNames.size(); ++i) {
            inTableName.append(",'").append(tableNames.get(i)).append("'");
        }
        String tableSql = null;
        String fieldSql = null;
        if (dataSourceConfig.getUsername().equals(dataSourceConfig.getSchemaname()) || "".equals(dataSourceConfig.getSchemaname()) || dataSourceConfig.getSchemaname() == null) {
            tableSql = querySqlModel.getTableBatchSqlTemplate().replace("${dbName}", dataSourceConfig.getUsername()).replace("${tableName}", inTableName);
            fieldSql = querySqlModel.getFieldBatchSqlTemplate().replace("${dbName}", dataSourceConfig.getUsername()).replace("${tableName}", inTableName);
        } else {
            tableSql = querySqlModel.getTableBatchSqlTemplate().replace("${dbName}", dataSourceConfig.getSchemaname()).replace("${tableName}", inTableName);
            fieldSql = querySqlModel.getFieldBatchSqlTemplate().replace("${dbName}", dataSourceConfig.getSchemaname()).replace("${tableName}", inTableName);
        }
        if (HussarUtils.isNotEmpty((Object)type)) {
            switch (type) {
                case "VIEW": {
                    tableSql = tableSql.replace("${tableType}", "VIEW");
                    break;
                }
                case "BASE TABLE": {
                    tableSql = tableSql.replace("${tableType}", "BASE TABLE");
                    break;
                }
                case "ALL": {
                    tableSql = tableSql.replace("${tableType}", "VIEW").replace("${tableType1}", "BASE TABLE");
                    break;
                }
                default: {
                    throw new IllegalArgumentException("failed to match table type");
                }
            }
        }
        if (HussarUtils.isEmpty((Object)(tableList = this.dsDataSourceBaseMapper.execute(tableSql)))) {
            return dsTableInfoList;
        }
        List fieldList = this.dsDataSourceBaseMapper.execute(fieldSql);
        this.dealTableResultMap(dsTableInfoList, tableList);
        this.dealFieldResultMap(fieldInfo, fieldList);
        return SqlPublicMethodUtil.combinedBatch(dsTableInfoList, fieldInfo, null);
    }

    public List<DsTableInfo> selectTableInfoWithFieldInfoBatch(DataSourceConfig dataSourceConfig, String type) throws DataSourceException {
        ArrayList<DsTableInfo> dsTableInfoList = new ArrayList<DsTableInfo>();
        ArrayList<DsTableField> fieldInfo = new ArrayList<DsTableField>();
        ArrayList<DsTableIndex> indexInfo = new ArrayList<DsTableIndex>();
        QuerySqlModel querySqlModel = SqlPublicMethodUtil.getQuerySqlObject((DataSourceConfig)dataSourceConfig);
        String tableSql = null;
        String fieldSql = null;
        String indexSql = null;
        String tableSqlWithTask = null;
        dataSourceConfig.setUsername(dataSourceConfig.getUsername());
        dataSourceConfig.setSchemaname(dataSourceConfig.getSchemaname());
        if (querySqlModel != null) {
            tableSql = dataSourceConfig.getUsername().equals(dataSourceConfig.getSchemaname()) || "".equals(dataSourceConfig.getSchemaname()) || dataSourceConfig.getSchemaname() == null ? querySqlModel.getTableSqlTemplate().replace("${dbName}", dataSourceConfig.getUsername()) : querySqlModel.getTableSqlTemplate().replace("${dbName}", dataSourceConfig.getSchemaname());
        }
        if (querySqlModel != null) {
            tableSqlWithTask = dataSourceConfig.getUsername().equals(dataSourceConfig.getSchemaname()) || "".equals(dataSourceConfig.getSchemaname()) || dataSourceConfig.getSchemaname() == null ? querySqlModel.getTableSqlWithTaskTemplate().replace("${dbName}", dataSourceConfig.getUsername()) : querySqlModel.getTableSqlWithTaskTemplate().replace("${dbName}", dataSourceConfig.getSchemaname());
        }
        if (querySqlModel != null) {
            fieldSql = dataSourceConfig.getUsername().equals(dataSourceConfig.getSchemaname()) || "".equals(dataSourceConfig.getSchemaname()) || dataSourceConfig.getSchemaname() == null ? querySqlModel.getFieldSqlTemplate().replace("${dbName}", dataSourceConfig.getUsername()) : querySqlModel.getFieldSqlTemplate().replace("${dbName}", dataSourceConfig.getSchemaname());
        }
        if (querySqlModel != null) {
            indexSql = dataSourceConfig.getUsername().equals(dataSourceConfig.getSchemaname()) || "".equals(dataSourceConfig.getSchemaname()) || dataSourceConfig.getSchemaname() == null ? querySqlModel.getIndexSqlTemplate().replace("${dbName}", dataSourceConfig.getUsername()) : querySqlModel.getIndexSqlTemplate().replace("${dbName}", dataSourceConfig.getSchemaname());
        }
        if (HussarUtils.isNotEmpty((Object)type) && tableSql != null) {
            switch (type) {
                case "VIEW": {
                    tableSql = tableSql.replace("${tableType}", "VIEW").replace("${tableType1}", "VIEW");
                    break;
                }
                case "BASE TABLE": {
                    tableSql = tableSql.replace("${tableType}", "BASE TABLE").replace("${tableType1}", "BASE TABLE");
                    break;
                }
                case "ALL": {
                    tableSql = tableSql.replace("${tableType}", "VIEW").replace("${tableType1}", "BASE TABLE");
                    break;
                }
                case "BASE TABLE TASK": {
                    if (tableSqlWithTask == null) break;
                    tableSql = tableSqlWithTask.replace("${tableType}", "BASE TABLE").replace("${tableType1}", "BASE TABLE");
                }
            }
        }
        List tableList = this.dsDataSourceBaseMapper.selectList(tableSql);
        List fieldList = this.dsDataSourceBaseMapper.selectList(fieldSql);
        List indexList = this.dsDataSourceBaseMapper.selectList(indexSql);
        this.dealTableResultMap(dsTableInfoList, tableList);
        this.dealFieldResultMap(fieldInfo, fieldList);
        this.dealIndexResultMap(indexInfo, indexList);
        return SqlPublicMethodUtil.combinedBatch(dsTableInfoList, fieldInfo, indexInfo);
    }

    public List<DsTableInfo> getTableInfoWithoutFiled(DataSourceConfig dataSourceConfig, String type) {
        ArrayList<DsTableInfo> dsTableInfoList = new ArrayList<DsTableInfo>();
        ArrayList fieldInfo = new ArrayList();
        ArrayList<DsTableIndex> indexInfo = new ArrayList<DsTableIndex>();
        QuerySqlModel querySqlModel = SqlPublicMethodUtil.getQuerySqlObject((DataSourceConfig)dataSourceConfig);
        String tableSql = null;
        String fieldSql = null;
        String indexSql = null;
        String tableSqlWithTask = null;
        dataSourceConfig.setUsername(dataSourceConfig.getUsername());
        dataSourceConfig.setSchemaname(dataSourceConfig.getSchemaname());
        if (querySqlModel != null) {
            tableSql = dataSourceConfig.getUsername().equals(dataSourceConfig.getSchemaname()) || "".equals(dataSourceConfig.getSchemaname()) || dataSourceConfig.getSchemaname() == null ? querySqlModel.getTableSqlTemplate().replace("${dbName}", dataSourceConfig.getUsername()) : querySqlModel.getTableSqlTemplate().replace("${dbName}", dataSourceConfig.getSchemaname());
        }
        if (querySqlModel != null) {
            tableSqlWithTask = dataSourceConfig.getUsername().equals(dataSourceConfig.getSchemaname()) || "".equals(dataSourceConfig.getSchemaname()) || dataSourceConfig.getSchemaname() == null ? querySqlModel.getTableSqlWithTaskTemplate().replace("${dbName}", dataSourceConfig.getUsername()) : querySqlModel.getTableSqlWithTaskTemplate().replace("${dbName}", dataSourceConfig.getSchemaname());
        }
        if (querySqlModel != null) {
            fieldSql = dataSourceConfig.getUsername().equals(dataSourceConfig.getSchemaname()) || "".equals(dataSourceConfig.getSchemaname()) || dataSourceConfig.getSchemaname() == null ? querySqlModel.getFieldSqlTemplate().replace("${dbName}", dataSourceConfig.getUsername()) : querySqlModel.getFieldSqlTemplate().replace("${dbName}", dataSourceConfig.getSchemaname());
        }
        if (querySqlModel != null) {
            indexSql = dataSourceConfig.getUsername().equals(dataSourceConfig.getSchemaname()) || "".equals(dataSourceConfig.getSchemaname()) || dataSourceConfig.getSchemaname() == null ? querySqlModel.getIndexSqlTemplate().replace("${dbName}", dataSourceConfig.getUsername()) : querySqlModel.getIndexSqlTemplate().replace("${dbName}", dataSourceConfig.getSchemaname());
        }
        if (HussarUtils.isNotEmpty((Object)type) && tableSql != null) {
            switch (type) {
                case "VIEW": {
                    tableSql = tableSql.replace("${tableType}", "VIEW").replace("${tableType1}", "VIEW");
                    break;
                }
                case "BASE TABLE": {
                    tableSql = tableSql.replace("${tableType}", "BASE TABLE").replace("${tableType1}", "BASE TABLE");
                    break;
                }
                case "ALL": {
                    tableSql = tableSql.replace("${tableType}", "VIEW").replace("${tableType1}", "BASE TABLE");
                    break;
                }
                case "BASE TABLE TASK": {
                    if (tableSqlWithTask == null) break;
                    tableSql = tableSqlWithTask.replace("${tableType}", "BASE TABLE").replace("${tableType1}", "BASE TABLE");
                }
            }
        }
        List tableList = this.dsDataSourceBaseMapper.selectList(tableSql);
        List<Map<String, Object>> indexList = null;
        this.dealTableResultMap(dsTableInfoList, tableList);
        this.dealIndexResultMap(indexInfo, indexList);
        return dsTableInfoList;
    }

    private void dealFieldResultMap(List<DsTableField> fieldInfo, List<Map<String, Object>> fieldList) {
        for (Map<String, Object> stringObjectMap : fieldList) {
            DsTableField dsTableField = new DsTableField();
            dsTableField.setTableName((String)stringObjectMap.get("table_name"));
            dsTableField.setName((String)stringObjectMap.get("column_name"));
            dsTableField.setComment((String)stringObjectMap.get("des"));
            String type = String.valueOf(stringObjectMap.get("data_type"));
            if ("real".equals(type)) {
                type = "FLOAT4";
            }
            if ("double precision".equals(type)) {
                type = "FLOAT8";
            }
            if ("time without time zone".equals(type)) {
                type = "TIME";
            }
            if ("timestamp without time zone".equals(type)) {
                type = "TIMESTAMP";
            }
            if ("character varying".equals(type)) {
                type = "VARCHAR";
            }
            if ("character".equals(type)) {
                type = "BPCHAR";
            }
            dsTableField.setType(type);
            Object dataLength = Optional.ofNullable(stringObjectMap.get("collength")).orElse("0");
            dsTableField.setDataLength(Integer.parseInt(String.valueOf(dataLength)));
            dsTableField.setDataDefaultValue((String)stringObjectMap.get("defaultvalue"));
            dsTableField.setDataIsEmpty(0 == (Integer)stringObjectMap.get("isempty"));
            dsTableField.setPrimarys((Integer)stringObjectMap.get("pk_id") == 0 ? null : "PRI");
            Optional.ofNullable(stringObjectMap.get("numeric_scale")).ifPresent(dataDto -> dsTableField.setDataDot(Integer.parseInt(String.valueOf(dataDto))));
            fieldInfo.add(dsTableField);
        }
    }

    private void dealIndexResultMap(List<DsTableIndex> indexInfo, List<Map<String, Object>> indexList) {
        if (HussarUtils.isEmpty(indexList)) {
            return;
        }
        for (int i = 0; i < indexList.size(); ++i) {
            if (Integer.valueOf(indexList.get(i).get("isPrimaryIndex".toLowerCase()).toString()) == 1) continue;
            DsTableIndex dsTableIndex = new DsTableIndex();
            dsTableIndex.setIndexName((String)indexList.get(i).get("indexName".toLowerCase()));
            dsTableIndex.setIndexType((String)indexList.get(i).get("indexType".toLowerCase()));
            dsTableIndex.setTableName((String)indexList.get(i).get("tableName".toLowerCase()));
            dsTableIndex.setTableSchema((String)indexList.get(i).get("tableSchema".toLowerCase()));
            dsTableIndex.setColumnName((String)indexList.get(i).get("columnName".toLowerCase()));
            dsTableIndex.setIsNonUnique(Integer.parseInt(indexList.get(i).get("isNonUnique".toLowerCase()).toString()));
            indexInfo.add(dsTableIndex);
        }
    }

    private void dealTableResultMap(List<DsTableInfo> dsTableInfoList, List<Map<String, Object>> tableResultSet) {
        tableResultSet.forEach(stringObjectMap -> {
            DsTableInfo dsTableInfo = new DsTableInfo();
            dsTableInfo.setName((String)stringObjectMap.get("name"));
            dsTableInfo.setComment((String)stringObjectMap.get("comment"));
            String type = (String)stringObjectMap.get("type");
            dsTableInfo.setType(type);
            dsTableInfo.setView(!"BASE TABLE".equalsIgnoreCase(type));
            dsTableInfoList.add(dsTableInfo);
        });
    }

    public List<DsTableField> getTableFieldByTableName(DataSourceConfig dataSourceConfig, String tableName) {
        QuerySqlModel querySqlModel = SqlPublicMethodUtil.getQuerySqlObject((DataSourceConfig)dataSourceConfig);
        String fieldSql = null;
        dataSourceConfig.setUsername(dataSourceConfig.getUsername());
        dataSourceConfig.setSchemaname(dataSourceConfig.getSchemaname());
        if (querySqlModel != null) {
            fieldSql = !dataSourceConfig.getUsername().equals(dataSourceConfig.getSchemaname()) && !"".equals(dataSourceConfig.getSchemaname()) && dataSourceConfig.getSchemaname() != null ? querySqlModel.getSingleFiledTemplate().replace("${dbName}", dataSourceConfig.getSchemaname()).replace("${tableName}", tableName) : querySqlModel.getSingleFiledTemplate().replace("${dbName}", dataSourceConfig.getUsername()).replace("${tableName}", tableName);
        }
        List fieldList = this.dsDataSourceBaseMapper.selectList(fieldSql);
        ArrayList<DsTableField> dsTableFieldList = new ArrayList<DsTableField>();
        this.dealFieldResultMap(dsTableFieldList, fieldList);
        return dsTableFieldList;
    }
}

