/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.ds.query.gauss.filter;

import com.jxdinfo.hussar.datasource.config.DataSourceConfig;
import com.jxdinfo.hussar.datasource.config.querysql.QuerySqlModel;
import com.jxdinfo.hussar.datasource.dao.DsDataSourceBaseMapper;
import com.jxdinfo.hussar.datasource.enm.TableTypeEnum;
import com.jxdinfo.hussar.datasource.exception.DataSourceException;
import com.jxdinfo.hussar.datasource.filter.SqlExecuteHandler;
import com.jxdinfo.hussar.datasource.model.DsTableField;
import com.jxdinfo.hussar.datasource.model.DsTableIndex;
import com.jxdinfo.hussar.datasource.model.DsTableInfo;
import com.jxdinfo.hussar.datasource.util.SqlPublicMethodUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="ds.query.gauss")
public class GaussFilter
implements SqlExecuteHandler {
    private static final Logger logger = LoggerFactory.getLogger(GaussFilter.class);
    private static final String DEFAULT_SCHEMA = "public";
    @Resource
    private DsDataSourceBaseMapper dsDataSourceBaseMapper;

    public List<DsTableInfo> selectBatch(DataSourceConfig dataSourceConfig, String type) {
        ArrayList<DsTableInfo> dsTableInfoList = new ArrayList<DsTableInfo>();
        ArrayList fieldInfo = new ArrayList();
        ArrayList<DsTableIndex> indexInfo = new ArrayList<DsTableIndex>();
        QuerySqlModel querySqlModel = SqlPublicMethodUtil.getQuerySqlObject((DataSourceConfig)dataSourceConfig);
        String tableSql = null;
        String fieldSql = null;
        String indexSql = null;
        String tableSqlWithTask = null;
        dataSourceConfig.setUsername(dataSourceConfig.getUsername());
        dataSourceConfig.setSchemaname(dataSourceConfig.getSchemaname());
        String dbName = DEFAULT_SCHEMA;
        if (HussarUtils.isNotEmpty((Object)dataSourceConfig.getSchemaname())) {
            dbName = dataSourceConfig.getSchemaname();
        }
        if (querySqlModel != null) {
            tableSql = querySqlModel.getTableSqlTemplate().replace("${dbName}", dbName);
        }
        if (querySqlModel != null) {
            tableSqlWithTask = querySqlModel.getTableSqlWithTaskTemplate().replace("${dbName}", dbName);
        }
        if (querySqlModel != null) {
            fieldSql = querySqlModel.getFieldSqlTemplate().replace("${dbName}", dbName);
        }
        if (querySqlModel != null) {
            indexSql = querySqlModel.getIndexSqlTemplate().replace("${dbName}", dbName);
        }
        if (HussarUtils.isNotEmpty((Object)type) && tableSql != null) {
            switch (type) {
                case "VIEW": {
                    tableSql = tableSql.replace("${tableType}", "VIEW").replace("${tableType1}", "VIEW");
                    break;
                }
                case "BASE TABLE": {
                    tableSql = tableSql.replace("${tableType}", "BASE TABLE").replace("${tableType1}", "BASE TABLE");
                    break;
                }
                case "ALL": {
                    tableSql = tableSql.replace("${tableType}", "VIEW").replace("${tableType1}", "BASE TABLE");
                    break;
                }
                case "BASE TABLE TASK": {
                    if (tableSqlWithTask == null) break;
                    tableSql = tableSqlWithTask.replace("${tableType}", "BASE TABLE").replace("${tableType1}", "BASE TABLE");
                }
            }
        }
        List tableList = this.dsDataSourceBaseMapper.selectList(tableSql);
        List<Map<String, Object>> indexList = null;
        this.dealTableResultMap(dsTableInfoList, tableList);
        this.dealIndexResultMap(indexInfo, indexList);
        return dsTableInfoList;
    }

    public Optional<DsTableInfo> selectOne(DataSourceConfig dataSourceConfig, String type, String tableName) {
        QuerySqlModel querySqlModel = SqlPublicMethodUtil.getQuerySqlObject((DataSourceConfig)dataSourceConfig);
        if (null == querySqlModel) {
            return Optional.empty();
        }
        String tableSql = null;
        String fieldSql = null;
        String indexSql = null;
        dataSourceConfig.setUsername(dataSourceConfig.getUsername());
        dataSourceConfig.setSchemaname(dataSourceConfig.getSchemaname());
        String dbName = DEFAULT_SCHEMA;
        if (HussarUtils.isNotEmpty((Object)dataSourceConfig.getSchemaname())) {
            dbName = dataSourceConfig.getSchemaname();
        }
        tableSql = querySqlModel.getSingleTableTemplate().replace("${dbName}", dbName).replace("${tableName}", tableName);
        fieldSql = querySqlModel.getSingleFiledTemplate().replace("${dbName}", dbName).replace("${tableName}", tableName);
        indexSql = querySqlModel.getSingleIndexSqlTemplate().replace("${dbName}", dbName).replace("${tableName}", tableName);
        if (HussarUtils.isNotEmpty((Object)type)) {
            TableTypeEnum tableTypeEnum = TableTypeEnum.valueOf((String)type.toUpperCase());
            switch (tableTypeEnum) {
                case VIEW: {
                    tableSql = tableSql.replace("${tableType}", TableTypeEnum.VIEW.getValue());
                    break;
                }
                case BASE_TABLE: {
                    tableSql = tableSql.replace("${tableType}", TableTypeEnum.BASE_TABLE.getValue());
                    break;
                }
                case ALL: {
                    tableSql = tableSql.replace("${tableType}", TableTypeEnum.VIEW.getValue()).replace("${tableType1}", TableTypeEnum.BASE_TABLE.getValue());
                    break;
                }
                default: {
                    throw new IllegalArgumentException("failed to match table type");
                }
            }
        }
        List tableList = this.dsDataSourceBaseMapper.execute(tableSql);
        List fieldList = this.dsDataSourceBaseMapper.execute(fieldSql);
        List<Map<String, Object>> indexList = null;
        if (HussarUtils.isEmpty((Object)tableList)) {
            return Optional.empty();
        }
        ArrayList<DsTableInfo> dsTableInfoList = new ArrayList<DsTableInfo>();
        ArrayList<DsTableField> fieldInfo = new ArrayList<DsTableField>();
        ArrayList<DsTableIndex> indexInfo = new ArrayList<DsTableIndex>();
        this.dealTableResultMap(dsTableInfoList, tableList);
        this.dealFieldResultMap(fieldInfo, fieldList);
        this.dealIndexResultMap(indexInfo, indexList);
        return Optional.ofNullable(SqlPublicMethodUtil.combined((DsTableInfo)((DsTableInfo)dsTableInfoList.get(0)), fieldInfo, indexInfo));
    }

    public List<DsTableInfo> selectTableBatch(DataSourceConfig dataSourceConfig, String s) throws DataSourceException {
        return null;
    }

    public List<DsTableInfo> selectTableInfoBatch(DataSourceConfig dataSourceConfig, String s, List<String> list) {
        return null;
    }

    public List<DsTableInfo> getTableInfoWithoutFiled(DataSourceConfig dataSourceConfig, String type) {
        ArrayList<DsTableInfo> dsTableInfoList = new ArrayList<DsTableInfo>();
        ArrayList fieldInfo = new ArrayList();
        ArrayList<DsTableIndex> indexInfo = new ArrayList<DsTableIndex>();
        QuerySqlModel querySqlModel = SqlPublicMethodUtil.getQuerySqlObject((DataSourceConfig)dataSourceConfig);
        String tableSql = null;
        String fieldSql = null;
        String indexSql = null;
        String tableSqlWithTask = null;
        dataSourceConfig.setUsername(dataSourceConfig.getUsername());
        dataSourceConfig.setSchemaname(dataSourceConfig.getSchemaname());
        String dbName = DEFAULT_SCHEMA;
        if (HussarUtils.isNotEmpty((Object)dataSourceConfig.getSchemaname())) {
            dbName = dataSourceConfig.getSchemaname();
        }
        if (querySqlModel != null) {
            tableSql = querySqlModel.getTableSqlTemplate().replace("${dbName}", dbName);
        }
        if (querySqlModel != null) {
            tableSqlWithTask = querySqlModel.getTableSqlWithTaskTemplate().replace("${dbName}", dbName);
        }
        if (querySqlModel != null) {
            fieldSql = querySqlModel.getFieldSqlTemplate().replace("${dbName}", dbName);
        }
        if (querySqlModel != null) {
            indexSql = querySqlModel.getIndexSqlTemplate().replace("${dbName}", dbName);
        }
        if (HussarUtils.isNotEmpty((Object)type) && tableSql != null) {
            switch (type) {
                case "VIEW": {
                    tableSql = tableSql.replace("${tableType}", "VIEW").replace("${tableType1}", "VIEW");
                    break;
                }
                case "BASE TABLE": {
                    tableSql = tableSql.replace("${tableType}", "BASE TABLE").replace("${tableType1}", "BASE TABLE");
                    break;
                }
                case "ALL": {
                    tableSql = tableSql.replace("${tableType}", "VIEW").replace("${tableType1}", "BASE TABLE");
                    break;
                }
                case "BASE TABLE TASK": {
                    if (tableSqlWithTask == null) break;
                    tableSql = tableSqlWithTask.replace("${tableType}", "BASE TABLE").replace("${tableType1}", "BASE TABLE");
                }
            }
        }
        List tableList = this.dsDataSourceBaseMapper.selectList(tableSql);
        List<Map<String, Object>> indexList = null;
        this.dealTableResultMap(dsTableInfoList, tableList);
        this.dealIndexResultMap(indexInfo, indexList);
        return dsTableInfoList;
    }

    public List<DsTableInfo> selectTableInfoWithFieldInfoBatch(DataSourceConfig dataSourceConfig, String type) throws DataSourceException {
        ArrayList<DsTableInfo> dsTableInfoList = new ArrayList<DsTableInfo>();
        ArrayList<DsTableField> fieldInfo = new ArrayList<DsTableField>();
        ArrayList<DsTableIndex> indexInfo = new ArrayList<DsTableIndex>();
        QuerySqlModel querySqlModel = SqlPublicMethodUtil.getQuerySqlObject((DataSourceConfig)dataSourceConfig);
        String tableSql = null;
        String fieldSql = null;
        String indexSql = null;
        String tableSqlWithTask = null;
        dataSourceConfig.setUsername(dataSourceConfig.getUsername());
        dataSourceConfig.setSchemaname(dataSourceConfig.getSchemaname());
        String dbName = DEFAULT_SCHEMA;
        if (HussarUtils.isNotEmpty((Object)dataSourceConfig.getSchemaname())) {
            dbName = dataSourceConfig.getSchemaname();
        }
        if (querySqlModel != null) {
            tableSql = querySqlModel.getTableSqlTemplate().replace("${dbName}", dbName);
        }
        if (querySqlModel != null) {
            tableSqlWithTask = querySqlModel.getTableSqlWithTaskTemplate().replace("${dbName}", dbName);
        }
        if (querySqlModel != null) {
            fieldSql = querySqlModel.getFieldSqlTemplate().replace("${dbName}", dbName);
        }
        if (querySqlModel != null) {
            indexSql = querySqlModel.getIndexSqlTemplate().replace("${dbName}", dbName);
        }
        if (HussarUtils.isNotEmpty((Object)type) && tableSql != null) {
            switch (type) {
                case "VIEW": {
                    tableSql = tableSql.replace("${tableType}", "VIEW").replace("${tableType1}", "VIEW");
                    break;
                }
                case "BASE TABLE": {
                    tableSql = tableSql.replace("${tableType}", "BASE TABLE").replace("${tableType1}", "BASE TABLE");
                    break;
                }
                case "ALL": {
                    tableSql = tableSql.replace("${tableType}", "VIEW").replace("${tableType1}", "BASE TABLE");
                    break;
                }
                case "BASE TABLE TASK": {
                    if (tableSqlWithTask == null) break;
                    tableSql = tableSqlWithTask.replace("${tableType}", "BASE TABLE").replace("${tableType1}", "BASE TABLE");
                }
            }
        }
        List tableList = this.dsDataSourceBaseMapper.selectList(tableSql);
        List fieldList = this.dsDataSourceBaseMapper.selectList(fieldSql);
        List indexList = this.dsDataSourceBaseMapper.selectList(indexSql);
        this.dealTableResultMap(dsTableInfoList, tableList);
        this.dealFieldResultMap(fieldInfo, fieldList);
        this.dealIndexResultMap(indexInfo, indexList);
        return SqlPublicMethodUtil.combinedBatch(dsTableInfoList, fieldInfo, indexInfo);
    }

    private void dealFieldResultMap(List<DsTableField> fieldInfo, List<Map<String, Object>> fieldList) {
        for (Map<String, Object> stringObjectMap : fieldList) {
            DsTableField dsTableField = new DsTableField();
            dsTableField.setTableName((String)stringObjectMap.get("table_name"));
            dsTableField.setName((String)stringObjectMap.get("column_name"));
            dsTableField.setComment((String)stringObjectMap.get("des"));
            String type = String.valueOf(stringObjectMap.get("data_type"));
            if ("real".equals(type)) {
                type = "FLOAT4";
            }
            if ("double precision".equals(type)) {
                type = "FLOAT8";
            }
            if ("time without time zone".equals(type)) {
                type = "TIME";
            }
            if ("timestamp without time zone".equals(type)) {
                type = "TIMESTAMP";
            }
            if ("character varying".equals(type)) {
                type = "VARCHAR";
            }
            if ("character".equals(type)) {
                type = "BPCHAR";
            }
            dsTableField.setType(type);
            Object dataLength = Optional.ofNullable(stringObjectMap.get("collength")).orElse("0");
            dsTableField.setDataLength(Integer.parseInt(String.valueOf(dataLength)));
            dsTableField.setDataDefaultValue((String)stringObjectMap.get("defaultvalue"));
            dsTableField.setDataIsEmpty(0 == (Integer)stringObjectMap.get("isempty"));
            dsTableField.setPrimarys((Integer)stringObjectMap.get("pk_id") == 0 ? null : "PRI");
            Optional.ofNullable(stringObjectMap.get("numeric_scale")).ifPresent(dataDto -> dsTableField.setDataDot(Integer.parseInt(String.valueOf(dataDto))));
            fieldInfo.add(dsTableField);
        }
    }

    private void dealIndexResultMap(List<DsTableIndex> indexInfo, List<Map<String, Object>> indexList) {
        if (HussarUtils.isEmpty(indexList)) {
            return;
        }
        for (int i = 0; i < indexList.size(); ++i) {
            DsTableIndex dsTableIndex = new DsTableIndex();
            dsTableIndex.setIndexName((String)indexList.get(i).get("index_name"));
            dsTableIndex.setIndexType((String)indexList.get(i).get("index_type"));
            dsTableIndex.setTableName((String)indexList.get(i).get("table_name"));
            dsTableIndex.setTableSchema((String)indexList.get(i).get("table_schema"));
            dsTableIndex.setColumnName((String)indexList.get(i).get("column_name"));
            dsTableIndex.setIsNonUnique((Boolean)indexList.get(i).get("is_non_unique") != false ? 1 : 0);
            indexInfo.add(dsTableIndex);
        }
    }

    private void dealTableResultMap(List<DsTableInfo> dsTableInfoList, List<Map<String, Object>> tableResultSet) {
        tableResultSet.forEach(stringObjectMap -> {
            DsTableInfo dsTableInfo = new DsTableInfo();
            dsTableInfo.setName((String)stringObjectMap.get("name"));
            dsTableInfo.setComment((String)stringObjectMap.get("comment"));
            String type = (String)stringObjectMap.get("type");
            dsTableInfo.setType(type);
            dsTableInfo.setView(!"BASE TABLE".equalsIgnoreCase(type));
            dsTableInfoList.add(dsTableInfo);
        });
    }

    public List<DsTableField> getTableFieldByTableName(DataSourceConfig dataSourceConfig, String tableName) {
        QuerySqlModel querySqlModel = SqlPublicMethodUtil.getQuerySqlObject((DataSourceConfig)dataSourceConfig);
        String fieldSql = null;
        String dbName = DEFAULT_SCHEMA;
        if (HussarUtils.isNotEmpty((Object)dataSourceConfig.getSchemaname())) {
            dbName = dataSourceConfig.getSchemaname();
        }
        if (querySqlModel != null) {
            fieldSql = querySqlModel.getSingleFiledTemplate().replace("${dbName}", dbName).replace("${tableName}", tableName);
        }
        List fieldList = this.dsDataSourceBaseMapper.selectList(fieldSql);
        ArrayList<DsTableField> dsTableFieldList = new ArrayList<DsTableField>();
        this.dealFieldResultMap(dsTableFieldList, fieldList);
        return dsTableFieldList;
    }
}

