/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.sync.utils;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.sync.enums.CheckUserNamePwdResult;
import com.jxdinfo.hussar.sync.enums.ObjectMapperInstance;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class IAMDataSyncUtil {
    private static final ObjectMapper OBJECT_MAPPER = ObjectMapperInstance.INSTANCE.getObjectMapper();

    public static CheckUserNamePwdResult checkUserNamePwd(String bimRemoteUser, String bimRemotePwd, String localUserName, String localPwd) {
        if (HussarUtils.hasEmpty((Object[])new Object[]{localUserName, localPwd})) {
            return CheckUserNamePwdResult.MISSING_CONFIGURATION;
        }
        if (!localUserName.equals(bimRemoteUser) || !localPwd.equals(bimRemotePwd)) {
            return CheckUserNamePwdResult.FAILURE;
        }
        return CheckUserNamePwdResult.SUCCESS;
    }

    public static ObjectNode assembleSchemaAttrInfo(Object source, List<String> schemaAttrs) {
        ObjectNode result = OBJECT_MAPPER.createObjectNode();
        if (source == null) {
            return result;
        }
        ArrayList<Field> allFields = new ArrayList<Field>();
        for (Class<?> currentClass = source.getClass(); currentClass != null; currentClass = currentClass.getSuperclass()) {
            allFields.addAll(Arrays.asList(currentClass.getDeclaredFields()));
        }
        Map<String, Field> fieldMap = allFields.stream().collect(Collectors.toMap(Field::getName, field -> field));
        for (String schemaAttr : schemaAttrs) {
            if (!fieldMap.containsKey(schemaAttr)) continue;
            try {
                Field field2 = fieldMap.get(schemaAttr);
                field2.setAccessible(true);
                Object value = field2.get(source);
                result.set(schemaAttr, OBJECT_MAPPER.valueToTree(value));
            }
            catch (IllegalAccessException e) {
                throw new BaseException(String.format("\u7ec4\u88c5%s\u5c5e\u6027\u5f02\u5e38", schemaAttr), (Throwable)e);
            }
        }
        return result;
    }

    public static void mergeObjectNodes(ObjectNode sourceNode, ObjectNode targetNode) {
        sourceNode.fields().forEachRemaining(entry -> targetNode.set((String)entry.getKey(), (JsonNode)entry.getValue()));
    }
}

