/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.sync.manager;

import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.google.common.collect.Lists;
import com.jxdinfo.hussar.authorization.enums.TipConstantsEnum;
import com.jxdinfo.hussar.authorization.enums.UserStatus;
import com.jxdinfo.hussar.authorization.organ.constants.OrganConstants;
import com.jxdinfo.hussar.authorization.organ.dao.SysStaffMapper;
import com.jxdinfo.hussar.authorization.organ.dao.SysStruMapper;
import com.jxdinfo.hussar.authorization.organ.dto.EditOnlyOutsideUserDto;
import com.jxdinfo.hussar.authorization.organ.dto.EditOutsideUserDto;
import com.jxdinfo.hussar.authorization.organ.model.SysStaff;
import com.jxdinfo.hussar.authorization.organ.service.ISysStaffService;
import com.jxdinfo.hussar.authorization.organ.util.OrganUtil;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.ISysUsersService;
import com.jxdinfo.hussar.authorization.relational.model.SysStruStaff;
import com.jxdinfo.hussar.authorization.relational.model.SysStruUser;
import com.jxdinfo.hussar.authorization.relational.service.ISysStruStaffService;
import com.jxdinfo.hussar.authorization.relational.service.ISysStruUserService;
import com.jxdinfo.hussar.base.config.baseconfig.service.IHussarLoginConfigService;
import com.jxdinfo.hussar.common.base.DataMapping;
import com.jxdinfo.hussar.common.base.Error;
import com.jxdinfo.hussar.common.base.R;
import com.jxdinfo.hussar.general.idtable.service.ISysIdtableService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.utils.TranslateUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UpdateAccountManager {
    @Autowired
    private IHussarLoginConfigService hussarLoginConfigService;
    @Autowired
    private ISysUsersService sysUsersService;
    @Resource
    private SysStruMapper sysStruMapper;
    @Autowired
    private ISysStaffService sysStaffService;
    @Autowired
    private ISysIdtableService sysIdtableService;
    @Resource
    private SysStaffMapper sysStaffMapper;
    @Autowired
    private ISysStruStaffService sysStruStaffService;
    @Autowired
    private ISysStruUserService sysStruUserService;

    public R<EditOutsideUserDto> doUpdate(EditOutsideUserDto user) {
        List organIds;
        boolean convert;
        R result = new R();
        List errors = OrganUtil.validateOne((Object)user);
        String account = user.getUserAccount();
        boolean bl = convert = this.hussarLoginConfigService.getLoginUpperOpen() == false && !OrganConstants.EXCLUDE_USERS.contains(account);
        if (convert) {
            account = account.toUpperCase();
        }
        if (user.getUpdateDeleteFlag().booleanValue()) {
            return this.editLogicalDeleteUser(user, (R<EditOutsideUserDto>)result, errors, account);
        }
        SysUsers sysUsers = (SysUsers)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.sysUsersService.lambdaQuery().eq(SysUsers::getUserAccount, (Object)account)).ne(SysUsers::getAccountStatus, (Object)UserStatus.DELETE.getCode())).one();
        if (sysUsers == null) {
            OrganUtil.addErrorMsg((List)errors, (Object)user, (String)"userAccount", (String[])new String[]{TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_USER_ACCOUNT_NOT_EXIST.getMessage())});
        }
        if (HussarUtils.isNotEmpty((Object)(organIds = user.getOrganIds()))) {
            organIds = organIds.stream().distinct().collect(Collectors.toList());
            user.setOrganIds(organIds);
            List existStruIds = this.sysStruMapper.selectExistIdByIds(organIds);
            if (existStruIds.size() != organIds.size()) {
                StringBuilder msg = new StringBuilder();
                for (Long organId : organIds) {
                    if (existStruIds.contains(organId)) continue;
                    msg.append(organId).append(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ORGAN_NOT_EMPTY.getMessage())).append("\uff1a");
                }
                OrganUtil.addErrorMsg((List)errors, (Object)user, (String)"organIds", (String[])new String[]{msg.toString()});
            }
        }
        if (HussarUtils.isEmpty((Object)errors)) {
            SysStaff sysStaff = (SysStaff)this.sysStaffService.getById((Serializable)sysUsers.getEmployeeId());
            this.initializationEdit(user, sysStaff, sysUsers);
            if (HussarUtils.isNotEmpty(organIds)) {
                Long departmentId = (Long)organIds.get(0);
                sysUsers.setCorporationId(departmentId);
                sysUsers.setDepartmentId(departmentId);
                this.handleUserStaff(user, sysUsers);
            }
            this.sysStaffService.updateById((Object)sysStaff);
            this.sysUsersService.updateById((Object)sysUsers);
            result.setSuccessList((List)Lists.newArrayList((Object[])new DataMapping[]{new DataMapping(sysUsers.getId(), StringUtils.trimToEmpty((String)sysUsers.getUserAccount()))}));
        } else {
            result.setSuccess(false);
            result.setErrorList(errors);
        }
        return result;
    }

    private R<EditOutsideUserDto> editLogicalDeleteUser(EditOutsideUserDto user, R<EditOutsideUserDto> result, List<Error<EditOutsideUserDto>> errors, String account) {
        List organIds;
        SysUsers sysUsers = (SysUsers)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.sysUsersService.lambdaQuery().eq(SysUsers::getUserAccount, (Object)account)).eq(SysUsers::getAccountStatus, (Object)UserStatus.DELETE.getCode())).one();
        if (sysUsers == null) {
            OrganUtil.addErrorMsg(errors, (Object)user, (String)"userAccount", (String[])new String[]{TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_USER_ACCOUNT_NOT_EXIST.getMessage())});
        }
        if (HussarUtils.isNotEmpty((Object)(organIds = user.getOrganIds()))) {
            organIds = organIds.stream().distinct().collect(Collectors.toList());
            user.setOrganIds(organIds);
            List existStruIds = this.sysStruMapper.selectExistIdByIds(organIds);
            if (existStruIds.size() != organIds.size()) {
                StringBuilder msg = new StringBuilder();
                for (Long organId : organIds) {
                    if (existStruIds.contains(organId)) continue;
                    msg.append(organId).append(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ORGAN_NOT_EMPTY.getMessage())).append("\uff1a");
                }
                OrganUtil.addErrorMsg(errors, (Object)user, (String)"organIds", (String[])new String[]{msg.toString()});
            }
        }
        if (HussarUtils.isEmpty(errors)) {
            SysStaff sysStaff = new SysStaff();
            this.initializationAddStaff(user, sysStaff);
            sysUsers.setEmployeeId(sysStaff.getId());
            sysUsers.setAccountStatus(UserStatus.OK.getCode());
            this.initializationEdit(user, sysStaff, sysUsers);
            this.sysStaffService.save((Object)sysStaff);
            if (HussarUtils.isNotEmpty(organIds)) {
                Long departmentId = (Long)organIds.get(0);
                sysUsers.setCorporationId(departmentId);
                sysUsers.setDepartmentId(departmentId);
                this.handleUserStaff(user, sysUsers);
            }
            this.sysUsersService.updateById((Object)sysUsers);
            result.setSuccessList((List)Lists.newArrayList((Object[])new DataMapping[]{new DataMapping(sysUsers.getId(), StringUtils.trimToEmpty((String)sysUsers.getUserAccount()))}));
        } else {
            result.setSuccess(false);
            result.setErrorList(errors);
        }
        return result;
    }

    private void initializationAddStaff(EditOutsideUserDto userDto, SysStaff sysStaff) {
        Integer maxStaffOrder;
        Long sysStaffId = IdWorker.getId((Object)sysStaff);
        String userName = StringUtils.trimToEmpty((String)userDto.getUserName());
        String staffPosition = StringUtils.trimToEmpty((String)userDto.getStaffPosition());
        String sex = StringUtils.trimToEmpty((String)userDto.getSex());
        String birthday = StringUtils.trimToEmpty((String)userDto.getBirthday());
        String idcard = StringUtils.trimToEmpty((String)userDto.getIdcard());
        String address = StringUtils.trimToEmpty((String)userDto.getAddress());
        String workId = StringUtils.trimToEmpty((String)userDto.getWorkId());
        String workDate = StringUtils.trimToEmpty((String)userDto.getWorkDate());
        String graduateDate = StringUtils.trimToEmpty((String)userDto.getGraduateDate());
        String graduateSchool = StringUtils.trimToEmpty((String)userDto.getGraduateSchool());
        Integer order = userDto.getUserOrder();
        sysStaff.setId(sysStaffId);
        sysStaff.setName(userName);
        sysStaff.setAddress(address);
        sysStaff.setBirthday(birthday);
        sysStaff.setSex(sex);
        sysStaff.setIdcard(idcard);
        sysStaff.setGraduateDate(graduateDate);
        sysStaff.setGraduateSchool(graduateSchool);
        sysStaff.setWorkDate(workDate);
        sysStaff.setWorkId(workId);
        sysStaff.setStaffPosition(staffPosition);
        sysStaff.setStaffCode(this.sysIdtableService.getCurrentCode("STAFF_CODE", "SYS_STAFF"));
        int staffOrder = 1;
        staffOrder = HussarUtils.isEmpty((Object)order) ? (HussarUtils.isEmpty((Object)(maxStaffOrder = this.sysStaffMapper.getMaxOrder())) ? staffOrder : maxStaffOrder + 1) : order;
        sysStaff.setStaffOrder(Integer.valueOf(staffOrder));
    }

    public R<EditOnlyOutsideUserDto> editOnlyUser(EditOnlyOutsideUserDto user) {
        SysStaff sysStaff;
        SysUsers sysUsers;
        boolean convert;
        R result = new R();
        List errors = OrganUtil.validateOne((Object)user);
        String account = user.getUserAccount();
        boolean bl = convert = this.hussarLoginConfigService.getLoginUpperOpen() == false && !OrganConstants.EXCLUDE_USERS.contains(account);
        if (convert) {
            account = account.toUpperCase();
        }
        if ((sysUsers = (SysUsers)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.sysUsersService.lambdaQuery().eq(SysUsers::getUserAccount, (Object)account)).ne(SysUsers::getAccountStatus, (Object)UserStatus.DELETE.getCode())).one()) == null) {
            OrganUtil.addErrorMsg((List)errors, (Object)user, (String)"userAccount", (String[])new String[]{TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_USER_ACCOUNT_NOT_EXIST.getMessage())});
        }
        if (HussarUtils.isNotEmpty((Object)user.getStaffId()) && HussarUtils.isNotEmpty((Object)sysUsers) && !sysUsers.getEmployeeId().equals(user.getStaffId()) && HussarUtils.isEmpty((Object)(sysStaff = (SysStaff)this.sysStaffMapper.selectById((Serializable)user.getStaffId())))) {
            OrganUtil.addErrorMsg((List)errors, (Object)user, (String)"staffId", (String[])new String[]{TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_USER_STAFF_EMPTY.getMessage())});
        }
        if (HussarUtils.isEmpty((Object)errors)) {
            this.initializationEditOnlyUser(user, sysUsers);
            List struIds = user.getOrganIds();
            if (HussarUtils.isNotEmpty((Object)struIds)) {
                ArrayList<SysStruUser> struUserList = new ArrayList<SysStruUser>();
                struIds = struIds.stream().distinct().collect(Collectors.toList());
                for (Long struId : struIds) {
                    SysStruUser sysStruUser = new SysStruUser();
                    sysStruUser.setStruId(struId);
                    sysStruUser.setUserId(sysUsers.getId());
                    struUserList.add(sysStruUser);
                }
                ((LambdaUpdateChainWrapper)this.sysStruUserService.lambdaUpdate().eq(SysStruUser::getUserId, (Object)sysUsers.getId())).remove();
                this.sysStruUserService.saveBatch(struUserList);
            }
            this.sysUsersService.updateById((Object)sysUsers);
            result.setSuccessList((List)Lists.newArrayList((Object[])new DataMapping[]{new DataMapping(sysUsers.getId(), StringUtils.trimToEmpty((String)sysUsers.getUserAccount()))}));
        } else {
            result.setSuccess(false);
            result.setErrorList(errors);
        }
        return result;
    }

    private void initializationEditOnlyUser(EditOnlyOutsideUserDto userDto, SysUsers sysUsers) {
        String userName = StringUtils.trimToEmpty((String)userDto.getUserName());
        String weChat = StringUtils.trimToEmpty((String)userDto.getWeChat());
        String mobile = StringUtils.trimToEmpty((String)userDto.getMobile());
        String telephone = StringUtils.trimToEmpty((String)userDto.getTelephone());
        String mail = StringUtils.trimToEmpty((String)userDto.getMail());
        Integer order = userDto.getUserOrder();
        String accountStatus = userDto.getAccountStatus();
        if (StringUtils.isNotBlank((CharSequence)userName)) {
            sysUsers.setUserName(userName);
        }
        sysUsers.setWeChat(weChat);
        sysUsers.setMobile(mobile);
        sysUsers.setTelephone(telephone);
        sysUsers.seteMail(mail);
        sysUsers.setEmployeeId(userDto.getStaffId());
        if (HussarUtils.isNotEmpty((Object)accountStatus)) {
            sysUsers.setAccountStatus(accountStatus);
        }
        if (HussarUtils.isNotEmpty((Object)order)) {
            sysUsers.setUserOrder(order);
        }
    }

    private void handleUserStaff(EditOutsideUserDto user, SysUsers sysUsers) {
        ((LambdaUpdateChainWrapper)this.sysStruUserService.lambdaUpdate().eq(SysStruUser::getUserId, (Object)sysUsers.getId())).remove();
        ((LambdaUpdateChainWrapper)this.sysStruStaffService.lambdaUpdate().eq(SysStruStaff::getStaffId, (Object)sysUsers.getEmployeeId())).remove();
        List organIds = user.getOrganIds();
        if (HussarUtils.isNotEmpty((Object)organIds)) {
            ArrayList<SysStruStaff> struStaffList = new ArrayList<SysStruStaff>();
            ArrayList<SysStruUser> struUserList = new ArrayList<SysStruUser>();
            for (Long organId : organIds) {
                SysStruStaff sysStruStaff = new SysStruStaff();
                sysStruStaff.setStruId(organId);
                sysStruStaff.setStaffId(sysUsers.getEmployeeId());
                struStaffList.add(sysStruStaff);
                SysStruUser sysStruUser = new SysStruUser();
                sysStruUser.setStruId(organId);
                sysStruUser.setUserId(sysUsers.getId());
                struUserList.add(sysStruUser);
            }
            this.sysStruStaffService.saveBatch(struStaffList);
            this.sysStruUserService.saveBatch(struUserList);
        }
    }

    private void initializationEdit(EditOutsideUserDto userDto, SysStaff sysStaff, SysUsers sysUsers) {
        String userName = StringUtils.trimToEmpty((String)userDto.getUserName());
        String weChat = StringUtils.trimToEmpty((String)userDto.getWeChat());
        String mobile = StringUtils.trimToEmpty((String)userDto.getMobile());
        String telephone = StringUtils.trimToEmpty((String)userDto.getTelephone());
        String staffPosition = StringUtils.trimToEmpty((String)userDto.getStaffPosition());
        String sex = StringUtils.trimToEmpty((String)userDto.getSex());
        String birthday = StringUtils.trimToEmpty((String)userDto.getBirthday());
        String idcard = StringUtils.trimToEmpty((String)userDto.getIdcard());
        String address = StringUtils.trimToEmpty((String)userDto.getAddress());
        String workId = StringUtils.trimToEmpty((String)userDto.getWorkId());
        String workDate = StringUtils.trimToEmpty((String)userDto.getWorkDate());
        String graduateDate = StringUtils.trimToEmpty((String)userDto.getGraduateDate());
        String graduateSchool = StringUtils.trimToEmpty((String)userDto.getGraduateSchool());
        Integer order = userDto.getUserOrder();
        if (StringUtils.isNotBlank((CharSequence)userName)) {
            sysStaff.setName(userName);
            sysUsers.setUserName(userName);
        }
        if (StringUtils.isNotBlank((CharSequence)weChat)) {
            sysUsers.setWeChat(weChat);
        }
        if (StringUtils.isNotBlank((CharSequence)mobile)) {
            sysUsers.setMobile(mobile);
        }
        if (StringUtils.isNotBlank((CharSequence)telephone)) {
            sysUsers.setTelephone(telephone);
        }
        if (HussarUtils.isNotEmpty((Object)order)) {
            sysUsers.setUserOrder(order);
            sysStaff.setStaffOrder(order);
        }
        if (StringUtils.isNotBlank((CharSequence)staffPosition)) {
            sysStaff.setStaffPosition(staffPosition);
        }
        if (StringUtils.isNotBlank((CharSequence)sex)) {
            sysStaff.setSex(sex);
        }
        if (StringUtils.isNotBlank((CharSequence)birthday)) {
            sysStaff.setBirthday(birthday);
        }
        if (StringUtils.isNotBlank((CharSequence)idcard)) {
            sysStaff.setIdcard(idcard);
        }
        if (StringUtils.isNotBlank((CharSequence)address)) {
            sysStaff.setAddress(address);
        }
        if (StringUtils.isNotBlank((CharSequence)workId)) {
            sysStaff.setWorkId(workId);
        }
        if (StringUtils.isNotBlank((CharSequence)workDate)) {
            sysStaff.setWorkDate(workDate);
        }
        if (StringUtils.isNotBlank((CharSequence)graduateDate)) {
            sysStaff.setGraduateDate(graduateDate);
        }
        if (StringUtils.isNotBlank((CharSequence)graduateSchool)) {
            sysStaff.setGraduateSchool(graduateSchool);
        }
    }

    private boolean existUser(String account) {
        Long count = ((LambdaQueryChainWrapper)this.sysUsersService.lambdaQuery().eq(SysUsers::getUserAccount, (Object)account)).count();
        return count != null && count > 0L;
    }
}

