/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.sync.manager;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.google.common.collect.Lists;
import com.jxdinfo.hussar.authorization.enums.TipConstantsEnum;
import com.jxdinfo.hussar.authorization.organ.dao.SysOfficeMapper;
import com.jxdinfo.hussar.authorization.organ.dao.SysOrganMapper;
import com.jxdinfo.hussar.authorization.organ.dao.SysStaffMapper;
import com.jxdinfo.hussar.authorization.organ.dao.SysStruMapper;
import com.jxdinfo.hussar.authorization.organ.model.SysOrgan;
import com.jxdinfo.hussar.authorization.organ.model.SysStru;
import com.jxdinfo.hussar.authorization.organ.service.ISysOrganService;
import com.jxdinfo.hussar.authorization.organ.service.ISysStruService;
import com.jxdinfo.hussar.authorization.organ.util.OrganUtil;
import com.jxdinfo.hussar.authorization.permit.dao.SysStruRoleMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysUsersMapper;
import com.jxdinfo.hussar.authorization.permit.model.SysStruRole;
import com.jxdinfo.hussar.authorization.permit.model.SysUserRole;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.ISysStruRoleService;
import com.jxdinfo.hussar.authorization.permit.service.ISysUserRoleService;
import com.jxdinfo.hussar.authorization.permit.service.ISysUsersService;
import com.jxdinfo.hussar.authorization.relational.dao.SysStruPostMapper;
import com.jxdinfo.hussar.authorization.relational.dao.SysStruStaffMapper;
import com.jxdinfo.hussar.authorization.relational.dao.SysStruUserMapper;
import com.jxdinfo.hussar.authorization.relational.model.SysStruPost;
import com.jxdinfo.hussar.authorization.relational.model.SysStruStaff;
import com.jxdinfo.hussar.authorization.relational.model.SysStruUser;
import com.jxdinfo.hussar.authorization.relational.model.SysUserPost;
import com.jxdinfo.hussar.authorization.relational.service.ISysStruPostService;
import com.jxdinfo.hussar.authorization.relational.service.ISysStruStaffService;
import com.jxdinfo.hussar.authorization.relational.service.ISysStruUserService;
import com.jxdinfo.hussar.authorization.relational.service.ISysUserPostService;
import com.jxdinfo.hussar.common.base.DataMapping;
import com.jxdinfo.hussar.common.base.R;
import com.jxdinfo.hussar.common.utils.SqlQueryUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.utils.TranslateUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DeleteOrgManager {
    @Autowired
    private ISysOrganService sysOrganService;
    @Autowired
    private ISysStruService sysStruService;
    @Autowired
    private SysStruMapper sysStruMapper;
    @Resource
    private SysStruUserMapper sysStruUserMapper;
    @Resource
    private SysStruPostMapper sysStruPostMapper;
    @Resource
    private SysStruRoleMapper sysStruRoleMapper;
    @Resource
    private SysStruStaffMapper sysStruStaffMapper;
    @Resource
    private SysOrganMapper sysOrganMapper;
    @Resource
    private SysOfficeMapper sysOfficeMapper;
    @Autowired
    private ISysStruUserService sysStruUserService;
    @Autowired
    private ISysUserRoleService sysUserRoleService;
    @Autowired
    private ISysUserPostService sysUserPostService;
    @Autowired
    private ISysStruRoleService sysStruRoleService;
    @Autowired
    private ISysStruPostService sysStruPostService;
    @Resource
    private SysUsersMapper sysUsersMapper;
    @Resource
    private SysStaffMapper sysStaffMapper;
    @Autowired
    private ISysStruStaffService sysStruStaffService;
    @Autowired
    private ISysUsersService sysUsersService;

    public R<String> doDelete(String organCode) {
        R result = new R();
        ArrayList errors = new ArrayList();
        if (HussarUtils.isBlank((CharSequence)organCode)) {
            OrganUtil.addErrorMsg(errors, (Object)organCode, (String)"organCode", (String[])new String[]{TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ORG_CODE_EMPTY.getMessage())});
        }
        if (HussarUtils.isNotEmpty(errors)) {
            result.setErrorList(errors);
            result.setSuccess(false);
            return result;
        }
        String code = StringUtils.trimToEmpty((String)organCode);
        SysOrgan sysOrgan = (SysOrgan)((LambdaQueryChainWrapper)this.sysOrganService.lambdaQuery().eq(SysOrgan::getOrganCode, (Object)code)).one();
        if (HussarUtils.isEmpty((Object)sysOrgan)) {
            result.setSuccess(true);
            result.setErrorList((List)null);
            return result;
        }
        SysStru sysStru = (SysStru)((LambdaQueryChainWrapper)this.sysStruService.lambdaQuery().eq(SysStru::getOrganId, (Object)sysOrgan.getId())).one();
        List strus = ((LambdaQueryChainWrapper)this.sysStruService.lambdaQuery().likeRight(SysStru::getStruFid, (Object)sysStru.getStruFid())).list();
        List struIds = strus.stream().map(SysStru::getId).distinct().collect(Collectors.toList());
        List userStruIds = this.sysStruUserMapper.getDuplicateStruIdByStruIds(struIds);
        List postStruIds = this.sysStruPostMapper.getDuplicateStruIdByStruIds(struIds);
        List roleStruIds = this.sysStruRoleMapper.getDuplicateStruIdByStruIds(struIds);
        List staffStruIds = this.sysStruStaffMapper.getDuplicateStruIdByStruIds(struIds);
        if (HussarUtils.isNotEmpty((Object)userStruIds)) {
            OrganUtil.addErrorMsg(errors, (Object)organCode, (String)"organCode", (String[])new String[]{TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ORGAN_USER_EXIST.getMessage())});
        }
        if (HussarUtils.isNotEmpty((Object)staffStruIds)) {
            OrganUtil.addErrorMsg(errors, (Object)organCode, (String)"organCode", (String[])new String[]{TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ORGAN_STAFF_EXIST.getMessage())});
        }
        if (HussarUtils.isNotEmpty((Object)postStruIds)) {
            OrganUtil.addErrorMsg(errors, (Object)organCode, (String)"organCode", (String[])new String[]{TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ORGAN_POST_EXIST.getMessage())});
        }
        if (HussarUtils.isNotEmpty((Object)roleStruIds)) {
            OrganUtil.addErrorMsg(errors, (Object)organCode, (String)"organCode", (String[])new String[]{TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ORGAN_ROLE_EXIST.getMessage())});
        }
        if (HussarUtils.isEmpty(errors)) {
            result.setSuccess(true);
            result.setErrorList((List)null);
        } else {
            result.setErrorList(errors);
            result.setSuccess(false);
        }
        if (result.isSuccess()) {
            Long parentId = sysStru.getParentId();
            SysStru parentSysStru = (SysStru)this.sysStruService.getById((Serializable)parentId);
            Long count = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.sysStruService.lambdaQuery().eq(SysStru::getParentId, (Object)parentId)).ne(SysStru::getId, (Object)sysStru.getId())).count();
            if (count == null || count < 1L) {
                parentSysStru.setIsLeaf("Y");
            }
            HashMap<String, Object> queryOrgParams = new HashMap<String, Object>();
            queryOrgParams.put("organFcode", SqlQueryUtil.transferSpecialChar((String)sysOrgan.getOrganFcode()));
            queryOrgParams.put("escapeSymbol", SqlQueryUtil.ESCAPE_SYMBOL);
            this.sysOrganMapper.deleteSubOrganByFcode(queryOrgParams);
            String struFid = sysStru.getStruFid();
            this.sysOfficeMapper.deleteBatchByStruFid(struFid);
            ((LambdaUpdateChainWrapper)this.sysStruService.lambdaUpdate().likeRight(SysStru::getStruFid, (Object)sysStru.getStruFid())).remove();
            this.sysStruMapper.updateById((Object)parentSysStru);
            result.setSuccessList((List)Lists.newArrayList((Object[])new DataMapping[]{new DataMapping(sysStru.getId(), code)}));
        }
        return result;
    }

    public R<String> deleteOrganUserRelation(String organCode) {
        R result = new R();
        ArrayList errors = new ArrayList();
        if (HussarUtils.isBlank((CharSequence)organCode)) {
            OrganUtil.addErrorMsg(errors, (Object)organCode, (String)"organCode", (String[])new String[]{TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ORG_CODE_EMPTY.getMessage())});
        }
        if (HussarUtils.isEmpty(errors)) {
            result.setSuccess(true);
            result.setErrorList((List)null);
        } else {
            result.setErrorList(errors);
            result.setSuccess(false);
        }
        if (result.isSuccess()) {
            String code = StringUtils.trimToEmpty((String)organCode);
            SysStru sysStru = this.sysStruMapper.selectStruByOrganCode(code);
            List strus = ((LambdaQueryChainWrapper)this.sysStruService.lambdaQuery().likeRight(SysStru::getStruFid, (Object)sysStru.getStruFid())).list();
            List struIds = strus.stream().map(SysStru::getId).distinct().collect(Collectors.toList());
            List struUsers = ((LambdaQueryChainWrapper)this.sysStruUserService.lambdaQuery().in(SysStruUser::getStruId, struIds)).list();
            if (HussarUtils.isNotEmpty((Object)struUsers)) {
                Map<Long, List<Long>> userStruMap = this.getUserStruMap(struUsers);
                Set<Long> userIds = userStruMap.keySet();
                List struUserT = ((LambdaQueryChainWrapper)this.sysStruUserService.lambdaQuery().in(SysStruUser::getUserId, userIds)).list();
                Map<Long, List<Long>> userStruMapT = this.getUserStruMap(struUserT);
                ArrayList<Long> delUserIds = new ArrayList<Long>();
                for (Long userId : userIds) {
                    List<Long> struIdList;
                    List<Long> delStruIds = userStruMap.get(userId);
                    if (!delStruIds.containsAll(struIdList = userStruMapT.get(userId))) continue;
                    delUserIds.add(userId);
                }
                ((LambdaUpdateChainWrapper)this.sysStruUserService.lambdaUpdate().in(SysStruUser::getStruId, struIds)).remove();
                if (HussarUtils.isNotEmpty(delUserIds)) {
                    ((LambdaUpdateChainWrapper)this.sysUserRoleService.lambdaUpdate().in(SysUserRole::getUserId, userIds)).remove();
                    ((LambdaUpdateChainWrapper)this.sysUserPostService.lambdaUpdate().in(SysUserPost::getUserId, userIds)).remove();
                    this.sysUsersMapper.deleteBatchIds(userIds);
                }
                result.setSuccessList((List)Lists.newArrayList((Object[])new DataMapping[]{new DataMapping(sysStru.getId(), code)}));
            }
        }
        return result;
    }

    public R<String> deleteOrganStaffRelation(String organCode) {
        R result = new R();
        ArrayList errors = new ArrayList();
        if (HussarUtils.isBlank((CharSequence)organCode)) {
            OrganUtil.addErrorMsg(errors, (Object)organCode, (String)"organCode", (String[])new String[]{TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ORG_CODE_EMPTY.getMessage())});
        }
        if (HussarUtils.isEmpty(errors)) {
            result.setSuccess(true);
            result.setErrorList((List)null);
        } else {
            result.setErrorList(errors);
            result.setSuccess(false);
        }
        if (result.isSuccess()) {
            String code = StringUtils.trimToEmpty((String)organCode);
            SysStru sysStru = this.sysStruMapper.selectStruByOrganCode(code);
            List strus = ((LambdaQueryChainWrapper)this.sysStruService.lambdaQuery().likeRight(SysStru::getStruFid, (Object)sysStru.getStruFid())).list();
            List struIds = strus.stream().map(SysStru::getId).distinct().collect(Collectors.toList());
            List struStaffs = ((LambdaQueryChainWrapper)this.sysStruStaffService.lambdaQuery().in(SysStruStaff::getStruId, struIds)).list();
            if (HussarUtils.isNotEmpty((Object)struStaffs)) {
                Map<Long, List<Long>> staffStruMap = this.getStaffStruMap(struStaffs);
                Set<Long> staffIds = staffStruMap.keySet();
                List struStaffT = ((LambdaQueryChainWrapper)this.sysStruStaffService.lambdaQuery().in(SysStruStaff::getStaffId, staffIds)).list();
                Map<Long, List<Long>> staffStruMapT = this.getStaffStruMap(struStaffT);
                ArrayList<Long> delStaffIds = new ArrayList<Long>();
                for (Long staffId : staffIds) {
                    List<Long> struIdList;
                    List<Long> delStruIds = staffStruMap.get(staffId);
                    if (!delStruIds.containsAll(struIdList = staffStruMapT.get(staffId))) continue;
                    delStaffIds.add(staffId);
                }
                ((LambdaUpdateChainWrapper)this.sysStruStaffService.lambdaUpdate().in(SysStruStaff::getStruId, struIds)).remove();
                if (HussarUtils.isNotEmpty(delStaffIds)) {
                    List users = ((LambdaQueryChainWrapper)this.sysUsersService.lambdaQuery().in(SysUsers::getEmployeeId, delStaffIds)).list();
                    if (HussarUtils.isNotEmpty((Object)users)) {
                        List userIds = users.stream().map(SysUsers::getId).distinct().collect(Collectors.toList());
                        ((LambdaUpdateChainWrapper)this.sysUserRoleService.lambdaUpdate().in(SysUserRole::getUserId, userIds)).remove();
                        ((LambdaUpdateChainWrapper)this.sysUserPostService.lambdaUpdate().in(SysUserPost::getUserId, userIds)).remove();
                        ((LambdaUpdateChainWrapper)this.sysStruUserService.lambdaUpdate().in(SysStruUser::getUserId, userIds)).remove();
                        this.sysUsersMapper.deleteBatchIds(userIds);
                    }
                    this.sysStaffMapper.deleteBatchIds(delStaffIds);
                }
                result.setSuccessList((List)Lists.newArrayList((Object[])new DataMapping[]{new DataMapping(sysStru.getId(), code)}));
            }
        }
        return result;
    }

    public R<String> deleteOrganPostRelation(String organCode) {
        String code;
        SysStru sysStru;
        R result = new R();
        ArrayList errors = new ArrayList();
        if (HussarUtils.isBlank((CharSequence)organCode)) {
            OrganUtil.addErrorMsg(errors, (Object)organCode, (String)"organCode", (String[])new String[]{TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ORG_CODE_EMPTY.getMessage())});
        }
        if (HussarUtils.isEmpty(errors)) {
            result.setSuccess(true);
            result.setErrorList((List)null);
        } else {
            result.setErrorList(errors);
            result.setSuccess(false);
        }
        if (result.isSuccess() && HussarUtils.isNotEmpty((Object)(sysStru = this.sysStruMapper.selectStruByOrganCode(code = StringUtils.trimToEmpty((String)organCode))))) {
            List strus = ((LambdaQueryChainWrapper)this.sysStruService.lambdaQuery().likeRight(SysStru::getStruFid, (Object)sysStru.getStruFid())).list();
            List struIds = strus.stream().map(SysStru::getId).distinct().collect(Collectors.toList());
            ((LambdaUpdateChainWrapper)this.sysStruPostService.lambdaUpdate().in(SysStruPost::getStruId, struIds)).remove();
            result.setSuccessList((List)Lists.newArrayList((Object[])new DataMapping[]{new DataMapping(sysStru.getId(), code)}));
        }
        return result;
    }

    public R<String> deleteOrganRoleRelation(String organCode) {
        String code;
        SysStru sysStru;
        R result = new R();
        ArrayList errors = new ArrayList();
        if (HussarUtils.isBlank((CharSequence)organCode)) {
            OrganUtil.addErrorMsg(errors, (Object)organCode, (String)"organCode", (String[])new String[]{TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ORG_CODE_EMPTY.getMessage())});
        }
        if (HussarUtils.isEmpty(errors)) {
            result.setSuccess(true);
            result.setErrorList((List)null);
        } else {
            result.setErrorList(errors);
            result.setSuccess(false);
        }
        if (result.isSuccess() && HussarUtils.isNotEmpty((Object)(sysStru = this.sysStruMapper.selectStruByOrganCode(code = StringUtils.trimToEmpty((String)organCode))))) {
            List strus = ((LambdaQueryChainWrapper)this.sysStruService.lambdaQuery().likeRight(SysStru::getStruFid, (Object)sysStru.getStruFid())).list();
            List struIds = strus.stream().map(SysStru::getId).distinct().collect(Collectors.toList());
            ((LambdaUpdateChainWrapper)this.sysStruRoleService.lambdaUpdate().in(SysStruRole::getStruId, struIds)).remove();
            result.setSuccessList((List)Lists.newArrayList((Object[])new DataMapping[]{new DataMapping(sysStru.getId(), code)}));
        }
        return result;
    }

    private Map<Long, List<Long>> getUserStruMap(List<SysStruUser> struUsers) {
        HashMap<Long, List<Long>> userStruMap = new HashMap<Long, List<Long>>();
        if (HussarUtils.isNotEmpty(struUsers)) {
            for (SysStruUser struUser : struUsers) {
                List<Long> ids;
                Long struId = struUser.getStruId();
                Long userId = struUser.getUserId();
                if (HussarUtils.isEmpty(userStruMap.get(userId))) {
                    ids = new ArrayList<Long>();
                    ids.add(struId);
                    userStruMap.put(userId, ids);
                    continue;
                }
                ids = (List)userStruMap.get(userId);
                ids.add(struId);
            }
        }
        return userStruMap;
    }

    private Map<Long, List<Long>> getStaffStruMap(List<SysStruStaff> struStaffs) {
        HashMap<Long, List<Long>> staffStruMap = new HashMap<Long, List<Long>>();
        if (HussarUtils.isNotEmpty(struStaffs)) {
            for (SysStruStaff struStaff : struStaffs) {
                List<Long> ids;
                Long struId = struStaff.getStruId();
                Long staffId = struStaff.getStaffId();
                if (HussarUtils.isEmpty(staffStruMap.get(staffId))) {
                    ids = new ArrayList<Long>();
                    ids.add(struId);
                    staffStruMap.put(staffId, ids);
                    continue;
                }
                ids = (List)staffStruMap.get(staffId);
                ids.add(struId);
            }
        }
        return staffStruMap;
    }
}

