/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.sync.manager;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.google.common.collect.Lists;
import com.jxdinfo.hussar.authorization.enums.TipConstantsEnum;
import com.jxdinfo.hussar.authorization.enums.UserStatus;
import com.jxdinfo.hussar.authorization.organ.constants.OrganConstants;
import com.jxdinfo.hussar.authorization.organ.model.SysStaff;
import com.jxdinfo.hussar.authorization.organ.service.ISysStaffService;
import com.jxdinfo.hussar.authorization.organ.util.OrganUtil;
import com.jxdinfo.hussar.authorization.permit.model.SysUserRole;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.ISysUserRoleService;
import com.jxdinfo.hussar.authorization.permit.service.ISysUsersService;
import com.jxdinfo.hussar.authorization.permit.util.UserLogoutCacheUtil;
import com.jxdinfo.hussar.authorization.relational.model.SysStruStaff;
import com.jxdinfo.hussar.authorization.relational.model.SysStruUser;
import com.jxdinfo.hussar.authorization.relational.model.SysUserPost;
import com.jxdinfo.hussar.authorization.relational.service.ISysStruStaffService;
import com.jxdinfo.hussar.authorization.relational.service.ISysStruUserService;
import com.jxdinfo.hussar.authorization.relational.service.ISysUserPostService;
import com.jxdinfo.hussar.base.config.baseconfig.service.IHussarLoginConfigService;
import com.jxdinfo.hussar.common.base.DataMapping;
import com.jxdinfo.hussar.common.base.R;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.utils.TranslateUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DeleteAccountManager {
    @Autowired
    private IHussarLoginConfigService hussarLoginConfigService;
    @Autowired
    private ISysUsersService sysUsersService;
    @Autowired
    private ISysStaffService sysStaffService;
    @Autowired
    private ISysStruStaffService sysStruStaffService;
    @Autowired
    private ISysStruUserService sysStruUserService;
    @Autowired
    private ISysUserPostService sysUserPostService;
    @Autowired
    private ISysUserRoleService sysUserRoleService;

    public R<String> doDelete(String userAccount) {
        boolean convert;
        R result = new R();
        String account = StringUtils.trimToEmpty((String)userAccount);
        boolean bl = convert = this.hussarLoginConfigService.getLoginUpperOpen() == false && !OrganConstants.EXCLUDE_USERS.contains(account);
        if (convert) {
            account = account.toUpperCase();
        }
        SysUsers sysUsers = (SysUsers)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.sysUsersService.lambdaQuery().eq(SysUsers::getUserAccount, (Object)account)).ne(SysUsers::getAccountStatus, (Object)UserStatus.DELETE.getCode())).ne(SysUsers::getAccountStatus, (Object)UserStatus.CANCEL.getCode())).one();
        ArrayList errors = new ArrayList();
        if (sysUsers == null) {
            OrganUtil.addErrorMsg(errors, (Object)userAccount, (String)"userAccount", (String[])new String[]{TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_USER_ACCOUNT_NOT_EXIST.getMessage())});
        }
        if (HussarUtils.isEmpty(errors)) {
            result.setSuccess(true);
            result.setErrorList((List)null);
        } else {
            result.setErrorList(errors);
            result.setSuccess(false);
        }
        if (result.isSuccess()) {
            Long employeeId = sysUsers.getEmployeeId();
            ((LambdaUpdateChainWrapper)this.sysStaffService.lambdaUpdate().eq(SysStaff::getId, (Object)employeeId)).remove();
            this.sysUsersService.removeById((Serializable)sysUsers.getId());
            ((LambdaUpdateChainWrapper)this.sysUserRoleService.lambdaUpdate().eq(SysUserRole::getUserId, (Object)sysUsers.getId())).remove();
            ((LambdaUpdateChainWrapper)this.sysStruUserService.lambdaUpdate().eq(SysStruUser::getUserId, (Object)sysUsers.getId())).remove();
            ((LambdaUpdateChainWrapper)this.sysStruStaffService.lambdaUpdate().eq(SysStruStaff::getStaffId, (Object)employeeId)).remove();
            ((LambdaUpdateChainWrapper)this.sysUserPostService.lambdaUpdate().eq(SysUserPost::getUserId, (Object)sysUsers.getId())).remove();
            result.setSuccessList((List)Lists.newArrayList((Object[])new DataMapping[]{new DataMapping(sysUsers.getId(), sysUsers.getUserAccount())}));
            UserLogoutCacheUtil.kickOutUser((Long)sysUsers.getId());
        }
        return result;
    }

    public R<String> deleteOnlyUser(String userAccount) {
        boolean convert;
        R result = new R();
        String account = StringUtils.trimToEmpty((String)userAccount);
        boolean bl = convert = this.hussarLoginConfigService.getLoginUpperOpen() == false && !OrganConstants.EXCLUDE_USERS.contains(account);
        if (convert) {
            account = account.toUpperCase();
        }
        SysUsers sysUsers = (SysUsers)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.sysUsersService.lambdaQuery().eq(SysUsers::getUserAccount, (Object)account)).ne(SysUsers::getAccountStatus, (Object)UserStatus.DELETE.getCode())).ne(SysUsers::getAccountStatus, (Object)UserStatus.CANCEL.getCode())).one();
        ArrayList errors = new ArrayList();
        if (sysUsers == null) {
            OrganUtil.addErrorMsg(errors, (Object)userAccount, (String)"userAccount", (String[])new String[]{TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_USER_ACCOUNT_NOT_EXIST.getMessage())});
        }
        if (HussarUtils.isEmpty(errors)) {
            result.setSuccess(true);
            result.setErrorList((List)null);
        } else {
            result.setErrorList(errors);
            result.setSuccess(false);
        }
        if (result.isSuccess()) {
            this.sysUsersService.removeById((Serializable)sysUsers.getId());
            ((LambdaUpdateChainWrapper)this.sysUserRoleService.lambdaUpdate().eq(SysUserRole::getUserId, (Object)sysUsers.getId())).remove();
            ((LambdaUpdateChainWrapper)this.sysStruUserService.lambdaUpdate().eq(SysStruUser::getUserId, (Object)sysUsers.getId())).remove();
            ((LambdaUpdateChainWrapper)this.sysUserPostService.lambdaUpdate().eq(SysUserPost::getUserId, (Object)sysUsers.getId())).remove();
            result.setSuccessList((List)Lists.newArrayList((Object[])new DataMapping[]{new DataMapping(sysUsers.getId(), sysUsers.getUserAccount())}));
        }
        return result;
    }

    public R<String> deleteLogicalUser(String userAccount) {
        boolean convert;
        R result = new R();
        String account = StringUtils.trimToEmpty((String)userAccount);
        boolean bl = convert = this.hussarLoginConfigService.getLoginUpperOpen() == false && !OrganConstants.EXCLUDE_USERS.contains(account);
        if (convert) {
            account = account.toUpperCase();
        }
        SysUsers sysUsers = (SysUsers)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.sysUsersService.lambdaQuery().eq(SysUsers::getUserAccount, (Object)account)).ne(SysUsers::getAccountStatus, (Object)UserStatus.DELETE.getCode())).one();
        ArrayList errors = new ArrayList();
        if (sysUsers == null) {
            OrganUtil.addErrorMsg(errors, (Object)userAccount, (String)"userAccount", (String[])new String[]{TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_USER_ACCOUNT_NOT_EXIST.getMessage())});
        }
        if (HussarUtils.isEmpty(errors)) {
            result.setSuccess(true);
            result.setErrorList((List)null);
        } else {
            result.setErrorList(errors);
            result.setSuccess(false);
        }
        if (result.isSuccess()) {
            Long employeeId = sysUsers.getEmployeeId();
            ((LambdaUpdateChainWrapper)this.sysStaffService.lambdaUpdate().eq(SysStaff::getId, (Object)employeeId)).remove();
            sysUsers.setAccountStatus(UserStatus.DELETE.getCode());
            this.sysUsersService.updateById((Object)sysUsers);
            ((LambdaUpdateChainWrapper)this.sysUserRoleService.lambdaUpdate().eq(SysUserRole::getUserId, (Object)sysUsers.getId())).remove();
            ((LambdaUpdateChainWrapper)this.sysStruUserService.lambdaUpdate().eq(SysStruUser::getUserId, (Object)sysUsers.getId())).remove();
            ((LambdaUpdateChainWrapper)this.sysStruStaffService.lambdaUpdate().eq(SysStruStaff::getStaffId, (Object)employeeId)).remove();
            ((LambdaUpdateChainWrapper)this.sysUserPostService.lambdaUpdate().eq(SysUserPost::getUserId, (Object)sysUsers.getId())).remove();
            result.setSuccessList((List)Lists.newArrayList((Object[])new DataMapping[]{new DataMapping(sysUsers.getId(), sysUsers.getUserAccount())}));
        }
        return result;
    }
}

