/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.sync.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.dynamic.datasource.annotation.Master;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.authorization.organ.dao.SysStruMapper;
import com.jxdinfo.hussar.authorization.organ.manager.EditOrganizationManager;
import com.jxdinfo.hussar.authorization.organ.model.SysOffice;
import com.jxdinfo.hussar.authorization.organ.model.SysOrgan;
import com.jxdinfo.hussar.authorization.organ.model.SysStru;
import com.jxdinfo.hussar.authorization.organ.service.IHussarBaseOrganTypeBoService;
import com.jxdinfo.hussar.authorization.organ.service.IStaffUserService;
import com.jxdinfo.hussar.authorization.organ.service.ISysOrganService;
import com.jxdinfo.hussar.authorization.organ.service.SysOrgManageService;
import com.jxdinfo.hussar.authorization.permit.dao.SysRolesMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysUsersMapper;
import com.jxdinfo.hussar.authorization.permit.service.ISysRolesService;
import com.jxdinfo.hussar.authorization.permit.service.ISysUsersService;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.general.bpm.messagepush.AbstractBpmPushMsgMatcher;
import com.jxdinfo.hussar.general.idtable.service.ISysIdtableService;
import com.jxdinfo.hussar.htsz.extend.organ.service.IHussarBaseOrgBoService;
import com.jxdinfo.hussar.htsz.extend.organ.service.IHussarBaseStruAssistOrganBoService;
import com.jxdinfo.hussar.htsz.extend.organ.service.IHussarBaseStruBoService;
import com.jxdinfo.hussar.htsz.extend.organ.service.ISysFormerlyOrgManageService;
import com.jxdinfo.hussar.htsz.extend.organ.service.ISysFormerlyOrganService;
import com.jxdinfo.hussar.htsz.extend.permit.service.IHussarBaseUserRoleBoService;
import com.jxdinfo.hussar.htsz.extend.utils.DataSourceUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.tenant.properties.HussarTenantProperties;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import com.jxdinfo.hussar.sync.bo.AddPublicRoleBo;
import com.jxdinfo.hussar.sync.bo.SyncOrgDataBo;
import com.jxdinfo.hussar.sync.dao.SyncDataMapper;
import com.jxdinfo.hussar.sync.dao.UumLogMapper;
import com.jxdinfo.hussar.sync.dto.SysDataDto;
import com.jxdinfo.hussar.sync.model.UumLog;
import com.jxdinfo.hussar.sync.model.UumOperator;
import com.jxdinfo.hussar.sync.model.UumOrganization;
import com.jxdinfo.hussar.sync.model.UumWebserviceLog;
import com.jxdinfo.hussar.sync.service.ISyncDataService;
import com.jxdinfo.hussar.sync.service.ISysUserRolesService;
import com.jxdinfo.hussar.sync.service.IUumLogService;
import com.jxdinfo.hussar.sync.service.IUumOperatorService;
import com.jxdinfo.hussar.sync.service.IUumOrganizationService;
import com.jxdinfo.hussar.sync.service.IUumWebserviceLogService;
import com.jxdinfo.hussar.tenant.common.model.DefaultTenant;
import com.jxdinfo.hussar.tenant.common.service.IHussarTenantCommonService;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.xml.namespace.QName;
import javax.xml.rpc.ParameterMode;
import org.apache.axis.client.Call;
import org.apache.axis.encoding.XMLType;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.tree.DefaultElement;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Service
@Master
public class SyncDataServiceImpl
implements ISyncDataService {
    @Value(value="${webservice.url:http://192.168.6.99/axis/services/BizService}")
    private String url;
    @Value(value="${webservice.packageName:uum}")
    private String packageName;
    @Value(value="${webservice.unitId:0}")
    private String unitId;
    @Value(value="${webservice.processName:bizWebService.bizQueryOrgEmp}")
    private String processName;
    @Value(value="${webservice.sysID:tianxin}")
    private String sysID;
    @Value(value="${webservice.tranferStruId:1}")
    private String tranferStruId;
    @Value(value="${webservice.flightCode:860459246301749248}")
    private String flightCode;
    @Value(value="${webservice.hospitalCode:001000}")
    private String hospitalCode;
    @Value(value="${webservice.sixthCenterCode:003216}")
    private String sixthCenterCode;
    @Value(value="${webservice.maxOrgLevel:6}")
    private int maxOrgLevel;
    @Resource
    private ISysIdtableService sysIdtableService;
    @Resource
    private SysOrgManageService orgMaintenanceService;
    @Autowired
    private SysStruMapper sysStruMapper;
    @Resource
    private IHussarBaseOrganTypeBoService hussarBaseOrganTypeBoService;
    @Resource
    private IStaffUserService staffUserService;
    @Autowired
    private SysUsersMapper sysUsersMapper;
    @Resource
    private IHussarBaseStruAssistOrganBoService hussarBaseStruAssistOrganBoService;
    @Resource
    private IHussarBaseStruBoService hussarBaseStruBoService;
    @Resource
    private IUumWebserviceLogService uumWebserviceLogService;
    @Resource
    private IUumOrganizationService uumOrganizationService;
    @Resource
    private IUumOperatorService uumOperatorService;
    @Resource
    private IUumLogService uumLogService;
    @Resource
    private UumLogMapper uumLogMapper;
    @Resource
    private ISysUserRolesService sysUserRolesUtilService;
    @Resource
    private ISysRolesService iSysRolesService;
    @Resource
    private SysRolesMapper sysRolesMapper;
    @Resource
    private AbstractBpmPushMsgMatcher bpmAbstractPushMsgMatcher;
    @Resource
    private ISysUsersService iSysUsersService;
    @Resource
    private IHussarBaseUserRoleBoService hussarBaseUserRoleBoService;
    @Resource
    private ISysFormerlyOrgManageService formerlyOrgManageService;
    @Resource
    private ISysOrganService organService;
    @Resource
    private ISysFormerlyOrganService formerlyOrganService;
    @Resource
    private IHussarBaseOrgBoService hussarBaseOrgBoService;
    @Autowired
    private EditOrganizationManager editOrganizationManager;
    @Resource
    private HussarTenantProperties hussarTenantProperties;
    @Autowired(required=false)
    private IHussarTenantCommonService tenantCommonService;
    @Resource
    private SyncDataMapper syncDataMapper;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @HussarTransactional
    public ApiResponse<?> syncData(SysDataDto sysDataDto) {
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            boolean tenantOpen;
            ServletRequestAttributes requestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
            HttpServletRequest request = ToolUtil.isNotEmpty((Object)requestAttributes) ? requestAttributes.getRequest() : null;
            DefaultTenant tenantInfo = new DefaultTenant();
            boolean bl = tenantOpen = this.hussarTenantProperties.isEnabled() && this.tenantCommonService != null;
            if (ToolUtil.isNotEmpty((Object)request) && tenantOpen) {
                tenantInfo = this.tenantCommonService.parse();
                DataSourceUtil.changeTempDs((String)tenantInfo.getConnName());
            }
            HussarCacheUtil.put((String)"sync_info", (Object)"sync_status", (Object)true);
            System.out.println("\u7edf\u4e00\u7528\u6237\u5f00\u59cb");
            long startTime = System.currentTimeMillis();
            List<UumOrganization> orgList = new ArrayList();
            ArrayList<Long> logIdList = new ArrayList<Long>();
            Long userId = null;
            SecurityUser shiroUser = null;
            try {
                shiroUser = BaseSecurityUtil.getUser();
            }
            catch (Exception e) {
                shiroUser = null;
            }
            if (ToolUtil.isNotEmpty((Object)shiroUser)) {
                userId = shiroUser.getId();
            }
            UumLog uumLog = new UumLog();
            uumLog.setCreator(userId);
            uumLog.setStartTime(LocalDateTime.now());
            uumLog.setStatus("0");
            this.uumLogService.save((Object)uumLog);
            Long docID = uumLog.getDocID();
            System.out.println("\u83b7\u53d6\u53ca\u5b58\u50a8\u4e34\u65f6\u6570\u636e\u5f00\u59cb");
            long startTime1 = System.currentTimeMillis();
            String msg = this.getData(true, logIdList, docID, sysDataDto);
            long endTime1 = System.currentTimeMillis();
            System.out.println("\u83b7\u53d6\u53ca\u5b58\u50a8\u4e34\u65f6\u6570\u636e\u7ed3\u675f");
            System.out.println("\u83b7\u53d6\u53ca\u5b58\u50a8\u4e34\u65f6\u6570\u636e\u65f6\u95f4\uff1a" + (endTime1 - startTime1) / 1000L + "s");
            UumLog uumLog1 = new UumLog();
            uumLog1.setDocID(docID);
            if (!"".equals(msg)) {
                System.out.println(msg);
                System.out.println("\u7edf\u4e00\u7528\u6237\u7ed3\u675f");
                uumLog1.setEndTime(LocalDateTime.now());
                uumLog1.setStatus("3");
                this.uumLogService.updateById((Object)uumLog1);
                HussarCacheUtil.evict((String)"sync_info", (Object)"sync_status");
                ApiResponse apiResponse = ApiResponse.fail((String)msg);
                return apiResponse;
            }
            QueryWrapper ew = new QueryWrapper();
            ew.in((Object)"UUMID", logIdList);
            ew.eq((Object)"RSTATUS", (Object)"0");
            ew.orderByAsc((Object)"DISPTIME", (Object[])new String[]{"GETORDER"});
            orgList = this.uumOrganizationService.list((Wrapper)ew);
            int orgSize = orgList.size();
            int orgFail = 0;
            uumLog1.setStatus("1");
            uumLog1.setOrgTotalNum(Integer.valueOf(orgSize));
            this.uumLogService.updateById((Object)uumLog1);
            System.out.println("\u5904\u7406\u6570\u636e\u5f00\u59cb");
            long startTime2 = System.currentTimeMillis();
            Map<String, Object> orgResult = this.dealOrg(orgList);
            if (ToolUtil.isNotEmpty(orgResult)) {
                Object failNum = orgResult.get("orgFail");
                orgFail = Integer.parseInt(failNum.toString());
            }
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("orgFail", orgFail);
            orgFail = this.recursionDealUser(logIdList, param, 0);
            uumLog1.setStatus("2");
            uumLog1.setOrgFailNum(Integer.valueOf(orgFail));
            this.uumLogService.updateById((Object)uumLog1);
            String returnMsg = "\u5171" + orgSize + "\u6761\u7ec4\u7ec7\u6570\u636e,\u5931\u8d25" + orgFail + "\u6761\u3002";
            map.put("msg", returnMsg);
            System.out.println(returnMsg);
            long endTime = System.currentTimeMillis();
            System.out.println("\u7edf\u4e00\u7ec4\u7ec7\u7ed3\u675f");
            System.out.println("\u7edf\u4e00\u7ec4\u7ec7\u6267\u884c\u603b\u65f6\u95f4\uff1a" + (endTime - startTime) / 1000L + "s");
            uumLog1.setEndTime(LocalDateTime.now());
            uumLog1.setStatus("3");
            this.uumLogService.updateById((Object)uumLog1);
            this.editOrganizationManager.refreshOrgan();
            HussarCacheUtil.evict((String)"sync_info", (Object)"sync_status");
        }
        finally {
            DataSourceUtil.poll();
        }
        return ApiResponse.success(map);
    }

    public Object getList(String page, String limit, Map<String, Object> map) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        if (ToolUtil.isNotEmpty((Object)page) && ToolUtil.isNotEmpty((Object)limit)) {
            Page pages = new Page((long)Integer.valueOf(page).intValue(), (long)Integer.valueOf(limit).intValue());
            List<UumLog> list = this.uumLogMapper.getList(pages, map);
            resultMap.put("count", pages.getTotal());
            resultMap.put("data", list);
            resultMap.put("code", 0);
            return resultMap;
        }
        resultMap.put("data", null);
        resultMap.put("code", "500");
        resultMap.put("msg", "\u53c2\u6570\u4e0d\u7b26");
        resultMap.put("count", null);
        return resultMap;
    }

    private String webService(String method, Map<String, Object> paramters) throws Exception {
        org.apache.axis.client.Service service = new org.apache.axis.client.Service();
        Call call = (Call)service.createCall();
        call.setUseSOAPAction(true);
        call.setTargetEndpointAddress(new URL(this.url));
        call.setOperationName(new QName("http://webService.service.zsjgl._000000.hussar.jxdinfo.com/", method));
        call.setUseSOAPAction(true);
        Object[] paraValues = new Object[paramters.size()];
        Iterator<String> iterator = paramters.keySet().iterator();
        int i = 0;
        while (iterator.hasNext()) {
            String key = iterator.next();
            paraValues[i++] = paramters.get(key);
            call.addParameter(key, XMLType.XSD_STRING, ParameterMode.IN);
        }
        call.setReturnType(XMLType.XSD_STRING);
        Object ret = call.invoke(paraValues);
        return ret.toString();
    }

    private String getData(boolean isCirclePull, List<Long> logIdList, Long docID, SysDataDto sysDataDto) {
        UumWebserviceLog webserviceLog = new UumWebserviceLog();
        webserviceLog.setLogID(docID);
        webserviceLog.setCreateTime(LocalDateTime.now());
        String bizStr = "";
        try {
            HashMap<String, Object> paramters = new HashMap<String, Object>();
            if (HussarUtils.isEmpty((Object)sysDataDto.getType())) {
                paramters.put("appId", sysDataDto.getAppId());
                paramters.put("mqname ", sysDataDto.getMqName());
                bizStr = this.webService("getMq", paramters);
            } else {
                paramters.put("appid", sysDataDto.getAppId());
                paramters.put("type", sysDataDto.getType());
                paramters.put("startTime", sysDataDto.getStartTime());
                paramters.put("endTime", sysDataDto.getEndTime());
                paramters.put("pageSize", sysDataDto.getPageSize());
                paramters.put("pagenum", sysDataDto.getPageNum());
                bizStr = this.webService("query", paramters);
            }
            if ("".equals(bizStr)) {
                webserviceLog.setXmlList(bizStr);
                webserviceLog.setAnalyzeResult("0");
                webserviceLog.setOp("\u6ca1\u6709\u5f85\u540c\u6b65\u7684\u6570\u636e\u4e86\uff01");
                this.uumWebserviceLogService.save((Object)webserviceLog);
                return "\u6682\u65e0\u5f85\u540c\u6b65\u7684\u6570\u636e\uff01";
            }
            if ("E".equals(bizStr)) {
                webserviceLog.setAnalyzeResult("0");
                webserviceLog.setOp("\u88ab\u8c03\u7528\u7684\u670d\u52a1\u62a5\u51fa\u5f02\u5e38");
                this.uumWebserviceLogService.save((Object)webserviceLog);
                return "\u540c\u6b65\u5931\u8d25\uff01\u88ab\u8c03\u7528\u7684\u670d\u52a1\u62a5\u51fa\u5f02\u5e38\uff01";
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            webserviceLog.setAnalyzeResult("0");
            webserviceLog.setOp("\u8c03\u7528\u670d\u52a1\u5931\u8d25");
            this.uumWebserviceLogService.save((Object)webserviceLog);
            return "\u540c\u6b65\u5931\u8d25\uff01\u8c03\u7528\u670d\u52a1\u5931\u8d25\uff01";
        }
        webserviceLog.setXmlList(bizStr);
        webserviceLog.setAnalyzeResult("0");
        webserviceLog.setOp("\u6210\u529f");
        this.uumWebserviceLogService.save((Object)webserviceLog);
        logIdList.add(webserviceLog.getDocID());
        Document doc = null;
        try {
            doc = DocumentHelper.parseText((String)bizStr);
        }
        catch (DocumentException e) {
            e.printStackTrace();
        }
        List listNodes = doc.selectNodes("/root/data/list");
        if (ToolUtil.isNotEmpty((Object)listNodes)) {
            for (Object listNode : listNodes) {
                List uumOrganizationDispList;
                Attribute tmpRowNum;
                String orgNum;
                int orgSize;
                DefaultElement listInfo = (DefaultElement)listNode;
                Attribute tmpName = listInfo.attribute("name");
                String type = tmpName.getText();
                if (!"UumOrganizationDisp".equals(type) || (orgSize = Integer.parseInt(orgNum = (tmpRowNum = listInfo.attribute("rowNum")).getText())) <= 0 || (uumOrganizationDispList = listInfo.content()) == null || uumOrganizationDispList.size() <= 0) continue;
                this.getOrgDataList(uumOrganizationDispList, webserviceLog.getDocID());
            }
        }
        if (ToolUtil.isNotEmpty((Object)webserviceLog.getDocID())) {
            UumWebserviceLog tmp = new UumWebserviceLog();
            tmp.setDocID(webserviceLog.getDocID());
            tmp.setAnalyzeResult("1");
            tmp.setOp("\u6210\u529f");
            this.uumWebserviceLogService.updateById((Object)tmp);
        }
        try {
            Object dataNodes = doc.selectObject("/root/data");
            DefaultElement dataInfo = (DefaultElement)dataNodes;
            Attribute tmpName = dataInfo.attribute("disid");
            String disid = tmpName.getText();
            String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<info><result>S</result><disid>" + disid + "</disid><message>\u66f4\u65b0\u6210\u529f\uff01</message></info>";
            HashMap<String, Object> paramters = new HashMap<String, Object>();
            paramters.put("str", xml);
            String updateDistributeStateStr = this.webService("updateDistributeState", paramters);
            System.out.println("\u8c03\u7528web\u670d\u52a1updateDistributeState\uff1a" + updateDistributeStateStr);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (isCirclePull) {
            this.getData(isCirclePull, logIdList, docID, sysDataDto);
        }
        return "";
    }

    private void getUserDataList(List uumOperatorDispList, Long uumID) {
        int t = 0;
        ArrayList<UumOperator> tempList = new ArrayList<UumOperator>();
        for (Object user : uumOperatorDispList) {
            DefaultElement uele;
            List ueleList;
            if (!(user instanceof DefaultElement) || (ueleList = (uele = (DefaultElement)user).content()) == null || ueleList.size() <= 0) continue;
            UumOperator operator = new UumOperator();
            operator.setUumID(uumID);
            operator.setGetOrder(Integer.valueOf(++t));
            operator.setrStatus("0");
            operator.setrMessage("\u672a\u5904\u7406");
            for (Object userContent : ueleList) {
                DefaultElement ueleNode = (DefaultElement)userContent;
                String text = "";
                if (!StringUtils.isNotEmpty((CharSequence)ueleNode.getText())) continue;
                text = ueleNode.getText();
                switch (ueleNode.getQName().getName()) {
                    case "pID": {
                        operator.setpID(text);
                        break;
                    }
                    case "operatorName": {
                        operator.setOperatorName(text);
                        break;
                    }
                    case "casicOrgCode": {
                        operator.setCasicOrgCode(text);
                        break;
                    }
                    case "syncType": {
                        operator.setSyncType(text);
                        break;
                    }
                    case "sysID": {
                        operator.setSysID(text);
                        break;
                    }
                    case "empCode": {
                        operator.setEmpCode(text);
                        break;
                    }
                    case "secretLevel": {
                        operator.setSecretLevel(text);
                        break;
                    }
                    case "birthDate": {
                        if (text.length() < 8) break;
                        Comparable<Date> time = this.textToDate(text);
                        operator.setBirthDate(time);
                        break;
                    }
                    case "gender": {
                        operator.setGender(text);
                        break;
                    }
                    case "oTel": {
                        operator.setoTel(text);
                        break;
                    }
                    case "oEmail": {
                        operator.setoEmail(text);
                        break;
                    }
                    case "workPost": {
                        operator.setWorkPost(text);
                        break;
                    }
                    case "tecPost": {
                        operator.setTecPost(text);
                        break;
                    }
                    case "orderID": {
                        operator.setOrderID(Integer.valueOf(Integer.parseInt(text)));
                        break;
                    }
                    case "dispTime": {
                        if (text.length() < 14) break;
                        Comparable<Date> time = this.textToTime(text);
                        operator.setDispTime((LocalDateTime)time);
                        break;
                    }
                    case "status": {
                        operator.setStatus(text);
                        break;
                    }
                    case "remark": {
                        operator.setRemark(text);
                        break;
                    }
                    case "refa": {
                        operator.setRefa(text);
                        break;
                    }
                    case "refb": {
                        operator.setRefb(text);
                        break;
                    }
                    case "orgName": {
                        operator.setOrgName(text);
                    }
                }
            }
            tempList.add(operator);
        }
        if (tempList.size() > 0) {
            this.uumOperatorService.saveBatch(tempList);
        }
    }

    private void getOrgDataList(List uumOrganizationDispList, Long uumID) {
        int t = 0;
        ArrayList<UumOrganization> tempList = new ArrayList<UumOrganization>();
        for (Object organ : uumOrganizationDispList) {
            DefaultElement oele;
            List oeleList;
            if (!(organ instanceof DefaultElement) || (oeleList = (oele = (DefaultElement)organ).content()) == null || oeleList.size() <= 0) continue;
            UumOrganization organization = new UumOrganization();
            organization.setUumID(uumID);
            organization.setGetOrder(Integer.valueOf(++t));
            organization.setrStatus("0");
            organization.setrMessage("\u672a\u5904\u7406");
            for (Object organContent : oeleList) {
                DefaultElement oeleNode = (DefaultElement)organContent;
                String text = "";
                if (!ToolUtil.isNotEmpty((Object)oeleNode.getText())) continue;
                text = oeleNode.getText();
                switch (oeleNode.getQName().getName()) {
                    case "CODE": {
                        organization.setCode(text);
                        break;
                    }
                    case "ORGTYPE": {
                        organization.setOrgType(text);
                        break;
                    }
                    case "ORGNAME": {
                        organization.setOrgName(text);
                        break;
                    }
                    case "SHORTNAME": {
                        organization.setShortName(text);
                        break;
                    }
                    case "ORGCLASS": {
                        organization.setOrgClass(text);
                        break;
                    }
                    case "ORRGNATURE": {
                        organization.setOrrgNature(text);
                        break;
                    }
                    case "ORGMANLEVEL": {
                        organization.setOrgManLevel(text);
                        break;
                    }
                    case "PARENTORGCODE": {
                        organization.setParentOrgCode(text);
                        break;
                    }
                    case "ORGREMARK": {
                        organization.setOrgRemark(text);
                        break;
                    }
                    case "ORGCREATEDATE": {
                        if (text.length() < 14) break;
                        LocalDateTime time = this.textToTime(text);
                        organization.setOrgCreateDate(time);
                        break;
                    }
                    case "ORGCANCELDATE": {
                        if (text.length() < 14) break;
                        LocalDateTime time = this.textToTime(text);
                        organization.setOrgCancelDate(time);
                        break;
                    }
                    case "MDMSTATUS": {
                        organization.setMdmStatus(text);
                        break;
                    }
                    case "MDMORDERNO": {
                        organization.setMdmOrderno(text);
                        break;
                    }
                    case "FILLTWOORG": {
                        organization.setFillTwoOrg(text);
                        break;
                    }
                    case "FILLTHRORG": {
                        organization.setFillThrOrg(text);
                        break;
                    }
                    case "OPERATINGSTATUS": {
                        organization.setOperatingStatus(text);
                        break;
                    }
                    case "CREDITCODE": {
                        organization.setCreditCode(text);
                        break;
                    }
                    case "ORGNATIONCODE": {
                        organization.setOrgnationCode(text);
                        break;
                    }
                    case "COUNTRY": {
                        organization.setCountry(text);
                        break;
                    }
                    case "PROVINCE": {
                        organization.setProvince(text);
                        break;
                    }
                    case "CITY": {
                        organization.setCity(text);
                        break;
                    }
                    case "ISFINANCE": {
                        organization.setIsFinance(text);
                        break;
                    }
                    case "FINANCEPARENTCODE": {
                        organization.setFinanceParentCode(text);
                        break;
                    }
                    case "FINANCEORGMANLEVEL": {
                        organization.setFinanceOrgmanLevel(text);
                        break;
                    }
                    case "FINANCEORDERNO": {
                        organization.setFinanceOrderno(text);
                        break;
                    }
                    case "DISTRICT": {
                        organization.setDistrict(text);
                        break;
                    }
                    case "ORGLANGUAGE": {
                        organization.setOrgLanguage(text);
                        break;
                    }
                    case "ORGCURRENCY": {
                        organization.setOrgCurrency(text);
                        break;
                    }
                    case "ISLICOMPANY": {
                        organization.setIsLiCompany(text);
                        break;
                    }
                    case "INDUCLASS": {
                        organization.setInduclass(text);
                        break;
                    }
                    case "ERPCORPCODE": {
                        organization.setErpCorpCode(text);
                        break;
                    }
                    case "ERPCORPNAME": {
                        organization.setErpCorpName(text);
                        break;
                    }
                    case "YL1": {
                        organization.setYl1(text);
                        break;
                    }
                    case "YL2": {
                        organization.setYl2(text);
                        break;
                    }
                    case "YL3": {
                        organization.setYl3(text);
                        break;
                    }
                    case "YL4": {
                        organization.setYl4(text);
                        break;
                    }
                    case "YL5": {
                        organization.setYl5(text);
                    }
                }
            }
            tempList.add(organization);
        }
        if (tempList.size() > 0) {
            this.uumOrganizationService.saveBatch(tempList);
        }
    }

    private int recursionDealUser(List<Long> logIdList, Map<String, Object> param, int dealNum) {
        int failNum = (Integer)param.get("orgFail");
        if (dealNum <= this.maxOrgLevel - 3 && failNum > 0) {
            Map<String, Object> orgResult1;
            QueryWrapper ew1 = new QueryWrapper();
            ew1.in((Object)"UUMID", logIdList);
            ew1.eq((Object)"RSTATUS", (Object)"N");
            ew1.orderByAsc((Object)"DISPTIME", (Object[])new String[]{"GETORDER"});
            List orgList = this.uumOrganizationService.list((Wrapper)ew1);
            if (orgList.size() > 0 && ToolUtil.isNotEmpty(orgResult1 = this.dealOrg(orgList))) {
                Object failNum1 = orgResult1.get("orgFail");
                failNum = Integer.parseInt(failNum1.toString());
                param.put("orgFail", failNum);
                this.recursionDealUser(logIdList, param, ++dealNum);
            }
        }
        failNum = (Integer)param.get("orgFail");
        return failNum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Object> dealOrg(List<UumOrganization> orgList) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        int orgFail = 0;
        int t = 0;
        ArrayList<SyncOrgDataBo> updateList = new ArrayList<SyncOrgDataBo>();
        ArrayList<SyncOrgDataBo> addList = new ArrayList<SyncOrgDataBo>();
        for (UumOrganization temp : orgList) {
            System.out.println("\u5171" + orgList.size() + "\u6761\u7ec4\u7ec7\u6570\u636e\uff0c\u5f53\u524d\u5904\u7406\u7b2c" + ++t + "\u6761");
            String casicOrgCode = temp.getCode();
            String rStatus = "Y";
            String rMessage = "\u6210\u529f";
            try {
                String departCasicOrgCode;
                String orgName = temp.getOrgName();
                if (ToolUtil.isEmpty((Object)casicOrgCode)) {
                    ++orgFail;
                    rStatus = "N";
                    rMessage = "\u96c6\u56e2\u673a\u6784\u7f16\u7801\u4e3a\u7a7a";
                    continue;
                }
                if (casicOrgCode.startsWith(this.sixthCenterCode) && !this.sixthCenterCode.equals(casicOrgCode) || casicOrgCode.length() > 6 && (casicOrgCode.startsWith("0059") || casicOrgCode.startsWith("0042") || casicOrgCode.startsWith("0077")) && casicOrgCode.startsWith(departCasicOrgCode = casicOrgCode.substring(0, 6)) && !departCasicOrgCode.equals(casicOrgCode)) continue;
                String casicPOrgCode = temp.getParentOrgCode();
                if (ToolUtil.isEmpty((Object)casicPOrgCode)) {
                    if (this.flightCode.equals(casicOrgCode)) continue;
                    ++orgFail;
                    rStatus = "N";
                    rMessage = "\u7236\u7ea7\u96c6\u56e2\u673a\u6784\u7f16\u7801\u4e3a\u7a7a";
                    continue;
                }
                String syncType = temp.getSyncType();
                Integer orderID = Integer.valueOf(temp.getMdmOrderno());
                String orgParentCode = "";
                Long parentId = Long.parseLong(temp.getParentOrgCode());
                Long struId = null;
                Long organId = null;
                String operateType = "";
                Object permissionStruId = null;
                String parentStruLevel = "0";
                String struType = "";
                Long oldParentId = null;
                List parentStruList = this.sysStruMapper.getSyncStruByCasicOrgCode(casicPOrgCode);
                List struList = this.sysStruMapper.getSyncStruByCasicOrgCode(casicOrgCode);
                if (ToolUtil.isNotEmpty((Object)struList)) {
                    Map stru = (Map)struList.get(0);
                    struId = Long.parseLong(stru.get("struId").toString());
                    organId = Long.parseLong(stru.get("organId").toString());
                    struType = stru.get("struType").toString();
                    oldParentId = Long.parseLong(stru.get("parentId").toString());
                }
                if ("2".equals(syncType)) {
                    if (ToolUtil.isEmpty(struId)) {
                        ++orgFail;
                        rStatus = "N";
                        rMessage = "\u5220\u9664\u7ec4\u7ec7\u4e0d\u5b58\u5728";
                        continue;
                    }
                    operateType = "2";
                } else {
                    operateType = ToolUtil.isNotEmpty(struId) ? "1" : "0";
                }
                if ("2".equals(operateType)) continue;
                SysStru sysStru = new SysStru();
                SysOrgan sysOrgan = new SysOrgan();
                SysOffice sysOffice = new SysOffice();
                sysStru.setOrganAlias(orgName);
                sysStru.setParentId(Long.valueOf(Long.parseLong(temp.getParentOrgCode())));
                sysStru.setImmeUpOrg(temp.getParentOrgCode());
                sysStru.setFillTwoOrg(temp.getFillTwoOrg());
                sysStru.setFillThrOrg(temp.getFillThrOrg());
                sysStru.setOrgmanLevel(temp.getOrgManLevel());
                sysStru.setOrderNumber(temp.getMdmOrderno());
                sysStru.setOrganType(temp.getOrgType());
                sysStru.setMdmStatus(temp.getMdmStatus());
                sysStru.setIsFinance(temp.getIsFinance());
                sysStru.setFinanceParentCode(temp.getFinanceParentCode());
                sysStru.setFinanceOrgmanLevel(temp.getFinanceOrgmanLevel());
                sysStru.setFinanceOrderNo(temp.getFinanceOrderno());
                sysStru.setYl1(temp.getYl1());
                sysStru.setYl2(temp.getYl2());
                sysStru.setYl3(temp.getYl3());
                sysStru.setYl4(temp.getYl4());
                sysStru.setYl5(temp.getYl5());
                if (ToolUtil.isNotEmpty((Object)orderID)) {
                    sysStru.setStruOrder(orderID);
                }
                DateTimeFormatter fmt = DateTimeFormatter.ofPattern("yyyy-MM-dd");
                sysOrgan.setOrganName(orgName);
                sysOrgan.setShortName(temp.getShortName());
                sysOrgan.setOrganCode(temp.getOrgnationCode());
                sysOrgan.setBeginDate(temp.getOrgCreateDate().format(fmt));
                sysOrgan.setEndDate(temp.getOrgCancelDate().format(fmt));
                sysOrgan.setCreditCode(temp.getCreditCode());
                sysOrgan.setCountry(temp.getCountry());
                sysOrgan.setProvince(temp.getProvince());
                sysOrgan.setLanguage(temp.getOrgLanguage());
                sysOrgan.setCurrency(temp.getOrgCurrency());
                sysOrgan.setInduclass(temp.getInduclass());
                sysOrgan.setOrgType(temp.getOrgClass());
                sysOrgan.setOrgNature(temp.getOrrgNature());
                sysOrgan.setIsltCompany(temp.getIsLiCompany());
                sysOrgan.setManageState(temp.getOperatingStatus());
                sysOrgan.setErpComCode(temp.getErpCorpCode());
                sysOrgan.setErpComName(temp.getErpCorpName());
                sysOrgan.setRemark(temp.getOrgRemark());
                sysOrgan.setCity(temp.getCity());
                sysOrgan.setCode(temp.getCode());
                sysOrgan.setAreaCounty(temp.getDistrict());
                boolean isAdd = true;
                if ("0".equals(operateType)) {
                    String businessName = "ORGAN_CODE_4";
                    String tableName = "SYS_ORGAN";
                    String currentCode = this.sysIdtableService.getCurrentCodeEy(businessName, tableName);
                    String orgType = "2";
                    if (casicOrgCode.length() == 4 || this.hospitalCode.equals(casicOrgCode)) {
                        orgType = "1";
                    }
                    sysStru.setStruType(orgType);
                    sysStru.setIsLeaf("0");
                    sysStru.setDelFlag("0");
                    sysStru.setStruPath("");
                    sysStru.setStruLevel(Integer.valueOf(1));
                    if (ToolUtil.isEmpty((Object)sysStru.getStruOrder())) {
                        Integer orderTree = 1;
                        Integer maxOrder = this.sysStruMapper.getMaxOrderById(sysStru.getParentId());
                        if (ToolUtil.isNotEmpty((Object)maxOrder)) {
                            orderTree = maxOrder + 1;
                        }
                        sysStru.setStruOrder(orderTree);
                    }
                    sysOrgan.setOrganCode(currentCode);
                    sysOrgan.setOrganType(orgType);
                    sysOrgan.setDelFlag("0");
                } else {
                    JSONObject result;
                    if (!parentId.equals(oldParentId) && !(result = this.formerlyOrgManageService.orgTreeChangeVue(struId, parentId, struType, "", parentStruLevel, Boolean.valueOf(true))).getBoolean("success").booleanValue()) {
                        ++orgFail;
                        rStatus = "N";
                        rMessage = result.getString("msg");
                        continue;
                    }
                    isAdd = false;
                    sysStru.setId(struId);
                    sysOrgan.setId(organId);
                    sysStru.setOrganId(organId);
                    sysOffice = null;
                }
                SyncOrgDataBo syncOrgDataBo = new SyncOrgDataBo();
                syncOrgDataBo.setSysOffice(sysOffice);
                syncOrgDataBo.setSysOrgan(sysOrgan);
                syncOrgDataBo.setSysStru(sysStru);
                if (isAdd) {
                    addList.add(syncOrgDataBo);
                    continue;
                }
                updateList.add(syncOrgDataBo);
            }
            catch (Exception e) {
                ++orgFail;
                rStatus = "N";
                rMessage = this.exceptionDetail(e);
            }
            finally {
                UumOrganization tmp = new UumOrganization();
                tmp.setDocID(temp.getDocID());
                tmp.setrStatus(rStatus);
                tmp.setrMessage(rMessage);
                this.uumOrganizationService.updateById((Object)tmp);
            }
        }
        this.syncOrgInfoSave(addList, true);
        this.syncOrgInfoSave(updateList, false);
        resultMap.put("orgFail", orgFail);
        return resultMap;
    }

    private LocalDateTime textToTime(String text) {
        LocalDateTime date = null;
        String year = text.substring(0, 4);
        String month = text.substring(4, 6);
        String day = text.substring(6, 8);
        String hour = text.substring(8, 10);
        String moment = text.substring(10, 12);
        String second = text.substring(12);
        String time = year + "-" + month + "-" + day + " " + hour + ":" + moment + ":" + second;
        DateTimeFormatter dateFormat = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        date = LocalDateTime.parse(time, dateFormat);
        return date;
    }

    private Date textToDate(String text) {
        Date date = null;
        String year = text.substring(0, 4);
        String month = text.substring(4, 6);
        String day = text.substring(6, 8);
        String time = year + "-" + month + "-" + day;
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        try {
            date = dateFormat.parse(time);
        }
        catch (ParseException e) {
            return date;
        }
        return date;
    }

    private String exceptionDetail(Exception e) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(outputStream);
        e.printStackTrace(printStream);
        String exceptionInformation = new String(outputStream.toByteArray());
        printStream.close();
        try {
            outputStream.close();
        }
        catch (IOException t) {
            t.printStackTrace();
        }
        return exceptionInformation;
    }

    private String convertSecurityLevel(String securityLevel) {
        String result = "60";
        if (ToolUtil.isNotEmpty((Object)securityLevel)) {
            if ("50".equals(securityLevel)) {
                result = "70";
            } else if ("70".equals(securityLevel)) {
                result = "80";
            } else if ("90".equals(securityLevel)) {
                result = "90";
            }
        }
        return result;
    }

    private void syncOrgInfoSave(List<SyncOrgDataBo> syncOrgDataBoList, boolean addFlag) {
        if (HussarUtils.isEmpty(syncOrgDataBoList)) {
            return;
        }
        if (addFlag) {
            ArrayList<SysOrgan> sysOrgans = new ArrayList<SysOrgan>(syncOrgDataBoList.size());
            for (SyncOrgDataBo item : syncOrgDataBoList) {
                sysOrgans.add(item.getSysOrgan());
            }
            this.organService.saveBatch(sysOrgans);
            ArrayList organList = new ArrayList();
            ArrayList<SysStru> struList = new ArrayList<SysStru>();
            for (SyncOrgDataBo item : syncOrgDataBoList) {
                SysStru sysStru = item.getSysStru();
                sysStru.setOrganId(item.getSysOrgan().getId());
                struList.add(sysStru);
            }
            this.hussarBaseStruBoService.saveStruBatch(struList);
            ArrayList<SysOffice> officeList = new ArrayList<SysOffice>();
            for (SyncOrgDataBo item : syncOrgDataBoList) {
                SysStru sysStru = item.getSysStru();
                SysOffice sysOffice = item.getSysOffice();
                sysOffice.setStruId(sysStru.getId());
                officeList.add(sysOffice);
            }
            this.hussarBaseOrgBoService.saveOfficeBatch(officeList);
        } else {
            ArrayList organList = new ArrayList();
            ArrayList<SysStru> struList = new ArrayList<SysStru>();
            ArrayList<SysOffice> officeList = new ArrayList<SysOffice>();
            ArrayList<SysOrgan> sysOrgans = new ArrayList<SysOrgan>();
            for (SyncOrgDataBo item : syncOrgDataBoList) {
                sysOrgans.add(item.getSysOrgan());
                struList.add(item.getSysStru());
                officeList.add(item.getSysOffice());
            }
            this.organService.updateBatchById(sysOrgans);
            this.organService.updateBatchById(organList);
            this.hussarBaseStruBoService.updateStruBatchById(struList);
            if (HussarUtils.isNotEmpty(officeList) && HussarUtils.isNotEmpty(officeList.get(0))) {
                this.hussarBaseOrgBoService.updateOfficeBatchById(officeList);
            }
        }
    }

    private void addUserRoleInServer(List<String> userAccounts) {
        if (HussarUtils.isEmpty(userAccounts)) {
            return;
        }
        List<AddPublicRoleBo> addPublicRoleBoList = this.syncDataMapper.getUserServerRelation(userAccounts);
        LinkedMultiValueMap serverUserRelation = new LinkedMultiValueMap();
        ArrayList<Long> roleIds = new ArrayList<Long>();
        for (AddPublicRoleBo addPublicRoleBo : addPublicRoleBoList) {
            roleIds.add(addPublicRoleBo.getUserId());
        }
        if (HussarUtils.isNotEmpty(roleIds)) {
            this.sysUserRolesUtilService.addPublicRole(roleIds);
        }
    }
}

