/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.organ.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.authorization.organ.dao.SysOrganMapper;
import com.jxdinfo.hussar.authorization.organ.dao.SysStruMapper;
import com.jxdinfo.hussar.authorization.organ.dto.AddOrganizationDto;
import com.jxdinfo.hussar.authorization.organ.dto.EditOrganizationDto;
import com.jxdinfo.hussar.authorization.organ.dto.TransferOrganizationDto;
import com.jxdinfo.hussar.authorization.organ.model.SysOrgan;
import com.jxdinfo.hussar.authorization.organ.model.SysStru;
import com.jxdinfo.hussar.authorization.organ.service.IHussarBaseOrganizationService;
import com.jxdinfo.hussar.organ.dao.OrganMapper;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/organ"})
public class OrganController {
    @Resource
    private IHussarBaseOrganizationService organizationService;
    @Resource
    private OrganMapper organMapper;
    @Resource
    private SysOrganMapper sysOrganMapper;
    @Resource
    private SysStruMapper sysStruMapper;
    @Value(value="${hussar.base.bimRemoteUser}")
    private String adminUser;
    @Value(value="${hussar.base.bimRemotePwd}")
    private String adminPwd;

    @PostMapping(value={"/OrgCreateService"})
    public Map<String, Object> OrgCreateService(@RequestBody Map<String, Object> map) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        String bimRequestId = map.get("bimRequestId") == null ? "" : map.get("bimRequestId").toString();
        String bimRemoteUser = map.get("bimRemoteUser") == null ? "" : map.get("bimRemoteUser").toString();
        String bimRemotePwd = map.get("bimRemotePwd") == null ? "" : map.get("bimRemotePwd").toString();
        String orgName = map.get("organName") == null ? "" : map.get("organName").toString();
        String parOrgId = map.get("parentId") == null ? "" : map.get("parentId").toString();
        String organCode = map.get("organCode") == null ? "" : map.get("organCode").toString();
        String organType = map.get("struType") == null ? "" : map.get("struType").toString();
        String signature = map.get("signature") == null ? "" : map.get("signature").toString();
        resultMap.put("bimRequestId", bimRequestId);
        if (!this.adminUser.equals(bimRemoteUser) || !this.adminPwd.equals(bimRemotePwd)) {
            resultMap.put("resultCode", 500);
            resultMap.put("message", "\u7528\u6237\u540d\u6216\u5bc6\u7801\u9519\u8bef");
            return resultMap;
        }
        AddOrganizationDto addOrganizationDto = new AddOrganizationDto();
        addOrganizationDto.setStruType(organType);
        addOrganizationDto.setOrganName(orgName);
        addOrganizationDto.setOrganCode(organCode);
        addOrganizationDto.setParentId(Long.valueOf(Long.parseLong(parOrgId)));
        addOrganizationDto.setOrganProperty("0");
        addOrganizationDto.setValidTimeLimitType("0");
        ApiResponse response = this.organizationService.addOrganization(addOrganizationDto);
        if (response.getCode() == 10001) {
            resultMap.put("resultCode", 500);
            resultMap.put("message", response.getMsg());
            return resultMap;
        }
        resultMap.put("uid", response.getData());
        resultMap.put("resultCode", 0);
        resultMap.put("message", "success");
        return resultMap;
    }

    @PostMapping(value={"/OrgUpdateService"})
    public Map<String, Object> OrgUpdateService(@RequestBody Map<String, Object> map) {
        String bimRequestId = map.get("bimRequestId") == null ? "" : map.get("bimRequestId").toString();
        String bimRemoteUser = map.get("bimRemoteUser") == null ? "" : map.get("bimRemoteUser").toString();
        String bimRemotePwd = map.get("bimRemotePwd") == null ? "" : map.get("bimRemotePwd").toString();
        String orgName = map.get("organName") == null ? "" : map.get("organName").toString();
        String bimOrgId = map.get("bimOrgId") == null ? "" : map.get("bimOrgId").toString();
        String parOrgId = map.get("parentId") == null ? "" : map.get("parentId").toString();
        String signature = map.get("signature") == null ? "" : map.get("signature").toString();
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("bimRequestId", bimRequestId);
        if (!this.adminUser.equals(bimRemoteUser) || !this.adminPwd.equals(bimRemotePwd)) {
            resultMap.put("resultCode", 500);
            resultMap.put("message", "\u7528\u6237\u540d\u6216\u5bc6\u7801\u9519\u8bef");
            return resultMap;
        }
        EditOrganizationDto editOrganizationDto = new EditOrganizationDto();
        editOrganizationDto.setId(Long.valueOf(Long.parseLong(bimOrgId)));
        editOrganizationDto.setStruType("2");
        editOrganizationDto.setShortName(orgName);
        editOrganizationDto.setOrganAlias(orgName);
        editOrganizationDto.setOrganName(orgName);
        editOrganizationDto.setOrganProperty("0");
        editOrganizationDto.setValidTimeLimitType("0");
        ApiResponse response = this.organizationService.editOrganization(editOrganizationDto);
        if (response.getCode() == 10001) {
            resultMap.put("resultCode", 500);
            resultMap.put("message", response.getMsg());
            return resultMap;
        }
        TransferOrganizationDto transferOrganizationDto = new TransferOrganizationDto();
        transferOrganizationDto.setOldId(Long.valueOf(Long.parseLong(bimOrgId)));
        transferOrganizationDto.setNewId(Long.valueOf(Long.parseLong(parOrgId)));
        ApiResponse response1 = this.organizationService.transferOrganization(transferOrganizationDto);
        if (response1.getCode() == 10001) {
            resultMap.put("resultCode", 500);
            resultMap.put("message", response.getMsg());
            return resultMap;
        }
        resultMap.put("message", "success");
        resultMap.put("resultCode", 0);
        return resultMap;
    }

    @PostMapping(value={"/OrgDeleteService"})
    public Map<String, Object> OrgDeleteService(@RequestBody Map<String, Object> map) {
        String bimRequestId = map.get("bimRequestId") == null ? "" : map.get("bimRequestId").toString();
        String bimRemoteUser = map.get("bimRemoteUser") == null ? "" : map.get("bimRemoteUser").toString();
        String bimRemotePwd = map.get("bimRemotePwd") == null ? "" : map.get("bimRemotePwd").toString();
        String bimOrgId = map.get("bimOrgId") == null ? "" : map.get("bimOrgId").toString();
        String signature = map.get("signature") == null ? "" : map.get("signature").toString();
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("bimRequestId", bimRequestId);
        if (!this.adminUser.equals(bimRemoteUser) || !this.adminPwd.equals(bimRemotePwd)) {
            resultMap.put("resultCode", 500);
            resultMap.put("message", "\u7528\u6237\u540d\u6216\u5bc6\u7801\u9519\u8bef");
            return resultMap;
        }
        ApiResponse response = this.organizationService.deleteOrganization(Long.valueOf(Long.parseLong(bimOrgId)));
        if (response.getCode() == 10001) {
            resultMap.put("resultCode", 500);
            resultMap.put("message", response.getMsg());
            return resultMap;
        }
        resultMap.put("message", "success");
        resultMap.put("resultCode", 0);
        return resultMap;
    }

    @PostMapping(value={"/QueryAllOrgIdsService"})
    public Map<String, Object> QueryAllOrgIdsService(@RequestBody Map<String, Object> map) {
        String bimRequestId = map.get("bimRequestId") == null ? "" : map.get("bimRequestId").toString();
        String bimRemoteUser = map.get("bimRemoteUser") == null ? "" : map.get("bimRemoteUser").toString();
        String bimRemotePwd = map.get("bimRemotePwd") == null ? "" : map.get("bimRemotePwd").toString();
        String signature = map.get("signature") == null ? "" : map.get("signature").toString();
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("bimRequestId", bimRequestId);
        if (!this.adminUser.equals(bimRemoteUser) || !this.adminPwd.equals(bimRemotePwd)) {
            resultMap.put("resultCode", 500);
            resultMap.put("message", "\u7528\u6237\u540d\u6216\u5bc6\u7801\u9519\u8bef");
            return resultMap;
        }
        List<String> organIds = this.organMapper.getAllOrganIds();
        if (HussarUtils.isEmpty(organIds)) {
            resultMap.put("message", "\u67e5\u8be2organId\u5931\u8d25\uff0c\u4e3a\u7a7a");
            resultMap.put("resultCode", 500);
            return resultMap;
        }
        resultMap.put("orgIdList", organIds);
        resultMap.put("message", "success");
        resultMap.put("resultCode", 0);
        return resultMap;
    }

    @PostMapping(value={"/QueryOrgByIdService"})
    public Map<String, Object> QueryOrgByIdService(@RequestBody Map<String, Object> map) {
        String bimRequestId = map.get("bimRequestId") == null ? "" : map.get("bimRequestId").toString();
        String bimRemoteUser = map.get("bimRemoteUser") == null ? "" : map.get("bimRemoteUser").toString();
        String bimRemotePwd = map.get("bimRemotePwd") == null ? "" : map.get("bimRemotePwd").toString();
        String signature = map.get("signature") == null ? "" : map.get("signature").toString();
        String bimOrgId = map.get("bimOrgId") == null ? "" : map.get("bimOrgId").toString();
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("bimRequestId", bimRequestId);
        if (!this.adminUser.equals(bimRemoteUser) || !this.adminPwd.equals(bimRemotePwd)) {
            resultMap.put("resultCode", 500);
            resultMap.put("message", "\u7528\u6237\u540d\u6216\u5bc6\u7801\u9519\u8bef");
            return resultMap;
        }
        if (HussarUtils.isEmpty((Object)bimOrgId)) {
            resultMap.put("message", "\u63a5\u6536\u5230\u7684bimOrgId\u4e3a\u7a7a");
            resultMap.put("resultCode", 500);
            return resultMap;
        }
        SysStru sysStru = (SysStru)this.sysStruMapper.selectOne((Wrapper)new LambdaQueryWrapper().eq(SysStru::getId, (Object)bimOrgId));
        if (HussarUtils.isEmpty((Object)sysStru)) {
            resultMap.put("message", "\u7ec4\u7ec7\u7ed3\u6784\u67e5\u8be2\u4e3a\u7a7a");
            resultMap.put("resultCode", 500);
            return resultMap;
        }
        SysOrgan sysOrgan = (SysOrgan)this.sysOrganMapper.selectOne((Wrapper)new LambdaQueryWrapper().eq(SysOrgan::getId, (Object)sysStru.getOrganId()));
        if (HussarUtils.isEmpty((Object)sysOrgan)) {
            resultMap.put("message", "\u7ec4\u7ec7\u673a\u6784\u67e5\u8be2\u4e3a\u7a7a");
            resultMap.put("resultCode", 500);
            return resultMap;
        }
        HashMap<String, Object> organMap = new HashMap<String, Object>();
        organMap.put("orgName", sysOrgan.getOrganName());
        organMap.put("parOrgId", sysStru.getParentId());
        organMap.put("orgId", sysStru.getId());
        resultMap.put("organization", organMap);
        resultMap.put("message", "success");
        resultMap.put("resultCode", 0);
        return resultMap;
    }
}

