/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.sync.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.dynamic.datasource.annotation.Master;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.authorization.permit.model.SysRoles;
import com.jxdinfo.hussar.authorization.permit.model.SysUserRole;
import com.jxdinfo.hussar.authorization.permit.service.IHussarBaseUserRoleBoService;
import com.jxdinfo.hussar.baseconfig.properties.GlobalProperties;
import com.jxdinfo.hussar.common.constant.Constants;
import com.jxdinfo.hussar.common.constant.enums.SysUserAndRole;
import com.jxdinfo.hussar.common.constant.state.UserStatus;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.common.utils.CopyPropertieUtils;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.example.plugin.feign.HussarCommonFeignServiceImpl;
import com.jxdinfo.hussar.example.plugin.feign.HussarDynamicFeignClientFactory;
import com.jxdinfo.hussar.formerlycommon.util.datasource.DataSourceUtil;
import com.jxdinfo.hussar.general.idtable.service.ISysIdtableService;
import com.jxdinfo.hussar.identity.organ.manager.EditOrganizationManager;
import com.jxdinfo.hussar.identity.organ.model.SysOffice;
import com.jxdinfo.hussar.identity.organ.model.SysOrgan;
import com.jxdinfo.hussar.identity.organ.model.SysStaff;
import com.jxdinfo.hussar.identity.organ.model.SysStru;
import com.jxdinfo.hussar.identity.organ.model.SysStruAssistOrgan;
import com.jxdinfo.hussar.identity.organ.service.IHussarBaseOrgBoService;
import com.jxdinfo.hussar.identity.organ.service.IHussarBaseOrganTypeBoService;
import com.jxdinfo.hussar.identity.organ.service.IHussarBaseStruAssistOrganBoService;
import com.jxdinfo.hussar.identity.organ.service.IHussarBaseStruBoService;
import com.jxdinfo.hussar.identity.organ.service.ISysOrganService;
import com.jxdinfo.hussar.identity.user.model.SysUsers;
import com.jxdinfo.hussar.organ.dao.SysOldStruMapper;
import com.jxdinfo.hussar.organ.model.SysFormerlyOrgan;
import com.jxdinfo.hussar.organ.service.IHussarBaseStaffUserService;
import com.jxdinfo.hussar.organ.service.IHussarBaseSysOrgManageService;
import com.jxdinfo.hussar.organ.service.ISysFormerlyOrgManageService;
import com.jxdinfo.hussar.organ.service.ISysFormerlyOrganService;
import com.jxdinfo.hussar.permit.dao.SysOldUsersMapper;
import com.jxdinfo.hussar.permit.service.ISysOldRolesService;
import com.jxdinfo.hussar.permit.service.ISysOldUsersService;
import com.jxdinfo.hussar.permit.service.ISysUserRolesService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.SpringContextUtil;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import com.jxdinfo.hussar.sync.bo.AddPublicRoleBo;
import com.jxdinfo.hussar.sync.bo.ServerInfoBo;
import com.jxdinfo.hussar.sync.bo.SyncOrgDataBo;
import com.jxdinfo.hussar.sync.dao.SyncDataMapper;
import com.jxdinfo.hussar.sync.dao.UumLogMapper;
import com.jxdinfo.hussar.sync.model.UumLog;
import com.jxdinfo.hussar.sync.model.UumOperator;
import com.jxdinfo.hussar.sync.model.UumOrganization;
import com.jxdinfo.hussar.sync.model.UumWebserviceLog;
import com.jxdinfo.hussar.sync.service.ISyncDataService;
import com.jxdinfo.hussar.sync.service.IUumLogService;
import com.jxdinfo.hussar.sync.service.IUumOperatorService;
import com.jxdinfo.hussar.sync.service.IUumOrganizationService;
import com.jxdinfo.hussar.sync.service.IUumWebserviceLogService;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.xml.namespace.QName;
import javax.xml.rpc.ParameterMode;
import org.apache.axis.client.Call;
import org.apache.axis.encoding.XMLType;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.tree.DefaultElement;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.LinkedMultiValueMap;

@Service
@Master
public class SyncDataServiceImpl
implements ISyncDataService {
    @Value(value="${webservice.url:http://192.168.6.99/axis/services/BizService}")
    private String url;
    @Value(value="${webservice.packageName:uum}")
    private String packageName;
    @Value(value="${webservice.unitId:0}")
    private String unitId;
    @Value(value="${webservice.processName:bizWebService.bizQueryOrgEmp}")
    private String processName;
    @Value(value="${webservice.sysID:tianxin}")
    private String sysID;
    @Value(value="${webservice.tranferStruId:1}")
    private String tranferStruId;
    @Value(value="${webservice.flightCode:99999}")
    private String flightCode;
    @Value(value="${webservice.hospitalCode:001000}")
    private String hospitalCode;
    @Value(value="${webservice.sixthCenterCode:003216}")
    private String sixthCenterCode;
    @Value(value="${webservice.maxOrgLevel:6}")
    private int maxOrgLevel;
    @Resource
    private ISysIdtableService sysIdtableService;
    @Resource
    private IHussarBaseSysOrgManageService orgMaintenanceService;
    @Autowired
    private SysOldStruMapper sysStruMapper;
    @Resource
    private GlobalProperties globalProperties;
    @Resource
    private IHussarBaseOrganTypeBoService hussarBaseOrganTypeBoService;
    @Resource
    private IHussarBaseStaffUserService staffUserService;
    @Autowired
    private SysOldUsersMapper sysUsersMapper;
    @Resource
    private IHussarBaseStruAssistOrganBoService hussarBaseStruAssistOrganBoService;
    @Resource
    private IHussarBaseStruBoService hussarBaseStruBoService;
    @Resource
    private IUumWebserviceLogService uumWebserviceLogService;
    @Resource
    private IUumOrganizationService uumOrganizationService;
    @Resource
    private IUumOperatorService uumOperatorService;
    @Resource
    private IUumLogService uumLogService;
    @Resource
    private UumLogMapper uumLogMapper;
    @Resource
    private ISysUserRolesService sysUserRolesUtilService;
    @Resource
    private ISysOldRolesService iSysRolesService;
    @Resource
    private ISysOldUsersService iSysUsersService;
    @Resource
    private IHussarBaseUserRoleBoService hussarBaseUserRoleBoService;
    @Resource
    private ISysFormerlyOrgManageService formerlyOrgManageService;
    @Resource
    private ISysOrganService organService;
    @Resource
    private ISysFormerlyOrganService formerlyOrganService;
    @Resource
    private IHussarBaseOrgBoService hussarBaseOrgBoService;
    @Autowired
    private EditOrganizationManager editOrganizationManager;
    @Resource
    private SyncDataMapper syncDataMapper;
    @Value(value="${hussar.cloud.enable}")
    private Boolean cloud;

    @HussarTransactional
    public ApiResponse<?> syncData() {
        HussarCacheUtil.put((String)"sync_info", (Object)"sync_status", (Object)true);
        System.out.println("\u7edf\u4e00\u7528\u6237\u5f00\u59cb");
        long startTime = System.currentTimeMillis();
        List<UumOrganization> orgList = new ArrayList();
        List<UumOperator> userList = new ArrayList();
        ArrayList<Long> logIdList = new ArrayList<Long>();
        Long userId = null;
        SecurityUser shiroUser = null;
        try {
            shiroUser = BaseSecurityUtil.getUser();
        }
        catch (Exception e) {
            shiroUser = null;
        }
        if (ToolUtil.isNotEmpty((Object)shiroUser)) {
            userId = shiroUser.getId();
        }
        UumLog uumLog = new UumLog();
        uumLog.setCreator(userId);
        uumLog.setStartTime(LocalDateTime.now());
        uumLog.setStatus("0");
        this.uumLogService.save((Object)uumLog);
        Long docID = uumLog.getDocID();
        System.out.println("\u83b7\u53d6\u53ca\u5b58\u50a8\u4e34\u65f6\u6570\u636e\u5f00\u59cb");
        long startTime1 = System.currentTimeMillis();
        String msg = this.getData(true, logIdList, docID);
        long endTime1 = System.currentTimeMillis();
        System.out.println("\u83b7\u53d6\u53ca\u5b58\u50a8\u4e34\u65f6\u6570\u636e\u7ed3\u675f");
        System.out.println("\u83b7\u53d6\u53ca\u5b58\u50a8\u4e34\u65f6\u6570\u636e\u65f6\u95f4\uff1a" + (endTime1 - startTime1) / 1000L + "s");
        UumLog uumLog1 = new UumLog();
        uumLog1.setDocID(docID);
        if (!"".equals(msg)) {
            System.out.println(msg);
            System.out.println("\u7edf\u4e00\u7528\u6237\u7ed3\u675f");
            uumLog1.setEndTime(LocalDateTime.now());
            uumLog1.setStatus("3");
            this.uumLogService.updateById((Object)uumLog1);
            HussarCacheUtil.evict((String)"sync_info", (Object)"sync_status");
            return ApiResponse.fail((String)msg);
        }
        QueryWrapper ew = new QueryWrapper();
        ew.in((Object)"UUMID", logIdList);
        ew.eq((Object)"RSTATUS", (Object)"0");
        ew.orderByAsc((Object)"DISPTIME", (Object[])new String[]{"GETORDER"});
        orgList = this.uumOrganizationService.list((Wrapper)ew);
        QueryWrapper qw = new QueryWrapper();
        qw.in((Object)"UUMID", logIdList);
        qw.eq((Object)"RSTATUS", (Object)"0");
        qw.orderByAsc((Object)"DISPTIME", (Object[])new String[]{"GETORDER"});
        userList = this.uumOperatorService.list((Wrapper)qw);
        int orgSize = orgList.size();
        int userSize = userList.size();
        int orgFail = 0;
        int userFail = 0;
        uumLog1.setStatus("1");
        uumLog1.setOrgTotalNum(Integer.valueOf(orgSize));
        uumLog1.setUserTotalNum(Integer.valueOf(userSize));
        this.uumLogService.updateById((Object)uumLog1);
        System.out.println("\u5904\u7406\u6570\u636e\u5f00\u59cb");
        long startTime2 = System.currentTimeMillis();
        Map<String, Object> orgResult = this.dealOrg(orgList);
        if (ToolUtil.isNotEmpty(orgResult)) {
            Object failNum = orgResult.get("orgFail");
            orgFail = Integer.parseInt(failNum.toString());
        }
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("orgFail", orgFail);
        orgFail = this.recursionDealUser(logIdList, param, 0);
        uumLog1.setStatus("2");
        uumLog1.setOrgFailNum(Integer.valueOf(orgFail));
        this.uumLogService.updateById((Object)uumLog1);
        Map<String, Object> userResult = this.dealUser(userList);
        long endTime2 = System.currentTimeMillis();
        System.out.println("\u5904\u7406\u6570\u636e\u7ed3\u675f");
        System.out.println("\u5904\u7406\u6570\u636e\u65f6\u95f4\uff1a" + (endTime2 - startTime2) / 1000L + "s");
        if (ToolUtil.isNotEmpty(userResult)) {
            Object failNum = userResult.get("userFail");
            userFail = Integer.parseInt(failNum.toString());
        }
        HashMap<String, String> map = new HashMap<String, String>();
        String returnMsg = "\u5171" + orgSize + "\u6761\u7ec4\u7ec7\u6570\u636e,\u5931\u8d25" + orgFail + "\u6761\uff1b\u5171" + userSize + "\u6761\u7528\u6237\u6570\u636e,\u5931\u8d25" + userFail + "\u6761\u3002";
        map.put("msg", returnMsg);
        System.out.println(returnMsg);
        long endTime = System.currentTimeMillis();
        System.out.println("\u7edf\u4e00\u7528\u6237\u7ed3\u675f");
        System.out.println("\u7edf\u4e00\u7528\u6237\u6267\u884c\u603b\u65f6\u95f4\uff1a" + (endTime - startTime) / 1000L + "s");
        uumLog1.setEndTime(LocalDateTime.now());
        uumLog1.setStatus("3");
        uumLog1.setUserFailNum(Integer.valueOf(userFail));
        this.uumLogService.updateById((Object)uumLog1);
        this.editOrganizationManager.refreshOrgan();
        HussarCacheUtil.evict((String)"sync_info", (Object)"sync_status");
        List<String> userAccount = userList.stream().map(UumOperator::getpID).collect(Collectors.toList());
        if (HussarUtils.isNotEmpty(userAccount)) {
            this.addUserRoleInServer(userAccount);
        }
        return ApiResponse.success(map);
    }

    public Object getList(String page, String limit, Map<String, Object> map) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        if (ToolUtil.isNotEmpty((Object)page) && ToolUtil.isNotEmpty((Object)limit)) {
            Page pages = new Page((long)Integer.valueOf(page).intValue(), (long)Integer.valueOf(limit).intValue());
            List<UumLog> list = this.uumLogMapper.getList(pages, map);
            resultMap.put("count", pages.getTotal());
            resultMap.put("data", list);
            resultMap.put("code", 0);
            return resultMap;
        }
        resultMap.put("data", null);
        resultMap.put("code", "500");
        resultMap.put("msg", "\u53c2\u6570\u4e0d\u7b26");
        resultMap.put("count", null);
        return resultMap;
    }

    private String webService(String method, Map<String, Object> paramters) throws Exception {
        org.apache.axis.client.Service service = new org.apache.axis.client.Service();
        Call call = (Call)service.createCall();
        call.setUseSOAPAction(true);
        call.setTargetEndpointAddress(new URL(this.url));
        call.setOperationName(new QName("http://webService.service.zsjgl._000000.hussar.jxdinfo.com/", method));
        call.setUseSOAPAction(true);
        Object[] paraValues = new Object[paramters.size()];
        Iterator<String> iterator = paramters.keySet().iterator();
        int i = 0;
        while (iterator.hasNext()) {
            String key = iterator.next();
            paraValues[i++] = paramters.get(key);
            call.addParameter(key, XMLType.XSD_STRING, ParameterMode.IN);
        }
        call.setReturnType(XMLType.XSD_STRING);
        Object ret = call.invoke(paraValues);
        return ret.toString();
    }

    private String getData(boolean isCirclePull, List<Long> logIdList, Long docID) {
        UumWebserviceLog webserviceLog = new UumWebserviceLog();
        webserviceLog.setLogID(docID);
        webserviceLog.setCreateTime(LocalDateTime.now());
        String bizStr = "";
        try {
            HashMap<String, Object> paramters = new HashMap<String, Object>();
            paramters.put("mqID", this.sysID + "-UUM");
            bizStr = this.webService("getMq", paramters);
            if ("".equals(bizStr)) {
                webserviceLog.setXmlList(bizStr);
                webserviceLog.setAnalyzeResult("0");
                webserviceLog.setOp("\u6ca1\u6709\u5f85\u540c\u6b65\u7684\u6570\u636e\u4e86\uff01");
                this.uumWebserviceLogService.save((Object)webserviceLog);
                return "\u6682\u65e0\u5f85\u540c\u6b65\u7684\u6570\u636e\uff01";
            }
            if ("E".equals(bizStr)) {
                webserviceLog.setAnalyzeResult("0");
                webserviceLog.setOp("\u88ab\u8c03\u7528\u7684\u670d\u52a1\u62a5\u51fa\u5f02\u5e38");
                this.uumWebserviceLogService.save((Object)webserviceLog);
                return "\u540c\u6b65\u5931\u8d25\uff01\u88ab\u8c03\u7528\u7684\u670d\u52a1\u62a5\u51fa\u5f02\u5e38\uff01";
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            webserviceLog.setAnalyzeResult("0");
            webserviceLog.setOp("\u8c03\u7528\u670d\u52a1\u5931\u8d25");
            this.uumWebserviceLogService.save((Object)webserviceLog);
            return "\u540c\u6b65\u5931\u8d25\uff01\u8c03\u7528\u670d\u52a1\u5931\u8d25\uff01";
        }
        webserviceLog.setXmlList(bizStr);
        webserviceLog.setAnalyzeResult("0");
        webserviceLog.setOp("\u6210\u529f");
        this.uumWebserviceLogService.save((Object)webserviceLog);
        logIdList.add(webserviceLog.getDocID());
        Document doc = null;
        try {
            doc = DocumentHelper.parseText((String)bizStr);
        }
        catch (DocumentException e) {
            e.printStackTrace();
        }
        List listNodes = doc.selectNodes("/root/data/list");
        if (ToolUtil.isNotEmpty((Object)listNodes)) {
            for (Object listNode : listNodes) {
                List uumOrganizationDispList;
                String orgNum;
                int orgSize;
                List uumOperatorDispList;
                Attribute tmpRowNum;
                String userNum;
                int userSize;
                DefaultElement listInfo = (DefaultElement)listNode;
                Attribute tmpName = listInfo.attribute("name");
                String type = tmpName.getText();
                if ("UumOperatorDisp".equals(type) && (userSize = Integer.parseInt(userNum = (tmpRowNum = listInfo.attribute("rowNum")).getText())) > 0 && (uumOperatorDispList = listInfo.content()) != null && uumOperatorDispList.size() > 0) {
                    this.getUserDataList(uumOperatorDispList, webserviceLog.getDocID());
                }
                if (!"UumOrganizationDisp".equals(type) || (orgSize = Integer.parseInt(orgNum = (tmpRowNum = listInfo.attribute("rowNum")).getText())) <= 0 || (uumOrganizationDispList = listInfo.content()) == null || uumOrganizationDispList.size() <= 0) continue;
                this.getOrgDataList(uumOrganizationDispList, webserviceLog.getDocID());
            }
        }
        if (ToolUtil.isNotEmpty((Object)webserviceLog.getDocID())) {
            UumWebserviceLog tmp = new UumWebserviceLog();
            tmp.setDocID(webserviceLog.getDocID());
            tmp.setAnalyzeResult("1");
            tmp.setOp("\u6210\u529f");
            this.uumWebserviceLogService.updateById((Object)tmp);
        }
        try {
            Object dataNodes = doc.selectObject("/root/data");
            DefaultElement dataInfo = (DefaultElement)dataNodes;
            Attribute tmpName = dataInfo.attribute("disid");
            String disid = tmpName.getText();
            String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<info><result>S</result><disid>" + disid + "</disid><message>\u66f4\u65b0\u6210\u529f\uff01</message></info>";
            HashMap<String, Object> paramters = new HashMap<String, Object>();
            paramters.put("str", xml);
            String updateDistributeStateStr = this.webService("updateDistributeState", paramters);
            System.out.println("\u8c03\u7528web\u670d\u52a1updateDistributeState\uff1a" + updateDistributeStateStr);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (isCirclePull) {
            this.getData(isCirclePull, logIdList, docID);
        }
        return "";
    }

    private void getUserDataList(List uumOperatorDispList, Long uumID) {
        int t = 0;
        ArrayList<UumOperator> tempList = new ArrayList<UumOperator>();
        for (Object user : uumOperatorDispList) {
            DefaultElement uele;
            List ueleList;
            if (!(user instanceof DefaultElement) || (ueleList = (uele = (DefaultElement)user).content()) == null || ueleList.size() <= 0) continue;
            UumOperator operator = new UumOperator();
            operator.setUumID(uumID);
            operator.setGetOrder(Integer.valueOf(++t));
            operator.setrStatus("0");
            operator.setrMessage("\u672a\u5904\u7406");
            for (Object userContent : ueleList) {
                DefaultElement ueleNode = (DefaultElement)userContent;
                String text = "";
                if (!StringUtils.isNotEmpty((CharSequence)ueleNode.getText())) continue;
                text = ueleNode.getText();
                switch (ueleNode.getQName().getName()) {
                    case "pID": {
                        operator.setpID(text);
                        break;
                    }
                    case "operatorName": {
                        operator.setOperatorName(text);
                        break;
                    }
                    case "casicOrgCode": {
                        operator.setCasicOrgCode(text);
                        break;
                    }
                    case "syncType": {
                        operator.setSyncType(text);
                        break;
                    }
                    case "sysID": {
                        operator.setSysID(text);
                        break;
                    }
                    case "empCode": {
                        operator.setEmpCode(text);
                        break;
                    }
                    case "secretLevel": {
                        operator.setSecretLevel(text);
                        break;
                    }
                    case "birthDate": {
                        if (text.length() < 8) break;
                        Comparable<Date> time = this.textToDate(text);
                        operator.setBirthDate(time);
                        break;
                    }
                    case "gender": {
                        operator.setGender(text);
                        break;
                    }
                    case "oTel": {
                        operator.setoTel(text);
                        break;
                    }
                    case "oEmail": {
                        operator.setoEmail(text);
                        break;
                    }
                    case "workPost": {
                        operator.setWorkPost(text);
                        break;
                    }
                    case "tecPost": {
                        operator.setTecPost(text);
                        break;
                    }
                    case "orderID": {
                        operator.setOrderID(Integer.valueOf(Integer.parseInt(text)));
                        break;
                    }
                    case "dispTime": {
                        if (text.length() < 14) break;
                        Comparable<Date> time = this.textToTime(text);
                        operator.setDispTime((LocalDateTime)time);
                        break;
                    }
                    case "status": {
                        operator.setStatus(text);
                        break;
                    }
                    case "remark": {
                        operator.setRemark(text);
                        break;
                    }
                    case "refa": {
                        operator.setRefa(text);
                        break;
                    }
                    case "refb": {
                        operator.setRefb(text);
                        break;
                    }
                    case "orgName": {
                        operator.setOrgName(text);
                    }
                }
            }
            tempList.add(operator);
        }
        if (tempList.size() > 0) {
            this.uumOperatorService.saveBatch(tempList);
        }
    }

    private void getOrgDataList(List uumOrganizationDispList, Long uumID) {
        int t = 0;
        ArrayList<UumOrganization> tempList = new ArrayList<UumOrganization>();
        for (Object organ : uumOrganizationDispList) {
            DefaultElement oele;
            List oeleList;
            if (!(organ instanceof DefaultElement) || (oeleList = (oele = (DefaultElement)organ).content()) == null || oeleList.size() <= 0) continue;
            UumOrganization organization = new UumOrganization();
            organization.setUumID(uumID);
            organization.setGetOrder(Integer.valueOf(++t));
            organization.setrStatus("0");
            organization.setrMessage("\u672a\u5904\u7406");
            for (Object organContent : oeleList) {
                DefaultElement oeleNode = (DefaultElement)organContent;
                String text = "";
                if (!ToolUtil.isNotEmpty((Object)oeleNode.getText())) continue;
                text = oeleNode.getText();
                switch (oeleNode.getQName().getName()) {
                    case "casicOrgCode": {
                        organization.setCasicOrgCode(text);
                        break;
                    }
                    case "orgName": {
                        organization.setOrgName(text);
                        break;
                    }
                    case "casicPOrgCode": {
                        organization.setCasicPOrgCode(text);
                        break;
                    }
                    case "syncType": {
                        organization.setSyncType(text);
                        break;
                    }
                    case "sysID": {
                        organization.setSysID(text);
                        break;
                    }
                    case "orgLevel": {
                        organization.setOrgLevel(Integer.valueOf(Integer.parseInt(text)));
                        break;
                    }
                    case "casicOrgSecret": {
                        organization.setCasicOrgSecret(text);
                        break;
                    }
                    case "externalName": {
                        organization.setExternalName(text);
                        break;
                    }
                    case "remark": {
                        organization.setRemark(text);
                        break;
                    }
                    case "orderID": {
                        organization.setOrderID(Integer.valueOf(Integer.parseInt(text)));
                        break;
                    }
                    case "dispTime": {
                        if (text.length() < 14) break;
                        LocalDateTime time = this.textToTime(text);
                        organization.setDispTime(time);
                        break;
                    }
                    case "status": {
                        organization.setStatus(text);
                        break;
                    }
                    case "refa": {
                        organization.setRefa(text);
                        break;
                    }
                    case "refb": {
                        organization.setRefb(text);
                        break;
                    }
                    case "orgCode": {
                        organization.setOrgCode(text);
                        break;
                    }
                    case "orgCodes": {
                        organization.setOrgCodes(text);
                        break;
                    }
                    case "orgNames": {
                        organization.setOrgNames(text);
                        break;
                    }
                    case "miltCode": {
                        organization.setMiltCode(text);
                        break;
                    }
                    case "orgnationCode": {
                        organization.setOrgnationCode(text);
                        break;
                    }
                    case "creditCode": {
                        organization.setCreditCode(text);
                        break;
                    }
                    case "country": {
                        organization.setCountry(text);
                        break;
                    }
                    case "province": {
                        organization.setProvince(text);
                        break;
                    }
                    case "city": {
                        organization.setCity(text);
                        break;
                    }
                    case "areaCounty": {
                        organization.setAreaCounty(text);
                        break;
                    }
                    case "languages": {
                        organization.setLanguages(text);
                        break;
                    }
                    case "currency": {
                        organization.setCurrency(text);
                        break;
                    }
                    case "inforLevel": {
                        organization.setInforLevel(text);
                        break;
                    }
                    case "orgNature": {
                        organization.setOrgNature(text);
                        break;
                    }
                    case "immeupOrg": {
                        organization.setImmeupOrg(text);
                        break;
                    }
                    case "orgManLevel": {
                        organization.setOrgManLevel(text);
                        break;
                    }
                    case "isLtCompany": {
                        organization.setIsLtCompany(text);
                        break;
                    }
                    case "fillTwoOrg": {
                        organization.setFillTwoOrg(text);
                        break;
                    }
                    case "fillThrOrg": {
                        organization.setFillThrOrg(text);
                        break;
                    }
                    case "erpComCode": {
                        organization.setErpComCode(text);
                        break;
                    }
                    case "orderNumber": {
                        organization.setOrderNumber(text);
                        break;
                    }
                    case "induclass": {
                        organization.setInduclass(text);
                    }
                }
            }
            tempList.add(organization);
        }
        if (tempList.size() > 0) {
            this.uumOrganizationService.saveBatch(tempList);
        }
    }

    private int recursionDealUser(List<Long> logIdList, Map<String, Object> param, int dealNum) {
        int failNum = (Integer)param.get("orgFail");
        if (dealNum <= this.maxOrgLevel - 3 && failNum > 0) {
            Map<String, Object> orgResult1;
            QueryWrapper ew1 = new QueryWrapper();
            ew1.in((Object)"UUMID", logIdList);
            ew1.eq((Object)"RSTATUS", (Object)"N");
            ew1.orderByAsc((Object)"DISPTIME", (Object[])new String[]{"GETORDER"});
            List orgList = this.uumOrganizationService.list((Wrapper)ew1);
            if (orgList.size() > 0 && ToolUtil.isNotEmpty(orgResult1 = this.dealOrg(orgList))) {
                Object failNum1 = orgResult1.get("orgFail");
                failNum = Integer.parseInt(failNum1.toString());
                param.put("orgFail", failNum);
                this.recursionDealUser(logIdList, param, ++dealNum);
            }
        }
        failNum = (Integer)param.get("orgFail");
        return failNum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Object> dealUser(List<UumOperator> userList) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        int userFail = 0;
        int t = 0;
        Long publicRoleYbbRoleId = null;
        Long publicRoleCsRoleId = null;
        SysRoles publicRoleYbb = this.sysUserRolesUtilService.getRoleInfos("public_role_ybb");
        SysRoles publicRoleCs = this.sysUserRolesUtilService.getRoleInfos("public_role_cs");
        if (ToolUtil.isEmpty((Object)publicRoleYbb)) {
            HashMap<String, String> Ybbmap = new HashMap<String, String>(3);
            Ybbmap.put("roleCode", "public_role_ybb");
            Ybbmap.put("roleName", "\u516c\u7528\u89d2\u8272_\u9662\u672c\u90e8");
            Ybbmap.put("roleYw", "\u516c\u7528\u89d2\u8272_\u9662\u672c\u90e8");
            Ybbmap.put("checkNodeId", Constants.SYSTEM_ROLE_GROUP.toString());
            Ybbmap.put("seq", "5");
            Ybbmap.put("isOrganRoleAdd", "false");
            publicRoleYbbRoleId = this.iSysRolesService.addRole(Ybbmap);
        } else {
            publicRoleYbbRoleId = publicRoleYbb.getId();
        }
        if (ToolUtil.isEmpty((Object)publicRoleCs)) {
            HashMap<String, String> Csmap = new HashMap<String, String>(3);
            Csmap.put("roleCode", "public_role_cs");
            Csmap.put("roleName", "\u516c\u7528\u89d2\u8272_\u5382\u6240");
            Csmap.put("roleYw", "\u516c\u7528\u89d2\u8272_\u5382\u6240");
            Csmap.put("checkNodeId", Constants.SYSTEM_ROLE_GROUP.toString());
            Csmap.put("seq", "6");
            Csmap.put("isOrganRoleAdd", "false");
            publicRoleCsRoleId = this.iSysRolesService.addRole(Csmap);
        } else {
            publicRoleCsRoleId = publicRoleCs.getId();
        }
        for (UumOperator temp : userList) {
            System.out.println("\u5171" + userList.size() + "\u6761\u7528\u6237\u6570\u636e\uff0c\u5f53\u524d\u5904\u7406\u7b2c" + ++t + "\u6761");
            String pID = temp.getpID();
            String rStatus = "Y";
            String rMessage = "\u6210\u529f";
            try {
                SysUsers user;
                List parentStruList;
                Map stru;
                String operatorName = temp.getOperatorName();
                String casicOrgCode = temp.getCasicOrgCode();
                String syncType = temp.getSyncType();
                String sLevel = temp.getSecretLevel();
                String secretLevel = this.convertSecurityLevel(sLevel);
                Integer orderID = temp.getOrderID();
                String parentTypeCode = "";
                Long parentId = null;
                Long struId = null;
                Long organId = null;
                Long staffId = null;
                String operateType = "";
                String parentStruLevel = "";
                String struType = "";
                Long oldParentId = null;
                String parentStruType = "";
                if (ToolUtil.isEmpty((Object)pID)) {
                    ++userFail;
                    rStatus = "N";
                    rMessage = "\u8eab\u4efd\u8bc1\u53f7\u4e3a\u7a7a";
                    continue;
                }
                List struList = this.sysUsersMapper.getUserByIdCard(pID);
                List list = this.sysUsersMapper.getDeleteUserByIdCard(pID);
                if (ToolUtil.isNotEmpty((Object)struList)) {
                    stru = (Map)struList.get(0);
                    struId = Long.parseLong(stru.get("id").toString());
                    organId = Long.parseLong(stru.get("organId").toString());
                    staffId = Long.parseLong(stru.get("staffId").toString());
                    struType = stru.get("struType").toString();
                    oldParentId = Long.parseLong(stru.get("parentId").toString());
                } else if (ToolUtil.isNotEmpty((Object)list)) {
                    stru = (Map)list.get(0);
                    struId = Long.parseLong(stru.get("struId").toString());
                    organId = Long.parseLong(stru.get("organId").toString());
                    staffId = Long.parseLong(stru.get("staffId").toString());
                    struType = stru.get("struType").toString();
                    oldParentId = Long.parseLong(stru.get("parentId").toString());
                }
                if ("2".equals(syncType)) {
                    if (ToolUtil.isEmpty(struId)) {
                        ++userFail;
                        rStatus = "N";
                        rMessage = "\u5220\u9664\u4eba\u5458\u4e0d\u5b58\u5728";
                        continue;
                    }
                    operateType = "2";
                } else {
                    operateType = ToolUtil.isNotEmpty(struId) ? "1" : "0";
                }
                if (ToolUtil.isEmpty((Object)casicOrgCode)) {
                    ++userFail;
                    rStatus = "N";
                    rMessage = "\u6240\u5c5e\u96c6\u56e2\u673a\u6784\u7f16\u7801\u4e3a\u7a7a";
                    continue;
                }
                if (casicOrgCode.startsWith(this.sixthCenterCode)) {
                    casicOrgCode = this.sixthCenterCode;
                }
                if (casicOrgCode.length() > 6 && (casicOrgCode.startsWith("0059") || casicOrgCode.startsWith("0042") || casicOrgCode.startsWith("0077"))) {
                    casicOrgCode = casicOrgCode.substring(0, 6);
                }
                if (ToolUtil.isEmpty((Object)(parentStruList = this.sysStruMapper.getSyncStruByCasicOrgCode(casicOrgCode)))) {
                    if (!"2".equals(operateType)) {
                        ++userFail;
                        rStatus = "N";
                        rMessage = "\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\u6240\u5c5e\u7ec4\u7ec7";
                        continue;
                    }
                } else {
                    Map parentStru = (Map)parentStruList.get(0);
                    parentTypeCode = parentStru.get("organcode").toString();
                    parentId = Long.parseLong(parentStru.get("struId").toString());
                    parentStruLevel = parentStru.get("strulevel").toString();
                    parentStruType = parentStru.get("struType").toString();
                }
                if ("2".equals(operateType)) {
                    JSONObject jsonObject = this.staffUserService.deleteStaffUserVue(struId);
                    if (!jsonObject.getBoolean("success").booleanValue()) {
                        ++userFail;
                        rStatus = "N";
                        rMessage = jsonObject.getString("msg");
                        continue;
                    }
                    SysUsers user2 = (SysUsers)this.iSysUsersService.getOne((Wrapper)new QueryWrapper().eq((Object)"employee_id", (Object)struId), false);
                    int staffNum = this.sysUserRolesUtilService.updateStaffByIdcard(pID);
                    int userNum = this.sysUserRolesUtilService.updateUserByStruid(pID, struId);
                    this.iSysUsersService.delUserRole(user2);
                    continue;
                }
                SysStru sysStru = new SysStru();
                SysOrgan sysOrgan = new SysOrgan();
                SysStaff sysStaff = new SysStaff();
                sysStru.setParentId(parentId);
                sysOrgan.setOrganName(operatorName);
                sysOrgan.setParentTypeCode(parentTypeCode);
                sysStaff.setIdcard(pID);
                if (ToolUtil.isNotEmpty((Object)orderID)) {
                    sysStru.setStruOrder(orderID);
                }
                String userAccount = pID;
                if ("0".equals(operateType)) {
                    Long count = this.hussarBaseOrganTypeBoService.countStruRuleStaff(parentStruType);
                    if (count < 1L) {
                        ++userFail;
                        rStatus = "N";
                        rMessage = "\u8be5\u65b0\u589e\u4e0d\u7b26\u5408\u7ec4\u7ec7\u673a\u6784\u89c4\u5219";
                        continue;
                    }
                    sysStru.setStruType("9");
                    sysStru.setIsEmployee("1");
                    String filedName = "STAFF_CODE";
                    String currentCode = this.sysIdtableService.getCurrentCode(filedName, "SYS_ORGAN");
                    if (ToolUtil.isEmpty((Object)currentCode)) {
                        ++userFail;
                        rStatus = "N";
                        rMessage = "\u6ca1\u6709\u5728\u6700\u5927\u53f7\u8868\u4e2d\u7ef4\u62a4\u7f16\u7801\u89c4\u5219";
                        continue;
                    }
                    currentCode = parentTypeCode + currentCode;
                    sysOrgan.setOrganType("9");
                    sysOrgan.setOrganCode(currentCode);
                    this.staffUserService.addStaffUser(sysStru, sysOrgan, sysStaff, userAccount, secretLevel);
                } else {
                    if (ToolUtil.isEmpty((Object)struList) && ToolUtil.isNotEmpty((Object)list)) {
                        sysStru.setDelFlag("0");
                        sysOrgan.setDelFlag("0");
                        SysUsers user3 = (SysUsers)this.iSysUsersService.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"EMPLOYEE_ID", (Object)struId)).eq((Object)"ACCOUNT_STATUS", (Object)UserStatus.DELETE.getCode()), false);
                        if (ToolUtil.isNotEmpty((Object)user3)) {
                            user3.setAccountStatus(UserStatus.OK.getCode());
                            if (ToolUtil.isNotEmpty((Object)orderID)) {
                                user3.setUserOrder(orderID);
                            }
                            this.iSysUsersService.updateById((Object)user3);
                            LocalDateTime date = LocalDateTime.now();
                            SysUserRole userRole = new SysUserRole();
                            userRole.setUserId(user3.getId());
                            userRole.setGrantedRole(SysUserAndRole.PUBLIC_ROLE.getValue());
                            userRole.setAdminOption("1");
                            userRole.setCreateTime(date);
                            userRole.setLastTime(date);
                            userRole.setCreator(user3.getId());
                            userRole.setLastEditor(user3.getId());
                            String connName = this.iSysUsersService.getConnNameByOrgan(user3.getCorporationId());
                            if (ToolUtil.isNotEmpty((Object)connName)) {
                                try {
                                    DataSourceUtil.changeTempDs((String)connName);
                                    this.hussarBaseUserRoleBoService.save(userRole);
                                }
                                finally {
                                    DataSourceUtil.poll();
                                }
                                if (ToolUtil.isNotEmpty((Object)userAccount) && !"master".equals(connName)) {
                                    this.hussarBaseUserRoleBoService.save(userRole);
                                }
                            } else {
                                this.hussarBaseUserRoleBoService.save(userRole);
                            }
                        }
                    }
                    String accountStatus = null;
                    if (!parentId.equals(oldParentId)) {
                        JSONObject result = this.formerlyOrgManageService.orgTreeChangeVue(struId, parentId, struType, "", parentStruLevel, Boolean.valueOf(true));
                        if (!result.getBoolean("success").booleanValue()) {
                            ++userFail;
                            rStatus = "N";
                            rMessage = result.getString("msg");
                            continue;
                        }
                        accountStatus = "1";
                    }
                    if (!this.hussarBaseStruBoService.checkCanOperate(struId)) {
                        ++userFail;
                        rStatus = "N";
                        rMessage = "\u5b58\u5728\u672a\u5ba1\u6838\u7684\u7533\u8bf7\uff0c\u7981\u6b62\u4fee\u6539\uff01";
                        continue;
                    }
                    sysStru.setId(struId);
                    sysOrgan.setId(organId);
                    sysStaff.setId(staffId);
                    String organIds = "";
                    StringBuilder assistIds = new StringBuilder();
                    List assistOrganList = this.hussarBaseStruAssistOrganBoService.list(struId);
                    if (ToolUtil.isNotEmpty((Object)assistOrganList)) {
                        for (SysStruAssistOrgan assistOrgan : assistOrganList) {
                            assistIds.append(",").append(assistOrgan.getAssistParentId());
                        }
                        if (assistIds.toString().length() > 0) {
                            organIds = assistIds.toString().substring(1);
                        }
                    }
                    this.staffUserService.editStaffUserVue(sysStru, sysOrgan, sysStaff, organIds, userAccount, secretLevel, accountStatus);
                }
                SysUsers users = (SysUsers)this.iSysUsersService.getOne((Wrapper)new QueryWrapper().eq((Object)"employee_id", (Object)struId), false);
                if (!ToolUtil.isNotEmpty((Object)orderID) || !ToolUtil.isNotEmpty((Object)(user = (SysUsers)this.iSysUsersService.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"EMPLOYEE_ID", (Object)sysStru.getId())).ne((Object)"ACCOUNT_STATUS", (Object)UserStatus.DELETE.getCode()), false)))) continue;
                user.setUserOrder(orderID);
                this.iSysUsersService.updateById((Object)user);
            }
            catch (Exception e) {
                ++userFail;
                rStatus = "N";
                rMessage = this.exceptionDetail(e);
            }
            finally {
                UumOperator tmp = new UumOperator();
                tmp.setDocID(temp.getDocID());
                tmp.setrStatus(rStatus);
                tmp.setrMessage(rMessage);
                this.uumOperatorService.updateById((Object)tmp);
            }
        }
        resultMap.put("userFail", userFail);
        return resultMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Object> dealOrg(List<UumOrganization> orgList) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        int orgFail = 0;
        int t = 0;
        ArrayList<SyncOrgDataBo> updateList = new ArrayList<SyncOrgDataBo>();
        ArrayList<SyncOrgDataBo> addList = new ArrayList<SyncOrgDataBo>();
        for (UumOrganization temp : orgList) {
            System.out.println("\u5171" + orgList.size() + "\u6761\u7ec4\u7ec7\u6570\u636e\uff0c\u5f53\u524d\u5904\u7406\u7b2c" + ++t + "\u6761");
            String casicOrgCode = temp.getCasicOrgCode();
            String rStatus = "Y";
            String rMessage = "\u6210\u529f";
            try {
                String departCasicOrgCode;
                String orgName = temp.getOrgName();
                if (ToolUtil.isEmpty((Object)casicOrgCode)) {
                    ++orgFail;
                    rStatus = "N";
                    rMessage = "\u96c6\u56e2\u673a\u6784\u7f16\u7801\u4e3a\u7a7a";
                    continue;
                }
                if (casicOrgCode.startsWith(this.sixthCenterCode) && !this.sixthCenterCode.equals(casicOrgCode) || casicOrgCode.length() > 6 && (casicOrgCode.startsWith("0059") || casicOrgCode.startsWith("0042") || casicOrgCode.startsWith("0077")) && casicOrgCode.startsWith(departCasicOrgCode = casicOrgCode.substring(0, 6)) && !departCasicOrgCode.equals(casicOrgCode)) continue;
                String casicPOrgCode = temp.getCasicPOrgCode();
                if (ToolUtil.isEmpty((Object)casicPOrgCode)) {
                    if (this.flightCode.equals(casicOrgCode)) continue;
                    ++orgFail;
                    rStatus = "N";
                    rMessage = "\u7236\u7ea7\u96c6\u56e2\u673a\u6784\u7f16\u7801\u4e3a\u7a7a";
                    continue;
                }
                String syncType = temp.getSyncType();
                Integer orderID = temp.getOrderID();
                String orgParentCode = "";
                Long parentId = null;
                Long struId = null;
                Long organId = null;
                String operateType = "";
                Long permissionStruId = null;
                String parentStruLevel = "0";
                String struType = "";
                Long oldParentId = null;
                List parentStruList = this.sysStruMapper.getSyncStruByCasicOrgCode(casicPOrgCode);
                if (ToolUtil.isEmpty((Object)parentStruList)) {
                    if (this.flightCode.equals(casicOrgCode)) continue;
                    ++orgFail;
                    rStatus = "N";
                    rMessage = "\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\u6240\u5c5e\u7ec4\u7ec7";
                    continue;
                }
                Map parentStru = (Map)parentStruList.get(0);
                orgParentCode = parentStru.get("organcode").toString();
                parentId = Long.parseLong(parentStru.get("struId").toString());
                parentStruLevel = parentStru.get("strulevel").toString();
                List struList = this.sysStruMapper.getSyncStruByCasicOrgCode(casicOrgCode);
                if (ToolUtil.isNotEmpty((Object)struList)) {
                    Map stru = (Map)struList.get(0);
                    struId = Long.parseLong(stru.get("struId").toString());
                    organId = Long.parseLong(stru.get("organId").toString());
                    struType = stru.get("struType").toString();
                    oldParentId = Long.parseLong(stru.get("organId").toString());
                    permissionStruId = Long.parseLong(stru.get("permissionStruId").toString());
                }
                if ("2".equals(syncType)) {
                    if (ToolUtil.isEmpty(struId)) {
                        ++orgFail;
                        rStatus = "N";
                        rMessage = "\u5220\u9664\u7ec4\u7ec7\u4e0d\u5b58\u5728";
                        continue;
                    }
                    operateType = "2";
                } else {
                    operateType = ToolUtil.isNotEmpty(struId) ? "1" : "0";
                }
                if ("2".equals(operateType)) continue;
                SysStru sysStru = new SysStru();
                SysFormerlyOrgan sysOrgan = new SysFormerlyOrgan();
                SysOffice sysOffice = new SysOffice();
                sysStru.setOrganAlias(orgName);
                sysStru.setParentId(parentId);
                if (ToolUtil.isNotEmpty((Object)orderID)) {
                    sysStru.setStruOrder(orderID);
                }
                sysOrgan.setOrganName(orgName);
                sysOrgan.setShortName(orgName);
                boolean isAdd = true;
                if ("0".equals(operateType)) {
                    String businessName = "ORGAN_CODE_4";
                    String tableName = "SYS_ORGAN";
                    String currentCode = this.sysIdtableService.getCurrentCode(businessName, tableName);
                    String orgType = "2";
                    if (casicOrgCode.length() == 4 || this.hospitalCode.equals(casicOrgCode)) {
                        orgType = "1";
                    }
                    sysStru.setStruType(orgType);
                    sysStru.setIsLeaf("0");
                    sysStru.setDelFlag("0");
                    sysStru.setStruPath("");
                    sysStru.setStruLevel(Integer.valueOf(1));
                    if (ToolUtil.isEmpty((Object)sysStru.getStruOrder())) {
                        Integer orderTree = 1;
                        Integer maxOrder = this.sysStruMapper.getMaxOrderById(sysStru.getParentId());
                        if (ToolUtil.isNotEmpty((Object)maxOrder)) {
                            orderTree = maxOrder + 1;
                        }
                        sysStru.setStruOrder(orderTree);
                    }
                    sysOrgan.setOrganCode(currentCode);
                    sysOrgan.setOrganType(orgType);
                    sysOrgan.setDelFlag("0");
                    sysOrgan.setCasicOrgCode(casicOrgCode);
                } else {
                    JSONObject result;
                    if (!parentId.equals(oldParentId) && !(result = this.formerlyOrgManageService.orgTreeChangeVue(struId, parentId, struType, "", parentStruLevel, Boolean.valueOf(true))).getBoolean("success").booleanValue()) {
                        ++orgFail;
                        rStatus = "N";
                        rMessage = result.getString("msg");
                        continue;
                    }
                    isAdd = false;
                    sysStru.setId(struId);
                    sysOrgan.setId(organId);
                    sysOffice = null;
                }
                SyncOrgDataBo syncOrgDataBo = new SyncOrgDataBo();
                syncOrgDataBo.setSysOffice(sysOffice);
                syncOrgDataBo.setFormerlyOrgan(sysOrgan);
                syncOrgDataBo.setSysStru(sysStru);
                if (isAdd) {
                    addList.add(syncOrgDataBo);
                    continue;
                }
                updateList.add(syncOrgDataBo);
            }
            catch (Exception e) {
                ++orgFail;
                rStatus = "N";
                rMessage = this.exceptionDetail(e);
            }
            finally {
                UumOrganization tmp = new UumOrganization();
                tmp.setDocID(temp.getDocID());
                tmp.setrStatus(rStatus);
                tmp.setrMessage(rMessage);
                this.uumOrganizationService.updateById((Object)tmp);
            }
        }
        this.syncOrgInfoSave(addList, true);
        this.syncOrgInfoSave(updateList, false);
        resultMap.put("orgFail", orgFail);
        return resultMap;
    }

    private LocalDateTime textToTime(String text) {
        LocalDateTime date = null;
        String year = text.substring(0, 4);
        String month = text.substring(4, 6);
        String day = text.substring(6, 8);
        String hour = text.substring(8, 10);
        String moment = text.substring(10, 12);
        String second = text.substring(12);
        String time = year + "-" + month + "-" + day + " " + hour + ":" + moment + ":" + second;
        DateTimeFormatter dateFormat = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        date = LocalDateTime.parse(time, dateFormat);
        return date;
    }

    private Date textToDate(String text) {
        Date date = null;
        String year = text.substring(0, 4);
        String month = text.substring(4, 6);
        String day = text.substring(6, 8);
        String time = year + "-" + month + "-" + day;
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        try {
            date = dateFormat.parse(time);
        }
        catch (ParseException e) {
            return date;
        }
        return date;
    }

    private String exceptionDetail(Exception e) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(outputStream);
        e.printStackTrace(printStream);
        String exceptionInformation = new String(outputStream.toByteArray());
        printStream.close();
        try {
            outputStream.close();
        }
        catch (IOException t) {
            t.printStackTrace();
        }
        return exceptionInformation;
    }

    private String convertSecurityLevel(String securityLevel) {
        String result = "60";
        if (ToolUtil.isNotEmpty((Object)securityLevel)) {
            if ("50".equals(securityLevel)) {
                result = "70";
            } else if ("70".equals(securityLevel)) {
                result = "80";
            } else if ("90".equals(securityLevel)) {
                result = "90";
            }
        }
        return result;
    }

    private void syncOrgInfoSave(List<SyncOrgDataBo> syncOrgDataBoList, boolean addFlag) {
        if (HussarUtils.isEmpty(syncOrgDataBoList)) {
            return;
        }
        if (addFlag) {
            ArrayList<SysFormerlyOrgan> formerlyOrganList = new ArrayList<SysFormerlyOrgan>(syncOrgDataBoList.size());
            for (SyncOrgDataBo item : syncOrgDataBoList) {
                formerlyOrganList.add(item.getFormerlyOrgan());
            }
            this.formerlyOrganService.saveBatch(formerlyOrganList);
            ArrayList<SysOrgan> organList = new ArrayList<SysOrgan>();
            ArrayList<SysStru> struList = new ArrayList<SysStru>();
            for (SyncOrgDataBo item : syncOrgDataBoList) {
                SysStru sysStru = item.getSysStru();
                SysFormerlyOrgan sysFormerlyOrgan = item.getFormerlyOrgan();
                SysOrgan sysOrgan = new SysOrgan();
                CopyPropertieUtils.copyProperties((Object)sysOrgan, (Object)sysFormerlyOrgan);
                organList.add(sysOrgan);
                sysStru.setOrganId(sysFormerlyOrgan.getId());
                struList.add(sysStru);
            }
            this.hussarBaseStruBoService.saveStruBatch(struList);
            this.organService.saveBatch(organList);
            ArrayList<SysOffice> officeList = new ArrayList<SysOffice>();
            for (SyncOrgDataBo item : syncOrgDataBoList) {
                SysStru sysStru = item.getSysStru();
                SysOffice sysOffice = item.getSysOffice();
                sysOffice.setStruId(sysStru.getId());
                officeList.add(sysOffice);
            }
            this.hussarBaseOrgBoService.saveOfficeBatch(officeList);
        } else {
            ArrayList<SysOrgan> organList = new ArrayList<SysOrgan>();
            ArrayList<SysStru> struList = new ArrayList<SysStru>();
            ArrayList<SysOffice> officeList = new ArrayList<SysOffice>();
            ArrayList<SysFormerlyOrgan> formerlyOrganList = new ArrayList<SysFormerlyOrgan>();
            for (SyncOrgDataBo item : syncOrgDataBoList) {
                SysOrgan sysOrgan = new SysOrgan();
                SysFormerlyOrgan sysFormerlyOrgan = item.getFormerlyOrgan();
                CopyPropertieUtils.copyProperties((Object)sysOrgan, (Object)sysFormerlyOrgan);
                organList.add(sysOrgan);
                formerlyOrganList.add(sysFormerlyOrgan);
                struList.add(item.getSysStru());
                officeList.add(item.getSysOffice());
            }
            this.formerlyOrganService.updateBatchById(formerlyOrganList);
            this.organService.updateBatchById(organList);
            this.hussarBaseStruBoService.updateStruBatchById(struList);
            this.hussarBaseOrgBoService.updateOfficeBatchById(officeList);
        }
    }

    private void addUserRoleInServer(List<String> userAccounts) {
        List userLongs;
        Set userIdList;
        if (HussarUtils.isEmpty(userAccounts)) {
            return;
        }
        List<AddPublicRoleBo> addPublicRoleBoList = this.syncDataMapper.getUserServerRelation(userAccounts);
        List<ServerInfoBo> serverInfoBoList = this.syncDataMapper.getServerInfo();
        HashMap<Long, String> serverDbNameRelation = new HashMap<Long, String>();
        HashMap<Long, String> serverIdAndCodeRelation = new HashMap<Long, String>();
        LinkedMultiValueMap serverUserRelation = new LinkedMultiValueMap();
        for (ServerInfoBo item : serverInfoBoList) {
            serverDbNameRelation.put(item.getServerId(), item.getDbName());
            serverIdAndCodeRelation.put(item.getServerId(), item.getServerCode());
            if (!HussarUtils.isNotEmpty((Object)item.getStruId())) continue;
            for (AddPublicRoleBo addPublicRoleBo : addPublicRoleBoList) {
                Long struId = item.getStruId();
                if (!HussarUtils.isNotEmpty((Object)struId) || 1L != item.getStruId() && !addPublicRoleBo.getSturFid().contains(struId.toString())) continue;
                serverUserRelation.add((Object)item.getServerId(), (Object)addPublicRoleBo.getUserId());
            }
        }
        if (this.cloud.booleanValue()) {
            userIdList = serverUserRelation.keySet();
            for (Long serverId : userIdList) {
                userLongs = serverUserRelation.get((Object)serverId);
                if (!HussarUtils.isNotEmpty((Object)userLongs)) continue;
                List list = userLongs.stream().map(Object::toString).collect(Collectors.toList());
                HussarDynamicFeignClientFactory hussarDynamicFeignClientFactory = (HussarDynamicFeignClientFactory)SpringContextUtil.getBean(HussarDynamicFeignClientFactory.class);
                HussarCommonFeignServiceImpl testFeignService = (HussarCommonFeignServiceImpl)hussarDynamicFeignClientFactory.getFeignClient(HussarCommonFeignServiceImpl.class, (String)serverIdAndCodeRelation.get(serverId));
                testFeignService.saveUserRole(list);
            }
        } else {
            userIdList = serverUserRelation.keySet();
            for (Long serverId : userIdList) {
                userLongs = serverUserRelation.get((Object)serverId);
                if (!HussarUtils.isNotEmpty((Object)userLongs)) continue;
                this.sysUserRolesUtilService.addPublicRole(userLongs, (String)serverDbNameRelation.get(serverId));
            }
        }
    }
}

