/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.sync.publisher.util;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.jxdinfo.hussar.authorization.organ.model.SysOffice;
import com.jxdinfo.hussar.authorization.organ.model.SysOrgan;
import com.jxdinfo.hussar.authorization.organ.model.SysStru;
import com.jxdinfo.hussar.authorization.organ.util.OrganUtil;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.ObjectUtil;
import com.jxdinfo.hussar.sync.common.dto.SyncOutsideOrganDto;
import com.jxdinfo.hussar.sync.common.service.ISysAuditConfigService;
import com.jxdinfo.hussar.sync.common.service.ISysOfficeService;
import com.jxdinfo.hussar.sync.consumer.dao.SyncOrganMapper;
import com.jxdinfo.hussar.sync.consumer.dao.SyncStruMapper;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SyncOrganPublisherUtil {
    @Resource
    private ISysOfficeService sysOfficeService;
    @Resource
    private SyncStruMapper syncStruMapper;
    @Resource
    private SyncOrganMapper syncOrganMapper;
    @Autowired
    protected ISysAuditConfigService sysAuditConfig;
    private static final String SEPATOR = "/";

    public void verifyNotEmpty(List<SyncOutsideOrganDto> addOrganizationDto, List<SyncOutsideOrganDto> verifyFail) {
        Iterator<SyncOutsideOrganDto> iterator = addOrganizationDto.iterator();
        while (iterator.hasNext()) {
            SyncOutsideOrganDto syncOutsideOrganDto = iterator.next();
            if (HussarUtils.isEmpty((Object)syncOutsideOrganDto.getParentId())) {
                syncOutsideOrganDto.setParentId("11");
            }
            if (!StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{syncOutsideOrganDto.getId(), syncOutsideOrganDto.getOriginId(), syncOutsideOrganDto.getName(), String.valueOf(syncOutsideOrganDto.getEnabled()), String.valueOf(syncOutsideOrganDto.getIsDeleted())})) continue;
            syncOutsideOrganDto.setProcessingState(2);
            syncOutsideOrganDto.setFailReason("\u6570\u636e\u4e0d\u5b8c\u6574");
            verifyFail.add(syncOutsideOrganDto);
            iterator.remove();
        }
    }

    public void initialization(List<SyncOutsideOrganDto> verifyPass, List<SysStru> sysStrus, List<SysOrgan> sysOrgans, List<SysOffice> sysOffices, List<SyncOutsideOrganDto> resultList, List<SysStru> struList, Map<String, List<SysStru>> returnMap, List<SyncOutsideOrganDto> verifyFail, List<SysOrgan> organList, List<SyncOutsideOrganDto> allOut, Boolean isJob) {
        ArrayList<SyncOutsideOrganDto> verifyPassNew = new ArrayList<SyncOutsideOrganDto>(verifyPass);
        for (SyncOutsideOrganDto syncOutsideOrganDto : verifyPassNew) {
            String projectStatusId;
            String originId;
            SysStru sysStru = new SysStru();
            SysOffice sysOffice = new SysOffice();
            SysOrgan sysOrgan = new SysOrgan();
            if (syncOutsideOrganDto.getOperationType() == 1) {
                Long stId;
                String outId = StringUtils.trimToEmpty((String)syncOutsideOrganDto.getId());
                String outParentId = syncOutsideOrganDto.getParentId();
                String organCode = StringUtils.trimToEmpty((String)syncOutsideOrganDto.getCode());
                String organType = StringUtils.trimToEmpty((String)syncOutsideOrganDto.getCompanyCategoryCode());
                String organName = StringUtils.trimToEmpty((String)syncOutsideOrganDto.getName());
                String organAlias = StringUtils.trimToEmpty((String)syncOutsideOrganDto.getAlias());
                String organShortName = StringUtils.trimToEmpty((String)syncOutsideOrganDto.getAlias());
                String organDescription = StringUtils.trimToEmpty((String)syncOutsideOrganDto.getRemark());
                String companyId = StringUtils.trimToEmpty((String)syncOutsideOrganDto.getCompanyId());
                String path = StringUtils.trimToEmpty((String)syncOutsideOrganDto.getPath());
                String pathName = StringUtils.trimToEmpty((String)syncOutsideOrganDto.getPathName());
                int enabled = syncOutsideOrganDto.getEnabled();
                int level = syncOutsideOrganDto.getLayer();
                int isVirtual = syncOutsideOrganDto.getIsVirtual();
                originId = StringUtils.trimToEmpty((String)syncOutsideOrganDto.getOriginId());
                projectStatusId = StringUtils.trimToEmpty((String)syncOutsideOrganDto.getProjectStatusId());
                long sysOrganId = IdWorker.getId((Object)sysOrgan);
                long sysOfficeId = IdWorker.getId((Object)sysOffice);
                List<SysStru> sysStruList = returnMap.get(syncOutsideOrganDto.getId());
                long sysStruId = CollectionUtils.isEmpty(sysStruList) ? (syncOutsideOrganDto.getStruId() != null ? syncOutsideOrganDto.getStruId() : IdWorker.getId((Object)sysStru)) : sysStruList.get(0).getParentId();
                sysStru.setId(Long.valueOf(sysStruId));
                sysStru.setOrganId(Long.valueOf(sysOrganId));
                if (HussarUtils.isEmpty((Object)outParentId) || outParentId.equals("11")) {
                    sysStru.setParentId(Long.valueOf(11L));
                } else if (!ObjectUtil.equals((Object)outParentId, (Object)"11")) {
                    stId = this.getSysStru(outParentId, resultList, struList, allOut);
                    if (HussarUtils.isEmpty((Object)stId) && !this.verifyExistParentInOut(outParentId, allOut)) {
                        syncOutsideOrganDto.setProcessingState(2);
                        syncOutsideOrganDto.setFailReason("\u672a\u67e5\u8be2\u5230\u7236\u7ea7\u7ec4\u7ec7\u673a\u6784\u4fe1\u606f");
                        verifyPass.remove(syncOutsideOrganDto);
                        verifyFail.add(syncOutsideOrganDto);
                        continue;
                    }
                    if (HussarUtils.isNotEmpty((Object)stId)) {
                        sysStru.setParentId(stId);
                    }
                }
                if (!companyId.isEmpty()) {
                    stId = this.getSysStru(companyId, resultList, struList, allOut);
                    if (HussarUtils.isEmpty((Object)stId) && !this.verifyExistParentInOut(companyId, allOut)) {
                        syncOutsideOrganDto.setProcessingState(2);
                        syncOutsideOrganDto.setFailReason("\u672a\u67e5\u8be2\u5230\u6240\u5c5e\u673a\u6784\u4fe1\u606f");
                        verifyPass.remove(syncOutsideOrganDto);
                        verifyFail.add(syncOutsideOrganDto);
                        continue;
                    }
                    if (HussarUtils.isNotEmpty((Object)stId)) {
                        sysStru.setCompanyId(String.valueOf(stId));
                    }
                }
                sysStru.setStruType(organType);
                sysStru.setStruLevel(Integer.valueOf(level));
                Integer orderTree = 1;
                Integer maxOrder = this.syncStruMapper.getMaxOrderById(sysStru.getParentId());
                if (ToolUtil.isNotEmpty((Object)maxOrder)) {
                    orderTree = maxOrder + 1;
                }
                Integer struOrder = orderTree;
                sysStru.setStruOrder(struOrder);
                sysOffice.setId(Long.valueOf(sysOfficeId));
                sysOffice.setStruId(Long.valueOf(sysStruId));
                sysOffice.setOfficeAlias(organDescription);
                sysOrgan.setId(Long.valueOf(sysOrganId));
                sysOrgan.setOrganCode(organCode);
                sysOrgan.setOrganName(organName);
                sysOrgan.setShortName(HussarUtils.isBlank((CharSequence)organShortName) ? sysOrgan.getOrganName() : StringUtils.trimToEmpty((String)organShortName));
                sysOrgan.setOrganType(organType);
                sysOrgan.setDelFlag(String.valueOf(syncOutsideOrganDto.getIsDeleted()));
                sysOrgan.setBeginDate(LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd")));
                sysOrgan.setEndDate("2099-12-30");
                sysStru.setOrganAlias(HussarUtils.isBlank((CharSequence)syncOutsideOrganDto.getAlias()) ? sysOrgan.getOrganName() : organAlias);
                sysStru.setIsLeaf("0");
                sysStru.setDelFlag(String.valueOf(syncOutsideOrganDto.getIsDeleted()));
                sysStru.setOutStruId(outId);
                sysStru.setPath(path);
                sysStru.setPathName(pathName);
                sysStru.setOutEnabled(enabled);
                sysStru.setIsVirtual(isVirtual);
                sysStru.setOutOriginId(originId);
                sysStru.setOutProjectStatusId(projectStatusId);
                if (HussarUtils.isNotEmpty((Object)sysStru.getParentId())) {
                    sysStru.setLevelCode(SEPATOR + sysStru.getParentId().toString() + SEPATOR + sysStruId);
                }
                if (!isJob.booleanValue()) {
                    this.wrapAddOrgan(sysStru, sysOrgan, true);
                }
                sysStrus.add(sysStru);
                sysOrgans.add(sysOrgan);
                sysOffices.add(sysOffice);
                continue;
            }
            if (syncOutsideOrganDto.getOperationType() != 2) continue;
            if (syncOutsideOrganDto.getParentId() == null || "".equals(syncOutsideOrganDto.getParentId())) {
                syncOutsideOrganDto.setProcessingState(1);
                syncOutsideOrganDto.setFailReason(null);
            } else {
                List existList1 = struList.stream().filter(item -> syncOutsideOrganDto.getParentId().equals(item.getOutStruId())).collect(Collectors.toList());
                List existList2 = resultList.stream().filter(item -> syncOutsideOrganDto.getParentId().equals(item.getId())).collect(Collectors.toList());
                if (!existList1.isEmpty() || !existList2.isEmpty() || HussarUtils.isEmpty((Object)syncOutsideOrganDto.getParentId()) || syncOutsideOrganDto.getParentId().equals("11")) {
                    syncOutsideOrganDto.setProcessingState(1);
                    syncOutsideOrganDto.setFailReason(null);
                } else {
                    syncOutsideOrganDto.setProcessingState(2);
                    syncOutsideOrganDto.setFailReason("\u5904\u7406\u5931\u8d25\uff0c\u7236\u7ea7id\u672a\u627e\u5230\u3002");
                    verifyPass.remove(syncOutsideOrganDto);
                    verifyFail.add(syncOutsideOrganDto);
                    continue;
                }
            }
            SysOrgan sysOrganTemp = null;
            if (returnMap.containsKey(syncOutsideOrganDto.getId())) {
                syncOutsideOrganDto.setProcessingState(2);
                syncOutsideOrganDto.setFailReason("\u63a8\u9001\u7684\u6b64\u6761\u6570\u636e\uff0cstru_id\u4e3a\u7a7a\uff0csys_stru\u8868\u4e2d\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u8fdb\u884c\u4fee\u6539\u64cd\u4f5c");
                verifyPass.remove(syncOutsideOrganDto);
                verifyFail.add(syncOutsideOrganDto);
                continue;
            }
            List<SysStru> sysStrus1 = returnMap.get(syncOutsideOrganDto.getId());
            if (HussarUtils.isNotEmpty(sysStrus1)) {
                SysStru stru = sysStrus1.get(0);
                sysOrganTemp = organList.stream().filter(o -> stru.getOrganId().equals(o.getId())).findAny().orElse(null);
            }
            if (sysOrganTemp == null) {
                syncOutsideOrganDto.setProcessingState(2);
                syncOutsideOrganDto.setFailReason("\u672a\u67e5\u8be2\u5230\u8be5\u7ec4\u7ec7\u673a\u6784\u7f16\u7801");
                verifyPass.remove(syncOutsideOrganDto);
                verifyFail.add(syncOutsideOrganDto);
                continue;
            }
            BeanUtils.copyProperties(sysOrganTemp, (Object)sysOrgan);
            String delFlag = StringUtils.trimToEmpty((String)String.valueOf(syncOutsideOrganDto.getIsDeleted()));
            SysStru sysStruT = (SysStru)this.syncStruMapper.selectOne((Wrapper)new LambdaQueryWrapper().eq(SysStru::getOrganId, (Object)sysOrgan.getId()));
            Long struId = sysStruT.getId();
            SysOffice sysOfficeT = (SysOffice)this.sysOfficeService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysOffice::getStruId, (Object)struId));
            if (HussarUtils.isNotEmpty((Object)sysStruT)) {
                BeanUtils.copyProperties((Object)sysStruT, (Object)sysStru);
            }
            if (HussarUtils.isNotEmpty((Object)sysOfficeT)) {
                BeanUtils.copyProperties((Object)sysOfficeT, (Object)sysOffice);
            }
            if ("1".equals(delFlag)) {
                sysStru.setDelFlag(delFlag);
                sysOrgan.setDelFlag(delFlag);
            } else {
                Long stId;
                String organName = StringUtils.trimToEmpty((String)syncOutsideOrganDto.getName());
                String organType = StringUtils.trimToEmpty((String)syncOutsideOrganDto.getCompanyCategoryCode());
                String organAlias = StringUtils.trimToEmpty((String)(HussarUtils.isEmpty((Object)syncOutsideOrganDto.getAlias()) ? syncOutsideOrganDto.getName() : syncOutsideOrganDto.getAlias()));
                String parentId = StringUtils.trimToEmpty((String)syncOutsideOrganDto.getParentId());
                String organShortName = StringUtils.trimToEmpty((String)(HussarUtils.isEmpty((Object)syncOutsideOrganDto.getAlias()) ? syncOutsideOrganDto.getName() : syncOutsideOrganDto.getAlias()));
                String organDescription = StringUtils.trimToEmpty((String)syncOutsideOrganDto.getRemark());
                String companyId = StringUtils.trimToEmpty((String)syncOutsideOrganDto.getCompanyId());
                String path = StringUtils.trimToEmpty((String)syncOutsideOrganDto.getPath());
                String pathName = StringUtils.trimToEmpty((String)syncOutsideOrganDto.getPathName());
                originId = StringUtils.trimToEmpty((String)syncOutsideOrganDto.getOriginId());
                projectStatusId = StringUtils.trimToEmpty((String)syncOutsideOrganDto.getProjectStatusId());
                int enabled = syncOutsideOrganDto.getEnabled();
                int level = syncOutsideOrganDto.getLayer();
                int isVirtual = syncOutsideOrganDto.getIsVirtual();
                sysStru.setStruLevel(Integer.valueOf(level));
                if (StringUtils.isNotBlank((CharSequence)organAlias)) {
                    sysStru.setOrganAlias(organAlias);
                }
                if (StringUtils.isNotBlank((CharSequence)organType)) {
                    sysStru.setStruType(organType);
                }
                if (parentId.isEmpty()) {
                    sysStru.setParentId(Long.valueOf(11L));
                } else {
                    stId = this.getSysStru(parentId, resultList, struList, allOut);
                    if (HussarUtils.isEmpty((Object)stId) && !parentId.equals("11") && !this.verifyExistParentInOut(parentId, allOut)) {
                        syncOutsideOrganDto.setProcessingState(2);
                        syncOutsideOrganDto.setFailReason("\u672a\u67e5\u8be2\u5230\u7236\u7ea7\u7ec4\u7ec7\u673a\u6784\u4fe1\u606f");
                        verifyPass.remove(syncOutsideOrganDto);
                        verifyFail.add(syncOutsideOrganDto);
                        continue;
                    }
                    if (HussarUtils.isNotEmpty((Object)stId)) {
                        sysStru.setParentId(stId);
                    }
                }
                if (!companyId.isEmpty() && !this.verifyExistParentInOut(companyId, allOut)) {
                    stId = this.getSysStru(companyId, resultList, struList, allOut);
                    if (HussarUtils.isEmpty((Object)stId)) {
                        syncOutsideOrganDto.setProcessingState(2);
                        syncOutsideOrganDto.setFailReason("\u672a\u67e5\u8be2\u5230\u6240\u5c5e\u673a\u6784\u4fe1\u606f");
                        verifyPass.remove(syncOutsideOrganDto);
                        verifyFail.add(syncOutsideOrganDto);
                        continue;
                    }
                    if (HussarUtils.isNotEmpty((Object)stId)) {
                        sysStru.setCompanyId(String.valueOf(stId));
                    }
                }
                sysStru.setPath(path);
                sysStru.setPathName(pathName);
                sysStru.setOutEnabled(enabled);
                sysStru.setIsVirtual(isVirtual);
                sysStru.setOutOriginId(originId);
                sysStru.setOutProjectStatusId(projectStatusId);
                if (HussarUtils.isNotEmpty((Object)sysStru.getParentId())) {
                    sysStru.setLevelCode(SEPATOR + sysStru.getParentId().toString() + SEPATOR + syncOutsideOrganDto.getStruId());
                }
                if (StringUtils.isNotBlank((CharSequence)organName)) {
                    sysOrgan.setOrganName(organName);
                }
                if (StringUtils.isNotBlank((CharSequence)organShortName)) {
                    sysOrgan.setShortName(organShortName);
                }
                if (StringUtils.isNotBlank((CharSequence)organDescription)) {
                    sysOffice.setOfficeAlias(organDescription);
                }
                sysStru.setStruFid(sysStru.getLevelCode());
            }
            if (!isJob.booleanValue()) {
                this.wrapAddOrgan(sysStru, sysOrgan, true);
            }
            sysStrus.add(sysStru);
            sysOrgans.add(sysOrgan);
            sysOffices.add(sysOffice);
        }
    }

    public Long getSysStru(String outId, List<SyncOutsideOrganDto> resultList, List<SysStru> struList, List<SyncOutsideOrganDto> allOut) {
        List list = struList.stream().filter(item -> outId.equals(item.getOutStruId())).collect(Collectors.toList());
        List parentList = resultList.stream().filter(item -> outId.equals(item.getId())).collect(Collectors.toList());
        List parentOutList = allOut.stream().filter(item -> outId.equals(item.getId())).collect(Collectors.toList());
        if (!list.isEmpty()) {
            return ((SysStru)list.get(0)).getId();
        }
        if (!parentList.isEmpty()) {
            return ((SyncOutsideOrganDto)parentList.get(0)).getStruId();
        }
        if (!parentOutList.isEmpty()) {
            return ((SyncOutsideOrganDto)parentOutList.get(0)).getStruId();
        }
        return null;
    }

    public void wrapAddOrgan(SysStru sysStru, SysOrgan sysOrgan, boolean updateStruSeq) {
        String organFcode = SEPATOR + sysOrgan.getOrganCode();
        String organFname = SEPATOR + sysOrgan.getOrganName();
        long struIdTemp = HussarUtils.isEmpty((Object)sysStru.getId()) ? IdWorker.getId((Object)sysStru) : sysStru.getId();
        String struFid = SEPATOR + struIdTemp;
        String pSeq = "";
        String pFid = SEPATOR;
        int level = sysStru.getStruLevel();
        if (level > 1) {
            boolean needAudit;
            SysStru pSysStru = (SysStru)this.syncStruMapper.selectById(sysStru.getParentId());
            SysOrgan pSysOrgan = (SysOrgan)this.syncOrganMapper.selectById(pSysStru.getOrganId());
            organFname = pSysOrgan.getOrganFname() + organFname;
            sysOrgan.setParentTypeCode(pSysOrgan.getOrganType());
            organFcode = pSysOrgan.getOrganFcode() + organFcode;
            pSeq = pSysStru.getStruSeq();
            pFid = pSysStru.getStruFid();
            struFid = pFid + struFid;
            boolean bl = needAudit = this.sysAuditConfig.isCriticalOperationsAudit() && this.sysAuditConfig.isOrganAudit();
            if (!sysOrgan.getOrganType().equals("9") && !needAudit) {
                pSysStru.setIsLeaf("N");
            }
        }
        if (updateStruSeq) {
            if (!sysOrgan.getOrganType().equals("9")) {
                sysStru.setStruSeq(this.getStruSeq(pFid, pSeq, level));
            } else {
                sysStru.setStruSeq(pSeq);
            }
        }
        sysOrgan.setOrganFcode(OrganUtil.convert((String)organFcode));
        sysOrgan.setOrganFname(organFname);
        sysStru.setId(Long.valueOf(struIdTemp));
        sysStru.setStruFid(OrganUtil.convert((String)struFid));
        sysStru.setStruLevel(Integer.valueOf(sysStru.getStruFid().split(SEPATOR).length - 1));
    }

    protected String getStruSeq(String pFid, String pSeq, int level) {
        String maxStruSeq = this.syncStruMapper.getMaxStruSeq(pFid, level);
        String struSeq = "";
        if (HussarUtils.isBlank((CharSequence)maxStruSeq)) {
            struSeq = pSeq + "/0001";
        } else {
            String[] arr = maxStruSeq.split(SEPATOR);
            if (StringUtils.isNotBlank((CharSequence)pSeq)) {
                int len = arr.length - 1;
                if (len < level) {
                    StringBuilder stringBuilder = new StringBuilder(maxStruSeq);
                    for (int i = 0; i < level - len; ++i) {
                        stringBuilder.append("/0001");
                    }
                    struSeq = stringBuilder.toString();
                } else {
                    struSeq = maxStruSeq.substring(0, maxStruSeq.lastIndexOf(SEPATOR)) + SEPATOR + String.format("%04d", Integer.parseInt(arr[arr.length - 1]) + 1);
                }
            } else {
                struSeq = SEPATOR + String.format("%04d", Integer.parseInt(arr[arr.length - 1]) + 1);
            }
        }
        return struSeq;
    }

    public boolean verifyExistParentInOut(String outId, List<SyncOutsideOrganDto> allOut) {
        List parentOutList = allOut.stream().filter(item -> outId.equals(item.getId())).collect(Collectors.toList());
        return !parentOutList.isEmpty();
    }
}

