/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.sync.publisher.service.impl;

import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import com.jxdinfo.hussar.sync.common.dto.SyncDataDto;
import com.jxdinfo.hussar.sync.common.dto.SyncProjectInfoDto;
import com.jxdinfo.hussar.sync.common.model.SyncProjectBasicInfo;
import com.jxdinfo.hussar.sync.common.model.SyncProjectEngineeringInfo;
import com.jxdinfo.hussar.sync.common.model.SyncProjectLocationInfo;
import com.jxdinfo.hussar.sync.common.model.SyncProjectRelationshipInfo;
import com.jxdinfo.hussar.sync.common.service.ISyncProjectInfoService;
import com.jxdinfo.hussar.sync.common.service.ISyncTenantService;
import com.jxdinfo.hussar.sync.publisher.mq.SyncPublisherRabbitMQTransmitter;
import com.jxdinfo.hussar.sync.publisher.service.ISyncProjectInfoPublisherService;
import com.jxdinfo.hussar.sync.publisher.util.SyncProjectInfoUtil;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class SyncProjectInfoPublisherServiceImpl
implements ISyncProjectInfoPublisherService {
    private static final Logger LOGGER = LoggerFactory.getLogger(SyncProjectInfoPublisherServiceImpl.class);
    @Resource
    private ISyncTenantService tenantService;
    @Resource
    private SyncPublisherRabbitMQTransmitter publisherRabbitMQTransmitter;
    @Resource
    private ISyncProjectInfoService syncProjectInfoService;
    @Resource
    private SyncProjectInfoUtil syncProjectInfoUtil;
    private static final String LOG_FLAG = "\u9879\u76ee\u4fe1\u606f";

    public synchronized ApiResponse<?> saveSyncProjectInfo(List<SyncProjectInfoDto> syncProjectInfos, String tenantCode, boolean isJob) {
        LOGGER.info("{}{}", (Object)LOG_FLAG, (Object)"\u6570\u636e\u63a5\u6536\u5f00\u59cb!");
        if (HussarUtils.isEmpty(syncProjectInfos)) {
            LOGGER.error("{}{}", (Object)LOG_FLAG, (Object)"\u63a5\u6536\u6570\u636e\u4e3a\u7a7a\uff01");
            return ApiResponse.fail((String)"\u9879\u76ee\u4fe1\u606f\u63a5\u6536\u6570\u636e\u4e3a\u7a7a\uff01");
        }
        String connName = this.tenantService.getTenantByTenantCode(tenantCode);
        Object flag = HussarCacheUtil.get((String)"syncLock", (Object)connName);
        if (flag != null) {
            LOGGER.error("{}{}", (Object)LOG_FLAG, (Object)"\u540c\u6b65\u9501\u5b9a\uff01");
            return ApiResponse.fail((String)"\u9879\u76ee\u4fe1\u606f\u540c\u6b65\u9501\u5b9a\uff01");
        }
        HussarCacheUtil.put((String)"syncLock", (Object)connName, (Object)connName);
        return this.saveSyncProjectInfoReal(syncProjectInfos, connName, isJob);
    }

    public ApiResponse<?> saveSyncProjectInfo(SyncProjectInfoDto syncProjectInfo, String tenantCode, boolean isJob) {
        ArrayList<SyncProjectInfoDto> list = new ArrayList<SyncProjectInfoDto>();
        list.add(syncProjectInfo);
        return this.saveSyncProjectInfo(list, tenantCode, isJob);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @HussarDs(value="#connName")
    public ApiResponse<?> saveSyncProjectInfoReal(List<SyncProjectInfoDto> syncProjectInfos, String connName, boolean isJob) {
        if (HussarUtils.isEmpty(syncProjectInfos)) {
            return ApiResponse.fail((String)"\u9879\u76ee\u4fe1\u606f\u63a5\u6536\u6570\u636e\u4e3a\u7a7a\uff01");
        }
        try {
            for (SyncProjectInfoDto syncProjectInfo : syncProjectInfos) {
                if (!isJob) {
                    syncProjectInfo.setConnName(connName);
                }
                syncProjectInfo.setProcessingState(3);
                syncProjectInfo.setPushTime(LocalDateTime.now());
            }
            boolean bl = this.syncProjectInfoService.saveOrUpdateByTenant(syncProjectInfos);
            if (!bl) {
                SyncProjectInfoDto syncProjectInfo;
                LOGGER.error("{}{}", (Object)LOG_FLAG, (Object)"\u63a5\u6536\u6570\u636e\u5931\u8d25\uff01");
                syncProjectInfo = ApiResponse.fail((String)"\u9879\u76ee\u4fe1\u606f\u63a5\u6536\u6570\u636e\u5931\u8d25\uff01");
                return syncProjectInfo;
            }
            LOGGER.info("{}{}", (Object)LOG_FLAG, (Object)"\u539f\u59cb\u6570\u636e\u5df2\u5165\u5e93!");
            ArrayList<SyncProjectBasicInfo> basicInfos = new ArrayList<SyncProjectBasicInfo>();
            ArrayList<SyncProjectEngineeringInfo> engineeringInfos = new ArrayList<SyncProjectEngineeringInfo>();
            ArrayList<SyncProjectLocationInfo> locationInfos = new ArrayList<SyncProjectLocationInfo>();
            ArrayList<SyncProjectRelationshipInfo> relationshipInfos = new ArrayList<SyncProjectRelationshipInfo>();
            this.syncProjectInfoUtil.initialization(syncProjectInfos, basicInfos, engineeringInfos, locationInfos, relationshipInfos);
            SyncDataDto message = new SyncDataDto(connName, relationshipInfos, engineeringInfos, basicInfos, locationInfos, "project");
            this.publisherRabbitMQTransmitter.send(connName, message);
            LOGGER.info("{}{}", (Object)LOG_FLAG, (Object)"\u6570\u636e\u53d1\u9001\u6210\u529f\uff01");
            ApiResponse apiResponse = ApiResponse.success();
            return apiResponse;
        }
        catch (Exception e) {
            LOGGER.error("errorMessage:{}", (Object)e.getMessage(), (Object)e);
            ApiResponse apiResponse = ApiResponse.fail((String)("\u9879\u76ee\u4fe1\u606f\u63a5\u6536\u6570\u636e\u5931\u8d25,\u7cfb\u7edf\u5f02\u5e38\uff01" + e));
            return apiResponse;
        }
        finally {
            HussarCacheUtil.evict((String)"syncLock", (Object)connName);
        }
    }
}

