/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.sync.publisher.mq;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.base.config.baseconfig.model.SysBaseConfig;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import com.jxdinfo.hussar.sync.common.service.ISysBaseConfigService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.amqp.support.converter.Jackson2JsonMessageConverter;
import org.springframework.amqp.support.converter.MessageConverter;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Component;

@Component
public class SyncPublisherRabbitMQTransmitter {
    private static final Logger LOGGER = LoggerFactory.getLogger(SyncPublisherRabbitMQTransmitter.class);
    @Resource
    private RabbitTemplate rabbitTemplate;
    @Resource
    private ISysBaseConfigService sysBaseConfigService;

    public void send(String routingKey, Object object) {
        this.rabbitTemplate.setMessageConverter((MessageConverter)new Jackson2JsonMessageConverter());
        this.rabbitTemplate.convertSendAndReceive("topicExchange", routingKey, object);
    }

    @Cacheable(value={"base_config:"}, key="'syncConfig'")
    @HussarDs(value="master")
    public Map<String, Object> getSyncConfig(String connName) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.in(SysBaseConfig::getConfigKey, new Object[]{"is_data_sync_verify", "is_trigger_after_sync", "scheduled_tasks_frequency"});
        List baseConfigs = this.sysBaseConfigService.list((Wrapper)wrapper);
        HashMap<String, Object> map = new HashMap<String, Object>(4);
        for (SysBaseConfig baseConfig : baseConfigs) {
            map.put(baseConfig.getConfigKey(), baseConfig.getConfigValue());
        }
        return map;
    }
}

