/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.sync.consumer.service.impl;

import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import com.jxdinfo.hussar.sync.common.dto.SyncDataDto;
import com.jxdinfo.hussar.sync.common.model.SyncOrganRela;
import com.jxdinfo.hussar.sync.common.service.impl.SyncOrganRelaServiceImpl;
import com.jxdinfo.hussar.sync.common.service.impl.SysOrganRelaServiceImpl;
import com.jxdinfo.hussar.sync.consumer.service.IHussarSyncConsumerService;
import com.jxdinfo.hussar.sync.consumer.service.ISyncConsumerService;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SyncOrganRelaConsumerServiceImpl
implements IHussarSyncConsumerService {
    private static final Logger LOGGER = LoggerFactory.getLogger(SyncOrganRelaConsumerServiceImpl.class);
    @Resource
    private ISyncConsumerService syncConsumerService;
    @Resource
    private SysOrganRelaServiceImpl sysOrganRelaService;
    @Resource
    private SyncOrganRelaServiceImpl syncOrganRelaService;
    private static final String LOG_FLAG = "\u7ec4\u7ec7\u5173\u7cfb";

    public String getSyncType() {
        return "organRela";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @HussarDs(value="#connName")
    @Transactional(rollbackFor={Exception.class})
    public void synchronization(String connName, SyncDataDto syncDataDto) {
        LOGGER.info("{}{}", (Object)LOG_FLAG, (Object)"\u540c\u6b65\u5f00\u59cb\uff01");
        String errorMsg = "";
        boolean isSuccess = true;
        List syncOrganRelas = syncDataDto.getSyncOrganRelas();
        ArrayList<String> outIds = new ArrayList();
        try {
            if (HussarUtils.isEmpty((Object)syncOrganRelas)) {
                isSuccess = false;
                errorMsg = "\u7ec4\u7ec7\u5173\u7cfb\u540c\u6b65\u6570\u636e\u5f02\u5e38\uff01";
                LOGGER.error(errorMsg);
                throw new RuntimeException(errorMsg);
            }
            outIds = syncOrganRelas.stream().map(SyncOrganRela::getOutId).collect(Collectors.toList());
            LOGGER.info("{}\u540c\u6b65\u6570\u636e{}\u6761", (Object)LOG_FLAG, (Object)syncOrganRelas.size());
            boolean b = this.sysOrganRelaService.saveOrUpdateBatch(syncOrganRelas);
            if (b) {
                this.syncOrganRelaService.updateStatus(outIds, isSuccess, errorMsg);
            }
            LOGGER.info("{}{}", (Object)LOG_FLAG, (Object)"\u540c\u6b65\u6210\u529f\uff01");
        }
        catch (Exception e) {
            LOGGER.error("{}\u540c\u6b65\u5931\u8d25\uff0c\u9519\u8bef\u539f\u56e0{}", new Object[]{LOG_FLAG, e.getMessage(), e});
            errorMsg = e.getMessage();
            isSuccess = false;
        }
        finally {
            this.syncConsumerService.saveMqMessage(connName, syncDataDto.toString(), errorMsg, isSuccess);
            this.syncOrganRelaService.updateStatusToZero();
        }
    }
}

