/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.sync.consumer.service.impl;

import com.jxdinfo.hussar.authorization.organ.model.SysStru;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import com.jxdinfo.hussar.sync.common.dto.SyncDataDto;
import com.jxdinfo.hussar.sync.common.service.ISyncOrganService;
import com.jxdinfo.hussar.sync.common.service.ISysOfficeService;
import com.jxdinfo.hussar.sync.common.service.ISysOrganService;
import com.jxdinfo.hussar.sync.common.service.ISysStruService;
import com.jxdinfo.hussar.sync.consumer.service.IHussarSyncConsumerService;
import com.jxdinfo.hussar.sync.consumer.service.ISyncConsumerService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SyncOrganConsumerServiceImpl
implements IHussarSyncConsumerService {
    private static final Logger LOGGER = LoggerFactory.getLogger(SyncOrganConsumerServiceImpl.class);
    @Resource
    private ISysOrganService organService;
    @Resource
    private ISysStruService sysStruService;
    @Resource
    private ISysOfficeService sysOfficeService;
    @Resource
    private ISyncConsumerService syncConsumerService;
    @Resource
    private ISyncOrganService syncOrganService;
    private static final String LOG_FLAG = "\u7ec4\u7ec7\u673a\u6784";

    public String getSyncType() {
        return "organ";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @HussarDs(value="#connName")
    @Transactional(rollbackFor={Exception.class})
    public void synchronization(String connName, SyncDataDto syncDataDto) {
        LOGGER.info("{}{}", (Object)LOG_FLAG, (Object)"\u540c\u6b65\u5f00\u59cb\uff01");
        String errorMsg = null;
        boolean isSuccess = true;
        List organList = syncDataDto.getOrganList();
        List officeList = syncDataDto.getOfficeList();
        List struList = syncDataDto.getStruList();
        List<Object> outIds = new ArrayList();
        try {
            if (HussarUtils.hasEmpty((Object[])new Object[]{organList, officeList, struList}) || organList.size() != officeList.size() || officeList.size() != struList.size()) {
                isSuccess = false;
                errorMsg = "\u7ec4\u7ec7\u673a\u6784\u540c\u6b65\u6570\u636e\u5f02\u5e38\uff01";
                LOGGER.error(errorMsg);
                throw new RuntimeException(errorMsg);
            }
            outIds = struList.stream().map(SysStru::getOutStruId).collect(Collectors.toList());
            LOGGER.info("{}\u540c\u6b65\u6570\u636e{}\u6761", (Object)LOG_FLAG, (Object)organList.size());
            boolean b = this.organService.saveOrUpdateBatch((Collection)organList);
            boolean b1 = this.sysOfficeService.saveOrUpdateBatch((Collection)officeList);
            boolean b2 = this.sysStruService.saveOrUpdateBatch((Collection)struList);
            if (b && b1 && b2) {
                this.syncOrganService.updateStatus(outIds, isSuccess, errorMsg);
            }
            LOGGER.info("{}{}", (Object)LOG_FLAG, (Object)"\u540c\u6b65\u6210\u529f\uff01");
        }
        catch (Exception e) {
            try {
                LOGGER.error("{}\u540c\u6b65\u5931\u8d25\uff0c\u9519\u8bef\u539f\u56e0{}", new Object[]{LOG_FLAG, e.getMessage(), e});
                errorMsg = e.getMessage();
                isSuccess = false;
            }
            catch (Throwable throwable) {
                this.syncConsumerService.saveMqMessage(connName, syncDataDto.toString(), errorMsg, isSuccess);
                this.syncOrganService.updateStatusToZero();
                throw throwable;
            }
            this.syncConsumerService.saveMqMessage(connName, syncDataDto.toString(), errorMsg, isSuccess);
            this.syncOrganService.updateStatusToZero();
        }
        this.syncConsumerService.saveMqMessage(connName, syncDataDto.toString(), errorMsg, isSuccess);
        this.syncOrganService.updateStatusToZero();
    }
}

