/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.sync.publisher.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.jxdinfo.hussar.authorization.organ.model.SysOffice;
import com.jxdinfo.hussar.authorization.organ.model.SysOrgan;
import com.jxdinfo.hussar.authorization.organ.model.SysOrganType;
import com.jxdinfo.hussar.authorization.organ.model.SysStru;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.sequence.builder.SeqBuilder;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import com.jxdinfo.hussar.sync.common.dto.SyncDataDto;
import com.jxdinfo.hussar.sync.common.dto.SyncOutsideOrganDto;
import com.jxdinfo.hussar.sync.common.service.ISyncOrganService;
import com.jxdinfo.hussar.sync.common.service.ISyncTenantService;
import com.jxdinfo.hussar.sync.common.service.ISysEmployeeService;
import com.jxdinfo.hussar.sync.common.service.ISysOrganService;
import com.jxdinfo.hussar.sync.common.service.ISysOrganTypeService;
import com.jxdinfo.hussar.sync.publisher.mq.SyncPublisherRabbitMQTransmitter;
import com.jxdinfo.hussar.sync.publisher.service.ISyncOrganPublisherService;
import com.jxdinfo.hussar.sync.publisher.util.SyncOrganPublisherUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class SyncOrganPublisherServiceImpl
implements ISyncOrganPublisherService {
    private static final Logger LOGGER = LoggerFactory.getLogger(SyncOrganPublisherServiceImpl.class);
    @Resource
    private ISyncTenantService tenantService;
    @Resource
    private ISyncOrganService syncOrganService;
    @Resource
    private SyncPublisherRabbitMQTransmitter publisherRabbitMQTransmitter;
    @Resource
    private SyncOrganPublisherUtil syncOrganPublisherUtil;
    @Resource
    private ISysEmployeeService sysEmployeeService;
    @Resource
    private ISysOrganTypeService organTypeService;
    @Resource
    private ISyncOrganService sysOrganOutService;
    @Resource
    private ISysOrganService organService;
    @Resource
    private SeqBuilder seqBuilder;
    private static final String LOG_FLAG = "\u7ec4\u7ec7\u673a\u6784";

    public synchronized ApiResponse<?> saveOrgan(List<SyncOutsideOrganDto> addOrganizationDto, String tenantCode, boolean isJob) {
        LOGGER.info("{}{}", (Object)LOG_FLAG, (Object)"\u6570\u636e\u63a5\u6536\u5f00\u59cb!");
        if (HussarUtils.isEmpty(addOrganizationDto)) {
            LOGGER.error("{}{}", (Object)LOG_FLAG, (Object)"\u63a5\u6536\u6570\u636e\u4e3a\u7a7a\uff01");
            return ApiResponse.fail((String)"\u7ec4\u7ec7\u673a\u6784\u63a5\u6536\u6570\u636e\u4e3a\u7a7a\uff01");
        }
        String connName = this.tenantService.getTenantByTenantCode(tenantCode);
        String key = connName + ":" + addOrganizationDto.get(0).getId();
        Object flag = HussarCacheUtil.get((String)"syncLock", (Object)key);
        if (flag != null) {
            LOGGER.error("{}{}", (Object)LOG_FLAG, (Object)"\u540c\u6b65\u9501\u5b9a\uff01");
            return ApiResponse.fail((String)"\u7ec4\u7ec7\u673a\u6784\u540c\u6b65\u9501\u5b9a\uff01");
        }
        HussarCacheUtil.put((String)"syncLock", (Object)key, (Object)key);
        return this.saveOrganReal(addOrganizationDto, connName, isJob);
    }

    public ApiResponse<?> saveOrgan(SyncOutsideOrganDto addOrganizationDto, String tenantCode, boolean isJob) {
        ArrayList<SyncOutsideOrganDto> list = new ArrayList<SyncOutsideOrganDto>();
        list.add(addOrganizationDto);
        return this.saveOrgan(list, tenantCode, isJob);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @HussarDs(value="#connName")
    public ApiResponse<?> saveOrganReal(List<SyncOutsideOrganDto> addOrganizationDto, String connName, boolean isJob) {
        try {
            for (SyncOutsideOrganDto syncOutsideOrganDto : addOrganizationDto) {
                if (!isJob) {
                    syncOutsideOrganDto.setConnName(connName);
                }
                syncOutsideOrganDto.setProcessingState(3);
            }
            boolean bl = this.syncOrganService.saveOrUpdateByTenant(addOrganizationDto);
            if (!bl) {
                SyncOutsideOrganDto syncOutsideOrganDto;
                LOGGER.error("{}{}", (Object)LOG_FLAG, (Object)"\u63a5\u6536\u6570\u636e\u5931\u8d25\uff01");
                syncOutsideOrganDto = ApiResponse.fail((String)"\u7ec4\u7ec7\u673a\u6784\u63a5\u6536\u6570\u636e\u5931\u8d25\uff01");
                return syncOutsideOrganDto;
            }
            LOGGER.info("{}{}", (Object)LOG_FLAG, (Object)"\u539f\u59cb\u6570\u636e\u5df2\u5165\u5e93!");
            ArrayList<SyncOutsideOrganDto> addList = new ArrayList<SyncOutsideOrganDto>();
            ArrayList<SyncOutsideOrganDto> verifyFail = new ArrayList<SyncOutsideOrganDto>();
            List<Object> verifyPass = new ArrayList();
            List<SyncOutsideOrganDto> allOut = addOrganizationDto;
            ArrayList<String> outIds = new ArrayList<String>();
            List<Object> parentAndCompanyId = new ArrayList<String>();
            Function<Object, String> f = Object::toString;
            String isVerify = String.valueOf(this.publisherRabbitMQTransmitter.getSyncConfig(connName).get("is_data_sync_verify"));
            if (isJob || "0".equals(isVerify)) {
                if (!addOrganizationDto.isEmpty()) {
                    this.syncOrganPublisherUtil.verifyNotEmpty(addOrganizationDto, verifyFail);
                    ArrayList ids = new ArrayList();
                    ArrayList arrayList = new ArrayList();
                    ArrayList types = new ArrayList();
                    addOrganizationDto.forEach(a -> {
                        ids.add(a.getParentId());
                        parentIds.add(a.getParentId());
                        ids.add(a.getId());
                        types.add(a.getCompanyCategoryCode());
                    });
                    List outStruIds = new ArrayList();
                    if (HussarUtils.isNotEmpty((Object)ids)) {
                        outStruIds = this.sysEmployeeService.listObjs((Wrapper)new LambdaQueryWrapper().select(new SFunction[]{SysStru::getOutStruId}).in(SysStru::getOutStruId, (Collection)ids), f);
                    }
                    Object organTypes = new ArrayList();
                    if (HussarUtils.isNotEmpty(types)) {
                        organTypes = this.organTypeService.listObjs((Wrapper)new LambdaQueryWrapper().select(new SFunction[]{SysOrganType::getOrganType}).in(SysOrganType::getOrganType, types), f);
                    }
                    List allOutIds = this.sysOrganOutService.getParentOutId(arrayList, connName);
                    for (SyncOutsideOrganDto syncOutsideOrganDto : addOrganizationDto) {
                        if (!(outStruIds.contains(syncOutsideOrganDto.getParentId()) || syncOutsideOrganDto.getParentId().equals("11") || allOutIds.contains(syncOutsideOrganDto.getParentId()))) {
                            syncOutsideOrganDto.setProcessingState(2);
                            syncOutsideOrganDto.setFailReason("\u7236\u7ea7\u7ec4\u7ec7\u4e0d\u5b58\u5728");
                            verifyFail.add(syncOutsideOrganDto);
                            continue;
                        }
                        String organType = StringUtils.trimToEmpty((String)syncOutsideOrganDto.getCompanyCategoryCode());
                        if (!organTypes.contains(organType)) {
                            syncOutsideOrganDto.setProcessingState(2);
                            syncOutsideOrganDto.setFailReason("\u4e0d\u5b58\u5728\u7684\u7ec4\u7ec7\u673a\u6784\u7c7b\u578b");
                            verifyFail.add(syncOutsideOrganDto);
                            continue;
                        }
                        syncOutsideOrganDto.setProcessingState(1);
                        syncOutsideOrganDto.setFailReason(null);
                        syncOutsideOrganDto.setStruId(Long.valueOf(this.seqBuilder.build().nextValue()));
                        if (outStruIds.contains(syncOutsideOrganDto.getId())) {
                            syncOutsideOrganDto.setOperationType(Integer.valueOf(2));
                        } else {
                            syncOutsideOrganDto.setOperationType(Integer.valueOf(1));
                            addList.add(syncOutsideOrganDto);
                        }
                        outIds.add(syncOutsideOrganDto.getId());
                        parentAndCompanyId.add(syncOutsideOrganDto.getParentId());
                        parentAndCompanyId.add(syncOutsideOrganDto.getCompanyId());
                        verifyPass.add(syncOutsideOrganDto);
                    }
                }
            } else {
                verifyPass = addOrganizationDto;
                for (SyncOutsideOrganDto syncOutsideOrganDto : verifyPass) {
                    addList.add(syncOutsideOrganDto);
                    syncOutsideOrganDto.setOperationType(Integer.valueOf(1));
                    outIds.add(syncOutsideOrganDto.getId());
                    parentAndCompanyId.add(syncOutsideOrganDto.getParentId());
                    parentAndCompanyId.add(syncOutsideOrganDto.getCompanyId());
                }
            }
            ArrayList<SysStru> syncStruList = new ArrayList<SysStru>();
            ArrayList<SysOrgan> arrayList = new ArrayList<SysOrgan>();
            ArrayList<SysOffice> sysOffices = new ArrayList<SysOffice>();
            if (!verifyPass.isEmpty()) {
                ArrayList<SyncOutsideOrganDto> resultList = new ArrayList<SyncOutsideOrganDto>();
                if (!addList.isEmpty()) {
                    for (SyncOutsideOrganDto syncOutsideOrganDto : addList) {
                        Long id = this.seqBuilder.build().nextValue();
                        syncOutsideOrganDto.setStruId(id);
                        resultList.add(syncOutsideOrganDto);
                    }
                }
                parentAndCompanyId = parentAndCompanyId.stream().filter(Objects::nonNull).collect(Collectors.toList());
                ArrayList<SysStru> struList = new ArrayList();
                if (HussarUtils.isNotEmpty(parentAndCompanyId)) {
                    struList = this.sysEmployeeService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().ne(SysStru::getStruType, (Object)9)).in(SysStru::getOutStruId, parentAndCompanyId));
                }
                List sysStruList = new ArrayList();
                if (HussarUtils.isNotEmpty(outIds)) {
                    sysStruList = this.sysEmployeeService.list((Wrapper)new LambdaQueryWrapper().in(SysStru::getOutStruId, outIds));
                }
                sysStruList.removeAll(Collections.singleton(null));
                Map<String, List<SysStru>> returnMap = sysStruList.stream().collect(Collectors.groupingBy(SysStru::getOutStruId));
                List organList = this.organService.list((Wrapper)Wrappers.lambdaQuery().ne(SysOrgan::getOrganType, (Object)"9"));
                this.syncOrganPublisherUtil.initialization(verifyPass, syncStruList, arrayList, sysOffices, resultList, struList, returnMap, verifyFail, organList, allOut, isJob);
            }
            ArrayList<Object> mergedList = new ArrayList<Object>();
            verifyPass.removeIf(obj -> obj.getProcessingState() == 2);
            mergedList.addAll(verifyFail);
            mergedList.addAll(verifyPass);
            if (!mergedList.isEmpty()) {
                this.syncOrganService.saveOrUpdateByTenant(mergedList);
            }
            if (!verifyPass.isEmpty()) {
                SyncDataDto message = new SyncDataDto(connName, arrayList, sysOffices, syncStruList, "organ");
                this.publisherRabbitMQTransmitter.send(connName, message);
            }
            LOGGER.info("{}{}", (Object)LOG_FLAG, (Object)"\u6570\u636e\u53d1\u9001\u6210\u529f\uff01");
            ApiResponse apiResponse = ApiResponse.success();
            return apiResponse;
        }
        catch (Exception e) {
            LOGGER.error("errorMessage:{}", (Object)e.getMessage(), (Object)e);
            ApiResponse apiResponse = ApiResponse.fail((String)("\u7ec4\u7ec7\u673a\u6784\u63a5\u6536\u6570\u636e\u5931\u8d25,\u7cfb\u7edf\u5f02\u5e38\uff01" + e));
            return apiResponse;
        }
        finally {
            HussarCacheUtil.evict((String)"syncLock", (Object)(connName + ":" + addOrganizationDto.get(0).getId()));
        }
    }
}

