/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.sync.common.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.sync.common.dto.SyncOutsideUserDto;
import com.jxdinfo.hussar.sync.common.service.ISyncUserService;
import com.jxdinfo.hussar.sync.consumer.dao.SyncUserOutMapper;
import java.util.List;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@HussarDs(value="master")
@Transactional(rollbackFor={Exception.class})
public class SyncUserServiceImpl
extends HussarServiceImpl<SyncUserOutMapper, SyncOutsideUserDto>
implements ISyncUserService {
    public void saveOrUpdateByTenant(List<SyncOutsideUserDto> post) {
        this.saveOrUpdateBatch(post);
    }

    public void updateStatusToZero() {
        ((SyncUserOutMapper)this.baseMapper).updateUserStatusToZero();
    }

    public void updateStatus(List<String> outIds, boolean isSuccess, String message) {
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.in(SyncOutsideUserDto::getId, outIds);
        if (isSuccess) {
            updateWrapper.set(SyncOutsideUserDto::getProcessingState, (Object)1);
            updateWrapper.set(SyncOutsideUserDto::getFailReason, null);
        } else {
            updateWrapper.set(SyncOutsideUserDto::getProcessingState, (Object)2);
            updateWrapper.set(SyncOutsideUserDto::getFailReason, (Object)message);
        }
        this.update((Wrapper)updateWrapper);
    }
}

