/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.sync.publisher.util;

import com.jxdinfo.hussar.authorization.post.model.SysPost;
import com.jxdinfo.hussar.platform.core.sequence.builder.SeqBuilder;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.sync.common.dto.SyncOutsidePostDto;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class SyncPostPublisherUtil {
    @Resource
    private SeqBuilder seqBuilder;

    public void verifyNotEmpty(List<SyncOutsidePostDto> post, List<SyncOutsidePostDto> verifyFail) {
        Iterator<SyncOutsidePostDto> iterator = post.iterator();
        while (iterator.hasNext()) {
            SyncOutsidePostDto syncOutsidePostDto = iterator.next();
            if (HussarUtils.isEmpty((Object)syncOutsidePostDto.getParentId())) {
                syncOutsidePostDto.setParentId("-1");
            }
            if (!StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{syncOutsidePostDto.getId(), syncOutsidePostDto.getOriginId(), syncOutsidePostDto.getCode(), syncOutsidePostDto.getParentId(), syncOutsidePostDto.getPositionTypeCode(), String.valueOf(syncOutsidePostDto.getEnabled()), String.valueOf(syncOutsidePostDto.getMainPost()), String.valueOf(syncOutsidePostDto.getIsDeleted())})) continue;
            syncOutsidePostDto.setProcessingState(2);
            syncOutsidePostDto.setFailReason("\u6570\u636e\u4e0d\u5b8c\u6574");
            verifyFail.add(syncOutsidePostDto);
            iterator.remove();
        }
    }

    public List<SysPost> transformationPost(List<SysPost> sysPostList, List<SyncOutsidePostDto> verifyPass, List<String> organTypes, List<SyncOutsidePostDto> verifyFail, List<SysPost> po) {
        ArrayList<SysPost> posts = new ArrayList<SysPost>();
        Iterator<SyncOutsidePostDto> iterator = verifyPass.iterator();
        while (iterator.hasNext()) {
            SyncOutsidePostDto syncOutsidePostDto = iterator.next();
            SysPost sysPost = new SysPost();
            List exist = po.stream().filter(a -> syncOutsidePostDto.getId().equals(a.getOutPostId())).collect(Collectors.toList());
            if (!exist.isEmpty()) {
                sysPost = (SysPost)exist.get(0);
            } else {
                sysPost.setPostId(syncOutsidePostDto.getPostId());
            }
            sysPost.setDelFlag(syncOutsidePostDto.getIsDeleted());
            sysPost.setOutPostId(syncOutsidePostDto.getId());
            sysPost.setPostName(syncOutsidePostDto.getName());
            sysPost.setPostNo(syncOutsidePostDto.getCode());
            sysPost.setPostStatus(String.valueOf(syncOutsidePostDto.getEnabled() == 1 ? 1 : 0));
            sysPost.setOutSortNumber(syncOutsidePostDto.getSortNumber());
            sysPost.setOutOriginId(syncOutsidePostDto.getOriginId());
            if (HussarUtils.isNotEmpty((Object)syncOutsidePostDto.getPositionTypeCode())) {
                if (!organTypes.contains(syncOutsidePostDto.getPositionTypeCode())) {
                    syncOutsidePostDto.setProcessingState(2);
                    syncOutsidePostDto.setFailReason("\u4e0d\u5b58\u5728\u7684\u5c97\u4f4d\u7c7b\u578b\u3002");
                    iterator.remove();
                    verifyFail.add(syncOutsidePostDto);
                    continue;
                }
            } else {
                syncOutsidePostDto.setProcessingState(2);
                syncOutsidePostDto.setFailReason("\u5c97\u4f4d\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\u3002");
                iterator.remove();
                verifyFail.add(syncOutsidePostDto);
                continue;
            }
            sysPost.setPostType(syncOutsidePostDto.getPositionTypeCode());
            if (Objects.equals(syncOutsidePostDto.getParentId(), "-1") || syncOutsidePostDto.getParentId() == null || "".equals(syncOutsidePostDto.getParentId())) {
                sysPost.setPostParentNo("-1");
            } else {
                List list = sysPostList.stream().filter(item -> syncOutsidePostDto.getParentId().equals(item.getOutPostId())).collect(Collectors.toList());
                List outList = verifyPass.stream().filter(item -> syncOutsidePostDto.getParentId().equals(item.getId())).collect(Collectors.toList());
                if (!list.isEmpty()) {
                    sysPost.setPostParentNo(String.valueOf(((SysPost)list.get(0)).getPostId()));
                } else if (!outList.isEmpty()) {
                    sysPost.setPostParentNo(String.valueOf(((SyncOutsidePostDto)outList.get(0)).getPostId()));
                } else if (!syncOutsidePostDto.getParentId().equals("-1")) {
                    syncOutsidePostDto.setProcessingState(2);
                    syncOutsidePostDto.setFailReason("\u7236\u7ea7\u5c97\u4f4did\u672a\u627e\u5230\u3002");
                    iterator.remove();
                    verifyFail.add(syncOutsidePostDto);
                    continue;
                }
            }
            syncOutsidePostDto.setPushTime(LocalDateTime.now());
            posts.add(sysPost);
        }
        return posts;
    }
}

