/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.sync.publisher.util;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.jxdinfo.hussar.authorization.organ.model.SysStru;
import com.jxdinfo.hussar.platform.core.sequence.builder.SeqBuilder;
import com.jxdinfo.hussar.sync.common.dto.SyncOutsideOrganRelaDto;
import com.jxdinfo.hussar.sync.common.model.SyncOrganRela;
import com.jxdinfo.hussar.sync.common.service.ISysStruService;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class SyncOrganRelaPublisherUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(SyncOrganRelaPublisherUtil.class);
    @Resource
    private SeqBuilder seqBuilder;
    @Resource
    private ISysStruService sysStruService;

    public void verifyNotEmpty(List<SyncOutsideOrganRelaDto> organRelas, List<SyncOutsideOrganRelaDto> verifyFail, List<SyncOutsideOrganRelaDto> verifyPass) {
        for (SyncOutsideOrganRelaDto syncOutsideOrganRelaDto : organRelas) {
            if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{syncOutsideOrganRelaDto.getId(), syncOutsideOrganRelaDto.getOriginId(), syncOutsideOrganRelaDto.getOrgRelId(), syncOutsideOrganRelaDto.getRelType(), syncOutsideOrganRelaDto.getIsDeleted(), syncOutsideOrganRelaDto.getStatus(), syncOutsideOrganRelaDto.getTenantCode()})) {
                syncOutsideOrganRelaDto.setProcessingState(2);
                syncOutsideOrganRelaDto.setFailReason("\u6570\u636e\u4e0d\u5b8c\u6574");
                verifyFail.add(syncOutsideOrganRelaDto);
                continue;
            }
            verifyPass.add(syncOutsideOrganRelaDto);
        }
    }

    public void initialization(List<SyncOutsideOrganRelaDto> verifyPass, List<SyncOutsideOrganRelaDto> verifyFail, List<SyncOrganRela> resultList) {
        try {
            List orgIds = verifyPass.stream().map(SyncOutsideOrganRelaDto::getOrgId).collect(Collectors.toList());
            List orgRelIds = verifyPass.stream().map(SyncOutsideOrganRelaDto::getOrgRelId).collect(Collectors.toList());
            List outStruIds = new ArrayList();
            outStruIds.addAll(orgIds);
            outStruIds.addAll(orgRelIds);
            outStruIds = outStruIds.stream().distinct().collect(Collectors.toList());
            List strus = this.sysStruService.list((Wrapper)Wrappers.lambdaQuery(SysStru.class).in(SysStru::getOutStruId, outStruIds));
            Map<String, Long> idToOutStruIdMap = strus.stream().collect(Collectors.toMap(SysStru::getOutStruId, SysStru::getId));
            for (SyncOutsideOrganRelaDto syncOutsideOrganRelaDto : verifyPass) {
                SyncOrganRela syncOrganRela = new SyncOrganRela();
                BeanUtils.copyProperties((Object)syncOrganRela, (Object)syncOutsideOrganRelaDto);
                Long id = this.seqBuilder.build().nextValue();
                syncOrganRela.setId(id);
                syncOrganRela.setDelFlag(syncOutsideOrganRelaDto.getIsDeleted());
                syncOrganRela.setCreateTime(LocalDateTime.now());
                syncOrganRela.setOutId(syncOutsideOrganRelaDto.getId());
                syncOrganRela.setOutOriginId(syncOutsideOrganRelaDto.getOriginId());
                if (!idToOutStruIdMap.containsKey(syncOutsideOrganRelaDto.getOrgId())) {
                    syncOutsideOrganRelaDto.setProcessingState(2);
                    syncOutsideOrganRelaDto.setFailReason("\u9879\u76eeID\u5bf9\u5e94\u7684\u7ec4\u7ec7\u673a\u6784\u4e0d\u5b58\u5728");
                    verifyFail.add(syncOutsideOrganRelaDto);
                    continue;
                }
                syncOrganRela.setOrgId(idToOutStruIdMap.get(syncOutsideOrganRelaDto.getOrgId()));
                syncOrganRela.setOutOrgId(syncOutsideOrganRelaDto.getOrgId());
                if (!idToOutStruIdMap.containsKey(syncOutsideOrganRelaDto.getOrgRelId())) {
                    syncOutsideOrganRelaDto.setProcessingState(2);
                    syncOutsideOrganRelaDto.setFailReason("\u4e1a\u52a1\u3001\u4f9b\u5e94\u5546\u3001\u5206\u5305\u5546\u5355\u4f4dID\u5bf9\u5e94\u7684\u7ec4\u7ec7\u673a\u6784\u4e0d\u5b58\u5728");
                    verifyFail.add(syncOutsideOrganRelaDto);
                    continue;
                }
                syncOrganRela.setOrgRelId(idToOutStruIdMap.get(syncOutsideOrganRelaDto.getOrgRelId()));
                syncOutsideOrganRelaDto.setProcessingState(1);
                syncOutsideOrganRelaDto.setFailReason(null);
                syncOutsideOrganRelaDto.setPushTime(LocalDateTime.now());
                syncOrganRela.setOutOrgRelId(syncOutsideOrganRelaDto.getOrgRelId());
                resultList.add(syncOrganRela);
            }
        }
        catch (Exception e) {
            LOGGER.error("\u521d\u59cb\u5316\u7ec4\u7ec7\u5173\u7cfb\u5931\u8d25", (Throwable)e);
        }
    }
}

