/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.sync.publisher.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.jxdinfo.hussar.authorization.organ.model.SysOrgan;
import com.jxdinfo.hussar.authorization.organ.model.SysStaff;
import com.jxdinfo.hussar.authorization.organ.model.SysStru;
import com.jxdinfo.hussar.authorization.permit.model.SysUserRole;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import com.jxdinfo.hussar.sync.common.dto.SyncDataDto;
import com.jxdinfo.hussar.sync.common.dto.SyncOutsideUserDto;
import com.jxdinfo.hussar.sync.common.model.SyncUsersPositionOut;
import com.jxdinfo.hussar.sync.common.service.IHussarLoginConfigService;
import com.jxdinfo.hussar.sync.common.service.ISyncTenantService;
import com.jxdinfo.hussar.sync.common.service.ISyncUserService;
import com.jxdinfo.hussar.sync.common.service.ISyncUsersPositionOutService;
import com.jxdinfo.hussar.sync.common.service.ISysStruService;
import com.jxdinfo.hussar.sync.common.service.ISysUserRoleService;
import com.jxdinfo.hussar.sync.common.service.ISysUsersService;
import com.jxdinfo.hussar.sync.consumer.dao.SyncUsersMapper;
import com.jxdinfo.hussar.sync.publisher.mq.SyncPublisherRabbitMQTransmitter;
import com.jxdinfo.hussar.sync.publisher.service.ISyncUserPublisherService;
import com.jxdinfo.hussar.sync.publisher.util.SyncUserPublisherUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class SyncUserPublisherServiceImpl
implements ISyncUserPublisherService {
    private static final Logger LOGGER = LoggerFactory.getLogger(SyncUserPublisherServiceImpl.class);
    @Resource
    private ISyncTenantService tenantService;
    @Resource
    private ISyncUsersPositionOutService syncUsersPositionOutService;
    @Resource
    private SyncPublisherRabbitMQTransmitter publisherRabbitMQTransmitter;
    @Resource
    protected IHussarLoginConfigService hussarLoginConfigService;
    @Resource
    private ISysUsersService sysUsersService;
    @Resource
    private ISysStruService sysStruService;
    @Resource
    private ISyncUserService userService;
    @Resource
    private SyncUserPublisherUtil syncUserPublisherUtil;
    @Resource
    private ISysUserRoleService sysUserRoleService;
    @Resource
    private SyncUsersMapper syncUsersMapper;
    private static final String LOG_FLAG = "\u7528\u6237";

    public synchronized ApiResponse<?> saveUser(List<SyncOutsideUserDto> user, String tenantCode, boolean isJob) {
        LOGGER.info("{}{}", (Object)LOG_FLAG, (Object)"\u6570\u636e\u63a5\u6536\u5f00\u59cb!");
        if (HussarUtils.isEmpty(user)) {
            LOGGER.error("{}{}", (Object)LOG_FLAG, (Object)"\u63a5\u6536\u6570\u636e\u4e3a\u7a7a\uff01");
            return ApiResponse.fail((String)"\u7528\u6237\u63a5\u6536\u6570\u636e\u4e3a\u7a7a\uff01");
        }
        String connName = this.tenantService.getTenantByTenantCode(tenantCode);
        String key = connName + ":" + user.get(0).getId();
        Object flag = HussarCacheUtil.get((String)"syncLock", (Object)key);
        if (flag != null) {
            LOGGER.error("{}{}", (Object)LOG_FLAG, (Object)"\u540c\u6b65\u9501\u5b9a\uff01");
            return ApiResponse.fail((String)"\u7528\u6237\u540c\u6b65\u9501\u5b9a\uff01");
        }
        HussarCacheUtil.put((String)"syncLock", (Object)key, (Object)key);
        return this.saveUserReal(user, connName, isJob);
    }

    public ApiResponse<?> saveUser(SyncOutsideUserDto user, String tenantCode, boolean isJob) {
        ArrayList<SyncOutsideUserDto> list = new ArrayList<SyncOutsideUserDto>();
        list.add(user);
        return this.saveUser(list, tenantCode, isJob);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @HussarDs(value="#connName")
    public ApiResponse<?> saveUserReal(List<SyncOutsideUserDto> user, String connName, boolean isJob) {
        try {
            ArrayList<String> delIds = new ArrayList<String>();
            ArrayList addList = new ArrayList();
            for (SyncOutsideUserDto syncOutsideUserDto : user) {
                if (!isJob) {
                    syncOutsideUserDto.setConnName(connName);
                    delIds.add(syncOutsideUserDto.getId());
                    if (syncOutsideUserDto.getPositionList() != null && !syncOutsideUserDto.getPositionList().isEmpty()) {
                        for (SyncUsersPositionOut syncUsersPositionOut : syncOutsideUserDto.getPositionList()) {
                            syncUsersPositionOut.setUsersOutId(syncOutsideUserDto.getId());
                            syncUsersPositionOut.setConnName(connName);
                        }
                        addList.addAll(syncOutsideUserDto.getPositionList());
                    }
                }
                syncOutsideUserDto.setProcessingState(3);
            }
            this.userService.saveOrUpdateByTenant(user);
            if (!isJob) {
                if (HussarUtils.isNotEmpty(delIds)) {
                    this.syncUsersPositionOutService.removeByOutIds(connName, delIds);
                }
                if (HussarUtils.isNotEmpty(addList)) {
                    this.syncUsersPositionOutService.saveBatch(addList);
                }
            }
            LOGGER.info("{}{}", (Object)LOG_FLAG, (Object)"\u539f\u59cb\u6570\u636e\u5df2\u5165\u5e93!");
            ArrayList<SyncOutsideUserDto> verifyFail = new ArrayList<SyncOutsideUserDto>();
            ArrayList<SyncOutsideUserDto> verifyPass = new ArrayList<SyncOutsideUserDto>();
            ArrayList<String> outUserId = new ArrayList<String>();
            boolean convert = this.hussarLoginConfigService.getLoginUpperOpen() == false;
            String isVerify = String.valueOf(this.publisherRabbitMQTransmitter.getSyncConfig(connName).get("is_data_sync_verify"));
            if (isJob || "0".equals(isVerify)) {
                this.syncUserPublisherUtil.verifyNotEmpty(user, verifyFail);
                if (!user.isEmpty()) {
                    ArrayList<String> userIds = new ArrayList<String>();
                    List<Object> accounts = new ArrayList<String>();
                    for (SyncOutsideUserDto syncOutsideUserDto : user) {
                        userIds.add(syncOutsideUserDto.getId());
                        accounts.add(syncOutsideUserDto.getUserCode());
                    }
                    if (convert) {
                        accounts = accounts.stream().map(String::toUpperCase).collect(Collectors.toList());
                    }
                    Object sysUsers = new ArrayList();
                    if (!userIds.isEmpty() && !accounts.isEmpty()) {
                        LambdaQueryWrapper lambdaQueryWrapper = Wrappers.lambdaQuery(SysUsers.class);
                        lambdaQueryWrapper.in(SysUsers::getOutUserId, userIds);
                        ((LambdaQueryWrapper)lambdaQueryWrapper.or()).in(SysUsers::getUserAccount, accounts);
                        sysUsers = this.sysUsersService.list((Wrapper)lambdaQueryWrapper);
                    }
                    for (SyncOutsideUserDto syncOutsideUserDto : user) {
                        String account = syncOutsideUserDto.getUserCode();
                        if (convert) {
                            account = account.toUpperCase();
                            syncOutsideUserDto.setUserCode(account);
                        }
                        List outUserIds = sysUsers.stream().map(SysUsers::getOutUserId).collect(Collectors.toList());
                        List accountList = sysUsers.stream().map(SysUsers::getUserAccount).collect(Collectors.toList());
                        boolean exists = accountList.contains(account);
                        if (outUserIds.contains(syncOutsideUserDto.getId())) {
                            if (!exists) {
                                syncOutsideUserDto.setProcessingState(2);
                                syncOutsideUserDto.setFailReason("\u66f4\u65b0\u64cd\u4f5c\u65f6\uff0c\u8d26\u53f7\u4e0d\u5b58\u5728");
                                verifyFail.add(syncOutsideUserDto);
                                continue;
                            }
                            if (Collections.frequency(accountList, account) > 1 || Collections.frequency(accounts, account) > 1) {
                                syncOutsideUserDto.setProcessingState(2);
                                syncOutsideUserDto.setFailReason("\u66f4\u65b0\u64cd\u4f5c\u65f6\uff0c\u8d26\u53f7\u4e0d\u552f\u4e00");
                                verifyFail.add(syncOutsideUserDto);
                                continue;
                            }
                            syncOutsideUserDto.setOperationType(Integer.valueOf(2));
                            outUserId.add(syncOutsideUserDto.getId());
                            verifyPass.add(syncOutsideUserDto);
                            continue;
                        }
                        if (Collections.frequency(accounts, account) > 1) {
                            syncOutsideUserDto.setProcessingState(2);
                            syncOutsideUserDto.setFailReason("\u65b0\u589e\u64cd\u4f5c\u65f6\uff0c\u8d26\u53f7\u4e0d\u552f\u4e00");
                            verifyFail.add(syncOutsideUserDto);
                            continue;
                        }
                        if (exists) {
                            syncOutsideUserDto.setProcessingState(2);
                            syncOutsideUserDto.setFailReason("\u65b0\u589e\u64cd\u4f5c\u65f6\uff0c\u8d26\u53f7\u5df2\u5b58\u5728");
                            verifyFail.add(syncOutsideUserDto);
                            continue;
                        }
                        syncOutsideUserDto.setOperationType(Integer.valueOf(1));
                        outUserId.add(syncOutsideUserDto.getId());
                        verifyPass.add(syncOutsideUserDto);
                    }
                }
            } else {
                Map<String, Long> mapGroup = user.stream().collect(Collectors.groupingBy(SyncOutsideUserDto::getUserCode, Collectors.counting()));
                List repeatAccount = mapGroup.entrySet().stream().filter(entry -> (Long)entry.getValue() > 1L).map(Map.Entry::getKey).collect(Collectors.toList());
                for (SyncOutsideUserDto syncOutsideUserDto : user) {
                    if (repeatAccount.contains(syncOutsideUserDto.getUserCode())) {
                        syncOutsideUserDto.setProcessingState(2);
                        syncOutsideUserDto.setFailReason("\u65b0\u589e\u64cd\u4f5c\u65f6\uff0c\u8d26\u53f7\u4e0d\u552f\u4e00");
                        verifyFail.add(syncOutsideUserDto);
                        continue;
                    }
                    syncOutsideUserDto.setOperationType(Integer.valueOf(1));
                    verifyPass.add(syncOutsideUserDto);
                    outUserId.add(syncOutsideUserDto.getId());
                }
            }
            ArrayList<SysStru> struList = new ArrayList<SysStru>();
            ArrayList<SysStaff> sysStaffs = new ArrayList<SysStaff>();
            ArrayList<SysOrgan> sysOrgans = new ArrayList<SysOrgan>();
            ArrayList<SysUsers> sysUserses = new ArrayList<SysUsers>();
            ArrayList<SysUserRole> sysUserRoles = new ArrayList<SysUserRole>();
            ArrayList<SysUserRole> sysUserRolesDel = new ArrayList<SysUserRole>();
            if (!verifyPass.isEmpty()) {
                List strus = this.sysStruService.list((Wrapper)Wrappers.lambdaQuery(SysStru.class).in(SysStru::getOutStruId, outUserId));
                this.syncUserPublisherUtil.initialization(verifyPass, struList, sysOrgans, sysStaffs, sysUserses, convert, strus, isJob, connName, verifyFail, sysUserRoles, sysUserRolesDel);
            }
            ArrayList<SyncOutsideUserDto> mergedList = new ArrayList<SyncOutsideUserDto>();
            verifyPass.removeIf(obj -> obj.getProcessingState() == 2);
            mergedList.addAll(verifyFail);
            mergedList.addAll(verifyPass);
            if (!mergedList.isEmpty()) {
                this.userService.saveOrUpdateByTenant(mergedList);
            }
            if (!sysUserRolesDel.isEmpty()) {
                this.syncUsersMapper.removeUserRoles(sysUserRolesDel);
            }
            if (!sysUserRoles.isEmpty()) {
                this.sysUserRoleService.saveBatch(sysUserRoles);
            }
            if (!verifyPass.isEmpty()) {
                SyncDataDto message = new SyncDataDto(sysOrgans, sysUserses, sysStaffs, struList, "user", connName);
                message.setOutsideUserDtoList(verifyPass);
                this.publisherRabbitMQTransmitter.send(connName, message);
            }
            LOGGER.info("{}{}", (Object)LOG_FLAG, (Object)"\u6570\u636e\u53d1\u9001\u6210\u529f\uff01");
            ApiResponse apiResponse = ApiResponse.success();
            return apiResponse;
        }
        catch (Exception e) {
            LOGGER.error("errorMessage:{}", (Object)e.getMessage(), (Object)e);
            ApiResponse apiResponse = ApiResponse.fail((String)("\u7528\u6237\u63a5\u6536\u6570\u636e\u5931\u8d25,\u7cfb\u7edf\u5f02\u5e38\uff01" + e));
            return apiResponse;
        }
        finally {
            HussarCacheUtil.evict((String)"syncLock", (Object)(connName + ":" + user.get(0).getId()));
            this.userService.updateStatusToZero();
        }
    }
}

