/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.sync.publisher.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import com.jxdinfo.hussar.sync.common.dto.SyncOutsideOrganDto;
import com.jxdinfo.hussar.sync.common.dto.SyncOutsideOrganRelaDto;
import com.jxdinfo.hussar.sync.common.dto.SyncOutsidePostDto;
import com.jxdinfo.hussar.sync.common.dto.SyncOutsideUserDto;
import com.jxdinfo.hussar.sync.common.dto.SyncProjectInfoDto;
import com.jxdinfo.hussar.sync.common.service.ISyncOrganRelaService;
import com.jxdinfo.hussar.sync.common.service.ISyncOrganService;
import com.jxdinfo.hussar.sync.common.service.ISyncPostService;
import com.jxdinfo.hussar.sync.common.service.ISyncProjectInfoService;
import com.jxdinfo.hussar.sync.common.service.ISyncUserService;
import com.jxdinfo.hussar.sync.publisher.service.ISyncOrganPublisherService;
import com.jxdinfo.hussar.sync.publisher.service.ISyncOrganRelaPublisherService;
import com.jxdinfo.hussar.sync.publisher.service.ISyncPostPublisherService;
import com.jxdinfo.hussar.sync.publisher.service.ISyncProjectInfoPublisherService;
import com.jxdinfo.hussar.sync.publisher.service.ISyncPublisherService;
import com.jxdinfo.hussar.sync.publisher.service.ISyncUserPublisherService;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class SyncPublisherServiceImpl
implements ISyncPublisherService {
    private static final Logger LOGGER = LoggerFactory.getLogger(SyncPublisherServiceImpl.class);
    @Resource
    private ISyncOrganPublisherService syncOrganPublisherService;
    @Resource
    private ISyncPostPublisherService syncPostPublisherService;
    @Resource
    private ISyncUserPublisherService syncUserPublisherService;
    @Resource
    private ISyncOrganRelaPublisherService syncOrganRelaPublisherService;
    @Resource
    private ISyncOrganService syncOrganService;
    @Resource
    private ISyncPostService syncPostService;
    @Resource
    private ISyncUserService syncUserService;
    @Resource
    private ISyncOrganRelaService syncOrganRelaService;
    @Resource
    private ISyncProjectInfoPublisherService syncProjectInfoPublisherService;
    @Resource
    private ISyncProjectInfoService syncProjectInfoService;

    @HussarDs(value="master")
    public synchronized void operationSync(String connName) {
        LOGGER.info("\u5f02\u5e38\u6570\u636e\u540c\u6b65\u5f00\u59cb\uff01");
        List<Integer> state = Arrays.asList(0, 2);
        LambdaQueryWrapper organWrapper = new LambdaQueryWrapper();
        organWrapper.in(SyncOutsideOrganDto::getProcessingState, state);
        organWrapper.eq(SyncOutsideOrganDto::getConnName, (Object)connName);
        List existOrgan = this.syncOrganService.list((Wrapper)organWrapper);
        LOGGER.info("\u540c\u6b65\u5f02\u5e38\u7ec4\u7ec7\u673a\u6784\u6570\u636e{}\u6761", (Object)existOrgan.size());
        if (!existOrgan.isEmpty()) {
            this.syncOrganPublisherService.saveOrganReal(existOrgan, connName, true);
        }
        LambdaQueryWrapper postWrapper = new LambdaQueryWrapper();
        postWrapper.in(SyncOutsidePostDto::getProcessingState, state);
        postWrapper.eq(SyncOutsidePostDto::getConnName, (Object)connName);
        List existPost = this.syncPostService.list((Wrapper)postWrapper);
        LOGGER.info("\u540c\u6b65\u5f02\u5e38\u5c97\u4f4d\u6570\u636e{}\u6761", (Object)existPost.size());
        if (!existPost.isEmpty()) {
            this.syncPostPublisherService.savePostReal(existPost, connName, true);
        }
        LambdaQueryWrapper userWrapper = new LambdaQueryWrapper();
        userWrapper.in(SyncOutsideUserDto::getProcessingState, state);
        userWrapper.eq(SyncOutsideUserDto::getConnName, (Object)connName);
        List existUser = this.syncUserService.list((Wrapper)userWrapper);
        LOGGER.info("\u540c\u6b65\u5f02\u5e38\u4eba\u5458\u6570\u636e{}\u6761", (Object)existUser.size());
        if (!existUser.isEmpty()) {
            this.syncUserPublisherService.saveUserReal(existUser, connName, true);
        }
        LambdaQueryWrapper organRelaWrapper = new LambdaQueryWrapper();
        organRelaWrapper.in(SyncOutsideOrganRelaDto::getProcessingState, state);
        organRelaWrapper.eq(SyncOutsideOrganRelaDto::getConnName, (Object)connName);
        List existOrganRela = this.syncOrganRelaService.list((Wrapper)organRelaWrapper);
        LOGGER.info("\u540c\u6b65\u5f02\u5e38\u7ec4\u7ec7\u5173\u7cfb\u6570\u636e{}\u6761", (Object)existOrganRela.size());
        if (!existOrganRela.isEmpty()) {
            this.syncOrganRelaPublisherService.saveOrganRelaReal(existOrganRela, connName, true);
        }
        LambdaQueryWrapper projectInfoWrapper = new LambdaQueryWrapper();
        projectInfoWrapper.in(SyncProjectInfoDto::getProcessingState, state);
        projectInfoWrapper.eq(SyncProjectInfoDto::getConnName, (Object)connName);
        List existProjectInfo = this.syncProjectInfoService.list((Wrapper)projectInfoWrapper);
        LOGGER.info("\u540c\u6b65\u5f02\u5e38\u9879\u76ee\u4fe1\u606f\u6570\u636e{}\u6761", (Object)existProjectInfo.size());
        if (!existProjectInfo.isEmpty()) {
            this.syncProjectInfoPublisherService.saveSyncProjectInfoReal(existProjectInfo, connName, true);
        }
        LOGGER.info("\u5f02\u5e38\u6570\u636e\u540c\u6b65\u6210\u529f\uff01");
    }

    @Async
    public void asyncOperationSync(String connName) {
        this.operationSync(connName);
    }
}

