/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.sync.publisher.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.jxdinfo.hussar.authorization.organ.model.SysOrganType;
import com.jxdinfo.hussar.authorization.post.model.SysPost;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.sequence.builder.SeqBuilder;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import com.jxdinfo.hussar.sync.common.dto.SyncDataDto;
import com.jxdinfo.hussar.sync.common.dto.SyncOutsidePostDto;
import com.jxdinfo.hussar.sync.common.service.ISyncPostService;
import com.jxdinfo.hussar.sync.common.service.ISyncTenantService;
import com.jxdinfo.hussar.sync.common.service.ISysOrganTypeService;
import com.jxdinfo.hussar.sync.common.service.ISysPostService;
import com.jxdinfo.hussar.sync.publisher.mq.SyncPublisherRabbitMQTransmitter;
import com.jxdinfo.hussar.sync.publisher.service.ISyncPostPublisherService;
import com.jxdinfo.hussar.sync.publisher.util.SyncPostPublisherUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class SyncPostPublisherServiceImpl
implements ISyncPostPublisherService {
    private static final Logger LOGGER = LoggerFactory.getLogger(SyncPostPublisherServiceImpl.class);
    @Resource
    private ISyncTenantService tenantService;
    @Resource
    private SyncPostPublisherUtil syncPostPublisherUtil;
    @Resource
    private SyncPublisherRabbitMQTransmitter publisherRabbitMQTransmitter;
    @Resource
    private ISysPostService sysPostService;
    @Resource
    private ISysOrganTypeService organTypeService;
    @Resource
    private ISyncPostService syncPostService;
    @Resource
    private SeqBuilder seqBuilder;
    private static final String LOG_FLAG = "\u5c97\u4f4d";

    public synchronized ApiResponse<?> savePost(List<SyncOutsidePostDto> post, String tenantCode, boolean isJob) {
        LOGGER.info("{}{}", (Object)LOG_FLAG, (Object)"\u6570\u636e\u63a5\u6536\u5f00\u59cb!");
        if (HussarUtils.isEmpty(post)) {
            LOGGER.error("{}{}", (Object)LOG_FLAG, (Object)"\u63a5\u6536\u6570\u636e\u4e3a\u7a7a\uff01");
            return ApiResponse.fail((String)"\u5c97\u4f4d\u63a5\u6536\u6570\u636e\u4e3a\u7a7a\uff01");
        }
        String connName = this.tenantService.getTenantByTenantCode(tenantCode);
        String key = connName + ":" + post.get(0).getId();
        Object flag = HussarCacheUtil.get((String)"syncLock", (Object)key);
        if (flag != null) {
            LOGGER.error("{}{}", (Object)LOG_FLAG, (Object)"\u540c\u6b65\u9501\u5b9a\uff01");
            return ApiResponse.fail((String)"\u5c97\u4f4d\u540c\u6b65\u9501\u5b9a\uff01");
        }
        HussarCacheUtil.put((String)"syncLock", (Object)key, (Object)key);
        return this.savePostReal(post, connName, isJob);
    }

    public ApiResponse<?> savePost(SyncOutsidePostDto post, String tenantCode, boolean isJob) {
        ArrayList<SyncOutsidePostDto> list = new ArrayList<SyncOutsidePostDto>();
        list.add(post);
        return this.savePost(list, tenantCode, isJob);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @HussarDs(value="#connName")
    public ApiResponse<?> savePostReal(List<SyncOutsidePostDto> post, String connName, boolean isJob) {
        try {
            for (SyncOutsidePostDto syncOutsidePostDto : post) {
                if (!isJob) {
                    syncOutsidePostDto.setConnName(connName);
                }
                syncOutsidePostDto.setProcessingState(3);
            }
            boolean bl = this.syncPostService.saveOrUpdateByTenant(post);
            if (!bl) {
                SyncOutsidePostDto syncOutsidePostDto;
                LOGGER.error("{}{}", (Object)LOG_FLAG, (Object)"\u63a5\u6536\u6570\u636e\u5931\u8d25\uff01");
                syncOutsidePostDto = ApiResponse.fail((String)"\u5c97\u4f4d\u63a5\u6536\u6570\u636e\u5931\u8d25\uff01");
                return syncOutsidePostDto;
            }
            LOGGER.info("{}{}", (Object)LOG_FLAG, (Object)"\u539f\u59cb\u6570\u636e\u5df2\u5165\u5e93!");
            ArrayList<SyncOutsidePostDto> verifyFail = new ArrayList<SyncOutsidePostDto>();
            List<Object> verifyPass = new ArrayList();
            ArrayList<SyncOutsidePostDto> addList = new ArrayList<SyncOutsidePostDto>();
            ArrayList<String> passId = new ArrayList<String>();
            ArrayList<String> passParentId = new ArrayList<String>();
            ArrayList<String> passPositionTypeCode = new ArrayList<String>();
            String isVerify = String.valueOf(this.publisherRabbitMQTransmitter.getSyncConfig(connName).get("is_data_sync_verify"));
            if (isJob || "0".equals(isVerify)) {
                this.syncPostPublisherUtil.verifyNotEmpty(post, verifyFail);
                if (!post.isEmpty()) {
                    ArrayList ids = new ArrayList();
                    ArrayList arrayList = new ArrayList();
                    post.forEach(a -> {
                        ids.add(a.getParentId());
                        ids.add(a.getId());
                        parentIds.add(a.getParentId());
                    });
                    Function<Object, String> f = Object::toString;
                    List outPostIds = this.sysPostService.listObjs((Wrapper)new LambdaQueryWrapper().in(SysPost::getOutPostId, (Collection)ids), f);
                    List parentOutId = this.syncPostService.getParentOutId(arrayList, connName);
                    for (SyncOutsidePostDto syncOutsidePostDto : post) {
                        if (!(syncOutsidePostDto.getParentId().equals("-1") || parentOutId.contains(syncOutsidePostDto.getParentId()) || outPostIds.contains(syncOutsidePostDto.getParentId()) || syncOutsidePostDto.getProcessingState() == 2)) {
                            syncOutsidePostDto.setProcessingState(2);
                            syncOutsidePostDto.setFailReason("\u7236\u5c97\u4f4d\u4e0d\u5b58\u5728");
                            verifyFail.add(syncOutsidePostDto);
                            continue;
                        }
                        if (outPostIds.contains(syncOutsidePostDto.getId())) {
                            syncOutsidePostDto.setOperationType(Integer.valueOf(2));
                        } else {
                            syncOutsidePostDto.setOperationType(Integer.valueOf(1));
                            Long id = this.seqBuilder.build().nextValue();
                            syncOutsidePostDto.setPostId(id);
                            addList.add(syncOutsidePostDto);
                        }
                        passParentId.add(syncOutsidePostDto.getParentId());
                        passId.add(syncOutsidePostDto.getId());
                        passPositionTypeCode.add(syncOutsidePostDto.getPositionTypeCode());
                        verifyPass.add(syncOutsidePostDto);
                    }
                }
            } else {
                verifyPass = post;
                for (SyncOutsidePostDto syncOutsidePostDto : verifyPass) {
                    Long id = this.seqBuilder.build().nextValue();
                    syncOutsidePostDto.setPostId(id);
                    passId.add(syncOutsidePostDto.getId());
                    passParentId.add(syncOutsidePostDto.getParentId());
                    passPositionTypeCode.add(syncOutsidePostDto.getPositionTypeCode());
                    addList.add(syncOutsidePostDto);
                }
            }
            Function<Object, String> f = Object::toString;
            ArrayList arrayList = new ArrayList();
            List<Object> sysPostList = new ArrayList<SysPost>();
            List<String> organTypes = new ArrayList<String>();
            List<Object> posts = new ArrayList();
            if (HussarUtils.isNotEmpty(passId)) {
                List list = this.sysPostService.list((Wrapper)new LambdaQueryWrapper().in(SysPost::getOutPostId, passId));
            }
            if (HussarUtils.isNotEmpty(passParentId)) {
                sysPostList = this.sysPostService.list((Wrapper)new LambdaQueryWrapper().in(SysPost::getOutPostId, passParentId));
            }
            if (HussarUtils.isNotEmpty(passPositionTypeCode)) {
                organTypes = this.organTypeService.listObjs((Wrapper)new LambdaQueryWrapper().select(new SFunction[]{SysOrganType::getOrganType}).in(SysOrganType::getOrganType, passPositionTypeCode), f);
            }
            if (!verifyPass.isEmpty()) {
                void var13_20;
                posts = this.syncPostPublisherUtil.transformationPost(sysPostList, verifyPass, organTypes, verifyFail, (List<SysPost>)var13_20);
            }
            List<Object> mergedList = new ArrayList<Object>();
            verifyPass.removeIf(obj -> obj.getProcessingState() == 2);
            mergedList.addAll(verifyFail);
            mergedList.addAll(verifyPass);
            if (!mergedList.isEmpty()) {
                mergedList = mergedList.stream().map(a -> {
                    if ("-1".equals(a.getParentId())) {
                        a.setParentId(null);
                    }
                    return a;
                }).collect(Collectors.toList());
                this.syncPostService.saveOrUpdateByTenant(mergedList);
            }
            if (!verifyPass.isEmpty()) {
                SyncDataDto message = new SyncDataDto(connName, posts, "post");
                this.publisherRabbitMQTransmitter.send(connName, message);
            }
            LOGGER.info("{}{}", (Object)LOG_FLAG, (Object)"\u6570\u636e\u53d1\u9001\u6210\u529f\uff01");
            ApiResponse apiResponse = ApiResponse.success();
            return apiResponse;
        }
        catch (Exception e) {
            LOGGER.error("errorMessage:{}", (Object)e.getMessage(), (Object)e);
            ApiResponse apiResponse = ApiResponse.fail((String)("\u5c97\u4f4d\u63a5\u6536\u6570\u636e\u5931\u8d25,\u7cfb\u7edf\u5f02\u5e38\uff01" + e));
            return apiResponse;
        }
        finally {
            HussarCacheUtil.evict((String)"syncLock", (Object)(connName + ":" + post.get(0).getId()));
            this.syncPostService.updateStatusToZero();
        }
    }
}

