/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.sync.publisher.service.impl;

import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import com.jxdinfo.hussar.sync.common.dto.SyncDataDto;
import com.jxdinfo.hussar.sync.common.dto.SyncOutsideOrganRelaDto;
import com.jxdinfo.hussar.sync.common.model.SyncOrganRela;
import com.jxdinfo.hussar.sync.common.service.ISyncTenantService;
import com.jxdinfo.hussar.sync.common.service.impl.SyncOrganRelaServiceImpl;
import com.jxdinfo.hussar.sync.publisher.mq.SyncPublisherRabbitMQTransmitter;
import com.jxdinfo.hussar.sync.publisher.service.ISyncOrganRelaPublisherService;
import com.jxdinfo.hussar.sync.publisher.util.SyncOrganRelaPublisherUtil;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class SyncOrganRelaPublisherServiceImpl
implements ISyncOrganRelaPublisherService {
    private static final Logger LOGGER = LoggerFactory.getLogger(SyncOrganRelaPublisherServiceImpl.class);
    private static final String LOG_FLAG = "\u7ec4\u7ec7\u5173\u7cfb";
    @Resource
    private ISyncTenantService tenantService;
    @Resource
    private SyncPublisherRabbitMQTransmitter publisherRabbitMQTransmitter;
    @Resource
    private SyncOrganRelaServiceImpl syncOrganRelaService;
    @Resource
    private SyncOrganRelaPublisherUtil syncOrganRelaPublisherUtil;

    public synchronized ApiResponse<?> saveOrganRela(List<SyncOutsideOrganRelaDto> organRelas, String tenantCode, boolean isJob) {
        LOGGER.info("{}{}", (Object)"\u6570\u636e\u63a5\u6536\u5f00\u59cb!", (Object)LOG_FLAG);
        if (HussarUtils.isEmpty(organRelas)) {
            LOGGER.error("{}{}", (Object)"\u63a5\u6536\u6570\u636e\u4e3a\u7a7a\uff01", (Object)LOG_FLAG);
            return ApiResponse.fail((String)"\u7ec4\u7ec7\u5173\u7cfb\u63a5\u6536\u6570\u636e\u4e3a\u7a7a\uff01");
        }
        String connName = this.tenantService.getTenantByTenantCode(tenantCode);
        String key = connName + ":" + organRelas.get(0).getId();
        Object flag = HussarCacheUtil.get((String)"syncLock", (Object)key);
        if (flag != null) {
            LOGGER.error("{}{}", (Object)"\u540c\u6b65\u9501\u5b9a\uff01", (Object)LOG_FLAG);
            return ApiResponse.fail((String)"\u7ec4\u7ec7\u5173\u7cfb\u540c\u6b65\u9501\u5b9a\uff01");
        }
        HussarCacheUtil.put((String)"syncLock", (Object)key, (Object)key);
        return this.saveOrganRelaReal(organRelas, connName, isJob);
    }

    public ApiResponse<?> saveOrganRela(SyncOutsideOrganRelaDto organRelas, String tenantCode, boolean isJob) {
        ArrayList<SyncOutsideOrganRelaDto> list = new ArrayList<SyncOutsideOrganRelaDto>();
        list.add(organRelas);
        return this.saveOrganRela(list, tenantCode, isJob);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @HussarDs(value="#connName")
    public ApiResponse<?> saveOrganRelaReal(List<SyncOutsideOrganRelaDto> organRelas, String connName, boolean isJob) {
        try {
            for (SyncOutsideOrganRelaDto syncOutsideOrganRelaDto : organRelas) {
                if (!isJob) {
                    syncOutsideOrganRelaDto.setTenantCode(connName);
                }
                syncOutsideOrganRelaDto.setProcessingState(3);
            }
            boolean bl = this.syncOrganRelaService.saveOrUpdateByTenant(organRelas);
            if (!bl) {
                SyncOutsideOrganRelaDto syncOutsideOrganRelaDto;
                LOGGER.error("{}{}", (Object)LOG_FLAG, (Object)"\u63a5\u6536\u6570\u636e\u5931\u8d25\uff01");
                syncOutsideOrganRelaDto = ApiResponse.fail((String)"\u7ec4\u7ec7\u5173\u7cfb\u63a5\u6536\u6570\u636e\u5931\u8d25\uff01");
                return syncOutsideOrganRelaDto;
            }
            LOGGER.info("{}{}", (Object)LOG_FLAG, (Object)"\u539f\u59cb\u6570\u636e\u5df2\u5165\u5e93!");
            ArrayList<SyncOutsideOrganRelaDto> verifyFail = new ArrayList<SyncOutsideOrganRelaDto>();
            List<SyncOutsideOrganRelaDto> verifyPass = new ArrayList<SyncOutsideOrganRelaDto>();
            String isVerify = String.valueOf(this.publisherRabbitMQTransmitter.getSyncConfig(connName).get("is_data_sync_verify"));
            if (isJob || "0".equals(isVerify)) {
                this.syncOrganRelaPublisherUtil.verifyNotEmpty(organRelas, verifyFail, verifyPass);
            } else {
                verifyPass = organRelas;
            }
            ArrayList<SyncOrganRela> resultList = new ArrayList<SyncOrganRela>();
            if (!verifyPass.isEmpty()) {
                this.syncOrganRelaPublisherUtil.initialization(verifyPass, verifyFail, resultList);
            }
            ArrayList<SyncOutsideOrganRelaDto> mergedList = new ArrayList<SyncOutsideOrganRelaDto>();
            verifyPass.removeIf(obj -> obj.getProcessingState() == 2);
            mergedList.addAll(verifyFail);
            mergedList.addAll(verifyPass);
            if (!mergedList.isEmpty()) {
                this.syncOrganRelaService.saveOrUpdateByTenant(mergedList);
            }
            if (!resultList.isEmpty()) {
                SyncDataDto message = new SyncDataDto(connName, "organRela", resultList);
                this.publisherRabbitMQTransmitter.send(connName, message);
            }
            LOGGER.info("{}{}", (Object)LOG_FLAG, (Object)"\u6570\u636e\u53d1\u9001\u6210\u529f\uff01");
            ApiResponse apiResponse = ApiResponse.success();
            return apiResponse;
        }
        catch (Exception e) {
            LOGGER.error("errorMessage:{}", (Object)e.getMessage(), (Object)e);
            ApiResponse apiResponse = ApiResponse.fail((String)("\u7ec4\u7ec7\u5173\u7cfb\u63a5\u6536\u6570\u636e\u5931\u8d25,\u7cfb\u7edf\u5f02\u5e38\uff01" + e));
            return apiResponse;
        }
        finally {
            HussarCacheUtil.evict((String)"syncLock", (Object)(connName + ":" + organRelas.get(0).getId()));
        }
    }
}

