/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.sync.consumer.mq;

import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.sync.common.service.ISyncTenantService;
import com.jxdinfo.hussar.sync.consumer.properties.SyncConsumerProperties;
import com.jxdinfo.hussar.sync.consumer.service.ISyncConsumerService;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.context.annotation.Bean;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;

@Component
public class SyncConsumerRabbitMQReceiver {
    private static final Logger LOGGER = LoggerFactory.getLogger(SyncConsumerRabbitMQReceiver.class);
    @Resource
    private SyncConsumerProperties syncConsumerProperties;
    @Resource
    private ISyncConsumerService consumerService;
    @Resource
    private RedisTemplate redisTemplate;
    @Resource
    private ISyncTenantService tenantService;
    private static final String DEFAULT_CONN_NAME = "master";

    @Bean
    private String[] syncQueuesNames() {
        Object o = this.redisTemplate.opsForValue().get((Object)"queueList");
        Set set = new HashSet();
        if (HussarUtils.isEmpty((Object)o)) {
            List allTenant = this.tenantService.getAllTenant();
            List queueNames = this.syncConsumerProperties.getListenerQueues();
            allTenant.add(DEFAULT_CONN_NAME);
            allTenant.addAll(queueNames);
            set = new HashSet(allTenant);
        } else {
            set = (Set)o;
        }
        return set.toArray(new String[set.size()]);
    }

    @RabbitListener(queues={"#{syncQueuesNames}"})
    public void handlePay(Message message) {
        try {
            this.consumerService.dataSynchronization(message);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }
}

