/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.sync.common.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.sync.common.dto.SyncOutsidePostDto;
import com.jxdinfo.hussar.sync.common.service.ISyncPostService;
import com.jxdinfo.hussar.sync.consumer.dao.SyncPostOutMapper;
import java.util.List;
import java.util.function.Function;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@HussarDs(value="master")
@Transactional(rollbackFor={Exception.class})
public class SyncPostServiceImpl
extends HussarServiceImpl<SyncPostOutMapper, SyncOutsidePostDto>
implements ISyncPostService {
    public boolean saveOrUpdateByTenant(List<SyncOutsidePostDto> post) {
        return this.saveOrUpdateBatch(post);
    }

    public void updateStatusToZero() {
        ((SyncPostOutMapper)this.baseMapper).updatePostStatusToZero();
    }

    public void updateStatus(List<String> outIds, boolean isSuccess, String message) {
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.in(SyncOutsidePostDto::getId, outIds);
        if (isSuccess) {
            updateWrapper.set(SyncOutsidePostDto::getProcessingState, (Object)1);
            updateWrapper.set(SyncOutsidePostDto::getFailReason, null);
        } else {
            updateWrapper.set(SyncOutsidePostDto::getProcessingState, (Object)2);
            updateWrapper.set(SyncOutsidePostDto::getFailReason, (Object)message);
        }
        this.update((Wrapper)updateWrapper);
    }

    public List<String> getParentOutId(List<String> parentId, String targetConn) {
        Function<Object, String> f = Object::toString;
        return this.listObjs((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().select(new SFunction[]{SyncOutsidePostDto::getId}).eq(SyncOutsidePostDto::getConnName, (Object)targetConn)).ne(SyncOutsidePostDto::getProcessingState, (Object)2)).in(SyncOutsidePostDto::getId, parentId), f);
    }
}

