/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.sync.publisher.config;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.jxdinfo.hussar.authorization.organ.model.SysStru;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.post.model.SysPost;
import com.jxdinfo.hussar.sync.common.dto.SyncDataDto;
import com.jxdinfo.hussar.sync.common.dto.SyncOutsideOrganDto;
import com.jxdinfo.hussar.sync.common.dto.SyncOutsideOrganRelaDto;
import com.jxdinfo.hussar.sync.common.dto.SyncOutsidePostDto;
import com.jxdinfo.hussar.sync.common.dto.SyncOutsideUserDto;
import com.jxdinfo.hussar.sync.common.dto.SyncProjectInfoDto;
import com.jxdinfo.hussar.sync.common.model.SyncOrganRela;
import com.jxdinfo.hussar.sync.common.model.SyncProjectBasicInfo;
import com.jxdinfo.hussar.sync.common.service.ISyncOrganRelaService;
import com.jxdinfo.hussar.sync.common.service.ISyncOrganService;
import com.jxdinfo.hussar.sync.common.service.ISyncPostService;
import com.jxdinfo.hussar.sync.common.service.ISyncProjectInfoService;
import com.jxdinfo.hussar.sync.common.service.ISyncUserService;
import com.jxdinfo.hussar.sync.publisher.mq.SyncPublisherRabbitMQTransmitter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Configuration;
import org.springframework.transaction.annotation.Transactional;

@Configuration
public class CommonConfig
implements ApplicationContextAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(CommonConfig.class);
    @Resource
    private SyncPublisherRabbitMQTransmitter publisherRabbitMQTransmitter;
    @Resource
    private ISyncPostService syncPostService;
    @Resource
    private ISyncOrganService syncOrganService;
    @Resource
    private ISyncUserService syncUserService;
    @Resource
    private ISyncOrganRelaService syncOrganRelaService;
    @Resource
    private ISyncProjectInfoService syncProjectInfoService;

    @Transactional
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        RabbitTemplate rabbitTemplate = (RabbitTemplate)applicationContext.getBean(RabbitTemplate.class);
        rabbitTemplate.setReturnCallback((message, replyCode, replyText, exchange, routingKey) -> {
            if (replyCode == 200) {
                LOGGER.info("\u6d88\u606f\u53d1\u9001\u6210\u529f");
                this.editOutTable(message);
            } else {
                LOGGER.error("\u6d88\u606f\u53d1\u9001\u5931\u8d25\uff0c\u5e94\u7b54\u7801{}\uff0c\u539f\u56e0{}\uff0c\u4ea4\u6362\u673a{}\uff0c\u8def\u7531\u952e{},\u6d88\u606f{}", new Object[]{replyCode, replyText, exchange, routingKey, message});
                this.publisherRabbitMQTransmitter.send(routingKey, message);
            }
        });
    }

    private void editOutTable(Message message) {
        String json = new String(message.getBody(), StandardCharsets.UTF_8);
        SyncDataDto syncDataDto = (SyncDataDto)JSONObject.parseObject((String)json, SyncDataDto.class);
        String connName = syncDataDto.getConnName();
        List<Object> outPostId = new ArrayList();
        List<Object> outStruId = new ArrayList();
        List<Object> outUserId = new ArrayList();
        List<Object> outOrganRelaId = new ArrayList();
        List<Object> outProjectInfoId = new ArrayList();
        try {
            if (!syncDataDto.getPostList().isEmpty()) {
                outPostId = syncDataDto.getPostList().stream().map(SysPost::getOutPostId).collect(Collectors.toList());
                LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
                updateWrapper.in(SyncOutsidePostDto::getId, outPostId);
                updateWrapper.eq(SyncOutsidePostDto::getConnName, (Object)connName);
                updateWrapper.set(SyncOutsidePostDto::getProcessingState, (Object)1);
                updateWrapper.set(SyncOutsidePostDto::getFailReason, null);
                this.syncPostService.update((Wrapper)updateWrapper);
            } else if (!syncDataDto.getOfficeList().isEmpty() && !syncDataDto.getStruList().isEmpty()) {
                outStruId = syncDataDto.getStruList().stream().map(SysStru::getOutStruId).collect(Collectors.toList());
                LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
                updateWrapper.in(SyncOutsideOrganDto::getId, outStruId);
                updateWrapper.eq(SyncOutsideOrganDto::getConnName, (Object)connName);
                updateWrapper.set(SyncOutsideOrganDto::getProcessingState, (Object)1);
                updateWrapper.set(SyncOutsideOrganDto::getFailReason, null);
                this.syncOrganService.update((Wrapper)updateWrapper);
            } else if (!syncDataDto.getStaffList().isEmpty() && !syncDataDto.getUsersList().isEmpty()) {
                outUserId = syncDataDto.getUsersList().stream().map(SysUsers::getOutUserId).collect(Collectors.toList());
                LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
                updateWrapper.in(SyncOutsideUserDto::getId, outUserId);
                updateWrapper.eq(SyncOutsideUserDto::getConnName, (Object)connName);
                updateWrapper.set(SyncOutsideUserDto::getProcessingState, (Object)1);
                updateWrapper.set(SyncOutsideUserDto::getFailReason, null);
                this.syncUserService.update((Wrapper)updateWrapper);
            } else if (!syncDataDto.getSyncOrganRelas().isEmpty()) {
                outOrganRelaId = syncDataDto.getSyncOrganRelas().stream().map(SyncOrganRela::getOutId).collect(Collectors.toList());
                LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
                updateWrapper.in(SyncOutsideOrganRelaDto::getId, outOrganRelaId);
                updateWrapper.eq(SyncOutsideOrganRelaDto::getConnName, (Object)connName);
                updateWrapper.set(SyncOutsideOrganRelaDto::getProcessingState, (Object)1);
                updateWrapper.set(SyncOutsideOrganRelaDto::getFailReason, null);
                this.syncOrganRelaService.update((Wrapper)updateWrapper);
            } else if (!syncDataDto.getBasicInfos().isEmpty()) {
                outProjectInfoId = syncDataDto.getBasicInfos().stream().map(SyncProjectBasicInfo::getProjectId).collect(Collectors.toList());
                LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
                updateWrapper.in(SyncProjectInfoDto::getProjectId, outProjectInfoId);
                updateWrapper.eq(SyncProjectInfoDto::getConnName, (Object)connName);
                updateWrapper.set(SyncProjectInfoDto::getProcessingState, (Object)1);
                updateWrapper.set(SyncProjectInfoDto::getFailReason, null);
                this.syncProjectInfoService.update((Wrapper)updateWrapper);
            } else {
                LOGGER.error("mq\u6d88\u8d39\u91cd\u8bd5\u6210\u529f\u65f6\u4fee\u6539out\u8868\u72b6\u6001\u5931\u8d25, outPostId:{}\uff0coutStruId:{}\uff0coutUserId:{}, outOrganRelaId:{}, outProjectInfoId:{}", new Object[]{outPostId, outStruId, outUserId, outOrganRelaId, outProjectInfoId});
            }
        }
        catch (Exception e) {
            LOGGER.error("errorMessage:{}", (Object)e.getMessage(), (Object)e);
            LOGGER.error("mq\u6d88\u8d39\u91cd\u8bd5\u6210\u529f\u65f6\u4fee\u6539out\u8868\u72b6\u6001\u5931\u8d25, outPostId:{}\uff0coutStruId:{}\uff0coutUserId:{}, outOrganRelaId:{}, outProjectInfoId:{}", new Object[]{outPostId, outStruId, outUserId, outOrganRelaId, outProjectInfoId});
        }
    }
}

