/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.sync.consumer.service.impl;

import com.jxdinfo.hussar.authorization.post.model.SysPost;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import com.jxdinfo.hussar.sync.common.dto.SyncDataDto;
import com.jxdinfo.hussar.sync.common.service.ISyncPostService;
import com.jxdinfo.hussar.sync.common.service.ISysPostService;
import com.jxdinfo.hussar.sync.consumer.service.IHussarSyncConsumerService;
import com.jxdinfo.hussar.sync.consumer.service.ISyncConsumerService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SyncPostConsumerServiceImpl
implements IHussarSyncConsumerService {
    private static final Logger LOGGER = LoggerFactory.getLogger(SyncPostConsumerServiceImpl.class);
    @Resource
    private ISysPostService sysPostService;
    @Resource
    private ISyncConsumerService syncConsumerService;
    @Resource
    private ISyncPostService syncPostService;
    private static final String LOG_FLAG = "\u5c97\u4f4d";

    public String getSyncType() {
        return "post";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @HussarDs(value="#connName")
    @Transactional(rollbackFor={Exception.class})
    public void synchronization(String connName, SyncDataDto syncDataDto) {
        LOGGER.info("{}{}", (Object)LOG_FLAG, (Object)"\u540c\u6b65\u5f00\u59cb\uff01");
        String errorMsg = null;
        boolean isSuccess = true;
        List<Object> outIds = new ArrayList();
        try {
            List postList = syncDataDto.getPostList();
            if (HussarUtils.isEmpty((Object)postList)) {
                isSuccess = false;
                errorMsg = "\u5c97\u4f4d\u540c\u6b65\u6570\u636e\u5f02\u5e38\uff01";
                LOGGER.error(errorMsg);
                throw new RuntimeException(errorMsg);
            }
            outIds = postList.stream().map(SysPost::getOutPostId).collect(Collectors.toList());
            LOGGER.info("{}\u540c\u6b65\u6570\u636e{}\u6761", (Object)LOG_FLAG, (Object)postList.size());
            boolean b = this.sysPostService.saveOrUpdateBatch((Collection)postList);
            if (b) {
                this.syncPostService.updateStatus(outIds, isSuccess, errorMsg);
            }
            LOGGER.info("{}{}", (Object)LOG_FLAG, (Object)"\u540c\u6b65\u6210\u529f\uff01");
        }
        catch (Exception e) {
            LOGGER.error("{}\u540c\u6b65\u5931\u8d25\uff0c\u9519\u8bef\u539f\u56e0{}", new Object[]{LOG_FLAG, e.getMessage(), e});
            errorMsg = e.getMessage();
            isSuccess = false;
        }
        finally {
            this.syncConsumerService.saveMqMessage(connName, syncDataDto.toString(), errorMsg, isSuccess);
            this.syncPostService.updateStatusToZero();
        }
    }
}

