/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.sync.common.service.impl;

import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.sync.publisher.mq.SyncPublisherRabbitMQTransmitter;
import com.jxdinfo.hussar.sync.publisher.service.ISyncPublisherService;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

@Component
public class SyncDataService {
    private static final Logger LOGGER = LoggerFactory.getLogger(SyncDataService.class);
    @Resource
    private SyncPublisherRabbitMQTransmitter publisherRabbitMQTransmitter;
    @Resource
    private ISyncPublisherService syncPublisherService;

    public void doJobAfterSyncEnd(String connName) {
        String frequency;
        Map<String, Object> syncConfig = this.publisherRabbitMQTransmitter.getSyncConfig(connName);
        if ("0".equals(syncConfig.get("is_trigger_after_sync")) && !HussarUtils.isEmpty((Object)(frequency = String.valueOf(syncConfig.get("scheduled_tasks_frequency")))) && !"null".equals(frequency) && !"0".equals(frequency)) {
            try {
                String logFlag = "\u5b9a\u65f6\u4efb\u52a1";
                Object flag = HussarCacheUtil.get((String)"syncLock", (Object)connName);
                if (flag != null) {
                    LOGGER.error("{}{}", (Object)logFlag, (Object)"\u540c\u6b65\u9501\u5b9a\uff01");
                    throw new RuntimeException(logFlag + "\u540c\u6b65\u9501\u5b9a\uff01");
                }
                HussarCacheUtil.put((String)"syncLock", (Object)connName, (Object)connName);
                int num = Integer.parseInt(frequency);
                this.doJob(num, connName);
            }
            catch (Exception e) {
                LOGGER.error("errorMessage:{}", (Object)e.getMessage(), (Object)e);
                throw new RuntimeException(e.getMessage());
            }
            finally {
                HussarCacheUtil.evict((String)"syncLock", (Object)connName);
            }
        }
    }

    @Async
    public void doJob(int num, String connName) {
        for (int i = 0; i < num; ++i) {
            this.syncPublisherService.operationSync(connName);
        }
    }
}

