/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.sync.consumer.service.impl;

import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import com.jxdinfo.hussar.sync.common.dto.SyncDataDto;
import com.jxdinfo.hussar.sync.common.service.ISyncUserService;
import com.jxdinfo.hussar.sync.common.service.ISysOrganService;
import com.jxdinfo.hussar.sync.common.service.ISysStaffService;
import com.jxdinfo.hussar.sync.common.service.ISysStruService;
import com.jxdinfo.hussar.sync.common.service.ISysUsersService;
import com.jxdinfo.hussar.sync.consumer.service.IHussarSyncConsumerService;
import com.jxdinfo.hussar.sync.consumer.service.ISyncConsumerService;
import com.jxdinfo.hussar.sync.consumer.service.ISyncUserPositionConsumer;
import com.jxdinfo.hussar.sync.publisher.service.ISyncPublisherService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SyncUserConsumerServiceImpl
implements IHussarSyncConsumerService {
    private static final Logger LOGGER = LoggerFactory.getLogger(SyncUserConsumerServiceImpl.class);
    @Resource
    private ISysUsersService usersService;
    @Resource
    protected ISysStruService sysStruService;
    @Resource
    protected ISysStaffService sysStaffService;
    @Resource
    private ISysOrganService organService;
    @Resource
    private ISyncConsumerService syncConsumerService;
    @Resource
    private ISyncUserService userService;
    @Resource
    private ISyncUserPositionConsumer syncUserPositionConsumer;
    @Resource
    @Lazy
    private ISyncPublisherService syncPublisherService;
    private static final String LOG_FLAG = "\u7528\u6237";

    public String getSyncType() {
        return "user";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @HussarDs(value="#connName")
    @Transactional(rollbackFor={Exception.class})
    public void synchronization(String connName, SyncDataDto syncDataDto) {
        LOGGER.info("{}{}", (Object)LOG_FLAG, (Object)"\u540c\u6b65\u5f00\u59cb\uff01");
        String errorMsg = "";
        boolean isSuccess = true;
        List usersList = syncDataDto.getUsersList();
        List struList = syncDataDto.getStruList();
        List organList = syncDataDto.getOrganList();
        List staffList = syncDataDto.getStaffList();
        List outsideUserDtoList = syncDataDto.getOutsideUserDtoList();
        List<Object> outIds = new ArrayList();
        try {
            if (HussarUtils.hasEmpty((Object[])new Object[]{usersList, staffList, struList, organList, outsideUserDtoList}) || outsideUserDtoList.size() != usersList.size() || usersList.size() != staffList.size() || staffList.size() != organList.size() || organList.size() != struList.size()) {
                isSuccess = false;
                errorMsg = "\u7528\u6237\u540c\u6b65\u6570\u636e\u5f02\u5e38\uff01";
                LOGGER.error(errorMsg);
                throw new RuntimeException(errorMsg);
            }
            outIds = usersList.stream().map(SysUsers::getOutUserId).collect(Collectors.toList());
            LOGGER.info("{}\u540c\u6b65\u6570\u636e{}\u6761", (Object)LOG_FLAG, (Object)usersList.size());
            boolean b = this.organService.saveOrUpdateBatch((Collection)organList);
            boolean b1 = this.sysStruService.saveOrUpdateBatch((Collection)struList);
            boolean b2 = this.usersService.saveOrUpdateBatch((Collection)usersList);
            boolean b3 = this.sysStaffService.saveOrUpdateBatch((Collection)staffList);
            if (b && b1 && b2 && b3) {
                this.userService.updateStatus(outIds, isSuccess, errorMsg);
            }
            LOGGER.info("{}{}", (Object)LOG_FLAG, (Object)"\u540c\u6b65\u6210\u529f\uff01");
        }
        catch (Exception e) {
            LOGGER.error("{}\u540c\u6b65\u5931\u8d25\uff0c\u9519\u8bef\u539f\u56e0{}", new Object[]{LOG_FLAG, e.getMessage(), e});
            errorMsg = e.getMessage();
            isSuccess = false;
        }
        finally {
            this.syncConsumerService.saveMqMessage(connName, syncDataDto.toString(), errorMsg, isSuccess);
            this.userService.updateStatusToZero();
        }
        if (!outIds.isEmpty()) {
            this.syncUserPositionConsumer.savePostList(connName, outIds, outsideUserDtoList);
        }
    }
}

