/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.sync.consumer.service.impl;

import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import com.jxdinfo.hussar.sync.common.dto.SyncDataDto;
import com.jxdinfo.hussar.sync.common.model.SyncProjectBasicInfo;
import com.jxdinfo.hussar.sync.common.service.ISyncProjectInfoService;
import com.jxdinfo.hussar.sync.common.service.ISysProjectBasicInfoService;
import com.jxdinfo.hussar.sync.common.service.ISysProjectEngineeringInfoService;
import com.jxdinfo.hussar.sync.common.service.ISysProjectLocationInfoService;
import com.jxdinfo.hussar.sync.common.service.ISysProjectRelationshipInfoService;
import com.jxdinfo.hussar.sync.consumer.service.IHussarSyncConsumerService;
import com.jxdinfo.hussar.sync.consumer.service.ISyncConsumerService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SyncProjectInfoConsumerServiceImpl
implements IHussarSyncConsumerService {
    private static final Logger LOGGER = LoggerFactory.getLogger(SyncProjectInfoConsumerServiceImpl.class);
    @Resource
    private ISyncConsumerService syncConsumerService;
    @Resource
    private ISysProjectBasicInfoService sysProjectBasicInfoService;
    @Resource
    private ISysProjectEngineeringInfoService sysProjectEngineeringInfoService;
    @Resource
    private ISysProjectLocationInfoService sysProjectLocationInfoService;
    @Resource
    private ISysProjectRelationshipInfoService sysProjectRelationshipInfoService;
    @Resource
    private ISyncProjectInfoService syncProjectInfoService;
    private static final String LOG_FLAG = "\u9879\u76ee\u4fe1\u606f";

    public String getSyncType() {
        return "project";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @HussarDs(value="#connName")
    @Transactional(rollbackFor={Exception.class})
    public void synchronization(String connName, SyncDataDto syncDataDto) {
        LOGGER.info("{}{}", (Object)LOG_FLAG, (Object)"\u540c\u6b65\u5f00\u59cb\uff01");
        String errorMsg = "";
        boolean isSuccess = true;
        ArrayList projectIds = new ArrayList();
        try {
            List basicInfos = syncDataDto.getBasicInfos();
            List engineeringInfos = syncDataDto.getEngineeringInfos();
            List relationshipInfos = syncDataDto.getRelationshipInfos();
            List locationInfos = syncDataDto.getLocationInfos();
            LOGGER.info("{}\u540c\u6b65\u6570\u636e{}\u6761", (Object)"\u9879\u76ee\u57fa\u672c\u4fe1\u606f", (Object)basicInfos.size());
            LOGGER.info("{}\u540c\u6b65\u6570\u636e{}\u6761", (Object)"\u9879\u76ee\u5de5\u7a0b\u4fe1\u606f", (Object)engineeringInfos.size());
            LOGGER.info("{}\u540c\u6b65\u6570\u636e{}\u6761", (Object)"\u9879\u76ee\u5173\u7cfb\u4fe1\u606f", (Object)relationshipInfos.size());
            LOGGER.info("{}\u540c\u6b65\u6570\u636e{}\u6761", (Object)"\u9879\u76ee\u4f4d\u7f6e\u4fe1\u606f", (Object)locationInfos.size());
            if (!basicInfos.isEmpty()) {
                this.sysProjectBasicInfoService.saveOrUpdateBatch((Collection)basicInfos);
                basicInfos.stream().map(SyncProjectBasicInfo::getProjectId).forEach(projectIds::add);
            }
            if (!engineeringInfos.isEmpty()) {
                this.sysProjectEngineeringInfoService.saveOrUpdateBatch((Collection)engineeringInfos);
            }
            if (!relationshipInfos.isEmpty()) {
                this.sysProjectRelationshipInfoService.saveOrUpdateBatch((Collection)relationshipInfos);
            }
            if (!locationInfos.isEmpty()) {
                this.sysProjectLocationInfoService.saveOrUpdateBatch((Collection)locationInfos);
            }
            if (!projectIds.isEmpty()) {
                this.syncProjectInfoService.updateStatus(projectIds, isSuccess, errorMsg);
            }
            LOGGER.info("{}{}", (Object)LOG_FLAG, (Object)"\u540c\u6b65\u6210\u529f\uff01");
        }
        catch (Exception e) {
            LOGGER.error("{}\u540c\u6b65\u5931\u8d25\uff0c\u9519\u8bef\u539f\u56e0{}", new Object[]{LOG_FLAG, e.getMessage(), e});
            errorMsg = e.getMessage();
            isSuccess = false;
            this.syncProjectInfoService.updateStatus(projectIds, isSuccess, errorMsg);
        }
        finally {
            this.syncConsumerService.saveMqMessage(connName, syncDataDto.toString(), errorMsg, isSuccess);
            this.syncProjectInfoService.updateStatusToZero();
        }
    }
}

