/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.sync.consumer.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.hussar.consumer.model.SysConsumerRecord;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import com.jxdinfo.hussar.sync.common.dto.SyncDataDto;
import com.jxdinfo.hussar.sync.common.service.impl.SyncDataService;
import com.jxdinfo.hussar.sync.consumer.dao.SyncConsumerRecordMapper;
import com.jxdinfo.hussar.sync.consumer.factory.HussarSyncConsumerFactory;
import com.jxdinfo.hussar.sync.consumer.service.ISyncConsumerService;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.Message;
import org.springframework.stereotype.Service;

@Service
public class SyncConsumerServiceImpl
extends ServiceImpl<SyncConsumerRecordMapper, SysConsumerRecord>
implements ISyncConsumerService {
    private static final Logger LOGGER = LoggerFactory.getLogger(SyncConsumerServiceImpl.class);
    @Resource
    private SyncDataService syncDataService;

    public void dataSynchronization(Message message) {
        String json = new String(message.getBody(), StandardCharsets.UTF_8);
        SyncDataDto syncDataDto = (SyncDataDto)JSONObject.parseObject((String)json, SyncDataDto.class);
        String connName = syncDataDto.getConnName();
        HussarSyncConsumerFactory.getSyncConsumerService(syncDataDto.getFlag()).synchronization(connName, syncDataDto);
        this.syncDataService.doJobAfterSyncEnd(connName);
    }

    @HussarDs(value="master")
    public void saveMqMessage(String queuesName, String json, String errorMsg, boolean isSuccess) {
        SysConsumerRecord sysConsumerRecord = new SysConsumerRecord();
        sysConsumerRecord.setQueueName(queuesName);
        sysConsumerRecord.setMessage(json);
        sysConsumerRecord.setCreateTime(LocalDateTime.now());
        if (isSuccess) {
            sysConsumerRecord.setConsumeStatus("0");
        } else {
            sysConsumerRecord.setProcessingStatus("1");
            sysConsumerRecord.setConsumeStatus("1");
            sysConsumerRecord.setErrorInfo(errorMsg);
        }
        this.save(sysConsumerRecord);
    }
}

