/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.sync.common.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.job.execution.core.processor.ProcessResult;
import com.jxdinfo.hussar.support.job.execution.core.processor.TaskContext;
import com.jxdinfo.hussar.support.job.execution.core.processor.sdk.BasicProcessor;
import com.jxdinfo.hussar.sync.publisher.service.ISyncPublisherService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="operationSyncJob")
public class OperationSyncJob
implements BasicProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(OperationSyncJob.class);
    private final ISyncPublisherService syncPublisherService = (ISyncPublisherService)SpringContextHolder.getBean(ISyncPublisherService.class);

    public ProcessResult process(TaskContext taskContext) {
        String logFlag = "\u5b9a\u65f6\u4efb\u52a1";
        String connName = "master";
        try {
            Object flag;
            JSONObject jsonObject;
            String jobParams = taskContext.getJobParams();
            if (HussarUtils.isNotEmpty((Object)jobParams) && HussarUtils.isNotEmpty((Object)(jsonObject = JSONObject.parseObject((String)jobParams)).get((Object)"connName"))) {
                connName = jsonObject.getString("connName");
            }
            if ((flag = HussarCacheUtil.get((String)"syncLock", (Object)connName)) != null) {
                LOGGER.error("{}{}", (Object)logFlag, (Object)"\u540c\u6b65\u9501\u5b9a\uff01");
                throw new RuntimeException(logFlag + "\u540c\u6b65\u9501\u5b9a\uff01");
            }
            HussarCacheUtil.put((String)"syncLock", (Object)connName, (Object)connName);
            this.syncPublisherService.asyncOperationSync(connName);
        }
        catch (Exception e) {
            LOGGER.error("errorMessage:{}", (Object)e.getMessage(), (Object)e);
            throw new RuntimeException(e.getMessage());
        }
        finally {
            HussarCacheUtil.evict((String)"syncLock", (Object)connName);
        }
        return new ProcessResult(true, "success");
    }
}

