/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.sync.consumer.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.jxdinfo.hussar.authorization.organ.model.SysStru;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.post.model.SysPost;
import com.jxdinfo.hussar.authorization.post.model.SysUserPostConcurrently;
import com.jxdinfo.hussar.authorization.post.model.SysUserPostMain;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import com.jxdinfo.hussar.sync.common.dto.SyncOutsideUserDto;
import com.jxdinfo.hussar.sync.common.model.SyncUsersPositionOut;
import com.jxdinfo.hussar.sync.common.service.ISysPostService;
import com.jxdinfo.hussar.sync.common.service.ISysStruService;
import com.jxdinfo.hussar.sync.common.service.ISysUsersService;
import com.jxdinfo.hussar.sync.common.service.UserPostConcurrentlyService;
import com.jxdinfo.hussar.sync.common.service.UserPostMainService;
import com.jxdinfo.hussar.sync.consumer.service.ISyncUserPositionConsumer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SyncUserPositionConsumerServiceImpl
implements ISyncUserPositionConsumer {
    private static final Logger LOGGER = LoggerFactory.getLogger(SyncUserPositionConsumerServiceImpl.class);
    @Resource
    private ISysPostService sysPostService;
    @Resource
    private ISysUsersService sysUsersService;
    @Resource
    private ISysStruService sysStruService;
    @Resource
    private UserPostMainService userPostMainService;
    @Resource
    private UserPostConcurrentlyService userPostConcurrentlyService;
    private static final String LOG_FLAG = "\u4eba\u5458\u5c97\u4f4d\u5173\u7cfb";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @HussarDs(value="#connName")
    @Transactional(rollbackFor={Exception.class})
    public void savePostList(String connName, List<String> outUserIdList, List<SyncOutsideUserDto> outsideUserDtoList) {
        LOGGER.info("{}{}", (Object)LOG_FLAG, (Object)"\u540c\u6b65\u5f00\u59cb\uff01");
        ArrayList<SysUserPostMain> mainlist = new ArrayList<SysUserPostMain>();
        ArrayList<SysUserPostConcurrently> concurrentlylist = new ArrayList<SysUserPostConcurrently>();
        ArrayList allPosition = new ArrayList();
        ArrayList outUserIds = new ArrayList();
        ArrayList positionIds = new ArrayList();
        ArrayList struIds = new ArrayList();
        String errorMsg = "";
        try {
            outsideUserDtoList.forEach(userDto -> {
                outUserIds.add(userDto.getId());
                List positionList = userDto.getPositionList();
                positionList.forEach(po -> {
                    positionIds.add(po.getPositionId());
                    struIds.add(po.getDepartmentId());
                    struIds.add(po.getCompanyId());
                });
                allPosition.addAll(positionList);
            });
            List usersList = this.sysUsersService.list((Wrapper)Wrappers.lambdaQuery(SysUsers.class).in(SysUsers::getOutUserId, outUserIds));
            if (usersList.isEmpty()) {
                LOGGER.error("\u540c\u6b65\u4eba\u5458\u5c97\u4f4d\u5173\u7cfb\u65f6\uff0cSysUsers\u8868\u67e5\u8be2\u4e3a\u7a7a");
                throw new RuntimeException("\u540c\u6b65\u4eba\u5458\u5c97\u4f4d\u5173\u7cfb\u65f6\uff0cSysUsers\u8868\u67e5\u8be2\u4e3a\u7a7a");
            }
            List postList = this.sysPostService.list((Wrapper)Wrappers.lambdaQuery(SysPost.class).in(SysPost::getOutPostId, positionIds));
            if (postList.isEmpty()) {
                LOGGER.error("\u540c\u6b65\u4eba\u5458\u5c97\u4f4d\u5173\u7cfb\u65f6\uff0cSysPost\u8868\u67e5\u8be2\u4e3a\u7a7a");
                throw new RuntimeException("\u540c\u6b65\u4eba\u5458\u5c97\u4f4d\u5173\u7cfb\u65f6\uff0cSysPost\u8868\u67e5\u8be2\u4e3a\u7a7a");
            }
            List struList = this.sysStruService.getStruList(struIds);
            if (struList.isEmpty()) {
                LOGGER.error("\u540c\u6b65\u4eba\u5458\u5c97\u4f4d\u5173\u7cfb\u65f6\uff0cSysStru\u8868\u67e5\u8be2\u4e3a\u7a7a");
                throw new RuntimeException("\u540c\u6b65\u4eba\u5458\u5c97\u4f4d\u5173\u7cfb\u65f6\uff0cSysStru\u8868\u67e5\u8be2\u4e3a\u7a7a");
            }
            Map<String, List<SysUsers>> users = usersList.stream().collect(Collectors.groupingBy(SysUsers::getOutUserId));
            Map<String, List<SysPost>> posts = postList.stream().collect(Collectors.groupingBy(SysPost::getOutPostId));
            Map<String, List<SysStru>> strus = struList.stream().collect(Collectors.groupingBy(SysStru::getOutStruId));
            block4: for (SyncOutsideUserDto userDto2 : outsideUserDtoList) {
                List positionList = userDto2.getPositionList();
                if (!positionList.isEmpty()) {
                    for (SyncUsersPositionOut syncUsersPositionOut : positionList) {
                        List<SysPost> sysPosts = posts.get(syncUsersPositionOut.getPositionId());
                        List<SysUsers> sysUsers = users.get(userDto2.getId());
                        if (HussarUtils.isEmpty(sysPosts) || HussarUtils.isEmpty(sysUsers)) {
                            LOGGER.error("outUserId\u4e3a\uff1a{}\uff0cpositionId\u4e3a\uff1a{}\u7684SysPost\u8868\u6216SysUsers\u8868\u4fe1\u606f\u7f3a\u5931", (Object)userDto2.getId(), (Object)syncUsersPositionOut.getPositionId());
                            continue block4;
                        }
                        if (syncUsersPositionOut.getMainPosition() == 1) {
                            SysUserPostMain sysUserPostMain = new SysUserPostMain();
                            sysUserPostMain.setUpUserId(sysUsers.get(0).getEmployeeId());
                            sysUserPostMain.setUpPostId(sysPosts.get(0).getPostId());
                            mainlist.add(sysUserPostMain);
                            continue;
                        }
                        if (syncUsersPositionOut.getEnabled() == 0) continue;
                        SysUserPostConcurrently sysUserPostConcurrently = new SysUserPostConcurrently();
                        sysUserPostConcurrently.setUpUserId(sysUsers.get(0).getEmployeeId());
                        List<SysStru> sysStrus = strus.get(syncUsersPositionOut.getCompanyId());
                        if (HussarUtils.isEmpty(sysStrus)) {
                            LOGGER.error("outUserId\u4e3a\uff1a{}\u7684\u517c\u5c97sysStrus\u8868\u4fe1\u606f\u7f3a\u5931\uff0ccompanyId\u4e3a\uff1a{}", (Object)userDto2.getId(), (Object)syncUsersPositionOut.getCompanyId());
                            continue block4;
                        }
                        sysUserPostConcurrently.setUpCompanyId(sysStrus.get(0).getId());
                        sysUserPostConcurrently.setUpPostId(sysPosts.get(0).getPostId());
                        List<SysStru> list = strus.get(syncUsersPositionOut.getDepartmentId());
                        if (HussarUtils.isEmpty(list)) {
                            LOGGER.error("outUserId\u4e3a\uff1a{}\u7684\u517c\u5c97sysStrus\u8868\u4fe1\u606f\u7f3a\u5931\uff0cdepartmentId\u4e3a\uff1a{}", (Object)userDto2.getId(), (Object)syncUsersPositionOut.getDepartmentId());
                            continue block4;
                        }
                        sysUserPostConcurrently.setUpStruId(Long.valueOf(String.valueOf(list.get(0).getId())));
                        concurrentlylist.add(sysUserPostConcurrently);
                    }
                    continue;
                }
                LOGGER.error("outUserId\u4e3a\uff1a{}\u7684\u5c97\u4f4d\u5217\u8868\u4e3a\u7a7a", (Object)userDto2.getId());
            }
            if (HussarUtils.hasEmpty((Object[])new Object[]{mainlist, concurrentlylist})) {
                errorMsg = "\u4eba\u5458\u5c97\u4f4d\u5173\u7cfb\u540c\u6b65\u6570\u636e\u5f02\u5e38\uff01";
                LOGGER.error(errorMsg);
                throw new RuntimeException(errorMsg);
            }
            LOGGER.info("{}\u540c\u6b65\u4e3b\u5c97\u6570\u636e{}\u6761", (Object)LOG_FLAG, (Object)mainlist.size());
            LOGGER.info("{}\u540c\u6b65\u517c\u5c97\u6570\u636e{}\u6761", (Object)LOG_FLAG, (Object)concurrentlylist.size());
            this.userPostMainService.saveOrUpdateBatch(mainlist);
            this.userPostConcurrentlyService.saveOrUpdateBatch(concurrentlylist);
            LOGGER.info("{}{}", (Object)LOG_FLAG, (Object)"\u540c\u6b65\u6210\u529f\uff01");
        }
        catch (Exception e) {
            LOGGER.error("{}\u540c\u6b65\u5931\u8d25\uff0c\u9519\u8bef\u539f\u56e0{}", new Object[]{LOG_FLAG, e.getMessage(), e});
        }
    }
}

