/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.sync.common.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.sync.common.dto.SyncProjectInfoDto;
import com.jxdinfo.hussar.sync.common.service.ISyncProjectInfoService;
import com.jxdinfo.hussar.sync.consumer.dao.SyncProjectInfoMapper;
import java.util.List;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@HussarDs(value="master")
@Transactional(rollbackFor={Exception.class})
public class SyncProjectInfoServiceImpl
extends HussarServiceImpl<SyncProjectInfoMapper, SyncProjectInfoDto>
implements ISyncProjectInfoService {
    public boolean saveOrUpdateByTenant(List<SyncProjectInfoDto> projectInfos) {
        return this.saveOrUpdateBatch(projectInfos);
    }

    public void updateStatusToZero() {
        ((SyncProjectInfoMapper)this.baseMapper).updateStruStatusToZero();
    }

    public void updateStatus(List<String> projectIds, boolean isSuccess, String message) {
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.in(SyncProjectInfoDto::getProjectId, projectIds);
        if (isSuccess) {
            updateWrapper.set(SyncProjectInfoDto::getProcessingState, (Object)1);
            updateWrapper.set(SyncProjectInfoDto::getFailReason, null);
        } else {
            updateWrapper.set(SyncProjectInfoDto::getProcessingState, (Object)2);
            updateWrapper.set(SyncProjectInfoDto::getFailReason, (Object)message);
        }
        this.update((Wrapper)updateWrapper);
    }
}

