/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.sync.common.service.impl;

import com.jxdinfo.hussar.authorization.organ.model.SysOrgan;
import com.jxdinfo.hussar.authorization.organ.model.SysStru;
import com.jxdinfo.hussar.authorization.organ.util.OrganUtil;
import com.jxdinfo.hussar.common.constant.Constants;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.sync.common.service.EditOrganizationManager;
import com.jxdinfo.hussar.sync.common.service.impl.CommonOrganizationManager;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;

@HussarTokenDs
@Repository(value="com.jxdinfo.hussar.sync.common.service.impl.SyncEditOrganizationManagerImpl")
public class SyncEditOrganizationManagerImpl
extends CommonOrganizationManager
implements EditOrganizationManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(SyncEditOrganizationManagerImpl.class);

    public synchronized void refreshOrgan() {
        List strus = this.syncStruMapper.selectList(null);
        List organs = this.syncOrganMapper.selectList(null);
        Map organsMap = organs.stream().collect(Collectors.toMap(SysOrgan::getId, Function.identity()));
        AtomicInteger index = new AtomicInteger(1);
        strus.stream().filter(organsEntity -> organsEntity.getParentId().equals(Constants.ROOT_NODE_ID)).sorted(Comparator.comparing(SysStru::getIsEmployee, Comparator.nullsLast(String::compareTo)).thenComparing(SysStru::getStruLevel, Comparator.nullsLast(Integer::compareTo)).thenComparing(SysStru::getStruOrder, Comparator.nullsLast(Integer::compareTo)).thenComparing(SysStru::getGlobalOrder, Comparator.nullsLast(Integer::compareTo)).thenComparing(SysStru::getId)).map(stru -> {
            SysOrgan sysOrgan = (SysOrgan)organsMap.get(stru.getOrganId());
            sysOrgan.setOrganFname("/" + sysOrgan.getOrganName());
            sysOrgan.setOrganFcode(sysOrgan.getOrganCode().equals("1") ? "/1/" : OrganUtil.convert((String)sysOrgan.getOrganCode()));
            stru.setStruSeq("/" + String.format("%04d", index.getAndIncrement()));
            stru.setStruFid(Objects.equals(stru.getId(), 1L) ? "/1/" : OrganUtil.convert((Long)stru.getId()));
            stru.setStruLevel(Integer.valueOf(stru.getStruFid().split("/").length - 1));
            stru.setIsLeaf("Y");
            this.setInfo((SysStru)stru, strus, organsMap);
            return stru;
        }).collect(Collectors.toList());
        this.sysStruService.updateBatchById((Collection)strus);
        this.sysOrganService.updateBatchById(organsMap.values());
    }

    private void setInfo(SysStru root, List<SysStru> all, Map<Long, SysOrgan> organsMap) {
        AtomicInteger index = new AtomicInteger(1);
        root.setIsLeaf("Y");
        SysOrgan rootOrgan = organsMap.get(root.getOrganId());
        all.stream().filter(stru -> stru.getParentId().equals(root.getId())).sorted(Comparator.comparing(SysStru::getIsEmployee, Comparator.nullsLast(String::compareTo)).thenComparing(SysStru::getStruLevel, Comparator.nullsLast(Integer::compareTo)).thenComparing(SysStru::getStruOrder, Comparator.nullsLast(Integer::compareTo)).thenComparing(SysStru::getGlobalOrder, Comparator.nullsLast(Integer::compareTo)).thenComparing(SysStru::getId)).map(stru -> {
            SysOrgan sysOrgan = (SysOrgan)organsMap.get(stru.getOrganId());
            AssertUtil.isNotNull((Object)sysOrgan, (String)("\u6570\u636e\u5e93\u6570\u636e\u9519\u4e71\uff0c\u6839\u636eSYS_STRU\u67e5\u8be2\u5230ORGAN_ID:" + stru.getOrganId() + ",\u4f46\u662f\u5728SYS_ORGAN\u4e2d\u672a\u67e5\u8be2\u5230\u6570\u636e"));
            sysOrgan.setOrganFname(rootOrgan.getOrganFname() + "/" + sysOrgan.getOrganName());
            sysOrgan.setOrganFcode(OrganUtil.convert((String)(rootOrgan.getOrganFcode() + sysOrgan.getOrganCode())));
            stru.setStruFid(OrganUtil.convert((String)(root.getStruFid() + stru.getId())));
            stru.setStruLevel(Integer.valueOf(stru.getStruFid().split("/").length - 1));
            if (!Objects.equals("9", stru.getStruType())) {
                root.setIsLeaf("N");
                stru.setStruSeq(root.getStruSeq() + "/" + String.format("%04d", index.getAndIncrement()));
            } else {
                stru.setStruSeq(root.getStruSeq());
            }
            this.setInfo((SysStru)stru, all, organsMap);
            return stru;
        }).collect(Collectors.toList());
    }
}

