/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.sync.publisher.mq;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.base.config.baseconfig.model.SysBaseConfig;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import com.jxdinfo.hussar.sync.common.service.ISysBaseConfigService;
import java.io.ByteArrayInputStream;
import java.io.ObjectInputStream;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.amqp.support.converter.Jackson2JsonMessageConverter;
import org.springframework.amqp.support.converter.MessageConverter;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Component;

@Component
public class SyncPublisherRabbitMQTransmitter {
    private static final Logger LOGGER = LoggerFactory.getLogger(SyncPublisherRabbitMQTransmitter.class);
    @Resource
    private RabbitTemplate rabbitTemplate;
    @Resource
    private ISysBaseConfigService sysBaseConfigService;

    public boolean send(String routingKey, Object object) {
        this.rabbitTemplate.setMessageConverter((MessageConverter)new Jackson2JsonMessageConverter());
        Object result = this.rabbitTemplate.convertSendAndReceive("topicExchange", routingKey, object);
        if (HussarUtils.isEmpty((Object)result)) {
            return false;
        }
        boolean flag = true;
        try {
            ByteArrayInputStream byteInt = new ByteArrayInputStream((byte[])result);
            ObjectInputStream objInt = new ObjectInputStream(byteInt);
            flag = (Boolean)objInt.readObject();
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
        }
        return flag;
    }

    @Cacheable(value={"syncConfig"}, key="#connName")
    @HussarDs(value="#connName")
    public Map<String, Object> getSyncConfig(String connName) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.in(SysBaseConfig::getConfigKey, new Object[]{"is_data_sync_verify", "is_trigger_after_sync", "scheduled_tasks_frequency"});
        HashMap<String, Object> map = new HashMap<String, Object>(4);
        map.put("is_data_sync_verify", "1");
        map.put("is_trigger_after_sync", null);
        map.put("scheduled_tasks_frequency", null);
        return map;
    }
}

