/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.sync.publisher.controller;

import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.support.audit.core.annotations.AuditLog;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.sync.publisher.service.ISyncPublisherService;
import io.swagger.annotations.ApiOperation;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/hussarSync"})
public class HussarSyncOperationController {
    private static final Logger LOGGER = LoggerFactory.getLogger(HussarSyncOperationController.class);
    @Resource
    private ISyncPublisherService syncPublisherService;

    @PostMapping(value={"/operationSync"})
    @AuditLog(moduleName="\u540c\u6b65\u4e3b\u6570\u636e\u5f02\u5e38\u6570\u636e", eventDesc="\u540c\u6b65\u4e3b\u6570\u636e\u5f02\u5e38\u6570\u636e", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.INSERT)
    @ApiOperation(value="\u540c\u6b65\u4e3b\u6570\u636e\u5f02\u5e38\u6570\u636e", notes="\u540c\u6b65\u4e3b\u6570\u636e\u5f02\u5e38\u6570\u636e")
    public ApiResponse<?> operationSync(String connName) {
        String logFlag = "\u5b9a\u65f6\u4efb\u52a1";
        try {
            Object flag = HussarCacheUtil.get((String)"syncLock", (Object)connName);
            if (flag != null) {
                LOGGER.error("{}\u540c\u6b65\u9501\u5b9a\uff01", (Object)logFlag);
                throw new RuntimeException(logFlag + "\u540c\u6b65\u9501\u5b9a\uff01");
            }
            HussarCacheUtil.put((String)"syncLock", (Object)connName, (Object)connName);
            this.syncPublisherService.asyncOperationSync(connName);
            ApiResponse apiResponse = ApiResponse.success((String)"\u540c\u6b65\u4e3b\u6570\u636e\u5f02\u5e38\u6570\u636e\u4efb\u52a1\u6b63\u5728\u6267\u884c\u3002");
            return apiResponse;
        }
        catch (Exception e) {
            LOGGER.error("errorMessage:{}", (Object)e.getMessage(), (Object)e);
            throw new RuntimeException(e.getMessage());
        }
        finally {
            HussarCacheUtil.evict((String)"syncLock", (Object)connName);
        }
    }
}

