/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.sync.common.service.impl;

import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import com.jxdinfo.hussar.sync.common.model.SyncIdtable;
import com.jxdinfo.hussar.sync.common.service.ISysIdtableService;
import com.jxdinfo.hussar.sync.consumer.dao.SysIdtableMapper;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service
public class SysIdtableServiceImpl
extends HussarServiceImpl<SysIdtableMapper, SyncIdtable>
implements ISysIdtableService {
    @Resource
    SysIdtableMapper sysIdtableMapper;

    @HussarTransactional
    public synchronized String getCurrentCode(String fieldName, String tableName) {
        SyncIdtable sysIdtable = this.sysIdtableMapper.getIdtableByQuery(fieldName, tableName);
        if (ToolUtil.isNotEmpty((Object)sysIdtable)) {
            String isPrefix = sysIdtable.getIsPrefix();
            String idPrefix = sysIdtable.getIdPrefix();
            String isSuffix = sysIdtable.getIsSuffix();
            String idSuffix = sysIdtable.getIdSuffix();
            StringBuilder currentCode = new StringBuilder();
            if ("1".equals(isPrefix)) {
                String lastDate;
                if (idPrefix.indexOf("[") == 0 && idPrefix.indexOf("]") == idPrefix.length() - 1) {
                    idPrefix = idPrefix.substring(1, idPrefix.length());
                    idPrefix = idPrefix.substring(0, idPrefix.length() - 1);
                    SimpleDateFormat sdf = new SimpleDateFormat(idPrefix);
                    idPrefix = sdf.format(Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant()));
                }
                if (!ToolUtil.equals((Object)(lastDate = sysIdtable.getLastDate()), (Object)idPrefix)) {
                    sysIdtable.setLastDate(idPrefix);
                    super.updateById((BaseEntity)sysIdtable);
                    sysIdtable.setIdValue(Integer.valueOf(0));
                }
                currentCode.append(idPrefix);
            }
            Integer result = sysIdtable.getIdValue() + sysIdtable.getCacheSize();
            Integer length = sysIdtable.getIdLength();
            String idLength = length.toString();
            String resultCode = result.toString();
            int zeroLength = Integer.valueOf(idLength) - resultCode.length();
            if (zeroLength < 0) {
                throw new BaseException("\u7f16\u7801\u8d85\u51fa\u89c4\u5b9a\u7684\u957f\u5ea6");
            }
            for (int i = 0; i < zeroLength; ++i) {
                currentCode.append("0");
            }
            currentCode.append(result);
            if ("1".equals(isSuffix)) {
                currentCode.append(idSuffix);
            }
            sysIdtable.setIdValue(result);
            this.sysIdtableMapper.updateById(sysIdtable);
            return currentCode.toString();
        }
        throw new BaseException("\u672a\u627e\u5230\u7f16\u7801\u89c4\u5219");
    }
}

