/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.sync.common.service.impl;

import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import com.jxdinfo.hussar.support.job.execution.core.processor.ProcessResult;
import com.jxdinfo.hussar.support.job.execution.core.processor.TaskContext;
import com.jxdinfo.hussar.support.job.execution.core.processor.sdk.BasicProcessor;
import com.jxdinfo.hussar.sync.publisher.service.ISyncPublisherService;
import com.jxdinfo.hussar.tenant.common.util.HussarContextHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="operationSyncJob")
public class OperationSyncJob
implements BasicProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(OperationSyncJob.class);
    private ISyncPublisherService syncPublisherService = (ISyncPublisherService)SpringContextHolder.getBean(ISyncPublisherService.class);

    @HussarDs(value="#context.dbName")
    public ProcessResult process(TaskContext taskContext) {
        String logFlag = "\u5b9a\u65f6\u4efb\u52a1";
        String connName = HussarContextHolder.getConnName();
        try {
            Object flag = HussarCacheUtil.get((String)"syncLock", (Object)connName);
            if (flag != null) {
                LOGGER.error("{}\u540c\u6b65\u9501\u5b9a\uff01", (Object)logFlag);
                throw new RuntimeException(logFlag + "\u540c\u6b65\u9501\u5b9a\uff01");
            }
            HussarCacheUtil.put((String)"syncLock", (Object)connName, (Object)connName);
            this.syncPublisherService.asyncOperationSync(connName);
        }
        catch (Exception e) {
            LOGGER.error("errorMessage:{}", (Object)e.getMessage(), (Object)e);
            throw new RuntimeException(e.getMessage());
        }
        finally {
            HussarCacheUtil.evict((String)"syncLock", (Object)connName);
        }
        return new ProcessResult(true, "success");
    }
}

