/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.sync.publisher.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.jxdinfo.hussar.authorization.organ.model.SysOrgan;
import com.jxdinfo.hussar.authorization.organ.model.SysStaff;
import com.jxdinfo.hussar.authorization.organ.model.SysStru;
import com.jxdinfo.hussar.authorization.organ.service.IHussarBaseOrganizationService;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import com.jxdinfo.hussar.sync.common.dto.SyncDataDto;
import com.jxdinfo.hussar.sync.common.dto.SyncOutsideUserDto;
import com.jxdinfo.hussar.sync.common.model.SyncUsersPositionOut;
import com.jxdinfo.hussar.sync.common.service.IHussarLoginConfigService;
import com.jxdinfo.hussar.sync.common.service.ISyncTenantService;
import com.jxdinfo.hussar.sync.common.service.ISyncUserService;
import com.jxdinfo.hussar.sync.common.service.ISysStruService;
import com.jxdinfo.hussar.sync.common.service.ISysUsersService;
import com.jxdinfo.hussar.sync.publisher.mq.SyncPublisherRabbitMQTransmitter;
import com.jxdinfo.hussar.sync.publisher.service.ISyncPublisherService;
import com.jxdinfo.hussar.sync.publisher.service.ISyncUserPublisherService;
import com.jxdinfo.hussar.sync.publisher.service.ISyncUsersPositionOutPublisherService;
import com.jxdinfo.hussar.sync.publisher.util.SyncUserPublisherUtil;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class SyncUserPublisherServiceImpl
implements ISyncUserPublisherService {
    private static final Logger LOGGER = LoggerFactory.getLogger(SyncUserPublisherServiceImpl.class);
    @Resource
    private ISyncTenantService tenantService;
    @Resource
    private ISyncUsersPositionOutPublisherService syncUsersPositionOutPublisherService;
    @Resource
    private SyncPublisherRabbitMQTransmitter publisherRabbitMQTransmitter;
    @Resource
    protected IHussarLoginConfigService hussarLoginConfigService;
    @Resource
    @Lazy
    private ISyncPublisherService syncPublisherService;
    @Resource
    private ISysUsersService sysUsersService;
    @Resource
    private ISysStruService sysStruService;
    @Resource
    private ISyncUserService userService;
    @Resource
    private SyncUserPublisherUtil syncUserPublisherUtil;
    private static final String LOG_FLAG = "\u7528\u6237";

    public synchronized ApiResponse<?> saveUser(List<SyncOutsideUserDto> user, String tenantCode, boolean isJob) {
        LOGGER.info("{}\u6570\u636e\u63a5\u6536\u5f00\u59cb!", (Object)LOG_FLAG);
        if (HussarUtils.isEmpty(user)) {
            LOGGER.error("{}\u63a5\u6536\u6570\u636e\u4e3a\u7a7a\uff01", (Object)LOG_FLAG);
            return ApiResponse.fail((String)"\u7528\u6237\u63a5\u6536\u6570\u636e\u4e3a\u7a7a\uff01");
        }
        String connName = this.tenantService.getTenantByTenantCode(tenantCode);
        Object flag = HussarCacheUtil.get((String)"syncLock", (Object)connName);
        if (flag != null) {
            LOGGER.error("{}\u540c\u6b65\u9501\u5b9a\uff01", (Object)LOG_FLAG);
            return ApiResponse.fail((String)"\u7528\u6237\u540c\u6b65\u9501\u5b9a\uff01");
        }
        HussarCacheUtil.put((String)"syncLock", (Object)connName, (Object)connName);
        return this.saveUserReal(user, connName, isJob);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @HussarDs(value="connName")
    public ApiResponse<?> saveUserReal(List<SyncOutsideUserDto> user, String connName, boolean isJob) {
        try {
            SyncDataDto message;
            boolean result;
            ArrayList<String> delIds = new ArrayList<String>();
            ArrayList addList = new ArrayList();
            for (SyncOutsideUserDto syncOutsideUserDto : user) {
                if (!isJob) {
                    syncOutsideUserDto.setConnName(connName);
                }
                syncOutsideUserDto.setProcessingState(3);
                syncOutsideUserDto.setPushTime(LocalDateTime.now());
                if (syncOutsideUserDto.getIsDeleted() == 1) {
                    delIds.add(syncOutsideUserDto.getId());
                }
                if (syncOutsideUserDto.getPositionList() == null || syncOutsideUserDto.getPositionList().isEmpty()) continue;
                for (SyncUsersPositionOut SyncUsersPositionOut2 : syncOutsideUserDto.getPositionList()) {
                    SyncUsersPositionOut2.setUsersOutId(syncOutsideUserDto.getId());
                }
                addList.addAll(syncOutsideUserDto.getPositionList());
            }
            this.userService.saveOrUpdateByTenant(user);
            if (HussarUtils.isNotEmpty(delIds)) {
                this.syncUsersPositionOutPublisherService.removeByOutIds(connName, delIds);
            }
            this.syncUsersPositionOutPublisherService.saveBatch(addList);
            LOGGER.info("{}\u539f\u59cb\u6570\u636e\u5df2\u5165\u5e93!", (Object)LOG_FLAG);
            ArrayList<SyncOutsideUserDto> verifyFail = new ArrayList<SyncOutsideUserDto>();
            List<Object> verifyPass = new ArrayList();
            ArrayList<String> passOriginId = new ArrayList<String>();
            List outStruIds = this.sysStruService.list((Wrapper)Wrappers.lambdaQuery(SysStru.class)).stream().map(SysStru::getOutStruId).collect(Collectors.toList());
            boolean convert = this.hussarLoginConfigService.getLoginUpperOpen() == false;
            boolean firstSynchronization = this.syncPublisherService.isFirstSynchronization();
            String isVerify = String.valueOf(this.publisherRabbitMQTransmitter.getSyncConfig(connName).get("is_data_sync_verify"));
            if (isJob || "1".equals(isVerify)) {
                if (firstSynchronization && !user.isEmpty()) {
                    this.syncUserPublisherUtil.verifyNotEmpty(user, verifyFail);
                    verifyPass = user;
                    for (SyncOutsideUserDto syncOutsideUserDto : user) {
                        syncOutsideUserDto.setOperationType(Integer.valueOf(1));
                    }
                } else if (!firstSynchronization && !user.isEmpty()) {
                    ArrayList<String> userIds = new ArrayList<String>();
                    List<Object> accounts = new ArrayList<String>();
                    for (SyncOutsideUserDto syncOutsideUserDto : user) {
                        userIds.add(syncOutsideUserDto.getId());
                        accounts.add(syncOutsideUserDto.getUserCode());
                    }
                    if (convert) {
                        accounts = accounts.stream().map(String::toUpperCase).collect(Collectors.toList());
                    }
                    List sysUsers = new ArrayList();
                    if (!userIds.isEmpty() && !accounts.isEmpty()) {
                        LambdaQueryWrapper lambdaQueryWrapper = Wrappers.lambdaQuery(SysUsers.class);
                        lambdaQueryWrapper.in(SysUsers::getOutUserId, userIds);
                        ((LambdaQueryWrapper)lambdaQueryWrapper.or()).in(SysUsers::getUserAccount, accounts);
                        sysUsers = this.sysUsersService.list((Wrapper)lambdaQueryWrapper);
                    }
                    if (!this.syncPublisherService.isFirstSynchronization() && !user.isEmpty()) {
                        for (SyncOutsideUserDto syncOutsideUserDto : user) {
                            String account = syncOutsideUserDto.getUserCode();
                            if (convert) {
                                account = account.toUpperCase();
                                syncOutsideUserDto.setUserCode(account);
                            }
                            List outUserIds = sysUsers.stream().map(SysUsers::getOutUserId).collect(Collectors.toList());
                            List accountList = sysUsers.stream().map(SysUsers::getUserAccount).collect(Collectors.toList());
                            boolean exists = accountList.contains(account);
                            if (outUserIds.contains(syncOutsideUserDto.getId())) {
                                if (!exists) {
                                    syncOutsideUserDto.setProcessingState(2);
                                    syncOutsideUserDto.setFailReason("\u66f4\u65b0\u64cd\u4f5c\u65f6\uff0c\u8d26\u53f7\u4e0d\u5b58\u5728");
                                    verifyFail.add(syncOutsideUserDto);
                                    continue;
                                }
                                if (Collections.frequency(accountList, account) > 1 || Collections.frequency(accounts, account) > 1) {
                                    syncOutsideUserDto.setProcessingState(2);
                                    syncOutsideUserDto.setFailReason("\u66f4\u65b0\u64cd\u4f5c\u65f6\uff0c\u8d26\u53f7\u4e0d\u552f\u4e00");
                                    verifyFail.add(syncOutsideUserDto);
                                    continue;
                                }
                                syncOutsideUserDto.setOperationType(Integer.valueOf(2));
                                passOriginId.add(syncOutsideUserDto.getOriginId());
                                verifyPass.add(syncOutsideUserDto);
                                continue;
                            }
                            if (Collections.frequency(accounts, account) > 1) {
                                syncOutsideUserDto.setProcessingState(2);
                                syncOutsideUserDto.setFailReason("\u65b0\u589e\u64cd\u4f5c\u65f6\uff0c\u8d26\u53f7\u4e0d\u552f\u4e00");
                                verifyFail.add(syncOutsideUserDto);
                                continue;
                            }
                            if (exists) {
                                syncOutsideUserDto.setProcessingState(2);
                                syncOutsideUserDto.setFailReason("\u65b0\u589e\u64cd\u4f5c\u65f6\uff0c\u8d26\u53f7\u5df2\u5b58\u5728");
                                verifyFail.add(syncOutsideUserDto);
                                continue;
                            }
                            syncOutsideUserDto.setOperationType(Integer.valueOf(1));
                            passOriginId.add(syncOutsideUserDto.getOriginId());
                            verifyPass.add(syncOutsideUserDto);
                        }
                    }
                }
            }
            ArrayList<SysStru> struList = new ArrayList<SysStru>();
            ArrayList<SysStaff> sysStaffs = new ArrayList<SysStaff>();
            ArrayList<SysOrgan> sysOrgans = new ArrayList<SysOrgan>();
            ArrayList<SysUsers> sysUserses = new ArrayList<SysUsers>();
            if (!verifyPass.isEmpty()) {
                Function<Object, String> f = Object::toString;
                List strus = this.sysStruService.list((Wrapper)Wrappers.lambdaQuery(SysStru.class).in(SysStru::getId, passOriginId));
                this.syncUserPublisherUtil.initialization(verifyPass, struList, sysOrgans, sysStaffs, sysUserses, convert, strus, this.syncPublisherService.isFirstSynchronization());
            }
            ArrayList<Object> mergedList = new ArrayList<Object>();
            mergedList.addAll(verifyFail);
            mergedList.addAll(verifyPass);
            if (!mergedList.isEmpty()) {
                this.userService.saveOrUpdateByTenant(mergedList);
            }
            int state = (result = this.publisherRabbitMQTransmitter.send(connName, message = new SyncDataDto(connName, sysOrgans, sysUserses, sysStaffs, struList, Integer.valueOf(2)))) ? 1 : 2;
            String errorMsg = result ? "" : "\u6570\u636e\u6d88\u8d39\u65f6\u51fa\u73b0\u5f02\u5e38\uff0c\u8bf7\u901a\u8fc7\u65e5\u5fd7\u83b7\u53d6\u8be6\u7ec6\u4fe1\u606f\uff01";
            verifyPass = verifyPass.stream().map(a -> {
                a.setProcessingState(state);
                a.setFailReason(errorMsg);
                return a;
            }).collect(Collectors.toList());
            this.userService.saveOrUpdateByTenant(verifyPass);
            if (!result) {
                LOGGER.error("{}\u6570\u636e\u6d88\u8d39\u65f6\u51fa\u73b0\u5f02\u5e38\uff0c\u8bf7\u901a\u8fc7\u65e5\u5fd7\u83b7\u53d6\u8be6\u7ec6\u4fe1\u606f\uff01", (Object)LOG_FLAG);
                ApiResponse apiResponse = ApiResponse.fail((String)"\u7528\u6237\u6570\u636e\u6d88\u8d39\u65f6\u51fa\u73b0\u5f02\u5e38\uff0c\u8bf7\u901a\u8fc7\u65e5\u5fd7\u83b7\u53d6\u8be6\u7ec6\u4fe1\u606f\uff01");
                return apiResponse;
            }
            if (this.syncPublisherService.isFirstSynchronization()) {
                CompletableFuture.runAsync(() -> ((IHussarBaseOrganizationService)SpringContextHolder.getBean(IHussarBaseOrganizationService.class)).refreshOrgan());
            }
            LOGGER.info("{}\u63a5\u6536\u6570\u636e\u6210\u529f\uff01", (Object)LOG_FLAG);
            ApiResponse apiResponse = ApiResponse.success();
            return apiResponse;
        }
        catch (Exception e) {
            LOGGER.error("errorMessage:{}", (Object)e.getMessage(), (Object)e);
            ApiResponse apiResponse = ApiResponse.fail((String)("\u7528\u6237\u63a5\u6536\u6570\u636e\u5931\u8d25,\u7cfb\u7edf\u5f02\u5e38\uff01" + e));
            return apiResponse;
        }
        finally {
            HussarCacheUtil.evict((String)"syncLock", (Object)connName);
        }
    }
}

