/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.sync.publisher.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import com.jxdinfo.hussar.sync.common.service.ISyncOrganService;
import com.jxdinfo.hussar.sync.common.service.ISyncPostService;
import com.jxdinfo.hussar.sync.common.service.ISyncUserService;
import com.jxdinfo.hussar.sync.publisher.service.ISyncOrganPublisherService;
import com.jxdinfo.hussar.sync.publisher.service.ISyncPostPublisherService;
import com.jxdinfo.hussar.sync.publisher.service.ISyncPublisherService;
import com.jxdinfo.hussar.sync.publisher.service.ISyncUserPublisherService;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class SyncPublisherServiceImpl
implements ISyncPublisherService {
    private static final Logger LOGGER = LoggerFactory.getLogger(SyncPublisherServiceImpl.class);
    @Resource
    private ISyncOrganPublisherService syncOrganPublisherService;
    @Resource
    private ISyncPostPublisherService syncPostPublisherService;
    @Resource
    private ISyncUserPublisherService syncUserPublisherService;
    @Resource
    private ISyncOrganService syncOrganService;
    @Resource
    private ISyncPostService syncPostService;
    @Resource
    private ISyncUserService syncUserService;

    public boolean isFirstSynchronization() {
        return this.syncOrganService.countForFirstSync();
    }

    @HussarDs(value="master")
    public synchronized void operationSync(String connName) {
        LOGGER.info("\u5f02\u5e38\u6570\u636e\u540c\u6b65\u5f00\u59cb\uff01");
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.in((Object)"PROCESSING_STATE", new Object[]{0, 2});
        queryWrapper.eq((Object)"CONN_NAME", (Object)connName);
        List existOrgan = this.syncOrganService.list((Wrapper)queryWrapper);
        LOGGER.info("\u540c\u6b65\u5f02\u5e38\u7ec4\u7ec7\u673a\u6784\u6570\u636e{}\u6761", (Object)existOrgan.size());
        if (!existOrgan.isEmpty()) {
            this.syncOrganPublisherService.saveOrganReal(existOrgan, connName, true);
        }
        List existPost = this.syncPostService.list((Wrapper)queryWrapper);
        LOGGER.info("\u540c\u6b65\u5f02\u5e38\u5c97\u4f4d\u6570\u636e{}\u6761", (Object)existPost.size());
        if (!existPost.isEmpty()) {
            this.syncPostPublisherService.savePostReal(existPost, connName, true);
        }
        List existUser = this.syncUserService.list((Wrapper)queryWrapper);
        LOGGER.info("\u540c\u6b65\u5f02\u5e38\u4eba\u5458\u6570\u636e{}\u6761", (Object)existUser.size());
        if (!existUser.isEmpty()) {
            this.syncUserPublisherService.saveUserReal(existUser, connName, true);
        }
        LOGGER.info("\u5f02\u5e38\u6570\u636e\u540c\u6b65\u6210\u529f\uff01");
    }

    @Async
    public void asyncOperationSync(String connName) {
        this.operationSync(connName);
    }
}

