/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.sync.publisher.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.jxdinfo.hussar.authorization.organ.model.SysOrganType;
import com.jxdinfo.hussar.authorization.post.model.SysPost;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import com.jxdinfo.hussar.sync.common.dto.SyncDataDto;
import com.jxdinfo.hussar.sync.common.dto.SyncOutsidePostDto;
import com.jxdinfo.hussar.sync.common.service.ISyncPostService;
import com.jxdinfo.hussar.sync.common.service.ISyncTenantService;
import com.jxdinfo.hussar.sync.common.service.ISysOrganTypeService;
import com.jxdinfo.hussar.sync.common.service.ISysPostService;
import com.jxdinfo.hussar.sync.publisher.mq.SyncPublisherRabbitMQTransmitter;
import com.jxdinfo.hussar.sync.publisher.service.ISyncPostPublisherService;
import com.jxdinfo.hussar.sync.publisher.service.ISyncPublisherService;
import com.jxdinfo.hussar.sync.publisher.util.SyncPostPublisherUtil;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class SyncPostPublisherServiceImpl
implements ISyncPostPublisherService {
    private static final Logger LOGGER = LoggerFactory.getLogger(SyncPostPublisherServiceImpl.class);
    @Resource
    private ISyncTenantService tenantService;
    @Resource
    private SyncPostPublisherUtil syncPostPublisherUtil;
    @Resource
    @Lazy
    private ISyncPublisherService syncPublisherService;
    @Resource
    private SyncPublisherRabbitMQTransmitter publisherRabbitMQTransmitter;
    @Resource
    private ISysPostService sysPostService;
    @Resource
    private ISysOrganTypeService organTypeService;
    @Resource
    private ISyncPostService syncPostService;
    private static final String LOG_FLAG = "\u5c97\u4f4d";

    public synchronized ApiResponse<?> savePost(List<SyncOutsidePostDto> post, String tenantCode, boolean isJob) {
        LOGGER.info("{}\u6570\u636e\u63a5\u6536\u5f00\u59cb!", (Object)LOG_FLAG);
        if (HussarUtils.isEmpty(post)) {
            LOGGER.error("{}\u63a5\u6536\u6570\u636e\u4e3a\u7a7a\uff01", (Object)LOG_FLAG);
            return ApiResponse.fail((String)"\u5c97\u4f4d\u63a5\u6536\u6570\u636e\u4e3a\u7a7a\uff01");
        }
        String connName = this.tenantService.getTenantByTenantCode(tenantCode);
        Object flag = HussarCacheUtil.get((String)"syncLock", (Object)connName);
        if (flag != null) {
            LOGGER.error("{}\u540c\u6b65\u9501\u5b9a\uff01", (Object)LOG_FLAG);
            return ApiResponse.fail((String)"\u5c97\u4f4d\u540c\u6b65\u9501\u5b9a\uff01");
        }
        HussarCacheUtil.put((String)"syncLock", (Object)connName, (Object)connName);
        return this.savePostReal(post, connName, isJob);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @HussarDs(value="connName")
    public ApiResponse<?> savePostReal(List<SyncOutsidePostDto> post, String connName, boolean isJob) {
        try {
            SyncDataDto message;
            boolean result;
            for (SyncOutsidePostDto SyncOutsidePostDto2 : post) {
                if (!isJob) {
                    SyncOutsidePostDto2.setConnName(connName);
                }
                SyncOutsidePostDto2.setProcessingState(3);
                SyncOutsidePostDto2.setPushTime(LocalDateTime.now());
            }
            boolean bl = this.syncPostService.saveOrUpdateByTenant(post);
            if (!bl) {
                SyncOutsidePostDto SyncOutsidePostDto2;
                LOGGER.error("{}\u63a5\u6536\u6570\u636e\u5931\u8d25\uff01", (Object)LOG_FLAG);
                SyncOutsidePostDto2 = ApiResponse.fail((String)"\u5c97\u4f4d\u63a5\u6536\u6570\u636e\u5931\u8d25\uff01");
                return SyncOutsidePostDto2;
            }
            LOGGER.info("{}\u539f\u59cb\u6570\u636e\u5df2\u5165\u5e93!", (Object)LOG_FLAG);
            ArrayList<SyncOutsidePostDto> verifyFail = new ArrayList<SyncOutsidePostDto>();
            List<Object> verifyPass = new ArrayList<SyncOutsidePostDto>();
            ArrayList<String> passId = new ArrayList<String>();
            ArrayList<String> passParentId = new ArrayList<String>();
            ArrayList<String> passPositionTypeCode = new ArrayList<String>();
            String isVerify = String.valueOf(this.publisherRabbitMQTransmitter.getSyncConfig(connName).get("is_data_sync_verify"));
            if (isJob || "1".equals(isVerify)) {
                this.syncPostPublisherUtil.verifyNotEmpty(post, verifyFail);
                if (!this.syncPublisherService.isFirstSynchronization() && !post.isEmpty()) {
                    ArrayList ids = new ArrayList();
                    post.forEach(a -> {
                        ids.add(a.getParentId());
                        ids.add(a.getId());
                    });
                    Function<Object, String> f = Object::toString;
                    List outPostIds = this.sysPostService.listObjs((Wrapper)new LambdaQueryWrapper().in(SysPost::getOutPostId, ids), f);
                    for (SyncOutsidePostDto syncOutsidePostDto : post) {
                        if (outPostIds.contains(syncOutsidePostDto.getParentId()) && syncOutsidePostDto.getProcessingState() != 2) {
                            syncOutsidePostDto.setProcessingState(2);
                            syncOutsidePostDto.setFailReason("\u7236\u5c97\u4f4d\u4e0d\u5b58\u5728");
                            verifyFail.add(syncOutsidePostDto);
                            continue;
                        }
                        if (outPostIds.contains(syncOutsidePostDto.getId())) {
                            syncOutsidePostDto.setOperationType(Integer.valueOf(2));
                        } else {
                            syncOutsidePostDto.setOperationType(Integer.valueOf(1));
                        }
                        passParentId.add(syncOutsidePostDto.getParentId());
                        passId.add(syncOutsidePostDto.getId());
                        passPositionTypeCode.add(syncOutsidePostDto.getPositionTypeCode());
                        verifyPass.add(syncOutsidePostDto);
                    }
                }
            }
            Function<Object, String> f = Object::toString;
            List po = this.sysPostService.list((Wrapper)new LambdaQueryWrapper().in(SysPost::getOutPostId, passId));
            List sysPostList = this.sysPostService.list((Wrapper)new LambdaQueryWrapper().in(SysPost::getOutPostId, passParentId));
            List organTypes = this.organTypeService.listObjs((Wrapper)new LambdaQueryWrapper().select(new SFunction[]{SysOrganType::getOrganType}).in(SysOrganType::getOrganType, passPositionTypeCode), f);
            List<Object> posts = new ArrayList();
            if (!verifyPass.isEmpty()) {
                posts = this.syncPostPublisherUtil.transformationPost(sysPostList, verifyPass, organTypes, verifyFail, po);
            }
            ArrayList<SyncOutsidePostDto> mergedList = new ArrayList<SyncOutsidePostDto>();
            mergedList.addAll(verifyFail);
            mergedList.addAll(verifyPass);
            if (!mergedList.isEmpty()) {
                this.syncPostService.saveOrUpdateByTenant(mergedList);
            }
            int state = (result = this.publisherRabbitMQTransmitter.send(connName, message = new SyncDataDto(connName, posts, Integer.valueOf(3)))) ? 1 : 2;
            String errorMsg = result ? "" : "\u6570\u636e\u6d88\u8d39\u65f6\u51fa\u73b0\u5f02\u5e38\uff0c\u8bf7\u901a\u8fc7\u65e5\u5fd7\u83b7\u53d6\u8be6\u7ec6\u4fe1\u606f\uff01";
            verifyPass = verifyPass.stream().map(a -> {
                a.setProcessingState(state);
                a.setFailReason(errorMsg);
                return a;
            }).collect(Collectors.toList());
            this.syncPostService.saveOrUpdateByTenant(verifyPass);
            if (!result) {
                LOGGER.error("{}\u6570\u636e\u6d88\u8d39\u65f6\u51fa\u73b0\u5f02\u5e38\uff0c\u8bf7\u901a\u8fc7\u65e5\u5fd7\u83b7\u53d6\u8be6\u7ec6\u4fe1\u606f\uff01", (Object)LOG_FLAG);
                ApiResponse apiResponse = ApiResponse.fail((String)"\u5c97\u4f4d\u6570\u636e\u6d88\u8d39\u65f6\u51fa\u73b0\u5f02\u5e38\uff0c\u8bf7\u901a\u8fc7\u65e5\u5fd7\u83b7\u53d6\u8be6\u7ec6\u4fe1\u606f\uff01");
                return apiResponse;
            }
            LOGGER.info("{}\u63a5\u6536\u6570\u636e\u6210\u529f\uff01", (Object)LOG_FLAG);
            ApiResponse apiResponse = ApiResponse.success();
            return apiResponse;
        }
        catch (Exception e) {
            LOGGER.error("errorMessage:{}", (Object)e.getMessage(), (Object)e);
            ApiResponse apiResponse = ApiResponse.fail((String)("\u5c97\u4f4d\u63a5\u6536\u6570\u636e\u5931\u8d25,\u7cfb\u7edf\u5f02\u5e38\uff01" + e));
            return apiResponse;
        }
        finally {
            HussarCacheUtil.evict((String)"syncLock", (Object)connName);
        }
    }
}

