/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.sync.publisher.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.jxdinfo.hussar.authorization.organ.model.SysOffice;
import com.jxdinfo.hussar.authorization.organ.model.SysOrgan;
import com.jxdinfo.hussar.authorization.organ.model.SysOrganType;
import com.jxdinfo.hussar.authorization.organ.model.SysStru;
import com.jxdinfo.hussar.authorization.organ.service.IHussarBaseOrganizationService;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.sequence.builder.SeqBuilder;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import com.jxdinfo.hussar.sync.common.dto.SyncDataDto;
import com.jxdinfo.hussar.sync.common.dto.SyncOutsideOrganDto;
import com.jxdinfo.hussar.sync.common.service.ISyncOrganService;
import com.jxdinfo.hussar.sync.common.service.ISyncTenantService;
import com.jxdinfo.hussar.sync.common.service.ISysEmployeeService;
import com.jxdinfo.hussar.sync.common.service.ISysOrganService;
import com.jxdinfo.hussar.sync.common.service.ISysOrganTypeService;
import com.jxdinfo.hussar.sync.publisher.mq.SyncPublisherRabbitMQTransmitter;
import com.jxdinfo.hussar.sync.publisher.service.ISyncOrganPublisherService;
import com.jxdinfo.hussar.sync.publisher.service.ISyncPublisherService;
import com.jxdinfo.hussar.sync.publisher.util.SyncOrganPublisherUtil;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class SyncOrganPublisherServiceImpl
implements ISyncOrganPublisherService {
    private static final Logger LOGGER = LoggerFactory.getLogger(SyncOrganPublisherServiceImpl.class);
    @Resource
    private ISyncTenantService tenantService;
    @Resource
    private ISyncOrganService syncOrganService;
    @Resource
    @Lazy
    private ISyncPublisherService syncPublisherService;
    @Resource
    private SyncPublisherRabbitMQTransmitter publisherRabbitMQTransmitter;
    @Resource
    private SyncOrganPublisherUtil syncOrganPublisherUtil;
    @Resource
    private ISysEmployeeService sysEmployeeService;
    @Resource
    private ISysOrganTypeService organTypeService;
    @Resource
    private ISyncOrganService sysOrganOutService;
    @Resource
    private ISysOrganService organService;
    @Resource
    private SeqBuilder seqBuilder;
    private static final String LOG_FLAG = "\u7ec4\u7ec7\u673a\u6784";

    public synchronized ApiResponse<?> saveOrgan(List<SyncOutsideOrganDto> addOrganizationDto, String tenantCode, boolean isJob) {
        LOGGER.info("{}\u6570\u636e\u63a5\u6536\u5f00\u59cb!", (Object)LOG_FLAG);
        if (HussarUtils.isEmpty(addOrganizationDto)) {
            LOGGER.error("{}\u63a5\u6536\u6570\u636e\u4e3a\u7a7a\uff01", (Object)LOG_FLAG);
            return ApiResponse.fail((String)"\u7ec4\u7ec7\u673a\u6784\u63a5\u6536\u6570\u636e\u4e3a\u7a7a\uff01");
        }
        String connName = this.tenantService.getTenantByTenantCode(tenantCode);
        Object flag = HussarCacheUtil.get((String)"syncLock", (Object)connName);
        if (flag != null) {
            LOGGER.error("{}\u540c\u6b65\u9501\u5b9a\uff01", (Object)LOG_FLAG);
            return ApiResponse.fail((String)"\u7ec4\u7ec7\u673a\u6784\u540c\u6b65\u9501\u5b9a\uff01");
        }
        HussarCacheUtil.put((String)"syncLock", (Object)connName, (Object)connName);
        return this.saveOrganReal(addOrganizationDto, connName, isJob);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @HussarDs(value="connName")
    public ApiResponse<?> saveOrganReal(List<SyncOutsideOrganDto> addOrganizationDto, String connName, boolean isJob) {
        try {
            SyncDataDto message;
            boolean result;
            for (SyncOutsideOrganDto syncOutsideOrganDto : addOrganizationDto) {
                if (!isJob) {
                    syncOutsideOrganDto.setConnName(connName);
                }
                syncOutsideOrganDto.setProcessingState(3);
                syncOutsideOrganDto.setPushTime(LocalDateTime.now());
            }
            boolean bl = this.syncOrganService.saveOrUpdateByTenant(addOrganizationDto);
            if (!bl) {
                SyncOutsideOrganDto syncOutsideOrganDto;
                LOGGER.error("{}\u63a5\u6536\u6570\u636e\u5931\u8d25\uff01", (Object)LOG_FLAG);
                syncOutsideOrganDto = ApiResponse.fail((String)"\u7ec4\u7ec7\u673a\u6784\u63a5\u6536\u6570\u636e\u5931\u8d25\uff01");
                return syncOutsideOrganDto;
            }
            LOGGER.info("{}\u539f\u59cb\u6570\u636e\u5df2\u5165\u5e93!", (Object)LOG_FLAG);
            ArrayList<SyncOutsideOrganDto> addList = new ArrayList<SyncOutsideOrganDto>();
            ArrayList<SyncOutsideOrganDto> verifyFail = new ArrayList<SyncOutsideOrganDto>();
            ArrayList<SyncOutsideOrganDto> verifyPass = new ArrayList();
            List<SyncOutsideOrganDto> allOut = addOrganizationDto;
            ArrayList<String> outIds = new ArrayList<String>();
            List<Object> parentAndCompanyId = new ArrayList();
            List allOutIds = new ArrayList();
            Function<Object, String> f = Object::toString;
            String isVerify = String.valueOf(this.publisherRabbitMQTransmitter.getSyncConfig(connName).get("is_data_sync_verify"));
            boolean firstSynchronization = this.syncPublisherService.isFirstSynchronization();
            if (isJob || "1".equals(isVerify)) {
                if (firstSynchronization && !addOrganizationDto.isEmpty()) {
                    this.syncOrganPublisherUtil.verifyNotEmpty(addOrganizationDto, verifyFail);
                    verifyPass = addOrganizationDto;
                    for (SyncOutsideOrganDto syncOutsideOrganDto : verifyPass) {
                        syncOutsideOrganDto.setOperationType(Integer.valueOf(1));
                    }
                } else if (!firstSynchronization && !addOrganizationDto.isEmpty()) {
                    this.syncOrganPublisherUtil.verifyNotEmpty(addOrganizationDto, verifyFail);
                    ArrayList ids = new ArrayList();
                    ArrayList parentIds = new ArrayList();
                    ArrayList types = new ArrayList();
                    addOrganizationDto.forEach(a -> {
                        ids.add(a.getParentId());
                        parentIds.add(a.getParentId());
                        ids.add(a.getId());
                        types.add(a.getCompanyCategoryCode());
                    });
                    List outStruIds = new ArrayList();
                    if (HussarUtils.isNotEmpty(ids)) {
                        outStruIds = this.sysEmployeeService.listObjs((Wrapper)new LambdaQueryWrapper().select(new SFunction[]{SysStru::getOutStruId}).in(SysStru::getOutStruId, ids), f);
                    }
                    List organTypes = new ArrayList();
                    if (HussarUtils.isNotEmpty(types)) {
                        organTypes = this.organTypeService.listObjs((Wrapper)new LambdaQueryWrapper().select(new SFunction[]{SysOrganType::getOrganType}).in(SysOrganType::getOrganType, types), f);
                    }
                    allOutIds = this.sysOrganOutService.getParentOutId(parentIds, connName);
                    for (SyncOutsideOrganDto syncOutsideOrganDto : addOrganizationDto) {
                        if (!(outStruIds.contains(syncOutsideOrganDto.getParentId()) || syncOutsideOrganDto.getParentId().equals("11") || allOutIds.contains(syncOutsideOrganDto.getParentId()))) {
                            syncOutsideOrganDto.setProcessingState(2);
                            syncOutsideOrganDto.setFailReason("\u7236\u7ea7\u7ec4\u7ec7\u4e0d\u5b58\u5728");
                            verifyFail.add(syncOutsideOrganDto);
                            continue;
                        }
                        String organType = StringUtils.trimToEmpty((String)syncOutsideOrganDto.getCompanyCategoryCode());
                        if (!organTypes.contains(organType)) {
                            syncOutsideOrganDto.setProcessingState(2);
                            syncOutsideOrganDto.setFailReason("\u4e0d\u5b58\u5728\u7684\u7ec4\u7ec7\u673a\u6784\u7c7b\u578b");
                            verifyFail.add(syncOutsideOrganDto);
                            continue;
                        }
                        syncOutsideOrganDto.setProcessingState(1);
                        syncOutsideOrganDto.setStruId(Long.valueOf(this.seqBuilder.build().nextValue()));
                        if (outStruIds.contains(syncOutsideOrganDto.getId())) {
                            syncOutsideOrganDto.setOperationType(Integer.valueOf(2));
                        } else {
                            syncOutsideOrganDto.setOperationType(Integer.valueOf(1));
                            addList.add(syncOutsideOrganDto);
                        }
                        outIds.add(syncOutsideOrganDto.getId());
                        parentAndCompanyId.add(syncOutsideOrganDto.getParentId());
                        parentAndCompanyId.add(syncOutsideOrganDto.getCompanyId());
                        verifyPass.add(syncOutsideOrganDto);
                    }
                }
            }
            ArrayList<SysStru> syncStruList = new ArrayList<SysStru>();
            ArrayList<SysOrgan> sysOrgans = new ArrayList<SysOrgan>();
            ArrayList<SysOffice> sysOffices = new ArrayList<SysOffice>();
            if (!verifyPass.isEmpty()) {
                ArrayList<SyncOutsideOrganDto> resultList = addList.isEmpty() ? new ArrayList<SyncOutsideOrganDto>() : addList;
                parentAndCompanyId = parentAndCompanyId.stream().filter(Objects::nonNull).collect(Collectors.toList());
                ArrayList<SysStru> struList = new ArrayList();
                if (HussarUtils.isNotEmpty(parentAndCompanyId)) {
                    struList = this.sysEmployeeService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().ne(SysStru::getStruType, (Object)9)).in(SysStru::getOutStruId, parentAndCompanyId));
                }
                List sysStruList = new ArrayList();
                if (HussarUtils.isNotEmpty(outIds)) {
                    sysStruList = this.sysEmployeeService.getStruByOutIds(outIds);
                }
                sysStruList.removeAll(Collections.singleton(null));
                Map<String, List<SysStru>> returnMap = sysStruList.stream().collect(Collectors.groupingBy(SysStru::getOutStruId));
                List organList = this.organService.list((Wrapper)Wrappers.lambdaQuery().ne(SysOrgan::getOrganType, (Object)"9"));
                this.syncOrganPublisherUtil.initialization(verifyPass, syncStruList, sysOrgans, sysOffices, resultList, struList, returnMap, verifyFail, organList, allOut, firstSynchronization);
            }
            ArrayList<Object> mergedList = new ArrayList<Object>();
            mergedList.addAll(verifyFail);
            mergedList.addAll(verifyPass);
            if (!mergedList.isEmpty()) {
                this.syncOrganService.saveOrUpdateByTenant(mergedList);
            }
            int state = (result = this.publisherRabbitMQTransmitter.send(connName, message = new SyncDataDto(connName, sysOrgans, sysOffices, syncStruList, Integer.valueOf(1)))) ? 1 : 2;
            String errorMsg = result ? "" : "\u6570\u636e\u6d88\u8d39\u65f6\u51fa\u73b0\u5f02\u5e38\uff0c\u8bf7\u901a\u8fc7\u65e5\u5fd7\u83b7\u53d6\u8be6\u7ec6\u4fe1\u606f\uff01";
            verifyPass = verifyPass.stream().map(a -> {
                a.setProcessingState(state);
                a.setFailReason(errorMsg);
                return a;
            }).collect(Collectors.toList());
            this.syncOrganService.saveOrUpdateByTenant(verifyPass);
            if (!result) {
                LOGGER.error("{}\u6570\u636e\u6d88\u8d39\u65f6\u51fa\u73b0\u5f02\u5e38\uff0c\u8bf7\u901a\u8fc7\u65e5\u5fd7\u83b7\u53d6\u8be6\u7ec6\u4fe1\u606f\uff01", (Object)LOG_FLAG);
                ApiResponse apiResponse = ApiResponse.fail((String)"\u7ec4\u7ec7\u673a\u6784\u6570\u636e\u6d88\u8d39\u65f6\u51fa\u73b0\u5f02\u5e38\uff0c\u8bf7\u901a\u8fc7\u65e5\u5fd7\u83b7\u53d6\u8be6\u7ec6\u4fe1\u606f\uff01");
                return apiResponse;
            }
            if (firstSynchronization) {
                CompletableFuture.runAsync(() -> ((IHussarBaseOrganizationService)SpringContextHolder.getBean(IHussarBaseOrganizationService.class)).refreshOrgan());
            }
            LOGGER.info("{}\u63a5\u6536\u6570\u636e\u6210\u529f\uff01", (Object)LOG_FLAG);
            ApiResponse apiResponse = ApiResponse.success();
            return apiResponse;
        }
        catch (Exception e) {
            LOGGER.error("errorMessage:{}", (Object)e.getMessage(), (Object)e);
            ApiResponse apiResponse = ApiResponse.fail((String)("\u7ec4\u7ec7\u673a\u6784\u63a5\u6536\u6570\u636e\u5931\u8d25,\u7cfb\u7edf\u5f02\u5e38\uff01" + e));
            return apiResponse;
        }
        finally {
            HussarCacheUtil.evict((String)"syncLock", (Object)connName);
        }
    }
}

