/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.sync.consumer.service.impl;

import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.sync.common.dto.SyncDataDto;
import com.jxdinfo.hussar.sync.common.dto.SyncOutsideUserDto;
import com.jxdinfo.hussar.sync.common.service.ISysOrganService;
import com.jxdinfo.hussar.sync.common.service.ISysStaffService;
import com.jxdinfo.hussar.sync.common.service.ISysStruService;
import com.jxdinfo.hussar.sync.common.service.ISysUsersService;
import com.jxdinfo.hussar.sync.consumer.dao.SyncUserOutMapper;
import com.jxdinfo.hussar.sync.consumer.service.ISyncConsumerService;
import com.jxdinfo.hussar.sync.consumer.service.ISyncUserConsumerService;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class SyncUserConsumerServiceImpl
extends HussarServiceImpl<SyncUserOutMapper, SyncOutsideUserDto>
implements ISyncUserConsumerService {
    private static final Logger LOGGER = LoggerFactory.getLogger(SyncUserConsumerServiceImpl.class);
    @Resource
    private ISysUsersService usersService;
    @Resource
    protected ISysStruService sysStruService;
    @Resource
    protected ISysStaffService sysStaffService;
    @Resource
    private ISysOrganService organService;
    @Resource
    private ISyncConsumerService syncConsumerService;
    private static final String LOG_FLAG = "\u7528\u6237";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @HussarDs(value="#connName")
    public void userSynchronization(String connName, SyncDataDto syncDataDto) {
        LOGGER.info("{}\u540c\u6b65\u5f00\u59cb\uff01", (Object)LOG_FLAG);
        String errorMsg = "";
        boolean isSuccess = true;
        try {
            List usersList = syncDataDto.getUsersList();
            List struList = syncDataDto.getStruList();
            List organList = syncDataDto.getOrganList();
            List staffList = syncDataDto.getStaffList();
            if (HussarUtils.hasEmpty((Object[])new Object[]{usersList, staffList, struList, organList}) || usersList.size() != staffList.size() || staffList.size() != organList.size() || organList.size() != struList.size()) {
                isSuccess = false;
                errorMsg = "\u7528\u6237\u540c\u6b65\u6570\u636e\u5f02\u5e38\uff01";
                LOGGER.error(errorMsg);
                throw new RuntimeException(errorMsg);
            }
            LOGGER.info("{}\u540c\u6b65\u6570\u636e{}\u6761", (Object)LOG_FLAG, (Object)usersList.size());
            this.organService.saveOrUpdateBatch((Collection)organList);
            this.sysStruService.saveOrUpdateBatch((Collection)struList);
            this.usersService.saveOrUpdateBatch((Collection)usersList);
            this.sysStaffService.saveOrUpdateBatch((Collection)staffList);
            LOGGER.info("{}\u540c\u6b65\u6210\u529f\uff01", (Object)LOG_FLAG);
        }
        catch (Exception e) {
            LOGGER.error("{}\u540c\u6b65\u5931\u8d25\uff0c\u9519\u8bef\u539f\u56e0{}", new Object[]{LOG_FLAG, e.getMessage(), e});
            errorMsg = e.getMessage();
            isSuccess = false;
        }
        finally {
            this.syncConsumerService.saveMqMessage(connName, syncDataDto.toString(), errorMsg, isSuccess);
        }
    }
}

