/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.sync.consumer.service.impl;

import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.sync.common.dto.SyncDataDto;
import com.jxdinfo.hussar.sync.common.dto.SyncOutsidePostDto;
import com.jxdinfo.hussar.sync.common.service.ISysPostService;
import com.jxdinfo.hussar.sync.consumer.dao.SyncPostOutMapper;
import com.jxdinfo.hussar.sync.consumer.service.ISyncConsumerService;
import com.jxdinfo.hussar.sync.consumer.service.ISyncPostConsumerService;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class SyncPostConsumerServiceImpl
extends HussarServiceImpl<SyncPostOutMapper, SyncOutsidePostDto>
implements ISyncPostConsumerService {
    private static final Logger LOGGER = LoggerFactory.getLogger(SyncPostConsumerServiceImpl.class);
    @Resource
    private ISysPostService sysPostService;
    @Resource
    private ISyncConsumerService syncConsumerService;
    private static final String LOG_FLAG = "\u5c97\u4f4d";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @HussarDs(value="#connName")
    public void postSynchronization(String connName, SyncDataDto syncDataDto) {
        LOGGER.info("{}\u540c\u6b65\u5f00\u59cb\uff01", (Object)LOG_FLAG);
        String errorMsg = "";
        boolean isSuccess = true;
        try {
            List postList = syncDataDto.getPostList();
            if (HussarUtils.isEmpty((Object)postList)) {
                isSuccess = false;
                errorMsg = "\u5c97\u4f4d\u540c\u6b65\u6570\u636e\u5f02\u5e38\uff01";
                LOGGER.error(errorMsg);
                throw new RuntimeException(errorMsg);
            }
            LOGGER.info("{}\u540c\u6b65\u6570\u636e{}\u6761", (Object)LOG_FLAG, (Object)postList.size());
            this.sysPostService.saveOrUpdateBatch((Collection)postList);
            LOGGER.info("{}\u540c\u6b65\u6210\u529f\uff01", (Object)LOG_FLAG);
        }
        catch (Exception e) {
            LOGGER.error("{}\u540c\u6b65\u5931\u8d25\uff0c\u9519\u8bef\u539f\u56e0{}", new Object[]{LOG_FLAG, e.getMessage(), e});
            errorMsg = e.getMessage();
            isSuccess = false;
        }
        finally {
            this.syncConsumerService.saveMqMessage(connName, syncDataDto.toString(), errorMsg, isSuccess);
        }
    }
}

