/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.sync.consumer.service.impl;

import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.sync.common.dto.SyncDataDto;
import com.jxdinfo.hussar.sync.common.dto.SyncOutsideOrganDto;
import com.jxdinfo.hussar.sync.common.service.ISysOfficeService;
import com.jxdinfo.hussar.sync.common.service.ISysOrganService;
import com.jxdinfo.hussar.sync.common.service.ISysStruService;
import com.jxdinfo.hussar.sync.consumer.dao.SyncOrganOutMapper;
import com.jxdinfo.hussar.sync.consumer.service.ISyncConsumerService;
import com.jxdinfo.hussar.sync.consumer.service.ISyncOrganConsumerService;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class SyncOrganConsumerServiceImpl
extends HussarServiceImpl<SyncOrganOutMapper, SyncOutsideOrganDto>
implements ISyncOrganConsumerService {
    private static final Logger LOGGER = LoggerFactory.getLogger(SyncOrganConsumerServiceImpl.class);
    @Resource
    private ISysOrganService organService;
    @Resource
    private ISysStruService sysStruService;
    @Resource
    private ISysOfficeService sysOfficeService;
    @Resource
    private ISyncConsumerService syncConsumerService;
    private static final String LOG_FLAG = "\u7ec4\u7ec7\u673a\u6784";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @HussarDs(value="#connName")
    public void organSynchronization(String connName, SyncDataDto syncDataDto) {
        LOGGER.info("{}\u540c\u6b65\u5f00\u59cb\uff01", (Object)LOG_FLAG);
        String errorMsg = "";
        boolean isSuccess = true;
        try {
            List organList = syncDataDto.getOrganList();
            List officeList = syncDataDto.getOfficeList();
            List struList = syncDataDto.getStruList();
            if (HussarUtils.hasEmpty((Object[])new Object[]{organList, officeList, struList}) || organList.size() != officeList.size() || officeList.size() != struList.size()) {
                isSuccess = false;
                errorMsg = "\u7ec4\u7ec7\u673a\u6784\u540c\u6b65\u6570\u636e\u5f02\u5e38\uff01";
                LOGGER.error(errorMsg);
                throw new RuntimeException(errorMsg);
            }
            LOGGER.info("{}\u540c\u6b65\u6570\u636e{}\u6761", (Object)LOG_FLAG, (Object)organList.size());
            this.organService.saveOrUpdateBatch((Collection)organList);
            this.sysOfficeService.saveOrUpdateBatch((Collection)officeList);
            this.sysStruService.saveOrUpdateBatch((Collection)struList);
            LOGGER.info("{}\u540c\u6b65\u6210\u529f\uff01", (Object)LOG_FLAG);
        }
        catch (Exception e) {
            LOGGER.error("{}\u540c\u6b65\u5931\u8d25\uff0c\u9519\u8bef\u539f\u56e0{}", new Object[]{LOG_FLAG, e.getMessage(), e});
            errorMsg = e.getMessage();
            isSuccess = false;
        }
        finally {
            this.syncConsumerService.saveMqMessage(connName, syncDataDto.toString(), errorMsg, isSuccess);
        }
    }
}

