/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.sync.consumer.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.hussar.consumer.model.SysConsumerRecord;
import com.jxdinfo.hussar.sync.common.dto.SyncDataDto;
import com.jxdinfo.hussar.sync.common.service.impl.SyncDataService;
import com.jxdinfo.hussar.sync.consumer.dao.SysConsumerRecordMapper;
import com.jxdinfo.hussar.sync.consumer.service.ISyncConsumerService;
import com.jxdinfo.hussar.sync.consumer.service.ISyncOrganConsumerService;
import com.jxdinfo.hussar.sync.consumer.service.ISyncPostConsumerService;
import com.jxdinfo.hussar.sync.consumer.service.ISyncUserConsumerService;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.Message;
import org.springframework.stereotype.Service;

@Service
public class SyncConsumerServiceImpl
extends ServiceImpl<SysConsumerRecordMapper, SysConsumerRecord>
implements ISyncConsumerService {
    private static final Logger LOGGER = LoggerFactory.getLogger(SyncConsumerServiceImpl.class);
    @Resource
    private ISyncOrganConsumerService syncOrganConsumerService;
    @Resource
    private ISyncPostConsumerService syncPostConsumerService;
    @Resource
    private ISyncUserConsumerService syncUserConsumerService;
    @Resource
    private SyncDataService syncDataService;

    public void dataSynchronization(Message message) {
        String json = new String(message.getBody(), StandardCharsets.UTF_8);
        SyncDataDto syncDataDto = (SyncDataDto)JSONObject.parseObject((String)json, SyncDataDto.class);
        String connName = syncDataDto.getConnName();
        Integer type = syncDataDto.getFlag();
        switch (type) {
            case 1: {
                this.syncOrganConsumerService.organSynchronization(connName, syncDataDto);
                break;
            }
            case 2: {
                this.syncUserConsumerService.userSynchronization(connName, syncDataDto);
                break;
            }
            case 3: {
                this.syncPostConsumerService.postSynchronization(connName, syncDataDto);
                break;
            }
        }
        this.syncDataService.doJobAfterSyncEnd(connName);
    }

    public void saveMqMessage(String queuesName, String json, String errorMsg, boolean isSuccess) {
        SysConsumerRecord sysConsumerRecord = new SysConsumerRecord();
        sysConsumerRecord.setQueueName(queuesName);
        sysConsumerRecord.setMessage(json);
        sysConsumerRecord.setCreateTime(LocalDateTime.now());
        if (isSuccess) {
            sysConsumerRecord.setConsumeStatus("0");
        } else {
            sysConsumerRecord.setProcessingStatus("1");
            sysConsumerRecord.setConsumeStatus("1");
            sysConsumerRecord.setErrorInfo(errorMsg);
        }
        this.save(sysConsumerRecord);
    }
}

