/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.sync.consumer.config;

import com.jxdinfo.hussar.sync.common.service.ISyncTenantService;
import com.jxdinfo.hussar.sync.consumer.properties.SyncConsumerProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.amqp.core.AmqpAdmin;
import org.springframework.amqp.core.Binding;
import org.springframework.amqp.core.BindingBuilder;
import org.springframework.amqp.core.Queue;
import org.springframework.amqp.core.TopicExchange;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.core.RedisTemplate;

@Configuration
public class SyncConsumerRabbitMQConfig {
    @Resource
    private SyncConsumerProperties consumerProperties;
    @Resource
    private AmqpAdmin amqpAdmin;
    @Resource
    private ISyncTenantService tenantService;
    @Resource
    private RedisTemplate redisTemplate;
    private static final String DEFAULT_CONN_NAME = "master";
    private static final Map<String, Object> ARGUMENTS = new HashMap<String, Object>(2);

    @Bean(value={"topicExchange"})
    public TopicExchange topicExchange() {
        return new TopicExchange("topicExchange", true, false);
    }

    @Bean(value={"initQueueBindingForSync"})
    public void initQueueBindingForSync() {
        List allTenant = this.tenantService.getAllTenant();
        allTenant.add(DEFAULT_CONN_NAME);
        List queueNames = this.consumerProperties.getListenerQueues();
        allTenant.addAll(queueNames);
        HashSet newQueue = new HashSet(allTenant);
        for (String queueName : newQueue) {
            Queue queue = new Queue(queueName, true, false, false, ARGUMENTS);
            this.amqpAdmin.declareQueue(queue);
            Binding bindingBuilder = BindingBuilder.bind((Queue)queue).to(this.topicExchange()).with(queueName);
            this.amqpAdmin.declareBinding(bindingBuilder);
        }
        this.redisTemplate.opsForValue().set((Object)"queueList", newQueue);
    }

    static {
        ARGUMENTS.put("x-queue-type", "classic");
    }
}

