/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.sync.eryuan.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.dynamic.datasource.annotation.Master;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.authorization.audit.service.ISysStruAuditService;
import com.jxdinfo.hussar.authorization.organ.dao.SysStaffMapper;
import com.jxdinfo.hussar.authorization.organ.manager.EditOrganizationManager;
import com.jxdinfo.hussar.authorization.organ.model.SysOffice;
import com.jxdinfo.hussar.authorization.organ.model.SysOrgan;
import com.jxdinfo.hussar.authorization.organ.model.SysStaff;
import com.jxdinfo.hussar.authorization.organ.model.SysStru;
import com.jxdinfo.hussar.authorization.organ.service.ISysOrganService;
import com.jxdinfo.hussar.authorization.organ.service.ISysStaffService;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.ISysUsersService;
import com.jxdinfo.hussar.base.config.baseconfig.service.ICreateUserConfigService;
import com.jxdinfo.hussar.base.config.baseconfig.service.IHussarPwdConfigService;
import com.jxdinfo.hussar.common.constant.state.UserStatus;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.common.utils.CopyPropertieUtils;
import com.jxdinfo.hussar.common.utils.GeneratePassword;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.general.idtable.service.ISysIdtableService;
import com.jxdinfo.hussar.otp.credential.AbstractOTPCredentialsMatcher;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.crypto.credential.AbstractCredentialsMatcher;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.mp.plugin.encrypt.support.Encrypt;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import com.jxdinfo.hussar.sync.eryuan.bo.SyncOrgDataBo;
import com.jxdinfo.hussar.sync.eryuan.dao.SyncStruMapper;
import com.jxdinfo.hussar.sync.eryuan.dao.SyncUsersMapper;
import com.jxdinfo.hussar.sync.eryuan.dao.UumLogMapper;
import com.jxdinfo.hussar.sync.eryuan.model.SysFormerlyOrgan;
import com.jxdinfo.hussar.sync.eryuan.model.UumLog;
import com.jxdinfo.hussar.sync.eryuan.model.UumOperator;
import com.jxdinfo.hussar.sync.eryuan.model.UumOrganization;
import com.jxdinfo.hussar.sync.eryuan.model.UumWebserviceLog;
import com.jxdinfo.hussar.sync.eryuan.service.ISyncDataService;
import com.jxdinfo.hussar.sync.eryuan.service.ISyncFormerlyOrgService;
import com.jxdinfo.hussar.sync.eryuan.service.ISyncStruService;
import com.jxdinfo.hussar.sync.eryuan.service.ISyncUserRolesService;
import com.jxdinfo.hussar.sync.eryuan.service.ISyncUsersService;
import com.jxdinfo.hussar.sync.eryuan.service.ISysFormerlyOrganService;
import com.jxdinfo.hussar.sync.eryuan.service.IUumLogService;
import com.jxdinfo.hussar.sync.eryuan.service.IUumOperatorService;
import com.jxdinfo.hussar.sync.eryuan.service.IUumOrganizationService;
import com.jxdinfo.hussar.sync.eryuan.service.IUumWebserviceLogService;
import com.jxdinfo.hussar.tenant.groupingmodel.service.SyncTenantStruUserStaffService;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.xml.namespace.QName;
import javax.xml.rpc.ParameterMode;
import org.apache.axis.client.Call;
import org.apache.axis.encoding.XMLType;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.tree.DefaultElement;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
@Master
public class SyncDataServiceImpl
implements ISyncDataService {
    @Value(value="${webservice.url:http://192.168.6.99/axis/services/BizService}")
    private String url;
    @Value(value="${webservice.packageName:uum}")
    private String packageName;
    @Value(value="${webservice.unitId:0}")
    private String unitId;
    @Value(value="${webservice.processName:bizWebService.bizQueryOrgEmp}")
    private String processName;
    @Value(value="${webservice.sysID:tianxin}")
    private String sysID;
    @Value(value="${webservice.tranferStruId:1}")
    private String tranferStruId;
    @Value(value="${webservice.flightCode:99999}")
    private String flightCode;
    @Value(value="${webservice.hospitalCode:001000}")
    private String hospitalCode;
    @Value(value="${webservice.sixthCenterCode:003216}")
    private String sixthCenterCode;
    @Value(value="${webservice.maxOrgLevel:6}")
    private int maxOrgLevel;
    @Resource
    private ISysIdtableService sysIdtableService;
    @Autowired
    private SyncStruMapper syncStruMapper;
    @Autowired
    private SyncUsersMapper syncUsersMapper;
    @Resource
    private IUumWebserviceLogService uumWebserviceLogService;
    @Resource
    private IUumOrganizationService uumOrganizationService;
    @Resource
    private IUumOperatorService uumOperatorService;
    @Resource
    private IUumLogService uumLogService;
    @Resource
    private UumLogMapper uumLogMapper;
    @Resource
    private ISyncUserRolesService sysUserRolesUtilService;
    @Autowired
    private ISysStruAuditService sysStruAuditService;
    @Resource
    private SysStaffMapper sysStaffMapper;
    @Resource
    private ISyncUsersService syncUsersService;
    @Autowired
    private AbstractOTPCredentialsMatcher abstractOTPCredentialsMatcher;
    @Autowired
    private ICreateUserConfigService createUserConfigService;
    @Autowired
    private IHussarPwdConfigService hussarPwdConfigService;
    @Autowired
    private SyncTenantStruUserStaffService syncTenantStruUserStaffService;
    @Resource
    private AbstractCredentialsMatcher credentialsMatcher;
    @Resource
    private ISyncFormerlyOrgService syncFormerlyOrgService;
    @Resource
    private ISysOrganService organService;
    @Resource
    private ISysFormerlyOrganService formerlyOrganService;
    @Autowired
    private EditOrganizationManager editOrganizationManager;
    @Autowired
    private ISysStaffService sysStaffService;
    @Autowired
    private Encrypt secret;
    @Autowired
    private ISyncStruService syncStruService;
    @Autowired
    private ISysUsersService sysUsersService;

    @HussarTransactional
    public ApiResponse<?> syncData() {
        HussarCacheUtil.put((String)"sync_info", (Object)"sync_status", (Object)true);
        System.out.println("\u7edf\u4e00\u7528\u6237\u5f00\u59cb");
        HashMap<String, String> map = new HashMap<String, String>();
        long funcStartTime = System.currentTimeMillis();
        List<UumOrganization> orgList = new ArrayList();
        List<UumOperator> userList = new ArrayList();
        ArrayList<Long> logIdList = new ArrayList<Long>();
        Long userId = null;
        SecurityUser shiroUser = null;
        try {
            try {
                shiroUser = BaseSecurityUtil.getUser();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (ToolUtil.isNotEmpty((Object)shiroUser)) {
                userId = shiroUser.getId();
            }
            UumLog uumLog = new UumLog();
            uumLog.setCreator(userId);
            uumLog.setStartTime(LocalDateTime.now());
            uumLog.setStatus("0");
            this.uumLogService.save((Object)uumLog);
            Long docID = uumLog.getDocID();
            System.out.println("\u83b7\u53d6\u53ca\u5b58\u50a8\u4e34\u65f6\u6570\u636e\u5f00\u59cb");
            long getStartTime = System.currentTimeMillis();
            String msg = this.getData(true, logIdList, docID);
            long getEndTime = System.currentTimeMillis();
            System.out.println("\u83b7\u53d6\u53ca\u5b58\u50a8\u4e34\u65f6\u6570\u636e\u7ed3\u675f");
            System.out.println("\u83b7\u53d6\u53ca\u5b58\u50a8\u4e34\u65f6\u6570\u636e\u65f6\u95f4\uff1a" + (getEndTime - getStartTime) / 1000L + "s");
            if (!"".equals(msg)) {
                System.out.println(msg);
                System.out.println("\u7edf\u4e00\u7528\u6237\u7ed3\u675f");
                uumLog.setEndTime(LocalDateTime.now());
                uumLog.setStatus("3");
                this.uumLogService.updateById((Object)uumLog);
                HussarCacheUtil.evict((String)"sync_info", (Object)"sync_status");
                return ApiResponse.fail((String)msg);
            }
            QueryWrapper ew = new QueryWrapper();
            ew.in((Object)"UUMID", logIdList);
            ew.eq((Object)"RSTATUS", (Object)"0");
            ew.orderByAsc((Object)"DISPTIME", (Object[])new String[]{"GETORDER"});
            orgList = this.uumOrganizationService.list((Wrapper)ew);
            QueryWrapper qw = new QueryWrapper();
            qw.in((Object)"UUMID", logIdList);
            qw.eq((Object)"RSTATUS", (Object)"0");
            qw.orderByAsc((Object)"DISPTIME", (Object[])new String[]{"GETORDER"});
            userList = this.uumOperatorService.list((Wrapper)qw);
            int orgSize = orgList.size();
            int userSize = userList.size();
            int orgFail = 0;
            int userFail = 0;
            uumLog.setStatus("1");
            uumLog.setOrgTotalNum(Integer.valueOf(orgSize));
            uumLog.setUserTotalNum(Integer.valueOf(userSize));
            this.uumLogService.updateById((Object)uumLog);
            System.out.println("\u5904\u7406\u6570\u636e\u5f00\u59cb");
            long dealStartTime = System.currentTimeMillis();
            Map<String, Object> orgResult = this.dealOrg(orgList);
            if (ToolUtil.isNotEmpty(orgResult)) {
                Object failNum = orgResult.get("orgFail");
                orgFail = Integer.parseInt(failNum.toString());
            }
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("orgFail", orgFail);
            orgFail = this.recursionDealUser(logIdList, param, 0);
            uumLog.setStatus("2");
            uumLog.setOrgFailNum(Integer.valueOf(orgFail));
            this.uumLogService.updateById((Object)uumLog);
            Map<String, Object> userResult = this.dealUser(userList);
            long dealEndTime = System.currentTimeMillis();
            System.out.println("\u5904\u7406\u6570\u636e\u7ed3\u675f");
            System.out.println("\u5904\u7406\u6570\u636e\u65f6\u95f4\uff1a" + (dealEndTime - dealStartTime) / 1000L + "s");
            if (ToolUtil.isNotEmpty(userResult)) {
                Object failNum = userResult.get("userFail");
                userFail = Integer.parseInt(failNum.toString());
            }
            String returnMsg = "\u5171" + orgSize + "\u6761\u7ec4\u7ec7\u6570\u636e,\u5931\u8d25" + orgFail + "\u6761\uff1b\u5171" + userSize + "\u6761\u7528\u6237\u6570\u636e,\u5931\u8d25" + userFail + "\u6761\u3002";
            map.put("msg", returnMsg);
            System.out.println(returnMsg);
            long endTime = System.currentTimeMillis();
            System.out.println("\u7edf\u4e00\u7528\u6237\u7ed3\u675f");
            System.out.println("\u7edf\u4e00\u7528\u6237\u6267\u884c\u603b\u65f6\u95f4\uff1a" + (endTime - funcStartTime) / 1000L + "s");
            uumLog.setEndTime(LocalDateTime.now());
            uumLog.setStatus("3");
            uumLog.setUserFailNum(Integer.valueOf(userFail));
            this.uumLogService.updateById((Object)uumLog);
            this.editOrganizationManager.refreshOrgan();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        HussarCacheUtil.evict((String)"sync_info", (Object)"sync_status");
        return ApiResponse.success(map);
    }

    private String getData(boolean isCirclePull, List<Long> logIdList, Long docID) {
        UumWebserviceLog webserviceLog = new UumWebserviceLog();
        webserviceLog.setLogID(docID);
        webserviceLog.setCreateTime(LocalDateTime.now());
        String bizStr = "";
        try {
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            parameters.put("mqID", this.sysID + "-UUM");
            bizStr = this.webService("getMq", parameters);
            if ("".equals(bizStr)) {
                webserviceLog.setXmlList(bizStr);
                webserviceLog.setAnalyzeResult("0");
                webserviceLog.setOp("\u6ca1\u6709\u5f85\u540c\u6b65\u7684\u6570\u636e\u4e86\uff01");
                this.uumWebserviceLogService.save((Object)webserviceLog);
                return "\u6682\u65e0\u5f85\u540c\u6b65\u7684\u6570\u636e\uff01";
            }
            if ("E".equals(bizStr)) {
                webserviceLog.setAnalyzeResult("0");
                webserviceLog.setOp("\u88ab\u8c03\u7528\u7684\u670d\u52a1\u62a5\u51fa\u5f02\u5e38");
                this.uumWebserviceLogService.save((Object)webserviceLog);
                return "\u540c\u6b65\u5931\u8d25\uff01\u88ab\u8c03\u7528\u7684\u670d\u52a1\u62a5\u51fa\u5f02\u5e38\uff01";
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            webserviceLog.setAnalyzeResult("0");
            webserviceLog.setOp("\u8c03\u7528\u670d\u52a1\u5931\u8d25");
            this.uumWebserviceLogService.save((Object)webserviceLog);
            return "\u540c\u6b65\u5931\u8d25\uff01\u8c03\u7528\u670d\u52a1\u5931\u8d25\uff01";
        }
        webserviceLog.setXmlList(bizStr);
        webserviceLog.setAnalyzeResult("0");
        webserviceLog.setOp("\u6210\u529f");
        this.uumWebserviceLogService.save((Object)webserviceLog);
        logIdList.add(webserviceLog.getDocID());
        Document doc = null;
        try {
            doc = DocumentHelper.parseText((String)bizStr);
        }
        catch (DocumentException e) {
            e.printStackTrace();
        }
        List listNodes = doc.selectNodes("/root/data/list");
        if (ToolUtil.isNotEmpty((Object)listNodes)) {
            for (Object listNode : listNodes) {
                List uumOrganizationDispList;
                String orgNum;
                int orgSize;
                Attribute tmpRowNum;
                DefaultElement listInfo = (DefaultElement)listNode;
                Attribute tmpName = listInfo.attribute("name");
                String type = tmpName.getText();
                if ("UumOperatorDisp".equals(type)) {
                    List uumOperatorDispList;
                    tmpRowNum = listInfo.attribute("rowNum");
                    String userNum = tmpRowNum.getText();
                    int userSize = Integer.parseInt(userNum);
                    if (userSize <= 0 || (uumOperatorDispList = listInfo.content()) == null || uumOperatorDispList.isEmpty()) continue;
                    this.getUserDataList(uumOperatorDispList, webserviceLog.getDocID());
                    continue;
                }
                if (!"UumOrganizationDisp".equals(type) || (orgSize = Integer.parseInt(orgNum = (tmpRowNum = listInfo.attribute("rowNum")).getText())) <= 0 || (uumOrganizationDispList = listInfo.content()) == null || uumOrganizationDispList.isEmpty()) continue;
                this.getOrgDataList(uumOrganizationDispList, webserviceLog.getDocID());
            }
        }
        if (ToolUtil.isNotEmpty((Object)webserviceLog.getDocID())) {
            UumWebserviceLog tmp = new UumWebserviceLog();
            tmp.setDocID(webserviceLog.getDocID());
            tmp.setAnalyzeResult("1");
            tmp.setOp("\u6210\u529f");
            this.uumWebserviceLogService.updateById((Object)tmp);
        }
        try {
            Object dataNodes = doc.selectObject("/root/data");
            DefaultElement dataInfo = (DefaultElement)dataNodes;
            Attribute tmpName = dataInfo.attribute("disid");
            String disid = tmpName.getText();
            String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<info><result>S</result><disid>" + disid + "</disid><message>\u66f4\u65b0\u6210\u529f\uff01</message></info>";
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            parameters.put("str", xml);
            String updateDistributeStateStr = this.webService("updateDistributeState", parameters);
            System.out.println("\u8c03\u7528web\u670d\u52a1updateDistributeState\uff1a" + updateDistributeStateStr);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (isCirclePull) {
            this.getData(isCirclePull, logIdList, docID);
        }
        return "";
    }

    private String webService(String method, Map<String, Object> parameters) throws Exception {
        org.apache.axis.client.Service service = new org.apache.axis.client.Service();
        Call call = (Call)service.createCall();
        call.setUseSOAPAction(true);
        call.setTargetEndpointAddress(new URL(this.url));
        call.setOperationName(new QName("http://webService.service.zsjgl._000000.hussar.jxdinfo.com/", method));
        call.setUseSOAPAction(true);
        Object[] paraValues = new Object[parameters.size()];
        Iterator<String> iterator = parameters.keySet().iterator();
        int i = 0;
        while (iterator.hasNext()) {
            String key = iterator.next();
            paraValues[i++] = parameters.get(key);
            call.addParameter(key, XMLType.XSD_STRING, ParameterMode.IN);
        }
        call.setReturnType(XMLType.XSD_STRING);
        Object ret = call.invoke(paraValues);
        return ret.toString();
    }

    private void getUserDataList(List uumOperatorDispList, Long uumID) {
        int t = 0;
        ArrayList<UumOperator> tempList = new ArrayList<UumOperator>();
        for (Object xmlInfo : uumOperatorDispList) {
            DefaultElement element;
            List userList;
            if (!(xmlInfo instanceof DefaultElement) || (userList = (element = (DefaultElement)xmlInfo).content()) == null || userList.isEmpty()) continue;
            UumOperator operator = new UumOperator();
            operator.setUumID(uumID);
            operator.setGetOrder(Integer.valueOf(++t));
            operator.setrStatus("0");
            operator.setrMessage("\u672a\u5904\u7406");
            for (Object userContent : userList) {
                DefaultElement userInfo = (DefaultElement)userContent;
                String text = "";
                if (!StringUtils.isNotEmpty((CharSequence)userInfo.getText())) continue;
                text = userInfo.getText();
                switch (userInfo.getQName().getName()) {
                    case "pID": {
                        operator.setpID(text);
                        break;
                    }
                    case "operatorName": {
                        operator.setOperatorName(text);
                        break;
                    }
                    case "casicOrgCode": {
                        operator.setCasicOrgCode(text);
                        break;
                    }
                    case "syncType": {
                        operator.setSyncType(text);
                        break;
                    }
                    case "sysID": {
                        operator.setSysID(text);
                        break;
                    }
                    case "empCode": {
                        operator.setEmpCode(text);
                        break;
                    }
                    case "secretLevel": {
                        operator.setSecretLevel(text);
                        break;
                    }
                    case "birthDate": {
                        if (text.length() < 8) break;
                        Comparable<Date> time = this.textToDate(text);
                        operator.setBirthDate(time);
                        break;
                    }
                    case "gender": {
                        operator.setGender(text);
                        break;
                    }
                    case "oTel": {
                        operator.setoTel(text);
                        break;
                    }
                    case "oEmail": {
                        operator.setoEmail(text);
                        break;
                    }
                    case "workPost": {
                        operator.setWorkPost(text);
                        break;
                    }
                    case "tecPost": {
                        operator.setTecPost(text);
                        break;
                    }
                    case "orderID": {
                        operator.setOrderID(Integer.valueOf(Integer.parseInt(text)));
                        break;
                    }
                    case "dispTime": {
                        if (text.length() < 14) break;
                        Comparable<Date> time = this.textToTime(text);
                        operator.setDispTime((LocalDateTime)time);
                        break;
                    }
                    case "remark": {
                        operator.setRemark(text);
                        break;
                    }
                    case "refa": {
                        operator.setRefa(text);
                        break;
                    }
                    case "refb": {
                        operator.setRefb(text);
                        break;
                    }
                    case "orgName": {
                        operator.setOrgName(text);
                    }
                }
            }
            tempList.add(operator);
        }
        if (!tempList.isEmpty()) {
            this.uumOperatorService.saveBatch(tempList);
        }
    }

    private void getOrgDataList(List uumOrganizationDispList, Long uumID) {
        int t = 0;
        ArrayList<UumOrganization> tempList = new ArrayList<UumOrganization>();
        for (Object xmlInfo : uumOrganizationDispList) {
            DefaultElement element;
            List organList;
            if (!(xmlInfo instanceof DefaultElement) || (organList = (element = (DefaultElement)xmlInfo).content()) == null || organList.isEmpty()) continue;
            UumOrganization organization = new UumOrganization();
            organization.setUumID(uumID);
            organization.setGetOrder(Integer.valueOf(++t));
            organization.setrStatus("0");
            organization.setrMessage("\u672a\u5904\u7406");
            for (Object organContent : organList) {
                DefaultElement organInfo = (DefaultElement)organContent;
                String text = "";
                if (!ToolUtil.isNotEmpty((Object)organInfo.getText())) continue;
                text = organInfo.getText();
                switch (organInfo.getQName().getName()) {
                    case "casicOrgCode": {
                        organization.setCasicOrgCode(text);
                        break;
                    }
                    case "orgName": {
                        organization.setOrgName(text);
                        break;
                    }
                    case "casicPOrgCode": {
                        organization.setCasicPOrgCode(text);
                        break;
                    }
                    case "syncType": {
                        organization.setSyncType(text);
                        break;
                    }
                    case "sysID": {
                        organization.setSysID(text);
                        break;
                    }
                    case "orgLevel": {
                        organization.setOrgLevel(Integer.valueOf(Integer.parseInt(text)));
                        break;
                    }
                    case "casicOrgSecret": {
                        organization.setCasicOrgSecret(text);
                        break;
                    }
                    case "externalName": {
                        organization.setExternalName(text);
                        break;
                    }
                    case "remark": {
                        organization.setRemark(text);
                        break;
                    }
                    case "orderID": {
                        organization.setOrderID(Integer.valueOf(Integer.parseInt(text)));
                        break;
                    }
                    case "dispTime": {
                        if (text.length() < 14) break;
                        LocalDateTime time = this.textToTime(text);
                        organization.setDispTime(time);
                        break;
                    }
                    case "status": {
                        organization.setStatus(text);
                        break;
                    }
                    case "refa": {
                        organization.setRefa(text);
                        break;
                    }
                    case "refb": {
                        organization.setRefb(text);
                        break;
                    }
                    case "orgCode": {
                        organization.setOrgCode(text);
                        break;
                    }
                    case "orgCodes": {
                        organization.setOrgCodes(text);
                        break;
                    }
                    case "orgNames": {
                        organization.setOrgNames(text);
                        break;
                    }
                    case "miltCode": {
                        organization.setMiltCode(text);
                        break;
                    }
                    case "orgnationCode": {
                        organization.setOrgnationCode(text);
                        break;
                    }
                    case "creditCode": {
                        organization.setCreditCode(text);
                        break;
                    }
                    case "country": {
                        organization.setCountry(text);
                        break;
                    }
                    case "province": {
                        organization.setProvince(text);
                        break;
                    }
                    case "city": {
                        organization.setCity(text);
                        break;
                    }
                    case "areaCounty": {
                        organization.setAreaCounty(text);
                        break;
                    }
                    case "languages": {
                        organization.setLanguages(text);
                        break;
                    }
                    case "currency": {
                        organization.setCurrency(text);
                        break;
                    }
                    case "inforLevel": {
                        organization.setInforLevel(text);
                        break;
                    }
                    case "orgNature": {
                        organization.setOrgNature(text);
                        break;
                    }
                    case "immeupOrg": {
                        organization.setImmeupOrg(text);
                        break;
                    }
                    case "orgManLevel": {
                        organization.setOrgManLevel(text);
                        break;
                    }
                    case "isLtCompany": {
                        organization.setIsLtCompany(text);
                        break;
                    }
                    case "fillTwoOrg": {
                        organization.setFillTwoOrg(text);
                        break;
                    }
                    case "fillThrOrg": {
                        organization.setFillThrOrg(text);
                        break;
                    }
                    case "erpComCode": {
                        organization.setErpComCode(text);
                        break;
                    }
                    case "orderNumber": {
                        organization.setOrderNumber(text);
                        break;
                    }
                    case "induclass": {
                        organization.setInduclass(text);
                    }
                }
            }
            tempList.add(organization);
        }
        if (!tempList.isEmpty()) {
            this.uumOrganizationService.saveBatch(tempList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Object> dealOrg(List<UumOrganization> orgList) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        int orgFail = 0;
        int t = 0;
        ArrayList<SyncOrgDataBo> updateList = new ArrayList<SyncOrgDataBo>();
        ArrayList<SyncOrgDataBo> addList = new ArrayList<SyncOrgDataBo>();
        for (UumOrganization temp : orgList) {
            System.out.println("\u5171" + orgList.size() + "\u6761\u7ec4\u7ec7\u6570\u636e\uff0c\u5f53\u524d\u5904\u7406\u7b2c" + ++t + "\u6761");
            String casicOrgCode = temp.getCasicOrgCode();
            String rStatus = "Y";
            String rMessage = "\u6210\u529f";
            try {
                List<Map<String, Object>> struList;
                String departCasicOrgCode;
                String orgName = temp.getOrgName();
                if (ToolUtil.isEmpty((Object)casicOrgCode)) {
                    ++orgFail;
                    rStatus = "N";
                    rMessage = "\u96c6\u56e2\u673a\u6784\u7f16\u7801\u4e3a\u7a7a";
                    continue;
                }
                if (casicOrgCode.startsWith(this.sixthCenterCode) && !this.sixthCenterCode.equals(casicOrgCode) || casicOrgCode.length() > 6 && (casicOrgCode.startsWith("0059") || casicOrgCode.startsWith("0042") || casicOrgCode.startsWith("0077")) && casicOrgCode.startsWith(departCasicOrgCode = casicOrgCode.substring(0, 6)) && !departCasicOrgCode.equals(casicOrgCode)) continue;
                String casicPOrgCode = temp.getCasicPOrgCode();
                if (ToolUtil.isEmpty((Object)casicPOrgCode)) {
                    if (this.flightCode.equals(casicOrgCode)) continue;
                    ++orgFail;
                    rStatus = "N";
                    rMessage = "\u7236\u7ea7\u96c6\u56e2\u673a\u6784\u7f16\u7801\u4e3a\u7a7a";
                    continue;
                }
                Long struId = null;
                Integer struOrder = temp.getOrderID();
                Long parentId = null;
                Long organId = null;
                String syncType = temp.getSyncType();
                String parentStruLevel = "0";
                String struType = "";
                Long oldParentId = null;
                List<Map<String, Object>> parentStruList = this.syncStruMapper.getSyncStruByCasicOrgCode(casicPOrgCode);
                if (ToolUtil.isEmpty(parentStruList)) {
                    if (!this.flightCode.equals(casicOrgCode)) {
                        ++orgFail;
                        rStatus = "N";
                        rMessage = "\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\u6240\u5c5e\u7ec4\u7ec7";
                        continue;
                    }
                } else {
                    Map<String, Object> parentStru = parentStruList.get(0);
                    parentId = Long.parseLong(parentStru.get("struId").toString());
                    parentStruLevel = parentStru.get("strulevel").toString();
                }
                if (ToolUtil.isNotEmpty(struList = this.syncStruMapper.getSyncStruByCasicOrgCode(casicOrgCode))) {
                    Map<String, Object> stru = struList.get(0);
                    struId = Long.parseLong(stru.get("struId").toString());
                    organId = Long.parseLong(stru.get("organId").toString());
                    struType = stru.get("struType").toString();
                    oldParentId = Long.parseLong(stru.get("organId").toString());
                }
                if ("2".equals(syncType)) {
                    if (!ToolUtil.isEmpty(struId)) continue;
                    ++orgFail;
                    rStatus = "N";
                    rMessage = "\u5220\u9664\u7ec4\u7ec7\u4e0d\u5b58\u5728";
                    continue;
                }
                SysStru sysStru = new SysStru();
                SysFormerlyOrgan sysFormerlyOrgan = new SysFormerlyOrgan();
                SysOffice sysOffice = new SysOffice();
                sysFormerlyOrgan.setOrganName(orgName);
                sysFormerlyOrgan.setShortName(orgName);
                boolean isAdd = true;
                if ("0".equals(syncType)) {
                    if (HussarUtils.isNotEmpty((Object)struId)) {
                        ++orgFail;
                        rStatus = "N";
                        rMessage = "\u7ec4\u7ec7\u5df2\u5b58\u5728";
                        continue;
                    }
                    String businessName = "ORGAN_CODE_4";
                    String tableName = "SYS_ORGAN";
                    String currentCode = this.sysIdtableService.getCurrentCode(businessName, tableName);
                    String orgType = "2";
                    if (casicOrgCode.length() == 4 || this.hospitalCode.equals(casicOrgCode)) {
                        orgType = "1";
                    }
                    sysStru.setOrganAlias(orgName);
                    sysStru.setParentId(parentId);
                    sysStru.setId(Long.valueOf(casicOrgCode));
                    sysStru.setStruType(orgType);
                    sysStru.setIsLeaf("0");
                    sysStru.setDelFlag("0");
                    sysStru.setStruPath("");
                    sysStru.setStruLevel(Integer.valueOf(1));
                    if (ToolUtil.isEmpty((Object)struOrder)) {
                        struOrder = 1;
                        Integer maxOrder = this.syncStruMapper.getMaxOrderById(parentId);
                        if (ToolUtil.isNotEmpty((Object)maxOrder)) {
                            struOrder = maxOrder + 1;
                        }
                    }
                    sysStru.setStruOrder(struOrder);
                    sysFormerlyOrgan.setOrganCode(currentCode);
                    sysFormerlyOrgan.setOrganType(orgType);
                    sysFormerlyOrgan.setDelFlag("0");
                    sysFormerlyOrgan.setCasicOrgCode(casicOrgCode);
                    sysOffice.setStruId(struId);
                } else if ("1".equals(syncType)) {
                    JSONObject result;
                    if (ToolUtil.isEmpty((Object)struId)) {
                        ++orgFail;
                        rStatus = "N";
                        rMessage = "\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\u6240\u5c5e\u7ec4\u7ec7";
                        continue;
                    }
                    if (!parentId.equals(oldParentId) && !(result = this.syncFormerlyOrgService.orgTreeChangeVue(struId, parentId, struType, "", parentStruLevel, Boolean.valueOf(true))).getBoolean("success").booleanValue()) {
                        ++orgFail;
                        rStatus = "N";
                        rMessage = result.getString("msg");
                        continue;
                    }
                    isAdd = false;
                    sysStru.setId(struId);
                    sysFormerlyOrgan.setId(organId);
                    sysOffice = null;
                } else {
                    ++orgFail;
                    rStatus = "N";
                    rMessage = "\u540c\u6b65\u7c7b\u578b\u5f02\u5e38";
                    continue;
                }
                SyncOrgDataBo syncOrgDataBo = new SyncOrgDataBo();
                syncOrgDataBo.setSysOffice(sysOffice);
                syncOrgDataBo.setFormerlyOrgan(sysFormerlyOrgan);
                syncOrgDataBo.setSysStru(sysStru);
                if (isAdd) {
                    addList.add(syncOrgDataBo);
                    continue;
                }
                updateList.add(syncOrgDataBo);
            }
            catch (Exception e) {
                ++orgFail;
                rStatus = "N";
                rMessage = this.exceptionDetail(e);
            }
            finally {
                UumOrganization tmp = new UumOrganization();
                tmp.setDocID(temp.getDocID());
                tmp.setrStatus(rStatus);
                tmp.setrMessage(rMessage);
                this.uumOrganizationService.updateById((Object)tmp);
            }
        }
        this.addOrUpdateOrg(addList, true);
        this.addOrUpdateOrg(updateList, false);
        resultMap.put("orgFail", orgFail);
        return resultMap;
    }

    private void addOrUpdateOrg(List<SyncOrgDataBo> syncOrgDataBoList, boolean addFlag) {
        if (HussarUtils.isEmpty(syncOrgDataBoList)) {
            return;
        }
        ArrayList<SysOrgan> organList = new ArrayList<SysOrgan>();
        ArrayList<SysStru> struList = new ArrayList<SysStru>();
        ArrayList<SysFormerlyOrgan> formerlyOrganList = new ArrayList<SysFormerlyOrgan>();
        if (addFlag) {
            ArrayList<SysOffice> officeList = new ArrayList<SysOffice>();
            for (SyncOrgDataBo item : syncOrgDataBoList) {
                formerlyOrganList.add(item.getFormerlyOrgan());
                SysStru sysStru = item.getSysStru();
                SysFormerlyOrgan sysFormerlyOrgan = item.getFormerlyOrgan();
                SysOrgan sysOrgan = new SysOrgan();
                SysOffice sysOffice = item.getSysOffice();
                sysOffice.setStruId(sysStru.getId());
                officeList.add(sysOffice);
                CopyPropertieUtils.copyProperties((Object)sysOrgan, (Object)sysFormerlyOrgan);
                organList.add(sysOrgan);
                sysStru.setOrganId(sysFormerlyOrgan.getId());
                struList.add(sysStru);
            }
            this.formerlyOrganService.saveBatch(formerlyOrganList);
            this.syncStruService.saveStruBatch(struList);
            this.organService.saveBatch(organList);
            this.syncStruService.saveOfficeBatch(officeList);
            this.syncTenantStruUserStaffService.syncAddStru(struList, organList, officeList, null);
        } else {
            for (SyncOrgDataBo item : syncOrgDataBoList) {
                SysOrgan sysOrgan = new SysOrgan();
                SysFormerlyOrgan sysFormerlyOrgan = item.getFormerlyOrgan();
                CopyPropertieUtils.copyProperties((Object)sysOrgan, (Object)sysFormerlyOrgan);
                organList.add(sysOrgan);
                formerlyOrganList.add(sysFormerlyOrgan);
                struList.add(item.getSysStru());
            }
            this.formerlyOrganService.updateBatchById(formerlyOrganList);
            this.organService.updateBatchById(organList);
            this.syncStruService.updateStruBatchById(struList);
            this.syncTenantStruUserStaffService.syncUpdateStru(struList, organList, null);
        }
    }

    private int recursionDealUser(List<Long> logIdList, Map<String, Object> param, int dealNum) {
        int failNum = (Integer)param.get("orgFail");
        if (dealNum <= this.maxOrgLevel - 3 && failNum > 0) {
            Map<String, Object> orgResult1;
            QueryWrapper ew1 = new QueryWrapper();
            ew1.in((Object)"UUMID", logIdList);
            ew1.eq((Object)"RSTATUS", (Object)"N");
            ew1.orderByAsc((Object)"DISPTIME", (Object[])new String[]{"GETORDER"});
            List orgList = this.uumOrganizationService.list((Wrapper)ew1);
            if (orgList.size() > 0 && ToolUtil.isNotEmpty(orgResult1 = this.dealOrg(orgList))) {
                Object failNum1 = orgResult1.get("orgFail");
                failNum = Integer.parseInt(failNum1.toString());
                param.put("orgFail", failNum);
                this.recursionDealUser(logIdList, param, ++dealNum);
            }
        }
        failNum = (Integer)param.get("orgFail");
        return failNum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Object> dealUser(List<UumOperator> userList) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        int userFail = 0;
        int t = 0;
        ArrayList<SysUsers> addUserList = new ArrayList<SysUsers>();
        ArrayList<SysUsers> editUserList = new ArrayList<SysUsers>();
        ArrayList<SysStaff> addStaffList = new ArrayList<SysStaff>();
        ArrayList<SysStaff> editStaffList = new ArrayList<SysStaff>();
        ArrayList<Long> delUserList = new ArrayList<Long>();
        for (UumOperator temp : userList) {
            System.out.println("\u5171" + userList.size() + "\u6761\u7528\u6237\u6570\u636e\uff0c\u5f53\u524d\u5904\u7406\u7b2c" + ++t + "\u6761");
            String rStatus = "Y";
            String rMessage = "\u6210\u529f";
            try {
                Long newStruId;
                Map<String, Object> user;
                String idCard = temp.getpID();
                if (ToolUtil.isEmpty((Object)idCard)) {
                    ++userFail;
                    rStatus = "N";
                    rMessage = "\u8eab\u4efd\u8bc1\u53f7\u4e3a\u7a7a";
                    continue;
                }
                String casicOrgCode = temp.getCasicOrgCode();
                Long struId = Long.valueOf(casicOrgCode);
                if (ToolUtil.isEmpty((Object)casicOrgCode)) {
                    ++userFail;
                    rStatus = "N";
                    rMessage = "\u6240\u5c5e\u96c6\u56e2\u673a\u6784\u7f16\u7801\u4e3a\u7a7a";
                    continue;
                }
                if (casicOrgCode.startsWith(this.sixthCenterCode)) {
                    casicOrgCode = this.sixthCenterCode;
                }
                if (casicOrgCode.length() > 6 && (casicOrgCode.startsWith("0059") || casicOrgCode.startsWith("0042") || casicOrgCode.startsWith("0077"))) {
                    casicOrgCode = casicOrgCode.substring(0, 6);
                }
                Date birthDate = temp.getBirthDate() != null ? temp.getBirthDate() : null;
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
                String name = temp.getOperatorName();
                String sex = temp.getGender();
                String remark = temp.getRemark();
                Integer order = temp.getOrderID();
                String securityLevel = this.convertSecurityLevel(temp.getSecretLevel());
                String telephone = temp.getoTel() == null ? "" : temp.getoTel();
                String userNamePinyinFull = (temp.getRefa().trim() + temp.getRefb().trim()).toLowerCase();
                String syncType = temp.getSyncType();
                Long userId = null;
                Long staffId = null;
                boolean status = true;
                List<Map<String, Object>> parentStruList = this.syncStruMapper.getSyncStruByCasicOrgCode(casicOrgCode);
                if (ToolUtil.isEmpty(parentStruList) && !"2".equals(syncType)) {
                    ++userFail;
                    rStatus = "N";
                    rMessage = "\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\u6240\u5c5e\u7ec4\u7ec7";
                    continue;
                }
                List<Map<String, Object>> activeUsers = this.syncUsersMapper.getUserByIdCard(this.secret.encrypt(idCard), idCard, true);
                List<Map<String, Object>> inactiveUsers = this.syncUsersMapper.getUserByIdCard(this.secret.encrypt(idCard), idCard, false);
                if (ToolUtil.isNotEmpty(activeUsers)) {
                    user = activeUsers.get(0);
                    userId = Long.parseLong(user.get("userId").toString());
                    staffId = Long.parseLong(user.get("staffId").toString());
                } else if (ToolUtil.isNotEmpty(inactiveUsers)) {
                    user = inactiveUsers.get(0);
                    userId = Long.parseLong(user.get("userId").toString());
                    staffId = Long.parseLong(user.get("staffId").toString());
                    status = false;
                }
                if ("2".equals(syncType)) {
                    if (HussarUtils.isEmpty(userId) && HussarUtils.isEmpty(staffId)) {
                        ++userFail;
                        rStatus = "N";
                        rMessage = "\u4eba\u5458\u4e0d\u5b58\u5728";
                        continue;
                    }
                    JSONObject jsonObject = this.syncUsersService.deleteStaffAndUser(userId, staffId);
                    if (jsonObject.getBoolean("success").booleanValue()) {
                        this.sysUserRolesUtilService.updateUserByStruid(idCard, staffId);
                        delUserList.add(userId);
                        continue;
                    }
                    ++userFail;
                    rStatus = "N";
                    rMessage = jsonObject.getString("msg");
                    continue;
                }
                SysStaff sysStaff = null;
                SysUsers sysUser = null;
                if ("0".equals(syncType)) {
                    List auditList = this.sysStruAuditService.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"stru_id", (Object)struId)).eq((Object)"state", (Object)"0"));
                    if (HussarUtils.isNotEmpty((Object)auditList)) {
                        ++userFail;
                        rStatus = "N";
                        rMessage = "\u7ec4\u7ec7\u673a\u6784\u672a\u5ba1\u6838";
                        continue;
                    }
                    boolean type = true;
                    sysStaff = (SysStaff)this.sysStaffService.getOne((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"idcard", (Object)this.secret.encrypt(idCard))).or()).eq((Object)"idcard", (Object)idCard));
                    if (sysStaff == null) {
                        sysStaff = new SysStaff();
                        sysUser = new SysUsers();
                    } else {
                        sysUser = (SysUsers)this.sysUsersService.getOne((Wrapper)new QueryWrapper().eq((Object)"employee_id", (Object)sysStaff.getId()));
                        if (sysUser == null) {
                            sysUser = new SysUsers();
                        } else {
                            type = false;
                        }
                    }
                    sysStaff.setName(name);
                    sysStaff.setIdcard(idCard);
                    if (birthDate != null) {
                        sysStaff.setBirthday(dateFormat.format(birthDate));
                    }
                    sysStaff.setSex(sex);
                    sysStaff.setRemark(remark);
                    sysStaff.setStaffOrder(order);
                    sysStaff.setDelFlag("0");
                    sysUser.setUserName(name);
                    sysUser.setUserAccount(idCard);
                    sysUser.setCorporationId(struId);
                    sysUser.setDepartmentId(struId);
                    sysUser.setSecurityLevel(Integer.valueOf(securityLevel));
                    sysUser.setTelephone(telephone);
                    sysUser.setUserNamePinyinFull(userNamePinyinFull);
                    if (type) {
                        Integer userOrder;
                        String currentCode = this.sysIdtableService.getCurrentCode("STAFF_CODE", "SYS_STAFF");
                        sysStaff.setStaffCode(HussarUtils.isNotEmpty((Object)sysStaff.getStaffCode()) ? sysStaff.getStaffCode() : currentCode);
                        List staffs = this.sysStaffMapper.selectList((Wrapper)new LambdaQueryWrapper().eq(SysStaff::getStaffCode, (Object)sysStaff.getStaffCode()));
                        if (HussarUtils.isNotEmpty((Object)staffs)) {
                            ++userFail;
                            rStatus = "N";
                            rMessage = "\u4eba\u5458\u7f16\u7801\u91cd\u590d";
                            continue;
                        }
                        Integer maxOrder = this.sysStaffMapper.getMaxOrder();
                        SysStaff ifExist = (SysStaff)this.sysStaffMapper.selectOne((Wrapper)new QueryWrapper().eq((Object)"idcard", (Object)sysStaff.getIdcard()));
                        if (HussarUtils.isNotEmpty((Object)ifExist)) {
                            sysStaff.setStaffOrder(Integer.valueOf(maxOrder != null ? maxOrder + 1 : 1));
                        }
                        if ((userOrder = this.syncUsersService.getMaxOrder(sysUser.getCorporationId())) == null) {
                            sysUser.setUserOrder(Integer.valueOf(1));
                        } else {
                            sysUser.setUserOrder(Integer.valueOf(userOrder + 1));
                        }
                        sysUser.setTypeProperty("1");
                        sysUser.setAccountStatus(UserStatus.OK.getCode());
                        sysUser.setTotpKey(this.abstractOTPCredentialsMatcher.getRandomSecretBase32());
                        String pass = "";
                        pass = this.createUserConfigService.getCreateUserSendEmail() != false && this.createUserConfigService.getCreateUserUseDefaultPass() == false ? GeneratePassword.generate((String)this.hussarPwdConfigService.getPwdRule()) : this.hussarPwdConfigService.getDefaultPassword();
                        String pwd = this.credentialsMatcher.passwordEncode(String.valueOf(pass).getBytes());
                        sysUser.setPassword(pwd);
                        sysUser.setMaxSessions(Integer.valueOf(-1));
                        sysUser.setLoginIpLimit("0");
                        sysUser.setLoginTimeLimit("0");
                        sysUser.setIsSys("0");
                        sysUser.setIsCpublic("0");
                        sysUser.setCreateTime(LocalDateTime.now());
                        sysUser.setEmployeeId(staffId);
                        sysUser.setTypeProperty("1");
                        addUserList.add(sysUser);
                        addStaffList.add(sysStaff);
                        continue;
                    }
                    editUserList.add(sysUser);
                    editStaffList.add(sysStaff);
                    continue;
                }
                if (HussarUtils.isEmpty(staffId)) {
                    ++userFail;
                    rStatus = "N";
                    rMessage = "\u4eba\u5458\u4e0d\u5b58\u5728";
                    continue;
                }
                sysStaff = (SysStaff)this.sysStaffService.getById((Serializable)staffId);
                sysUser = this.sysUsersService.getById(userId);
                if (!idCard.equals(sysStaff.getIdcard())) {
                    ++userFail;
                    rStatus = "N";
                    rMessage = "\u7528\u6237\u8d26\u6237\u88ab\u4fee\u6539\uff0c\u9700\u8981\u624b\u52a8\u5904\u7406";
                    continue;
                }
                Long oldStruId = sysUser.getCorporationId();
                if (!oldStruId.equals(newStruId = Long.valueOf(casicOrgCode)) && !this.sysStruAuditService.checkCanOperate(newStruId)) {
                    ++userFail;
                    rStatus = "N";
                    rMessage = "\u7ec4\u7ec7\u673a\u6784\u672a\u5ba1\u6838";
                    continue;
                }
                if (!status) {
                    sysUser.setUserAccount(idCard);
                }
                sysStaff.setName(name);
                sysStaff.setIdcard(idCard);
                if (birthDate != null) {
                    sysStaff.setBirthday(dateFormat.format(birthDate));
                }
                sysStaff.setSex(sex);
                sysStaff.setRemark(remark);
                sysStaff.setStaffOrder(order);
                sysStaff.setDelFlag("0");
                sysUser.setCorporationId(struId);
                sysUser.setDepartmentId(struId);
                sysUser.setSecurityLevel(Integer.valueOf(securityLevel));
                sysUser.setTelephone(telephone);
                sysUser.setUserNamePinyinFull(userNamePinyinFull);
                sysUser.setAccountStatus(UserStatus.OK.getCode());
                if (HussarUtils.isEmpty((Object)sysUser.getUserOrder())) {
                    Integer userOrder = this.syncUsersService.getMaxOrder(sysUser.getCorporationId());
                    sysUser.setUserOrder(userOrder);
                }
                if (HussarUtils.isEmpty((Object)sysStaff.getStaffOrder())) {
                    Integer maxOrder = this.sysStaffMapper.getMaxOrder();
                    sysStaff.setStaffOrder(Integer.valueOf(maxOrder != null ? maxOrder + 1 : 1));
                }
                sysStaff.setDelFlag("0");
                editUserList.add(sysUser);
                editStaffList.add(sysStaff);
            }
            catch (Exception e) {
                ++userFail;
                rStatus = "N";
                rMessage = this.exceptionDetail(e);
            }
            finally {
                UumOperator tmp = new UumOperator();
                tmp.setDocID(temp.getDocID());
                tmp.setrStatus(rStatus);
                tmp.setrMessage(rMessage);
                this.uumOperatorService.updateById((Object)tmp);
            }
        }
        this.syncUsersService.addOrUpdateBatchStaffAndUser(addUserList, addStaffList, true);
        this.syncUsersService.addOrUpdateBatchStaffAndUser(editUserList, editStaffList, false);
        this.syncTenantStruUserStaffService.syncDeleteUser(delUserList, null);
        resultMap.put("userFail", userFail);
        return resultMap;
    }

    private LocalDateTime textToTime(String text) {
        LocalDateTime date = null;
        String year = text.substring(0, 4);
        String month = text.substring(4, 6);
        String day = text.substring(6, 8);
        String hour = text.substring(8, 10);
        String moment = text.substring(10, 12);
        String second = text.substring(12);
        String time = year + "-" + month + "-" + day + " " + hour + ":" + moment + ":" + second;
        DateTimeFormatter dateFormat = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        date = LocalDateTime.parse(time, dateFormat);
        return date;
    }

    private Date textToDate(String text) {
        Date date = null;
        String year = text.substring(0, 4);
        String month = text.substring(4, 6);
        String day = text.substring(6, 8);
        String time = year + "-" + month + "-" + day;
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        try {
            date = dateFormat.parse(time);
        }
        catch (ParseException e) {
            return date;
        }
        return date;
    }

    private String convertSecurityLevel(String securityLevel) {
        String result = "60";
        if (ToolUtil.isNotEmpty((Object)securityLevel)) {
            if ("50".equals(securityLevel)) {
                result = "70";
            } else if ("70".equals(securityLevel)) {
                result = "80";
            } else if ("90".equals(securityLevel)) {
                result = "90";
            }
        }
        return result;
    }

    private String exceptionDetail(Exception e) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(outputStream);
        e.printStackTrace(printStream);
        String exceptionInformation = new String(outputStream.toByteArray());
        printStream.close();
        try {
            outputStream.close();
        }
        catch (IOException t) {
            t.printStackTrace();
        }
        return exceptionInformation;
    }

    public Object getList(String page, String limit, Map<String, Object> map) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        if (ToolUtil.isNotEmpty((Object)page) && ToolUtil.isNotEmpty((Object)limit)) {
            Page pages = new Page((long)Integer.valueOf(page).intValue(), (long)Integer.valueOf(limit).intValue());
            List<UumLog> list = this.uumLogMapper.getList(pages, map);
            resultMap.put("count", pages.getTotal());
            resultMap.put("data", list);
            resultMap.put("code", 0);
            return resultMap;
        }
        resultMap.put("data", null);
        resultMap.put("code", "500");
        resultMap.put("msg", "\u53c2\u6570\u4e0d\u7b26");
        resultMap.put("count", null);
        return resultMap;
    }

    public Object orgFailList(String page, String limit, String docId) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        if (ToolUtil.isNotEmpty((Object)page) && ToolUtil.isNotEmpty((Object)limit)) {
            Page pages = new Page((long)Integer.parseInt(page), (long)Integer.parseInt(limit));
            List<UumOrganization> list = this.uumLogMapper.orgFailList((Page<UumOrganization>)pages, docId);
            resultMap.put("count", pages.getTotal());
            resultMap.put("data", list);
            resultMap.put("code", 0);
            return resultMap;
        }
        resultMap.put("data", null);
        resultMap.put("code", "500");
        resultMap.put("msg", "\u53c2\u6570\u4e0d\u7b26");
        resultMap.put("count", null);
        return resultMap;
    }

    public Object userFailList(String page, String limit, String docId) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        if (ToolUtil.isNotEmpty((Object)page) && ToolUtil.isNotEmpty((Object)limit)) {
            Page pages = new Page((long)Integer.parseInt(page), (long)Integer.parseInt(limit));
            List<UumOperator> list = this.uumLogMapper.userFailList((Page<UumOperator>)pages, docId);
            resultMap.put("count", pages.getTotal());
            resultMap.put("data", list);
            resultMap.put("code", 0);
            return resultMap;
        }
        resultMap.put("data", null);
        resultMap.put("code", "500");
        resultMap.put("msg", "\u53c2\u6570\u4e0d\u7b26");
        resultMap.put("count", null);
        return resultMap;
    }
}

